/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.cli;

import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.Commands;
import edu.uiuc.ncsa.security.util.cli.InputLine;

public class CommandsTest
implements Commands {
    AbstractEnvironment environment;

    @Override
    public String getPrompt() {
        return "cli test>";
    }

    public static void main(String[] args) throws Exception {
        CommandsTest c = new CommandsTest();
        FooCommands foo = new FooCommands();
        CLIDriver cliDriver = new CLIDriver(c, foo);
        cliDriver.start();
    }

    protected void say(String x) {
        System.out.println(x);
    }

    public void load(InputLine inputLine) {
        if (this.showHelp(inputLine)) {
            this.showLoadHelp();
            return;
        }
        this.say("load something");
    }

    protected void showLoadHelp() {
        this.say("loads a configuration from the file. The options are");
        this.say("   load fileName - Assumes a single configuration in the fully qualified name of the file and loads it, setting it active");
        this.say("   load fileName configName - loads the configuration named \"configName\" from the fully qualified name of the file and sets it active");
        this.say("\nExample\n");
        this.say("   load /var/www/config/config.xml default\n");
        this.say("loads the configuration named \"default\" from the file named \"config.xml\" in the directory \"/var/www/config\"\n");
    }

    public AbstractEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(AbstractEnvironment environment) {
        this.environment = environment;
    }

    public void show(InputLine inputLine) {
        if (this.showHelp(inputLine)) {
            this.showHelp();
            return;
        }
        this.say("show command should do something");
    }

    protected void showHelp() {
        this.say("help for the show command");
    }

    protected boolean showHelp(InputLine inputLine) {
        return 1 < inputLine.size() && inputLine.getArg(1).equals("--help");
    }

    public void about(InputLine inputLine) {
        this.say("**********************************************************");
        this.say("* OA4MP CLI (Command Line Interpreter)                   *");
        this.say("* Version 1.0                                            *");
        this.say("* By Jeff Gaynor  NCSA                                   *");
        this.say("*  (National Center for Supercomputing Applications)     *");
        this.say("*                                                        *");
        this.say("* type 'help' for a list of commands                     *");
        this.say("*      'exit/quit' to end this session.                  *");
        this.say("**********************************************************");
    }

    public void help() {
        this.say("");
        this.say("Supported Commands\n=======================");
        this.say("cd folderTitle -- Change directory to the given folder.");
        this.say("  The usual \".\" and \"..\" are supported");
        this.say("cp (-r) object targetFolder -- copy an object. If the flag is used,");
        this.say("  the copy will be recursive on any directories.");
        this.say("createAnother (-title title) objectTitle [destination] -- Creates another object");
        this.say("  of the same type as the given object in the destination folder. If the -title is");
        this.say("  given, the new object has the given title, otherwise it has the same title as the");
        this.say("  current object.");
        this.say("edit objectName -- Invokes the editor for the objects settings.");
        this.say("exit/quit -- Stop execution and quit.");
        this.say("help -- More or less this help.");
        this.say("ls objectName -- Lists the object by title, along with other information.");
        this.say("  If the object is a folder, the contents are listed, much like a standard directory listing,");
        this.say("  but with an additional col. showing the size of the system level information.");
        this.say("mkdir folderName -- Make a new folder");
        this.say("move -r source target -- Moves an object from one location to another.");
        this.say("  The \" - r \" flag indicates that this should be done recursively if possible.");
        this.say("rm object -- Deletes an object. If invoked on a folder without the switch");
        this.say("  folder, an error is returned. The switch permits this");
        this.say("  to be recursive, deleting all subobject and folders.");
        this.say("rmdir (-r) folder -- Removes the (empty) folder.");
        this.say("\nYou can type the name of a command and --help to get more information, e.g. \n\ncp --help\n");
        this.say("Would print detailed on the copy command.");
    }

    public static class FooCommands
    implements Commands {
        void say(String x) {
            System.out.println(x);
        }

        @Override
        public String getPrompt() {
            return "foo >";
        }

        public void query(InputLine inputLine) {
            this.say("query invoked");
        }
    }
}

