/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Directory;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.event.SearchEngineEventManager;
import org.compass.core.lucene.engine.store.CopyFromHolder;
import org.compass.core.lucene.engine.store.DirectoryStore;

public abstract class AbstractDirectoryStore
implements DirectoryStore {
    protected final transient Log log = LogFactory.getLog(this.getClass());

    public void closeDirectory(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        try {
            dir.close();
        }
        catch (IOException e) {
            this.log.warn((Object)("Failed to close direcrtory for sub context [" + subContext + "] and sub index [" + subIndex + "]"));
        }
    }

    public Boolean indexExists(Directory dir) throws SearchEngineException {
        return null;
    }

    public void deleteIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
    }

    public void cleanIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
    }

    public void performScheduledTasks(Directory dir, String subContext, String subIndex) throws SearchEngineException {
    }

    public void registerEventListeners(SearchEngine searchEngine, SearchEngineEventManager eventManager) {
    }

    public CopyFromHolder beforeCopyFrom(String subContext, String subIndex, Directory dir) throws SearchEngineException {
        return new CopyFromHolder();
    }

    public void afterSuccessfulCopyFrom(String subContext, String subIndex, CopyFromHolder holder) throws SearchEngineException {
    }

    public void afterFailedCopyFrom(String subContext, String subIndex, CopyFromHolder holder) throws SearchEngineException {
    }

    public void close() {
    }

    public boolean requiresAsyncTransactionalContext() {
        return false;
    }

    public boolean suggestedUseCompoundFile() {
        return false;
    }

    public boolean supportsConcurrentOperations() {
        return true;
    }

    public String suggestedIndexDeletionPolicy() {
        return null;
    }
}

