/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.indexdeletionpolicy;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexCommitPoint;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.lucene.engine.indexdeletionpolicy.DirectoryConfigurable;

public class ExpirationTimeDeletionPolicy
implements IndexDeletionPolicy,
DirectoryConfigurable,
CompassConfigurable {
    private double expirationTimeSeconds;
    private Directory dir;

    public void setDirectory(Directory directory) {
        this.dir = directory;
    }

    public void configure(CompassSettings settings) throws CompassException {
        double defaultValue = (double)settings.getSettingAsLong("compass.engine.cacheIntervalInvalidation", 5000L) / 1000.0;
        this.expirationTimeSeconds = settings.getSettingAsDouble("compass.engine.store.indexDeletionPolicy.expirationTimeInSeconds", defaultValue * 3.0);
    }

    public void onInit(List commits) throws IOException {
        this.onCommit(commits);
    }

    public void onCommit(List commits) throws IOException {
        IndexCommitPoint lastCommit = (IndexCommitPoint)commits.get(commits.size() - 1);
        double expireTime = (double)this.dir.fileModified(lastCommit.getSegmentsFileName()) / 1000.0 - this.expirationTimeSeconds;
        for (IndexCommitPoint commit : commits) {
            double modTime = (double)this.dir.fileModified(commit.getSegmentsFileName()) / 1000.0;
            if (commit == lastCommit || !(modTime < expireTime)) continue;
            commit.delete();
        }
    }

    public String toString() {
        return super.toString() + " expirationTimeInSeconds [" + this.expirationTimeSeconds + "]";
    }
}

