/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPService;
import edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.ClientServlet;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.credential.store.util.ConfigurationReader;
import org.apache.airavata.credential.store.util.PrivateKeyStore;
import org.apache.airavata.credential.store.util.TokenGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialStoreStartServlet
extends ClientServlet {
    private static ConfigurationReader configurationReader = null;
    private static Logger log = LoggerFactory.getLogger(CredentialStoreStartServlet.class);
    private OA4MPService oa4mpService;

    protected String decorateURI(URI inputURI, Map<String, String> parameters) {
        if (parameters.isEmpty()) {
            return inputURI.toString();
        }
        String stringUri = inputURI.toString();
        StringBuilder stringBuilder = new StringBuilder(stringUri);
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (isFirst) {
                stringBuilder.append("?");
                isFirst = false;
            } else {
                stringBuilder.append("&");
            }
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    public void init() throws ServletException {
        super.init();
        try {
            if (configurationReader == null) {
                configurationReader = new ConfigurationReader();
            }
        }
        catch (CredentialStoreException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public OA4MPService getOA4MPService() {
        return this.oa4mpService;
    }

    public void loadEnvironment() throws IOException {
        environment = CredentialStoreStartServlet.getConfigurationLoader().load();
        this.oa4mpService = new OA4MPService((ClientEnvironment)environment);
    }

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        OA4MPResponse gtwResp;
        String gatewayName = request.getParameter("gatewayName");
        String portalUserName = request.getParameter("portalUserName");
        String contactEmail = request.getParameter("email");
        String associatedToken = TokenGenerator.generateToken(gatewayName, portalUserName);
        if (gatewayName == null) {
            JSPUtil.handleException((Throwable)new RuntimeException("Please specify a gateway name."), (HttpServletRequest)request, (HttpServletResponse)response, (String)configurationReader.getErrorUrl());
            return;
        }
        if (portalUserName == null) {
            JSPUtil.handleException((Throwable)new RuntimeException("Please specify a portal user name."), (HttpServletRequest)request, (HttpServletResponse)response, (String)configurationReader.getErrorUrl());
            return;
        }
        if (contactEmail == null) {
            JSPUtil.handleException((Throwable)new RuntimeException("Please specify a contact email address for community user account."), (HttpServletRequest)request, (HttpServletResponse)response, (String)configurationReader.getErrorUrl());
            return;
        }
        log.info("1.a. Starting transaction");
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("gatewayName", gatewayName);
        queryParameters.put("portalUserName", portalUserName);
        queryParameters.put("email", contactEmail);
        queryParameters.put("associatedToken", associatedToken);
        HashMap additionalParameters = new HashMap();
        if (this.getOA4MPService() == null) {
            this.loadEnvironment();
        }
        String modifiedCallbackUri = this.decorateURI(this.getOA4MPService().getEnvironment().getCallback(), queryParameters);
        this.info("The modified callback URI - " + modifiedCallbackUri);
        additionalParameters.put(CredentialStoreStartServlet.getEnvironment().getConstants().get("oa4mp:callback_uri"), modifiedCallbackUri);
        try {
            gtwResp = this.getOA4MPService().requestCert(additionalParameters);
            PrivateKeyStore privateKeyStore = PrivateKeyStore.getPrivateKeyStore();
            privateKeyStore.addKey(associatedToken, gtwResp.getPrivateKey());
        }
        catch (Throwable t) {
            JSPUtil.handleException((Throwable)t, (HttpServletRequest)request, (HttpServletResponse)response, (String)configurationReader.getErrorUrl());
            return;
        }
        log.info("1.b. Got response. Creating page with redirect for " + gtwResp.getRedirect().getHost());
        request.setAttribute("redirect", (Object)"redirect");
        request.setAttribute("redirectUrl", (Object)gtwResp.getRedirect().toString());
        request.setAttribute("actionKey", (Object)"actionKey");
        request.setAttribute("action", (Object)"redirect");
        log.info("1.b. Showing redirect page.");
        JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)configurationReader.getPortalRedirectUrl());
    }
}

