/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.client;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.queue.AddAllOperation;
import com.hazelcast.queue.client.QueueRequest;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class AddAllRequest
extends QueueRequest {
    private Collection<Data> dataList;

    public AddAllRequest() {
    }

    public AddAllRequest(String name, Collection<Data> dataList) {
        super(name);
        this.dataList = dataList;
    }

    @Override
    protected Operation prepareOperation() {
        return new AddAllOperation(this.name, this.dataList);
    }

    @Override
    public int getClassId() {
        return 11;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        super.writePortable(writer);
        writer.writeInt("s", this.dataList.size());
        ObjectDataOutput out = writer.getRawDataOutput();
        for (Data data : this.dataList) {
            data.writeData(out);
        }
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        super.readPortable(reader);
        int size = reader.readInt("s");
        ObjectDataInput in = reader.getRawDataInput();
        this.dataList = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data data = new Data();
            data.readData(in);
            this.dataList.add(data);
        }
    }
}

