/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.record;

import com.hazelcast.map.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class RecordReplicationInfo
implements DataSerializable {
    private Record record;
    private long idleDelayMillis = -1L;
    private long ttlDelayMillis = -1L;
    private long mapStoreWriteDelayMillis = -1L;
    private long mapStoreDeleteDelayMillis = -1L;

    public RecordReplicationInfo(Record record, long idleDelayMillis, long ttlDelayMillis, long mapStoreWriteDelayMillis, long mapStoreDeleteDelayMillis) {
        this.record = record;
        this.idleDelayMillis = idleDelayMillis;
        this.ttlDelayMillis = ttlDelayMillis;
        this.mapStoreWriteDelayMillis = mapStoreWriteDelayMillis;
        this.mapStoreDeleteDelayMillis = mapStoreDeleteDelayMillis;
    }

    public RecordReplicationInfo(Record record) {
        this.record = record;
    }

    public RecordReplicationInfo() {
    }

    public Record getRecord() {
        return this.record;
    }

    public long getIdleDelayMillis() {
        return this.idleDelayMillis;
    }

    public long getTtlDelayMillis() {
        return this.ttlDelayMillis;
    }

    public long getMapStoreWriteDelayMillis() {
        return this.mapStoreWriteDelayMillis;
    }

    public long getMapStoreDeleteDelayMillis() {
        return this.mapStoreDeleteDelayMillis;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.record);
        out.writeLong(this.idleDelayMillis);
        out.writeLong(this.ttlDelayMillis);
        out.writeLong(this.mapStoreWriteDelayMillis);
        out.writeLong(this.mapStoreDeleteDelayMillis);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.record = (Record)in.readObject();
        this.idleDelayMillis = in.readLong();
        this.ttlDelayMillis = in.readLong();
        this.mapStoreWriteDelayMillis = in.readLong();
        this.mapStoreDeleteDelayMillis = in.readLong();
    }
}

