/*
 * Decompiled with CFR 0.152.
 */
package org.globus.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.globus.net.PortRange;

public class ServerSocketFactory {
    private static ServerSocketFactory defaultFactory = null;
    private PortRange portRange = PortRange.getTcpInstance();

    protected ServerSocketFactory() {
    }

    public static synchronized ServerSocketFactory getDefault() {
        if (defaultFactory == null) {
            defaultFactory = new ServerSocketFactory();
        }
        return defaultFactory;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return this.createServerSocket(port, 50, null);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.createServerSocket(port, backlog, null);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        if (this.portRange.isEnabled() && port == 0) {
            return this.createServerSocket(backlog, bindAddr);
        }
        return new ServerSocket(port, backlog, bindAddr);
    }

    private ServerSocket createServerSocket(int backlog, InetAddress binAddr) throws IOException {
        PrServerSocket server = null;
        int port = 0;
        while (true) {
            port = this.portRange.getFreePort(port);
            try {
                server = new PrServerSocket(port, backlog, binAddr);
                this.portRange.setUsed(port);
                return server;
            }
            catch (IOException e) {
                ++port;
                continue;
            }
            break;
        }
    }

    class PrServerSocket
    extends ServerSocket {
        public PrServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
            super(port, backlog, bindAddr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            int port = this.getLocalPort();
            try {
                super.close();
            }
            finally {
                if (port != -1) {
                    ServerSocketFactory.this.portRange.free(port);
                }
            }
        }
    }
}

