/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.security;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.client.CredentialStoreClientFactory;
import org.apache.airavata.credential.store.cpi.CredentialStoreService;
import org.apache.airavata.credential.store.exception.CredentialStoreException;
import org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile;
import org.apache.airavata.model.credential.store.PasswordCredential;
import org.apache.airavata.model.security.AuthzToken;
import org.apache.airavata.registry.api.RegistryService;
import org.apache.airavata.registry.api.client.RegistryServiceClientFactory;
import org.apache.airavata.registry.api.exception.RegistryServiceException;
import org.apache.airavata.security.AiravataSecurityException;
import org.apache.airavata.security.util.TrustStoreManager;
import org.apache.airavata.service.security.AiravataSecurityManager;
import org.apache.airavata.service.security.authzcache.AuthzCacheEntry;
import org.apache.airavata.service.security.authzcache.AuthzCacheIndex;
import org.apache.airavata.service.security.authzcache.AuthzCacheManager;
import org.apache.airavata.service.security.authzcache.AuthzCacheManagerFactory;
import org.apache.airavata.service.security.authzcache.AuthzCachedStatus;
import org.apache.thrift.TException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyCloakSecurityManager
implements AiravataSecurityManager {
    private static final Logger logger = LoggerFactory.getLogger(KeyCloakSecurityManager.class);
    private HashMap<String, String> rolePermissionConfig = new HashMap();
    private static final String USER_RESOURCE_PROFILE_USER_METHODS = "/airavata/registerUserResourceProfile|/airavata/getUserResourceProfile|/airavata/updateUserResourceProfile|/airavata/deleteUserResourceProfile|/airavata/addUserComputeResourcePreference|/airavata/addUserStoragePreference|/airavata/getUserComputeResourcePreference|/airavata/getUserStoragePreference|/airavata/getAllUserComputeResourcePreferences|/airavata/getAllUserStoragePreferences|/airavata/updateUserComputeResourcePreference|/airavata/updateUserStoragePreference|/airavata/deleteUserComputeResourcePreference|/airavata/deleteUserStoragePreference|/airavata/generateAndRegisterSSHKeys|/airavata/getAllCredentialSummaryForUsersInGateway|/airavata/deleteSSHPubKey";
    private static final String SHARING_RESOURCE_METHODS = "/airavata/shareResourceWithUsers|/airavata/revokeSharingOfResourceFromUsers|/airavata/getAllAccessibleUsers";
    private static final String SSH_ACCOUNT_PROVISIONER_METHODS = "/airavata/getSSHAccountProvisioners|/airavata/doesUserHaveSSHAccount|/airavata/setupUserComputeResourcePreferencesForSSH|/airavata/getGatewayResourceProfile";

    public KeyCloakSecurityManager() throws AiravataSecurityException {
        this.rolePermissionConfig.put("admin", "/airavata/.*");
        this.rolePermissionConfig.put("gateway-provider", "/airavata/.*");
        this.rolePermissionConfig.put("admin-read-only", "/airavata/getSSHPubKey|/airavata/getAllGatewaySSHPubKeys|/airavata/getAllGatewayPWDCredentials|/airavata/getApplicationModule|/airavata/getAllAppModules|/airavata/getApplicationDeployment|/airavata/getAllApplicationDeployments|/airavata/getAppModuleDeployedResources|/airavata/getStorageResource|/airavata/getAllStorageResourceNames|/airavata/getSCPDataMovement|/airavata/getUnicoreDataMovement|/airavata/getGridFTPDataMovement|/airavata/getResourceJobManager|/airavata/deleteResourceJobManager|/airavata/getGatewayResourceProfile|/airavata/getGatewayComputeResourcePreference|/airavata/getGatewayStoragePreference|/airavata/getAllGatewayComputeResourcePreferences|/airavata/getAllGatewayStoragePreferences|/airavata/getAllGatewayResourceProfiles|/airavata/getAPIVersion|/airavata/getNotification|/airavata/getAllNotifications|/airavata/createProject|/airavata/updateProject|/airavata/getProject|/airavata/deleteProject|/airavata/getUserProjects|/airavata/searchProjectsByProjectName|/airavata/searchProjectsByProjectDesc|/airavata/searchExperimentsByName|/airavata/searchExperimentsByDesc|/airavata/searchExperimentsByApplication|/airavata/searchExperimentsByStatus|/airavata/searchExperimentsByCreationTime|/airavata/searchExperiments|/airavata/getExperimentStatistics|/airavata/getExperimentsInProject|/airavata/getUserExperiments|/airavata/createExperiment|/airavata/deleteExperiment|/airavata/getExperiment|/airavata/getDetailedExperimentTree|/airavata/updateExperiment|/airavata/updateExperimentConfiguration|/airavata/updateResourceScheduleing|/airavata/validateExperiment|/airavata/launchExperiment|/airavata/getExperimentStatus|/airavata/getExperimentOutputs|/airavata/getIntermediateOutputs|/airavata/getJobStatuses|/airavata/getJobDetails|/airavata/cloneExperiment|/airavata/terminateExperiment|/airavata/getApplicationInterface|/airavata/getAllApplicationInterfaceNames|/airavata/getAllApplicationInterfaces|/airavata/getApplicationInputs|/airavata/getApplicationOutputs|/airavata/getAvailableAppInterfaceComputeResources|/airavata/getComputeResource|/airavata/getAllComputeResourceNames|/airavata/getWorkflow|/airavata/getWorkflowTemplateId|/airavata/isWorkflowExistWithName|/airavata/registerDataProduct|/airavata/getDataProduct|/airavata/registerReplicaLocation|/airavata/getParentDataProduct|/airavata/getChildDataProducts|/airavata/getAllAccessibleUsers|/airavata/getExperimentByAdmin|/airavata/cloneExperimentByAdmin|/airavata/registerUserResourceProfile|/airavata/getUserResourceProfile|/airavata/updateUserResourceProfile|/airavata/deleteUserResourceProfile|/airavata/addUserComputeResourcePreference|/airavata/addUserStoragePreference|/airavata/getUserComputeResourcePreference|/airavata/getUserStoragePreference|/airavata/getAllUserComputeResourcePreferences|/airavata/getAllUserStoragePreferences|/airavata/updateUserComputeResourcePreference|/airavata/updateUserStoragePreference|/airavata/deleteUserComputeResourcePreference|/airavata/deleteUserStoragePreference|/airavata/generateAndRegisterSSHKeys|/airavata/getAllCredentialSummaryForUsersInGateway|/airavata/deleteSSHPubKey|/airavata/getAllUserResourceProfiles|/airavata/shareResourceWithUsers|/airavata/revokeSharingOfResourceFromUsers|/airavata/getAllAccessibleUsers|/airavata/getGateway|/airavata/getSSHAccountProvisioners|/airavata/doesUserHaveSSHAccount|/airavata/setupUserComputeResourcePreferencesForSSH|/airavata/getGatewayResourceProfile");
        this.rolePermissionConfig.put("gateway-user", "/airavata/getAPIVersion|/airavata/getNotification|/airavata/getAllNotifications|/airavata/createProject|/airavata/updateProject|/airavata/getProject|/airavata/deleteProject|/airavata/getUserProjects|/airavata/searchProjectsByProjectName|/airavata/searchProjectsByProjectDesc|/airavata/searchExperimentsByName|/airavata/searchExperimentsByDesc|/airavata/searchExperimentsByApplication|/airavata/searchExperimentsByStatus|/airavata/searchExperimentsByCreationTime|/airavata/searchExperiments|/airavata/getExperimentStatistics|/airavata/getExperimentsInProject|/airavata/getUserExperiments|/airavata/createExperiment|/airavata/deleteExperiment|/airavata/getExperiment|/airavata/getDetailedExperimentTree|/airavata/updateExperiment|/airavata/updateExperimentConfiguration|/airavata/updateResourceScheduleing|/airavata/validateExperiment|/airavata/launchExperiment|/airavata/getExperimentStatus|/airavata/getExperimentOutputs|/airavata/getIntermediateOutputs|/airavata/getJobStatuses|/airavata/getJobDetails|/airavata/cloneExperiment|/airavata/terminateExperiment|/airavata/getApplicationInterface|/airavata/getAllApplicationInterfaceNames|/airavata/getAllApplicationInterfaces|/airavata/getApplicationInputs|/airavata/getApplicationOutputs|/airavata/getAvailableAppInterfaceComputeResources|/airavata/getComputeResource|/airavata/getAllComputeResourceNames|/airavata/getWorkflow|/airavata/getWorkflowTemplateId|/airavata/isWorkflowExistWithName|/airavata/registerDataProduct|/airavata/getDataProduct|/airavata/registerReplicaLocation|/airavata/getParentDataProduct|/airavata/getChildDataProducts|/airavata/getAllAccessibleUsers|/airavata/getAllApplicationDeployments|/airavata/registerUserResourceProfile|/airavata/getUserResourceProfile|/airavata/updateUserResourceProfile|/airavata/deleteUserResourceProfile|/airavata/addUserComputeResourcePreference|/airavata/addUserStoragePreference|/airavata/getUserComputeResourcePreference|/airavata/getUserStoragePreference|/airavata/getAllUserComputeResourcePreferences|/airavata/getAllUserStoragePreferences|/airavata/updateUserComputeResourcePreference|/airavata/updateUserStoragePreference|/airavata/deleteUserComputeResourcePreference|/airavata/deleteUserStoragePreference|/airavata/generateAndRegisterSSHKeys|/airavata/getAllCredentialSummaryForUsersInGateway|/airavata/deleteSSHPubKey|/airavata/shareResourceWithUsers|/airavata/revokeSharingOfResourceFromUsers|/airavata/getAllAccessibleUsers|/airavata/getSSHAccountProvisioners|/airavata/doesUserHaveSSHAccount|/airavata/setupUserComputeResourcePreferencesForSSH|/airavata/getGatewayResourceProfile");
        this.initializeSecurityInfra();
    }

    @Override
    public void initializeSecurityInfra() throws AiravataSecurityException {
        try {
            TrustStoreManager trustStoreManager = new TrustStoreManager();
            trustStoreManager.initializeTrustStoreManager(ServerSettings.getTrustStorePath(), ServerSettings.getTrustStorePassword());
        }
        catch (Exception e) {
            throw new AiravataSecurityException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isUserAuthorized(AuthzToken authzToken, Map<String, String> metaData) throws AiravataSecurityException {
        String subject = (String)authzToken.getClaimsMap().get("userName");
        String accessToken = authzToken.getAccessToken();
        String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
        String action = "/airavata/" + metaData.get("api.method.name");
        try {
            if (!ServerSettings.isAPISecured()) {
                return true;
            }
            if (ServerSettings.isAuthzCacheEnabled()) {
                AuthzCacheManager authzCacheManager = AuthzCacheManagerFactory.getAuthzCacheManager();
                AuthzCachedStatus authzCachedStatus = authzCacheManager.getAuthzCachedStatus(new AuthzCacheIndex(subject, gatewayId, accessToken, action));
                if (AuthzCachedStatus.AUTHORIZED.equals((Object)authzCachedStatus)) {
                    logger.debug("Authz decision for: (" + subject + ", " + accessToken + ", " + action + ") is retrieved from cache.");
                    return true;
                }
                if (AuthzCachedStatus.NOT_AUTHORIZED.equals((Object)authzCachedStatus)) {
                    logger.debug("Authz decision for: (" + subject + ", " + accessToken + ", " + action + ") is retrieved from cache.");
                    return false;
                }
                if (AuthzCachedStatus.NOT_CACHED.equals((Object)authzCachedStatus)) {
                    logger.debug("Authz decision for: (" + subject + ", " + accessToken + ", " + action + ") is not in the cache. Obtaining it from the authorization server.");
                    String[] roles = this.getUserRolesFromOAuthToken(subject, accessToken, gatewayId);
                    boolean authorizationDecision = this.hasPermission(roles, action);
                    long currentTime = System.currentTimeMillis();
                    authzCacheManager.addToAuthzCache(new AuthzCacheIndex(subject, gatewayId, accessToken, action), new AuthzCacheEntry(authorizationDecision, currentTime + 3600000L, currentTime));
                    return authorizationDecision;
                }
                throw new AiravataSecurityException("Error in reading from the authorization cache.");
            }
            String[] roles = this.getUserRolesFromOAuthToken(subject, accessToken, gatewayId);
            return this.hasPermission(roles, action);
        }
        catch (ApplicationSettingsException e) {
            e.printStackTrace();
            throw new AiravataSecurityException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AiravataSecurityException(e.getMessage(), (Throwable)e);
        }
    }

    private String[] getUserRolesFromOAuthToken(String username, String token, String gatewayId) throws Exception {
        GatewayResourceProfile gwrp = this.getRegistryServiceClient().getGatewayResourceProfile(gatewayId);
        String identityServerRealm = gwrp.getIdentityServerTenant();
        String openIdConnectUrl = this.getOpenIDConfigurationUrl(identityServerRealm);
        JSONObject openIdConnectConfig = new JSONObject(this.getFromUrl(openIdConnectUrl, token));
        String userInfoEndPoint = openIdConnectConfig.getString("userinfo_endpoint");
        JSONObject userInfo = new JSONObject(this.getFromUrl(userInfoEndPoint, token));
        if (!username.equals(userInfo.get("preferred_username"))) {
            throw new AiravataSecurityException("Subject name and username for the token doesn't match");
        }
        String userId = userInfo.getString("sub");
        String userRoleMappingUrl = ServerSettings.getRemoteIDPServiceUrl() + "/admin/realms/" + identityServerRealm + "/users/" + userId + "/role-mappings/realm";
        JSONArray roleMappings = new JSONArray(this.getFromUrl(userRoleMappingUrl, this.getAdminAccessToken(gatewayId)));
        String[] roles = new String[roleMappings.length()];
        for (int i = 0; i < roleMappings.length(); ++i) {
            roles[i] = new JSONObject(roleMappings.get(i).toString()).get("name").toString();
        }
        return roles;
    }

    private String getOpenIDConfigurationUrl(String realm) throws ApplicationSettingsException {
        return ServerSettings.getRemoteIDPServiceUrl() + "/realms/" + realm + "/.well-known/openid-configuration";
    }

    public String getFromUrl(String urlToRead, String token) throws Exception {
        String line;
        StringBuilder result = new StringBuilder();
        URL url = new URL(urlToRead);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        if (token != null) {
            String bearerAuth = "Bearer " + token;
            conn.setRequestProperty("Authorization", bearerAuth);
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        rd.close();
        return result.toString();
    }

    private String getAdminAccessToken(String gatewayId) throws Exception {
        String line;
        CredentialStoreService.Client csClient = this.getCredentialStoreServiceClient();
        GatewayResourceProfile gwrp = this.getRegistryServiceClient().getGatewayResourceProfile(gatewayId);
        String identityServerRealm = gwrp.getIdentityServerTenant();
        String openIdConnectUrl = this.getOpenIDConfigurationUrl(identityServerRealm);
        JSONObject openIdConnectConfig = new JSONObject(this.getFromUrl(openIdConnectUrl, null));
        PasswordCredential credential = csClient.getPasswordCredential(gwrp.getIdentityServerPwdCredToken(), gwrp.getGatewayID());
        String username = credential.getLoginUserName();
        String password = credential.getPassword();
        String urlString = openIdConnectConfig.getString("token_endpoint");
        StringBuilder result = new StringBuilder();
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        String postFields = "client_id=admin-cli&username=" + username + "&password=" + password + "&grant_type=password";
        conn.getOutputStream().write(postFields.getBytes());
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        rd.close();
        JSONObject tokenInfo = new JSONObject(result.toString());
        return tokenInfo.get("access_token").toString();
    }

    private boolean hasPermission(String[] roles, String apiMethod) {
        for (int i = 0; i < roles.length; ++i) {
            Pattern pattern;
            Matcher matcher;
            String role = roles[i];
            if (!this.rolePermissionConfig.keySet().contains(role) || !(matcher = (pattern = Pattern.compile(this.rolePermissionConfig.get(role))).matcher(apiMethod)).matches()) continue;
            return true;
        }
        return false;
    }

    private RegistryService.Client getRegistryServiceClient() throws TException, ApplicationSettingsException {
        int serverPort = Integer.parseInt(ServerSettings.getRegistryServerPort());
        String serverHost = ServerSettings.getRegistryServerHost();
        try {
            return RegistryServiceClientFactory.createRegistryClient((String)serverHost, (int)serverPort);
        }
        catch (RegistryServiceException e) {
            throw new TException("Unable to create registry client...", (Throwable)e);
        }
    }

    private CredentialStoreService.Client getCredentialStoreServiceClient() throws TException, ApplicationSettingsException {
        int serverPort = Integer.parseInt(ServerSettings.getCredentialStoreServerPort());
        String serverHost = ServerSettings.getCredentialStoreServerHost();
        try {
            return CredentialStoreClientFactory.createAiravataCSClient((String)serverHost, (int)serverPort);
        }
        catch (CredentialStoreException e) {
            throw new TException("Unable to create credential store client...", (Throwable)e);
        }
    }
}

