/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudsearchv2.model.DescribeExpressionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeExpressionsRequestMarshaller
implements Marshaller<Request<DescribeExpressionsRequest>, DescribeExpressionsRequest> {
    public Request<DescribeExpressionsRequest> marshall(DescribeExpressionsRequest describeExpressionsRequest) {
        if (describeExpressionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeExpressionsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeExpressions");
        request.addParameter("Version", "2013-01-01");
        if (describeExpressionsRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)describeExpressionsRequest.getDomainName()));
        }
        List<String> expressionNamesList = describeExpressionsRequest.getExpressionNames();
        int expressionNamesListIndex = 1;
        for (String expressionNamesListValue : expressionNamesList) {
            if (expressionNamesListValue != null) {
                request.addParameter("ExpressionNames.member." + expressionNamesListIndex, StringUtils.fromString((String)expressionNamesListValue));
            }
            ++expressionNamesListIndex;
        }
        if (describeExpressionsRequest.isDeployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean((Boolean)describeExpressionsRequest.isDeployed()));
        }
        return request;
    }
}

