/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.AuthenticationException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.Properties;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.common.RoleContext;
import org.wso2.carbon.user.core.jdbc.JDBCUserStoreManager;
import org.wso2.carbon.user.core.ldap.LDAPConnectionContext;
import org.wso2.carbon.user.core.ldap.LDAPRoleContext;
import org.wso2.carbon.user.core.ldap.ReadOnlyLDAPUserStoreConstants;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.JNDIUtil;
import org.wso2.carbon.user.core.util.LDAPUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class ReadOnlyLDAPUserStoreManager
extends AbstractUserStoreManager {
    protected LDAPConnectionContext connectionSource = null;
    private final int MAX_USER_CACHE = 200;
    private Map<String, String> userCache = new ConcurrentHashMap<String, String>(200);
    private static Log log = LogFactory.getLog(ReadOnlyLDAPUserStoreManager.class);
    protected String userSearchBase = null;
    protected String groupSearchBase = null;
    protected boolean emptyRolesAllowed = false;

    public ReadOnlyLDAPUserStoreManager() {
    }

    public ReadOnlyLDAPUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        this(realmConfig, properties, claimManager, profileManager, realm, tenantId, false);
    }

    public ReadOnlyLDAPUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId, boolean skipInitData) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing Started " + System.currentTimeMillis()));
        }
        this.realmConfig = realmConfig;
        this.claimManager = claimManager;
        this.userRealm = realm;
        this.tenantId = tenantId;
        this.checkRequiredUserStoreConfigurations();
        this.dataSource = (DataSource)properties.get("um.datasource");
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
        }
        if (this.dataSource == null) {
            throw new UserStoreException("Data Source is null");
        }
        properties.put("um.datasource", this.dataSource);
        this.connectionSource = new LDAPConnectionContext(realmConfig);
        try {
            this.connectionSource.getContext();
            if (this.isReadOnly()) {
                log.info((Object)"LDAP connection created successfully in read-only mode");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException("Cannot create connection to LDAP server. Error message " + e.getMessage());
        }
        this.userRealm = realm;
        this.persistDomain();
        this.doInitialSetup();
        if (realmConfig.isPrimary()) {
            this.addInitialAdminData(Boolean.parseBoolean(realmConfig.getAddAdmin()), !this.isInitSetupDone());
        }
        this.initUserRolesCache();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing Ended " + System.currentTimeMillis()));
        }
    }

    public ReadOnlyLDAPUserStoreManager(RealmConfiguration realmConfig, ClaimManager claimManager, ProfileConfigurationManager profileManager) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started " + System.currentTimeMillis()));
        }
        this.realmConfig = realmConfig;
        this.claimManager = claimManager;
        this.checkRequiredUserStoreConfigurations();
        this.connectionSource = new LDAPConnectionContext(realmConfig);
    }

    protected void checkRequiredUserStoreConfigurations() throws UserStoreException {
        log.debug((Object)"Checking LDAP configurations ");
        String connectionURL = this.realmConfig.getUserStoreProperty("ConnectionURL");
        String DNSURL = this.realmConfig.getUserStoreProperty("URLOfDNS");
        if (!(connectionURL != null && connectionURL.trim().length() != 0 || DNSURL != null && DNSURL.trim().length() != 0)) {
            throw new UserStoreException("Required ConnectionURL property is not set at the LDAP configurations");
        }
        String connectionName = this.realmConfig.getUserStoreProperty("ConnectionName");
        if (connectionName == null || connectionName.trim().length() == 0) {
            throw new UserStoreException("Required ConnectionNme property is not set at the LDAP configurations");
        }
        String connectionPassword = this.realmConfig.getUserStoreProperty("ConnectionPassword");
        if (connectionPassword == null || connectionPassword.trim().length() == 0) {
            throw new UserStoreException("Required ConnectionPassword property is not set at the LDAP configurations");
        }
        this.userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        if (this.userSearchBase == null || this.userSearchBase.trim().length() == 0) {
            throw new UserStoreException("Required UserSearchBase property is not set at the LDAP configurations");
        }
        String usernameListFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
        if (usernameListFilter == null || usernameListFilter.trim().length() == 0) {
            throw new UserStoreException("Required UserNameListFilter property is not set at the LDAP configurations");
        }
        String usernameSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        if (usernameSearchFilter == null || usernameSearchFilter.trim().length() == 0) {
            throw new UserStoreException("Required UserNameSearchFilter property is not set at the LDAP configurations");
        }
        String usernameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        if (usernameAttribute == null || usernameAttribute.trim().length() == 0) {
            throw new UserStoreException("Required UserNameAttribute property is not set at the LDAP configurations");
        }
        this.writeGroupsEnabled = false;
        if (this.realmConfig.getUserStoreProperty("ReadGroups") != null) {
            this.readGroupsEnabled = Boolean.parseBoolean(this.realmConfig.getUserStoreProperty("ReadGroups"));
        }
        if (this.readGroupsEnabled) {
            this.groupSearchBase = this.realmConfig.getUserStoreProperty("GroupSearchBase");
            if (this.groupSearchBase == null || this.groupSearchBase.trim().length() == 0) {
                throw new UserStoreException("Required GroupSearchBase property is not set at the LDAP configurations");
            }
            String groupNameListFilter = this.realmConfig.getUserStoreProperty("GroupNameListFilter");
            if (groupNameListFilter == null || groupNameListFilter.trim().length() == 0) {
                throw new UserStoreException("Required GroupNameListFilter property is not set at the LDAP configurations");
            }
            String groupNameSearchFilter = this.realmConfig.getUserStoreProperty("GroupNameSearchFilter");
            if (groupNameSearchFilter == null || groupNameSearchFilter.trim().length() == 0) {
                throw new UserStoreException("Required GroupNameSearchFilter property is not set at the LDAP configurations");
            }
            String groupNameAttribute = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
            if (groupNameAttribute == null || groupNameAttribute.trim().length() == 0) {
                throw new UserStoreException("Required GroupNameAttribute property is not set at the LDAP configurations");
            }
            String memebershipAttribute = this.realmConfig.getUserStoreProperty("MembershipAttribute");
            if (memebershipAttribute == null || memebershipAttribute.trim().length() == 0) {
                throw new UserStoreException("Required MembershipAttribute property is not set at the LDAP configurations");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean doAuthenticate(String userName, Object credential) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        if (userName == null) return false;
        if (credential == null) {
            return false;
        }
        userName = userName.trim();
        userName = this.replaceEscapeCharacters(userName);
        String password = (String)credential;
        password = password.trim();
        if (userName.equals("")) return false;
        if (password.equals("")) {
            return false;
        }
        if (debug) {
            log.debug((Object)("Authenticating user " + userName));
        }
        boolean bValue = false;
        String name = null;
        String patterns = this.realmConfig.getUserStoreProperty("UserDNPattern");
        if (patterns != null && !patterns.isEmpty()) {
            String[] userDNPatternList;
            if (debug) {
                log.debug((Object)("Using UserDNPatterns " + patterns));
            }
            if ((name = this.userCache.get(userName)) != null) {
                block16: {
                    try {
                        if (debug) {
                            log.debug((Object)("Cache hit. Using DN " + name));
                        }
                        bValue = this.bindAsUser(name, (String)credential);
                    }
                    catch (NamingException e) {
                        if (!log.isDebugEnabled()) break block16;
                        log.debug((Object)("Checking authentication with UserDN " + name + "failed " + e.getStackTrace()));
                    }
                }
                if (bValue) {
                    return bValue;
                }
            }
            if ((userDNPatternList = patterns.split("#")).length <= 0) return bValue;
            String[] arr$ = userDNPatternList;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                block17: {
                    String userDNPattern = arr$[i$];
                    name = MessageFormat.format(userDNPattern, userName);
                    if (debug) {
                        log.debug((Object)("Authenticating with " + name));
                    }
                    try {
                        if (name == null || !(bValue = this.bindAsUser(name, (String)credential))) break block17;
                        this.userCache.put(userName, name);
                        return bValue;
                    }
                    catch (NamingException e) {
                        if (!log.isDebugEnabled()) break block17;
                        log.debug((Object)("Checking authentication with UserDN " + userDNPattern + "failed " + e.getStackTrace()));
                    }
                }
                ++i$;
            }
            return bValue;
        }
        name = this.getNameInSpaceForUserName(userName);
        try {
            if (name == null) return bValue;
            if (!debug) return this.bindAsUser(name, (String)credential);
            log.debug((Object)("Authenticating with " + name));
            return this.bindAsUser(name, (String)credential);
        }
        catch (NamingException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage());
        }
    }

    @Override
    public String[] getAllProfileNames() throws UserStoreException {
        return new String[]{"default"};
    }

    @Override
    public String[] getProfileNames(String userName) throws UserStoreException {
        return new String[]{"default"};
    }

    @Override
    public Map<String, String> getUserPropertyValues(String userName, String[] propertyNames, String profileName) throws UserStoreException {
        HashMap<String, String> values = new HashMap<String, String>();
        String searchFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
        String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        String[] userNames = userName.split("/");
        if (userNames.length > 1) {
            userName = userNames[1];
        }
        searchFilter = "(&" + searchFilter + "(" + userNameProperty + "=" + userName + "))";
        DirContext dirContext = this.connectionSource.getContext();
        NamingEnumeration<SearchResult> answer = null;
        NamingEnumeration<?> attrs = null;
        try {
            answer = this.searchForUser(searchFilter, propertyNames, dirContext);
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                Attributes attributes = sr.getAttributes();
                if (attributes == null) continue;
                for (String name : propertyNames) {
                    Attribute attribute;
                    if (name == null || (attribute = attributes.get(name)) == null) continue;
                    StringBuffer attrBuffer = new StringBuffer();
                    attrs = attribute.getAll();
                    while (attrs.hasMore()) {
                        Object attObject = attrs.next();
                        String attr = null;
                        if (attObject instanceof String) {
                            attr = (String)attObject;
                        } else if (attObject instanceof byte[]) {
                            attr = new String(Base64.encodeBase64((byte[])((byte[])attObject)));
                        }
                        if (attr == null || attr.trim().length() <= 0) continue;
                        attrBuffer.append(attr + ",");
                    }
                    String value = attrBuffer.toString();
                    if (value == null || value.trim().length() <= 1) continue;
                    value = value.substring(0, value.length() - 1);
                    values.put(name, value);
                }
            }
        }
        catch (NamingException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage());
        }
        finally {
            JNDIUtil.closeNamingEnumeration(attrs);
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        return values;
    }

    @Override
    public boolean doCheckExistingRole(String roleName) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        return this.isExistingLDAPRole(roleContext);
    }

    protected boolean isExistingLDAPRole(RoleContext context) throws UserStoreException {
        String roleName;
        boolean isExisting;
        boolean debug;
        block17: {
            debug = log.isDebugEnabled();
            isExisting = false;
            roleName = context.getRoleName();
            if (debug) {
                log.debug((Object)("Searching for role: " + roleName));
            }
            String searchFilter = ((LDAPRoleContext)context).getListFilter();
            String roleNameProperty = ((LDAPRoleContext)context).getRoleNameProperty();
            searchFilter = "(&" + searchFilter + "(" + roleNameProperty + "=" + roleName + "))";
            String searchBase = ((LDAPRoleContext)context).getSearchBase();
            if (debug) {
                log.debug((Object)("Using search filter: " + searchFilter));
            }
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            searchCtls.setReturningAttributes(new String[]{roleNameProperty});
            DirContext dirContext = null;
            NamingEnumeration<SearchResult> answer = null;
            try {
                dirContext = this.connectionSource.getContext();
                if (((LDAPRoleContext)context).getRoleDNPatterns().size() > 0) {
                    for (String pattern : ((LDAPRoleContext)context).getRoleDNPatterns()) {
                        block16: {
                            if (debug) {
                                log.debug((Object)("Using pattern: " + pattern));
                            }
                            searchBase = MessageFormat.format(pattern.trim(), roleName);
                            try {
                                answer = dirContext.search(searchBase, searchFilter, searchCtls);
                            }
                            catch (NamingException e) {
                                if (!log.isDebugEnabled()) break block16;
                                log.debug((Object)e);
                            }
                        }
                        if (answer == null || !answer.hasMoreElements()) continue;
                        boolean bl = true;
                        return bl;
                    }
                    break block17;
                }
                if (debug) {
                    log.debug((Object)("Searching in " + searchBase));
                }
                if ((answer = dirContext.search(searchBase, searchFilter, searchCtls)).hasMoreElements()) {
                    isExisting = true;
                }
            }
            catch (NamingException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
                throw new UserStoreException(e.getMessage());
            }
            finally {
                JNDIUtil.closeNamingEnumeration(answer);
                JNDIUtil.closeContext(dirContext);
            }
        }
        if (debug) {
            log.debug((Object)("Is role: " + roleName + " exist: " + isExisting));
        }
        return isExisting;
    }

    @Override
    public boolean doCheckExistingUser(String userName) throws UserStoreException {
        boolean bFound = false;
        boolean debug = log.isDebugEnabled();
        try {
            String name;
            if (debug) {
                log.debug((Object)("Searching for user " + userName));
            }
            if ((name = this.getNameInSpaceForUserName(userName)) != null && name.length() > 0) {
                bFound = true;
            }
        }
        catch (Exception e) {
            throw new UserStoreException(e.getMessage(), e);
        }
        if (debug) {
            log.debug((Object)("User: " + userName + " exist: " + bFound));
        }
        return bFound;
    }

    @Override
    public String[] doListUsers(String filter, int maxItemLimit) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        Object[] userNames = new String[]{};
        if (maxItemLimit == 0) {
            return userNames;
        }
        int givenMax = 100;
        int searchTime = 10000;
        try {
            givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxUserNameListLength"));
        }
        catch (Exception e) {
            givenMax = 100;
        }
        try {
            searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
        }
        catch (Exception e) {
            searchTime = 10000;
        }
        if (maxItemLimit < 0 || maxItemLimit > givenMax) {
            maxItemLimit = givenMax;
        }
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setCountLimit(maxItemLimit);
        searchCtls.setTimeLimit(searchTime);
        if (filter.contains("?") || filter.contains("**")) {
            throw new UserStoreException("Invalid character sequence entered for user serch. Please enter valid sequence.");
        }
        StringBuffer searchFilter = new StringBuffer(this.realmConfig.getUserStoreProperty("UserNameListFilter"));
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        String serviceNameAttribute = "sn";
        StringBuffer finalFilter = new StringBuffer();
        String displayNameAttribute = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
        String[] returnedAtts = null;
        if (displayNameAttribute != null) {
            returnedAtts = new String[]{userNameProperty, serviceNameAttribute, displayNameAttribute};
            finalFilter.append("(&").append(searchFilter).append("(").append(displayNameAttribute).append("=").append(filter).append("))");
        } else {
            returnedAtts = new String[]{userNameProperty, serviceNameAttribute};
            finalFilter.append("(&").append(searchFilter).append("(").append(userNameProperty).append("=").append(filter).append("))");
        }
        if (debug) {
            log.debug((Object)("Listing users. SearchBase: " + searchBase + " Constructed-Filter: " + finalFilter.toString()));
            log.debug((Object)("Search controls. Max Limit: " + maxItemLimit + " Max Time: " + searchTime));
        }
        searchCtls.setReturningAttributes(returnedAtts);
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> answer = null;
        try {
            dirContext = this.connectionSource.getContext();
            answer = dirContext.search(searchBase, finalFilter.toString(), searchCtls);
            ArrayList<String> list = new ArrayList<String>();
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                if (sr.getAttributes() == null) continue;
                log.debug((Object)"Result found ..");
                Attribute attr = sr.getAttributes().get(userNameProperty);
                Attribute attrSurname = sr.getAttributes().get(serviceNameAttribute);
                if (attrSurname != null) {
                    String serviceName;
                    if (debug) {
                        log.debug((Object)(serviceNameAttribute + " : " + attrSurname));
                    }
                    if ((serviceName = (String)attrSurname.get()) != null && serviceName.equals("Service")) continue;
                }
                Attribute displayName = null;
                if (displayNameAttribute != null) {
                    displayName = sr.getAttributes().get(displayNameAttribute);
                    if (debug) {
                        log.debug((Object)(displayNameAttribute + " : " + displayName));
                    }
                }
                if (attr == null) continue;
                String name = (String)attr.get();
                String display = null;
                if (displayName != null) {
                    display = (String)displayName.get();
                }
                String domain = this.getRealmConfiguration().getUserStoreProperty("DomainName");
                name = UserCoreUtil.getCombinedName(domain, name, display);
                list.add(name);
            }
            userNames = list.toArray(new String[list.size()]);
            Arrays.sort(userNames);
            if (debug) {
                for (Object username : userNames) {
                    log.debug((Object)("result: " + (String)username));
                }
            }
        }
        catch (NamingException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage());
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        return userNames;
    }

    @Override
    protected String[] doGetDisplayNamesForInternalRole(String[] userNames) throws UserStoreException {
        String displayNameAttribute = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
        if (displayNameAttribute != null) {
            String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
            String userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
            String userNameListFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
            String[] returningAttributes = new String[]{displayNameAttribute};
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(returningAttributes);
            ArrayList<String> combinedNames = new ArrayList<String>();
            if (userNames != null && userNames.length > 0) {
                for (String userName : userNames) {
                    String searchFilter = "(&" + userNameListFilter + "(" + userNameAttribute + "=" + userName + "))";
                    List<String> displayNames = this.getListOfNames(userSearchBase, searchFilter, searchControls, displayNameAttribute, false);
                    String name = UserCoreUtil.getCombinedName(this.realmConfig.getUserStoreProperty("DomainName"), userName, displayNames.get(0));
                    combinedNames.add(name);
                }
                return combinedNames.toArray(new String[combinedNames.size()]);
            }
            return userNames;
        }
        return userNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean bindAsUser(String dn, String credentials) throws NamingException, UserStoreException {
        boolean isAuthed = false;
        boolean debug = log.isDebugEnabled();
        LdapContext cxt = null;
        try {
            cxt = this.connectionSource.getContextWithCredentials(dn, credentials);
            isAuthed = true;
        }
        catch (AuthenticationException e) {
            block5: {
                try {
                    if (!debug) break block5;
                    log.debug((Object)("Authentication failed " + e));
                }
                catch (Throwable throwable) {
                    JNDIUtil.closeContext(cxt);
                    throw throwable;
                }
            }
            JNDIUtil.closeContext(cxt);
        }
        JNDIUtil.closeContext(cxt);
        if (debug) {
            log.debug((Object)("User: " + dn + " is authnticated: " + isAuthed));
        }
        return isAuthed;
    }

    protected NamingEnumeration<SearchResult> searchForUser(String searchFilter, String[] returnedAtts, DirContext dirContext) throws UserStoreException {
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        if (returnedAtts != null && returnedAtts.length > 0) {
            searchCtls.setReturningAttributes(returnedAtts);
        }
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)("Searching for user with SearchFilter: " + searchFilter + " in SearchBase: " + dirContext.getNameInNamespace()));
            }
            catch (NamingException e) {
                log.debug((Object)"Error while getting DN of search base", (Throwable)e);
            }
            if (returnedAtts == null) {
                log.debug((Object)"No attributes requested");
            } else {
                for (String attribute : returnedAtts) {
                    log.debug((Object)("Requesting attribute :" + attribute));
                }
            }
        }
        try {
            NamingEnumeration<SearchResult> answer = dirContext.search(searchBase, searchFilter, searchCtls);
            return answer;
        }
        catch (NamingException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage());
        }
    }

    @Override
    public void doAddRole(String roleName, String[] userList, boolean shared) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateRoleName(String roleName, String newRoleName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public boolean isBulkImportSupported() {
        return false;
    }

    public boolean isMultipleProfilesAllowed() {
        return false;
    }

    @Override
    public void doDeleteRole(String roleName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    protected List<String> getLDAPRoleNames(int searchTime, String filter, int maxItemLimit, String searchFilter, String roleNameProperty, String searchBase, boolean appendTenantDomain) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        ArrayList<String> roles = new ArrayList<String>();
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setCountLimit(maxItemLimit);
        searchCtls.setTimeLimit(searchTime);
        String[] returnedAtts = new String[]{roleNameProperty};
        searchCtls.setReturningAttributes(returnedAtts);
        StringBuffer finalFilter = new StringBuffer();
        finalFilter.append("(&").append(searchFilter).append("(").append(roleNameProperty).append("=").append(filter).append("))");
        if (debug) {
            log.debug((Object)("Listing roles. SearchBase: " + searchBase + " ConstructedFilter: " + finalFilter.toString()));
        }
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> answer = null;
        try {
            dirContext = this.connectionSource.getContext();
            answer = dirContext.search(searchBase, finalFilter.toString(), searchCtls);
            String domain = this.getRealmConfiguration().getUserStoreProperty("DomainName");
            while (answer.hasMoreElements()) {
                Attribute attr;
                SearchResult sr = answer.next();
                if (sr.getAttributes() == null || (attr = sr.getAttributes().get(roleNameProperty)) == null) continue;
                String name = (String)attr.get();
                name = UserCoreUtil.addDomainToName(name, domain);
                if (appendTenantDomain) {
                    String dn = sr.getNameInNamespace();
                    name = UserCoreUtil.addTenantDomainToEntry(name, this.getTenantDomainFromRoleDN(dn, name));
                }
                roles.add(name);
            }
        }
        catch (NamingException e) {
            log.debug((Object)e);
            throw new UserStoreException(e.getMessage());
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        if (debug) {
            Iterator rolesIte = roles.iterator();
            while (rolesIte.hasNext()) {
                log.debug((Object)("result: " + (String)rolesIte.next()));
            }
        }
        return roles;
    }

    private String getTenantDomainFromRoleDN(String dn, String roleName) {
        dn = dn.toLowerCase();
        roleName = roleName.toLowerCase();
        String sharedSearchBase = (String)this.realmConfig.getUserStoreProperties().get("SharedGroupSearchBase");
        if (dn.indexOf(sharedSearchBase = sharedSearchBase.toLowerCase()) > -1) {
            String groupNameAttributeName;
            int lastIndex;
            dn = dn.replaceAll(sharedSearchBase, "");
            if ((dn = dn.replace(this.realmConfig.getUserStoreProperty("GroupNameAttribute").toLowerCase() + "=" + roleName, "")).indexOf(",") == 0) {
                dn = dn.substring(1);
            }
            if ((lastIndex = dn.indexOf(",")) > -1 && lastIndex == dn.length() - 1) {
                dn = dn.substring(0, dn.length() - 1);
            }
            if ((dn = dn.replaceAll((groupNameAttributeName = this.realmConfig.getUserStoreProperty("SharedTenantNameAttribute").toLowerCase()) + "=", "")) == null || dn.isEmpty()) {
                dn = "carbon.super";
            }
            return dn;
        }
        return CarbonContext.getCurrentContext().getTenantDomain();
    }

    @Override
    protected void filterSharedRoles(List<String> sharedRoles, String tenantDomain) {
        if ((tenantDomain = tenantDomain.toLowerCase()) != null) {
            Iterator<String> i = sharedRoles.iterator();
            while (i.hasNext()) {
                String role = i.next();
                if (role.toLowerCase().indexOf(tenantDomain) <= -1) continue;
                i.remove();
            }
        }
    }

    @Override
    public String[] doGetRoleNames(String filter, int maxItemLimit) throws UserStoreException {
        if (maxItemLimit == 0) {
            return new String[0];
        }
        int givenMax = 100;
        int searchTime = 10000;
        try {
            givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxRoleNameListLength"));
        }
        catch (Exception e) {
            givenMax = 100;
        }
        try {
            searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
        }
        catch (Exception e) {
            searchTime = 10000;
        }
        if (maxItemLimit < 0 || maxItemLimit > givenMax) {
            maxItemLimit = givenMax;
        }
        ArrayList<String> externalRoles = new ArrayList<String>();
        if (this.readGroupsEnabled) {
            externalRoles.addAll(this.getLDAPRoleNames(searchTime, filter, maxItemLimit, this.realmConfig.getUserStoreProperty("GroupNameListFilter"), this.realmConfig.getUserStoreProperty("GroupNameAttribute"), this.realmConfig.getUserStoreProperty("GroupSearchBase"), false));
        }
        return externalRoles.toArray(new String[externalRoles.size()]);
    }

    @Override
    protected String[] doGetSharedRoleNames(String tenantDomain, String filter, int maxItemLimit) throws UserStoreException {
        if (!this.isSharedGroupEnabled()) {
            return new String[0];
        }
        if (maxItemLimit == 0) {
            return new String[0];
        }
        int givenMax = 100;
        int searchTime = 10000;
        try {
            givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxRoleNameListLength"));
        }
        catch (Exception e) {
            givenMax = 100;
        }
        try {
            searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
        }
        catch (Exception e) {
            searchTime = 10000;
        }
        if (maxItemLimit < 0 || maxItemLimit > givenMax) {
            maxItemLimit = givenMax;
        }
        String searchBase = null;
        if ("carbon.super".equalsIgnoreCase(tenantDomain)) {
            searchBase = this.realmConfig.getUserStoreProperty("SharedGroupSearchBase");
        } else {
            String groupNameAttributeName = this.realmConfig.getUserStoreProperty("SharedTenantNameAttribute");
            if (groupNameAttributeName == null || groupNameAttributeName.trim().length() == 0) {
                groupNameAttributeName = "ou";
            }
            searchBase = groupNameAttributeName + "=" + tenantDomain + "," + this.realmConfig.getUserStoreProperty("SharedGroupSearchBase");
        }
        List<String> sharedRoleNames = this.getLDAPRoleNames(searchTime, filter, maxItemLimit, this.realmConfig.getUserStoreProperty("GroupNameListFilter"), this.realmConfig.getUserStoreProperty("GroupNameAttribute"), searchBase, true);
        this.filterSharedRoles(sharedRoleNames, CarbonContext.getCurrentContext().getTenantDomain());
        return sharedRoleNames.toArray(new String[sharedRoleNames.size()]);
    }

    @Override
    public RealmConfiguration getRealmConfiguration() {
        return this.realmConfig;
    }

    @Override
    public String[] doGetUserListOfRole(String roleName, String filter) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        return this.getUserListOfLDAPRole(roleContext, filter);
    }

    public String[] getUserListOfLDAPRole(RoleContext context, String filter) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Getting user list of role: " + context.getRoleName() + " with filter: " + filter));
        }
        ArrayList<String> userList = new ArrayList<String>();
        String[] names = new String[]{};
        int givenMax = 100;
        int searchTime = 10000;
        try {
            givenMax = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxUserNameListLength"));
        }
        catch (Exception e) {
            givenMax = 100;
        }
        try {
            searchTime = Integer.parseInt(this.realmConfig.getUserStoreProperty("MaxSearchQueryTime"));
        }
        catch (Exception e) {
            searchTime = 10000;
        }
        try {
            Attributes attributes;
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            searchCtls.setTimeLimit(searchTime);
            searchCtls.setCountLimit(givenMax);
            String searchFilter = ((LDAPRoleContext)context).getListFilter();
            String roleNameProperty = ((LDAPRoleContext)context).getRoleNameProperty();
            searchFilter = "(&" + searchFilter + "(" + roleNameProperty + "=" + context.getRoleName() + "))";
            String membershipProperty = this.realmConfig.getUserStoreProperty("MembershipAttribute");
            String[] returnedAtts = new String[]{membershipProperty};
            searchCtls.setReturningAttributes(returnedAtts);
            ArrayList<String> userDNList = new ArrayList<String>();
            if (debug) {
                log.debug((Object)("Searching role: " + context.getRoleName() + " SearchBase: " + ((LDAPRoleContext)context).getSearchBase() + " SearchFilter: " + searchFilter));
            }
            DirContext dirContext = this.connectionSource.getContext();
            NamingEnumeration<SearchResult> answer = dirContext.search(((LDAPRoleContext)context).getSearchBase(), searchFilter, searchCtls);
            int count = 0;
            SearchResult sr = null;
            while (answer.hasMore()) {
                if (count > 0) {
                    throw new UserStoreException("More than one group exist with name");
                }
                sr = answer.next();
                ++count;
            }
            if (debug) {
                log.debug((Object)("Found role: " + sr.getNameInNamespace()));
            }
            if ((attributes = sr.getAttributes()) != null) {
                NamingEnumeration<? extends Attribute> attributeEntry = null;
                attributeEntry = attributes.getAll();
                while (attributeEntry.hasMore()) {
                    Attribute valAttribute = attributeEntry.next();
                    if (membershipProperty != null && !membershipProperty.equals(valAttribute.getID())) continue;
                    NamingEnumeration<?> values = null;
                    values = valAttribute.getAll();
                    while (values.hasMore()) {
                        String value = values.next().toString();
                        userDNList.add(value);
                        if (!debug) continue;
                        log.debug((Object)("Found attribute: " + membershipProperty + " value: " + value));
                    }
                }
            }
            String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
            String displayNameAttribute = this.realmConfig.getUserStoreProperty("DisplayNameAttribute");
            String[] returnedAttributes = new String[]{userNameProperty, displayNameAttribute};
            for (String user : userDNList) {
                if (debug) {
                    log.debug((Object)("Getting name attributes of: " + user));
                }
                dirContext = this.connectionSource.getContext();
                Attributes userAttributes = dirContext.getAttributes(user, returnedAttributes);
                String displayName = null;
                String userName = null;
                if (userAttributes != null) {
                    Attribute userNameAttribute = userAttributes.get(userNameProperty);
                    if (userNameAttribute != null) {
                        userName = (String)userNameAttribute.get();
                        if (debug) {
                            log.debug((Object)("UserName: " + userName));
                        }
                    }
                    if (displayNameAttribute != null) {
                        Attribute displayAttribute = userAttributes.get(displayNameAttribute);
                        if (displayAttribute != null) {
                            displayName = (String)displayAttribute.get();
                        }
                        if (debug) {
                            log.debug((Object)("DisplayName: " + displayName));
                        }
                    }
                }
                String domainName = this.realmConfig.getUserStoreProperty("DomainName");
                if (userName != null) {
                    user = UserCoreUtil.getCombinedName(domainName, userName, displayName);
                    userList.add(user);
                    if (!debug) continue;
                    log.debug((Object)(user + " is added to the result list"));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("User " + user + " doesn't have the user name property : " + userNameProperty));
            }
            names = userList.toArray(new String[userList.size()]);
        }
        catch (PartialResultException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (NamingException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException("Error in reading user information in the user store.");
        }
        return names;
    }

    protected String getEffectiveSearchBase(boolean shared) {
        String backLinksEnabled = this.realmConfig.getUserStoreProperty("BackLinksEnabled");
        boolean isBackLinkEnabled = false;
        if (backLinksEnabled != null && !backLinksEnabled.equals("")) {
            isBackLinkEnabled = Boolean.parseBoolean(backLinksEnabled);
        }
        if (isBackLinkEnabled) {
            return this.realmConfig.getUserStoreProperty("UserSearchBase");
        }
        if (shared) {
            return this.realmConfig.getUserStoreProperty("SharedGroupSearchBase");
        }
        return this.realmConfig.getUserStoreProperty("GroupSearchBase");
    }

    protected String[] getLDAPRoleListOfUser(String userName, String filter, String searchBase, boolean shared) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        List<String> list = new ArrayList<String>();
        if (this.readGroupsEnabled && !UserCoreUtil.isRegistryAnnonymousUser(userName) && !UserCoreUtil.isRegistrySystemUser(userName)) {
            String[] returnedAtts;
            String searchFilter;
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            String memberOfProperty = this.realmConfig.getUserStoreProperty("MemberOfAttribute");
            if (memberOfProperty != null && memberOfProperty.length() > 0) {
                searchFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
                String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
                searchFilter = "(&" + searchFilter + "(" + userNameProperty + "=" + userName + "))";
                String binaryAttribute = this.realmConfig.getUserStoreProperty("java.naming.ldap.attributes.binary");
                String primaryGroupId = this.realmConfig.getUserStoreProperty("PrimaryGroupId");
                returnedAtts = new String[]{memberOfProperty};
                if (binaryAttribute != null && primaryGroupId != null) {
                    returnedAtts = new String[]{memberOfProperty, binaryAttribute, primaryGroupId};
                }
                searchCtls.setReturningAttributes(returnedAtts);
                if (debug) {
                    log.debug((Object)("Reading roles with the memberOfProperty Property: " + memberOfProperty));
                }
                if (binaryAttribute != null && primaryGroupId != null) {
                    list = this.getAttributeListOfOneElementWithPrimarGroup(searchBase, searchFilter, searchCtls, binaryAttribute, primaryGroupId, userNameProperty, memberOfProperty);
                } else {
                    List<String> groupDNs = this.getListOfNames(searchBase, searchFilter, searchCtls, memberOfProperty, false);
                    list = this.getGroupNameAttributeValuesOfGroups(groupDNs);
                }
            } else {
                searchFilter = shared ? this.realmConfig.getUserStoreProperty("GroupNameListFilter") : this.realmConfig.getUserStoreProperty("GroupNameListFilter");
                String roleNameProperty = shared ? this.realmConfig.getUserStoreProperty("GroupNameAttribute") : this.realmConfig.getUserStoreProperty("GroupNameAttribute");
                String membershipProperty = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                String nameInSpace = this.getNameInSpaceForUserName(userName);
                if (membershipProperty == null || membershipProperty.length() < 1) {
                    throw new UserStoreException("Please set member of attribute or membership attribute");
                }
                searchFilter = "(&" + searchFilter + "(" + membershipProperty + "=" + nameInSpace + "))";
                returnedAtts = new String[]{roleNameProperty};
                searchCtls.setReturningAttributes(returnedAtts);
                if (debug) {
                    log.debug((Object)("Reading roles with the membershipProperty Property: " + membershipProperty));
                }
                list = this.getListOfNames(searchBase, searchFilter, searchCtls, roleNameProperty, false);
            }
        } else if (UserCoreUtil.isRegistryAnnonymousUser(userName)) {
            list.add("system/wso2.anonymous.role");
        }
        String[] result = list.toArray(new String[list.size()]);
        if (result != null) {
            for (String rolename : result) {
                log.debug((Object)("Found role: " + rolename));
            }
        }
        return result;
    }

    @Override
    protected String[] doGetExternalRoleListOfUser(String userName, String filter) throws UserStoreException {
        String searchBase = this.getEffectiveSearchBase(false);
        return this.getLDAPRoleListOfUser(userName, filter, searchBase, false);
    }

    @Override
    protected String[] doGetSharedRoleListOfUser(String userName, String tenantDomain, String filter) throws UserStoreException {
        String searchBase = this.getEffectiveSearchBase(true);
        if (tenantDomain != null && tenantDomain.trim().length() > 0 && !"carbon.super".equalsIgnoreCase(tenantDomain.trim())) {
            String groupNameAttributeName = this.realmConfig.getUserStoreProperty("SharedTenantNameAttribute");
            if (groupNameAttributeName == null || groupNameAttributeName.trim().length() == 0) {
                groupNameAttributeName = "ou";
            }
            searchBase = groupNameAttributeName + "=" + tenantDomain + "," + searchBase;
        }
        return this.getLDAPRoleListOfUser(userName, filter, searchBase, true);
    }

    @Override
    public boolean isReadOnly() throws UserStoreException {
        return true;
    }

    protected String getNameInSpaceForUserName(String userName) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        userSearchFilter = userSearchFilter.replace("?", userName);
        DirContext dirContext = this.connectionSource.getContext();
        NamingEnumeration<SearchResult> answer = null;
        try {
            if (debug) {
                log.debug((Object)("Search for " + userSearchFilter));
            }
            String name = null;
            answer = this.searchForUser(userSearchFilter, null, dirContext);
            NameClassPair userObj = null;
            if (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                userObj = sr;
            }
            if (userObj != null) {
                name = userObj.getNameInNamespace();
            }
            if (debug) {
                log.debug((Object)("Name in space for " + userName + " is " + name));
            }
            String string = name;
            return string;
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
    }

    private List<String> parseSearchResult(SearchResult sr, String groupAttributeName) {
        ArrayList<String> list = new ArrayList<String>();
        Attributes attrs = sr.getAttributes();
        if (attrs != null) {
            try {
                NamingEnumeration<? extends Attribute> ae = null;
                ae = attrs.getAll();
                while (ae.hasMore()) {
                    Attribute attr = ae.next();
                    if (groupAttributeName != null && !groupAttributeName.equals(attr.getID())) continue;
                    NamingEnumeration<?> e = null;
                    e = attr.getAll();
                    while (e.hasMore()) {
                        String value = e.next().toString();
                        int begin = value.indexOf("=") + 1;
                        int end = value.indexOf(",");
                        if (begin > -1 && end > -1) {
                            value = value.substring(begin, end);
                        }
                        list.add(value);
                    }
                    JNDIUtil.closeNamingEnumeration(e);
                }
                JNDIUtil.closeNamingEnumeration(ae);
            }
            catch (NamingException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    private List<String> getAttributeListOfOneElementWithPrimarGroup(String searchBase, String searchFilter, SearchControls searchCtls, String objectSid, String primaryGroupID, String userAttributeId, String groupAttributeName) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        List<String> list = new ArrayList<String>();
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> answer = null;
        if (debug) {
            log.debug((Object)("GetAttributeListOfOneElementWithPrimarGroup. SearchBase: " + searchBase + " SearchFilter: " + searchFilter));
        }
        try {
            dirContext = this.connectionSource.getContext();
            answer = dirContext.search(searchBase, searchFilter, searchCtls);
            int count = 0;
            while (answer.hasMore()) {
                if (count > 0) {
                    log.error((Object)"More than element user exist with name");
                    throw new UserStoreException("More than element user exist with name");
                }
                SearchResult sr = answer.next();
                ++count;
                list = this.parseSearchResult(sr, groupAttributeName);
                String primaryGroupSID = LDAPUtil.getPrimaryGroupSID(sr, objectSid, primaryGroupID);
                String primaryGroupName = LDAPUtil.findGroupBySID(dirContext, searchBase, primaryGroupSID, userAttributeId);
                if (primaryGroupName == null) continue;
                list.add(primaryGroupName);
            }
        }
        catch (PartialResultException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"LDAP", (Throwable)e);
            }
        }
        catch (NamingException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage());
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        if (debug) {
            log.debug((Object)("GetAttributeListOfOneElementWithPrimarGroup. SearchBase: " + searchBase + " SearchFilter: " + searchFilter));
            Iterator<String> ite = list.iterator();
            while (ite.hasNext()) {
                log.debug((Object)("result: " + ite.next()));
            }
        }
        return list;
    }

    protected List<String> getAttributeListOfOneElement(String searchBase, String searchFilter, SearchControls searchCtls) throws UserStoreException {
        List<String> list = new ArrayList<String>();
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> answer = null;
        try {
            dirContext = this.connectionSource.getContext();
            answer = dirContext.search(searchBase, searchFilter, searchCtls);
            int count = 0;
            while (answer.hasMore()) {
                if (count > 0) {
                    log.error((Object)"More than element user exist with name");
                    throw new UserStoreException("More than element user exist with name");
                }
                SearchResult sr = answer.next();
                ++count;
                list = this.parseSearchResult(sr, null);
            }
        }
        catch (PartialResultException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"LDAPError", (Throwable)e);
            }
        }
        catch (NamingException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage());
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        return list;
    }

    private List<String> getListOfNames(String searchBase, String searchFilter, SearchControls searchCtls, String property, boolean appendDn) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        ArrayList<String> names = new ArrayList<String>();
        DirContext dirContext = null;
        NamingEnumeration<SearchResult> answer = null;
        if (debug) {
            log.debug((Object)("Result for searchBase: " + searchBase + " searchFilter: " + searchFilter + " property:" + property + " appendDN: " + appendDn));
        }
        try {
            dirContext = this.connectionSource.getContext();
            answer = dirContext.search(searchBase, searchFilter, searchCtls);
            String domain = this.getRealmConfiguration().getUserStoreProperty("DomainName");
            while (answer.hasMoreElements()) {
                Attribute attr;
                SearchResult sr = answer.next();
                if (sr.getAttributes() == null || (attr = sr.getAttributes().get(property)) == null) continue;
                String name = (String)attr.get();
                if (debug) {
                    log.debug((Object)("Found user: " + name));
                }
                domain = UserCoreUtil.addDomainToName(name, domain);
                names.add(name);
            }
            if (debug) {
                Iterator namesIterator = names.iterator();
                while (namesIterator.hasNext()) {
                    log.debug((Object)("result " + (String)namesIterator.next()));
                }
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        catch (NamingException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage());
        }
        finally {
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
    }

    public Map<String, String> getProperties(Tenant tenant) throws org.wso2.carbon.user.api.UserStoreException {
        return this.getProperties((org.wso2.carbon.user.core.tenant.Tenant)tenant);
    }

    @Override
    public int getTenantId() throws UserStoreException {
        return this.tenantId;
    }

    @Override
    public String[] getUserListFromProperties(String property, String value, String profileName) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        ArrayList<String> values = new ArrayList<String>();
        String searchFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
        String userPropertyName = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        searchFilter = "(&" + searchFilter + "(" + property + "=" + value + "))";
        DirContext dirContext = this.connectionSource.getContext();
        NamingEnumeration<SearchResult> answer = null;
        NamingEnumeration<?> attrs = null;
        if (debug) {
            log.debug((Object)("Listing users with Property: " + property + " SearchFilter: " + searchFilter));
        }
        try {
            answer = this.searchForUser(searchFilter, new String[]{userPropertyName}, dirContext);
            while (answer.hasMoreElements()) {
                Attribute attribute;
                SearchResult sr = answer.next();
                Attributes attributes = sr.getAttributes();
                if (attributes == null || (attribute = attributes.get(userPropertyName)) == null) continue;
                StringBuffer attrBuffer = new StringBuffer();
                attrs = attribute.getAll();
                while (attrs.hasMore()) {
                    String attr = (String)attrs.next();
                    if (attr == null || attr.trim().length() <= 0) continue;
                    attrBuffer.append(attr + ",");
                    if (!debug) continue;
                    log.debug((Object)(userPropertyName + " : " + attr));
                }
                String propertyValue = attrBuffer.toString();
                if (propertyValue == null || propertyValue.trim().length() <= 1) continue;
                propertyValue = propertyValue.substring(0, propertyValue.length() - 1);
                values.add(propertyValue);
            }
        }
        catch (NamingException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage());
        }
        finally {
            JNDIUtil.closeNamingEnumeration(attrs);
            JNDIUtil.closeNamingEnumeration(answer);
            JNDIUtil.closeContext(dirContext);
        }
        if (debug) {
            String[] results;
            for (String result : results = values.toArray(new String[values.size()])) {
                log.debug((Object)("result: " + result));
            }
        }
        return values.toArray(new String[values.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doCheckIsUserInRole(String userName, String roleName) throws UserStoreException {
        block34: {
            boolean debug = log.isDebugEnabled();
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            LDAPRoleContext context = (LDAPRoleContext)this.createRoleContext(roleName);
            String searchBase = this.getEffectiveSearchBase(context.isShared());
            String memberOfProperty = this.realmConfig.getUserStoreProperty("MemberOfAttribute");
            if (memberOfProperty != null && memberOfProperty.length() > 0) {
                String searchFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
                String userNameProperty = this.realmConfig.getUserStoreProperty("UserNameAttribute");
                searchFilter = "(&" + searchFilter + "(" + userNameProperty + "=" + userName + "))";
                String binaryAttribute = this.realmConfig.getUserStoreProperty("java.naming.ldap.attributes.binary");
                String primaryGroupId = this.realmConfig.getUserStoreProperty("PrimaryGroupId");
                String[] returnedAtts = new String[]{memberOfProperty};
                if (binaryAttribute != null && primaryGroupId != null) {
                    returnedAtts = new String[]{memberOfProperty, binaryAttribute, primaryGroupId};
                }
                searchCtls.setReturningAttributes(returnedAtts);
                if (debug) {
                    log.debug((Object)("Do check is user: " + userName + " in role: " + roleName));
                    log.debug((Object)("Search filter: " + searchFilter));
                    for (String retAttrib : returnedAtts) {
                        log.debug((Object)("Requesting attribute: " + retAttrib));
                    }
                }
                List<String> list = binaryAttribute != null && primaryGroupId != null ? this.getAttributeListOfOneElementWithPrimarGroup(searchBase, searchFilter, searchCtls, binaryAttribute, primaryGroupId, userNameProperty, memberOfProperty) : this.getAttributeListOfOneElement(searchBase, searchFilter, searchCtls);
                if (debug) {
                    if (list != null) {
                        for (String item : list) {
                            log.debug((Object)("Result: " + item));
                        }
                        log.debug((Object)("Is user: " + userName + " in role: " + roleName + " ? " + list.contains(roleName)));
                    } else {
                        log.debug((Object)"No results found !");
                    }
                }
                if (list.contains(roleName)) {
                    return true;
                }
            } else {
                String searchFilter = this.realmConfig.getUserStoreProperty("GroupNameListFilter");
                String membershipProperty = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                if (membershipProperty == null || membershipProperty.length() < 1) {
                    throw new UserStoreException("Please set member of attribute or membership attribute");
                }
                String roleNameProperty = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
                String userDNPattern = this.realmConfig.getUserStoreProperty("UserDNPattern");
                String nameInSpace = userDNPattern != null && !userDNPattern.contains("#") ? MessageFormat.format(userDNPattern, userName) : this.getNameInSpaceForUserName(userName);
                searchFilter = "(&" + searchFilter + "(" + membershipProperty + "=" + nameInSpace + "))";
                String[] returnedAtts = new String[]{roleNameProperty};
                searchCtls.setReturningAttributes(returnedAtts);
                if (debug) {
                    log.debug((Object)("Do check is user : " + userName + " in role: " + roleName));
                    log.debug((Object)("Search filter : " + searchFilter));
                    for (String retAttrib : returnedAtts) {
                        log.debug((Object)("Requesting attribute: " + retAttrib));
                    }
                }
                DirContext dirContext = null;
                NamingEnumeration<SearchResult> answer = null;
                try {
                    dirContext = this.connectionSource.getContext();
                    if (context.getRoleDNPatterns().size() > 0) {
                        for (String pattern : context.getRoleDNPatterns()) {
                            block33: {
                                if (debug) {
                                    log.debug((Object)("Using pattern: " + pattern));
                                }
                                searchBase = MessageFormat.format(pattern.trim(), roleName);
                                try {
                                    answer = dirContext.search(searchBase, searchFilter, searchCtls);
                                }
                                catch (NamingException e) {
                                    if (!log.isDebugEnabled()) break block33;
                                    log.debug((Object)e);
                                }
                            }
                            if (answer != null && answer.hasMoreElements()) {
                                if (debug) {
                                    log.debug((Object)("User: " + userName + " in role: " + roleName));
                                }
                                boolean e = true;
                                return e;
                            }
                            if (!debug) continue;
                            log.debug((Object)("User: " + userName + " NOT in role: " + roleName));
                        }
                        break block34;
                    }
                    if (debug) {
                        log.debug((Object)("Do check is user: " + userName + " in role: " + roleName));
                        log.debug((Object)("Search filter: " + searchFilter));
                        for (String retAttrib : returnedAtts) {
                            log.debug((Object)("Requesting attribute: " + retAttrib));
                        }
                    }
                    if ((answer = dirContext.search(searchBase, searchFilter = "(&" + searchFilter + "(" + membershipProperty + "=" + nameInSpace + ") (" + roleNameProperty + "=" + roleName + "))", searchCtls)).hasMoreElements()) {
                        if (debug) {
                            log.debug((Object)("User: " + userName + " in role: " + roleName));
                        }
                        boolean arr$ = true;
                        return arr$;
                    }
                    if (debug) {
                        log.debug((Object)("User: " + userName + " NOT in role: " + roleName));
                    }
                }
                catch (NamingException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
                finally {
                    JNDIUtil.closeNamingEnumeration(answer);
                    JNDIUtil.closeContext(dirContext);
                }
            }
        }
        return false;
    }

    @Override
    public Date getPasswordExpirationTime(String username) throws UserStoreException {
        return null;
    }

    @Override
    public int getTenantId(String username) throws UserStoreException {
        throw new UserStoreException("Invalid operation");
    }

    @Override
    public int getUserId(String username) throws UserStoreException {
        throw new UserStoreException("Invalid operation");
    }

    @Override
    public void doDeleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doDeleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doDeleteUser(String userName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doSetUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public void doUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        throw new UserStoreException("User store is operating in read only mode. Cannot write into the user store.");
    }

    @Override
    public Map<String, String> getProperties(org.wso2.carbon.user.core.tenant.Tenant tenant) throws UserStoreException {
        return this.realmConfig.getUserStoreProperties();
    }

    public void addRememberMe(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        JDBCUserStoreManager jdbcUserStore = new JDBCUserStoreManager(this.dataSource, this.realmConfig, this.realmConfig.getTenantId(), false);
        jdbcUserStore.addRememberMe(userName, token);
    }

    public boolean isValidRememberMeToken(String userName, String token) throws org.wso2.carbon.user.api.UserStoreException {
        try {
            if (this.isExistingUser(userName)) {
                JDBCUserStoreManager jdbcUserStore = new JDBCUserStoreManager(this.dataSource, this.realmConfig, this.realmConfig.getTenantId(), false);
                return jdbcUserStore.isExistingRememberMeToken(userName, token);
            }
        }
        catch (Exception e) {
            log.error((Object)("Validating remember me token failed for" + userName));
        }
        return false;
    }

    private List<String> getGroupNameAttributeValuesOfGroups(List<String> groupDNs) throws UserStoreException {
        log.debug((Object)"GetGroupNameAttributeValuesOfGroups with DN");
        boolean debug = log.isDebugEnabled();
        String groupNameAttribute = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
        String[] returnedAttributes = new String[]{groupNameAttribute};
        ArrayList<String> groupNameAttributeValues = new ArrayList<String>();
        try {
            DirContext dirContext = this.connectionSource.getContext();
            for (String group : groupDNs) {
                Attribute groupAttribute;
                Attributes groupAttributes;
                if (debug) {
                    log.debug((Object)("Using DN: " + group));
                }
                if ((groupAttributes = dirContext.getAttributes(group, returnedAttributes)) == null || (groupAttribute = groupAttributes.get(groupNameAttribute)) == null) continue;
                String groupNameAttributeValue = (String)groupAttribute.get();
                if (debug) {
                    log.debug((Object)(groupNameAttribute + " : " + groupNameAttributeValue));
                }
                groupNameAttributeValues.add(groupNameAttributeValue);
            }
        }
        catch (UserStoreException e) {
            log.debug((Object)"LDAPError", (Throwable)((Object)e));
            throw new UserStoreException("Error in getting group name attribute values of groups");
        }
        catch (NamingException e) {
            log.debug((Object)"LDAPError", (Throwable)e);
            throw new UserStoreException("Error in getting group name attribute values of groups");
        }
        return groupNameAttributeValues;
    }

    public Properties getDefaultUserStoreProperties() {
        Properties properties = new Properties();
        properties.setMandatoryProperties(ReadOnlyLDAPUserStoreConstants.ROLDAP_USERSTORE_PROPERTIES.toArray(new Property[ReadOnlyLDAPUserStoreConstants.ROLDAP_USERSTORE_PROPERTIES.size()]));
        properties.setOptionalProperties(ReadOnlyLDAPUserStoreConstants.OPTIONAL_ROLDAP_USERSTORE_PROPERTIES.toArray(new Property[ReadOnlyLDAPUserStoreConstants.OPTIONAL_ROLDAP_USERSTORE_PROPERTIES.size()]));
        return properties;
    }

    @Override
    public boolean isSharedRole(String roleName, String roleNameBase) {
        String sharedRoleBase;
        return super.isSharedRole(roleName, roleNameBase) && roleNameBase != null && roleNameBase.contains(sharedRoleBase = (String)this.realmConfig.getUserStoreProperties().get("SharedGroupSearchBase"));
    }

    @Override
    protected boolean isOwnRole(String roleName) {
        String[] nameArray = roleName.split("@");
        if (nameArray.length > 1) {
            String currentTenantDomain = CarbonContext.getCurrentContext().getTenantDomain();
            return currentTenantDomain.equalsIgnoreCase(nameArray[1]);
        }
        return super.isOwnRole(roleName);
    }

    @Override
    protected RoleContext createRoleContext(String roleName) {
        LDAPRoleContext roleContext = new LDAPRoleContext();
        String[] rolePortions = roleName.split("@");
        if (rolePortions.length > 1 && (rolePortions[1] == null || rolePortions[1].equals("null"))) {
            rolePortions = new String[]{rolePortions[0]};
        }
        boolean shared = false;
        if (rolePortions.length == 1) {
            roleContext.setSearchBase(this.realmConfig.getUserStoreProperty("GroupSearchBase"));
            roleContext.setTenantDomain(CarbonContext.getCurrentContext().getTenantDomain());
        } else if (rolePortions.length > 1) {
            String tenantDomain = rolePortions[1].toLowerCase();
            roleContext.setTenantDomain(rolePortions[1]);
            String base = this.realmConfig.getUserStoreProperty("SharedGroupSearchBase");
            if (!rolePortions[1].equalsIgnoreCase("carbon.super")) {
                String groupNameAttributeName = this.realmConfig.getUserStoreProperty("SharedTenantNameAttribute");
                base = groupNameAttributeName + "=" + rolePortions[1] + "," + base;
            }
            String roleDNPattern = this.realmConfig.getUserStoreProperty("GroupNameAttribute") + "={0}," + base;
            roleContext.setSearchBase(base);
            roleContext.addRoleDNPatterns(roleDNPattern);
            shared = true;
        }
        if (shared) {
            roleContext.setSearchFilter(this.realmConfig.getUserStoreProperty("GroupNameSearchFilter"));
            roleContext.setRoleNameProperty(this.realmConfig.getUserStoreProperty("GroupNameAttribute"));
            roleContext.setListFilter(this.realmConfig.getUserStoreProperty("GroupNameListFilter"));
            roleContext.setGroupEntryObjectClass(this.realmConfig.getUserStoreProperty("GroupEntryObjectClass"));
        } else {
            roleContext.setSearchFilter(this.realmConfig.getUserStoreProperty("GroupNameSearchFilter"));
            roleContext.setRoleNameProperty(this.realmConfig.getUserStoreProperty("GroupNameAttribute"));
            roleContext.setListFilter(this.realmConfig.getUserStoreProperty("GroupNameListFilter"));
            roleContext.setGroupEntryObjectClass(this.realmConfig.getUserStoreProperty("GroupEntryObjectClass"));
            String roleDNPattern = this.realmConfig.getUserStoreProperty("RoleDNPattern");
            if (roleDNPattern != null && roleDNPattern.trim().length() > 0) {
                if (roleDNPattern.contains("#")) {
                    String[] patterns;
                    for (String pattern : patterns = roleDNPattern.split("#")) {
                        roleContext.addRoleDNPatterns(pattern);
                    }
                } else {
                    roleContext.addRoleDNPatterns(roleDNPattern);
                }
            }
        }
        roleContext.setRoleName(rolePortions[0]);
        roleContext.setShared(shared);
        return roleContext;
    }
}

