/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference;
import org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile;
import org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeHostPreferenceResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceResource;
import org.apache.airavata.registry.core.app.catalog.resources.GatewayProfileResource;
import org.apache.airavata.registry.core.app.catalog.resources.StoragePreferenceResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogThriftConversion;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.GwyResourceProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwyResourceProfileImpl
implements GwyResourceProfile {
    private static final Logger logger = LoggerFactory.getLogger(GwyResourceProfileImpl.class);

    public String addGatewayResourceProfile(GatewayResourceProfile gatewayProfile) throws AppCatalogException {
        try {
            List dataStoragePreferences;
            GatewayProfileResource profileResource = new GatewayProfileResource();
            if (!gatewayProfile.getGatewayID().equals("")) {
                profileResource.setGatewayID(gatewayProfile.getGatewayID());
            }
            if (gatewayProfile.getCredentialStoreToken() != null) {
                profileResource.setCredentialStoreToken(gatewayProfile.getCredentialStoreToken());
            }
            if (gatewayProfile.getIdentityServerTenant() != null) {
                profileResource.setIdentityServerTenant(gatewayProfile.getIdentityServerTenant());
            }
            if (gatewayProfile.getIdentityServerPwdCredToken() != null) {
                profileResource.setIdentityServerPwdCredToken(gatewayProfile.getIdentityServerPwdCredToken());
            }
            profileResource.setGatewayID(gatewayProfile.getGatewayID());
            profileResource.save();
            List computeResourcePreferences = gatewayProfile.getComputeResourcePreferences();
            if (computeResourcePreferences != null && !computeResourcePreferences.isEmpty()) {
                for (ComputeResourcePreference preference : computeResourcePreferences) {
                    ComputeHostPreferenceResource resource = new ComputeHostPreferenceResource();
                    resource.setGatewayProfile(profileResource);
                    resource.setResourceId(preference.getComputeResourceId());
                    ComputeResourceResource computeHostResource = new ComputeResourceResource();
                    resource.setComputeHostResource((ComputeResourceResource)computeHostResource.get(preference.getComputeResourceId()));
                    resource.setGatewayId(profileResource.getGatewayID());
                    resource.setOverrideByAiravata(preference.isOverridebyAiravata());
                    resource.setLoginUserName(preference.getLoginUserName());
                    resource.setResourceCSToken(preference.getResourceSpecificCredentialStoreToken());
                    resource.setUsageReportingGatewayId(preference.getUsageReportingGatewayId());
                    if (preference.getPreferredJobSubmissionProtocol() != null) {
                        resource.setPreferredJobProtocol(preference.getPreferredJobSubmissionProtocol().toString());
                    }
                    if (preference.getPreferredDataMovementProtocol() != null) {
                        resource.setPreferedDMProtocol(preference.getPreferredDataMovementProtocol().toString());
                    }
                    resource.setBatchQueue(preference.getPreferredBatchQueue());
                    resource.setProjectNumber(preference.getAllocationProjectNumber());
                    resource.setScratchLocation(preference.getScratchLocation());
                    resource.setQualityOfService(preference.getQualityOfService());
                    resource.setReservation(preference.getReservation());
                    if (preference.getReservationStartTime() > 0L) {
                        resource.setReservationStartTime(AiravataUtils.getTime((long)preference.getReservationStartTime()));
                    }
                    if (preference.getReservationEndTime() > 0L) {
                        resource.setReservationEndTime(AiravataUtils.getTime((long)preference.getReservationEndTime()));
                    }
                    resource.setSshAccountProvisioner(preference.getSshAccountProvisioner());
                    if (preference.getSshAccountProvisionerConfig() != null && !preference.getSshAccountProvisionerConfig().isEmpty()) {
                        HashMap<String, String> sshAccountProvisionerConfigurationsCopy = new HashMap<String, String>(preference.getSshAccountProvisionerConfig());
                        resource.setSshAccountProvisionerConfigurations(sshAccountProvisionerConfigurationsCopy);
                    }
                    resource.setSshAccountProvisionerAdditionalInfo(preference.getSshAccountProvisionerAdditionalInfo());
                    resource.save();
                }
            }
            if ((dataStoragePreferences = gatewayProfile.getStoragePreferences()) != null && !dataStoragePreferences.isEmpty()) {
                for (StoragePreference storagePreference : dataStoragePreferences) {
                    StoragePreferenceResource resource = new StoragePreferenceResource();
                    resource.setStorageResourceId(storagePreference.getStorageResourceId());
                    resource.setGatewayId(profileResource.getGatewayID());
                    resource.setFsRootLocation(storagePreference.getFileSystemRootLocation());
                    resource.setLoginUserName(storagePreference.getLoginUserName());
                    resource.setResourceCSToken(storagePreference.getResourceSpecificCredentialStoreToken());
                    resource.setGatewayProfile(profileResource);
                    resource.save();
                }
            }
            return profileResource.getGatewayID();
        }
        catch (Exception e) {
            logger.error("Error while saving gateway profile...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public void updateGatewayResourceProfile(String gatewayId, GatewayResourceProfile updatedProfile) throws AppCatalogException {
        try {
            List dataStoragePreferences;
            GatewayProfileResource profileResource = new GatewayProfileResource();
            GatewayProfileResource existingGP = (GatewayProfileResource)profileResource.get(gatewayId);
            existingGP.setCredentialStoreToken(updatedProfile.getCredentialStoreToken());
            existingGP.setIdentityServerTenant(updatedProfile.getIdentityServerTenant());
            existingGP.setIdentityServerPwdCredToken(updatedProfile.getIdentityServerPwdCredToken());
            existingGP.save();
            List computeResourcePreferences = updatedProfile.getComputeResourcePreferences();
            if (computeResourcePreferences != null && !computeResourcePreferences.isEmpty()) {
                for (ComputeResourcePreference preference : computeResourcePreferences) {
                    ComputeHostPreferenceResource resource = new ComputeHostPreferenceResource();
                    resource.setGatewayProfile(existingGP);
                    resource.setResourceId(preference.getComputeResourceId());
                    ComputeResourceResource computeHostResource = new ComputeResourceResource();
                    resource.setComputeHostResource((ComputeResourceResource)computeHostResource.get(preference.getComputeResourceId()));
                    resource.setGatewayId(gatewayId);
                    resource.setLoginUserName(preference.getLoginUserName());
                    resource.setOverrideByAiravata(preference.isOverridebyAiravata());
                    if (preference.getPreferredJobSubmissionProtocol() != null) {
                        resource.setPreferredJobProtocol(preference.getPreferredJobSubmissionProtocol().toString());
                    }
                    if (preference.getPreferredDataMovementProtocol() != null) {
                        resource.setPreferedDMProtocol(preference.getPreferredDataMovementProtocol().toString());
                    }
                    resource.setBatchQueue(preference.getPreferredBatchQueue());
                    resource.setProjectNumber(preference.getAllocationProjectNumber());
                    resource.setScratchLocation(preference.getScratchLocation());
                    resource.setResourceCSToken(preference.getResourceSpecificCredentialStoreToken());
                    resource.setUsageReportingGatewayId(preference.getUsageReportingGatewayId());
                    resource.setQualityOfService(preference.getQualityOfService());
                    resource.setReservation(preference.getReservation());
                    if (preference.getReservationStartTime() > 0L) {
                        resource.setReservationStartTime(AiravataUtils.getTime((long)preference.getReservationStartTime()));
                    }
                    if (preference.getReservationEndTime() > 0L) {
                        resource.setReservationEndTime(AiravataUtils.getTime((long)preference.getReservationEndTime()));
                    }
                    resource.setSshAccountProvisioner(preference.getSshAccountProvisioner());
                    if (preference.getSshAccountProvisionerConfig() != null && !preference.getSshAccountProvisionerConfig().isEmpty()) {
                        HashMap<String, String> sshAccountProvisionerConfigurationsCopy = new HashMap<String, String>(preference.getSshAccountProvisionerConfig());
                        resource.setSshAccountProvisionerConfigurations(sshAccountProvisionerConfigurationsCopy);
                    }
                    resource.setSshAccountProvisionerAdditionalInfo(preference.getSshAccountProvisionerAdditionalInfo());
                    resource.save();
                }
            }
            if ((dataStoragePreferences = updatedProfile.getStoragePreferences()) != null && !dataStoragePreferences.isEmpty()) {
                for (StoragePreference storagePreference : dataStoragePreferences) {
                    StoragePreferenceResource resource = new StoragePreferenceResource();
                    resource.setStorageResourceId(storagePreference.getStorageResourceId());
                    resource.setGatewayId(existingGP.getGatewayID());
                    resource.setFsRootLocation(storagePreference.getFileSystemRootLocation());
                    resource.setLoginUserName(storagePreference.getLoginUserName());
                    resource.setResourceCSToken(storagePreference.getResourceSpecificCredentialStoreToken());
                    resource.setGatewayProfile(existingGP);
                    resource.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating gateway profile...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public GatewayResourceProfile getGatewayProfile(String gatewayId) throws AppCatalogException {
        try {
            GatewayProfileResource resource = new GatewayProfileResource();
            GatewayProfileResource gwresource = (GatewayProfileResource)resource.get(gatewayId);
            ComputeHostPreferenceResource prefResource = new ComputeHostPreferenceResource();
            List<AppCatalogResource> computePrefList = prefResource.get("gatewayId", gatewayId);
            List<ComputeResourcePreference> computeResourcePreferences = AppCatalogThriftConversion.getComputeResourcePreferences(computePrefList);
            List<StoragePreference> dataStoragePreferences = this.getAllStoragePreferences(gatewayId);
            return AppCatalogThriftConversion.getGatewayResourceProfile(gwresource, computeResourcePreferences, dataStoragePreferences);
        }
        catch (Exception e) {
            logger.error("Error while retrieving gateway profile...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public boolean removeGatewayResourceProfile(String gatewayId) throws AppCatalogException {
        try {
            GatewayProfileResource resource = new GatewayProfileResource();
            resource.remove(gatewayId);
            return true;
        }
        catch (Exception e) {
            logger.error("Error while deleting gateway profile...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public boolean removeComputeResourcePreferenceFromGateway(String gatewayId, String preferenceId) throws AppCatalogException {
        try {
            ComputeHostPreferenceResource resource = new ComputeHostPreferenceResource();
            HashMap<String, String> ids = new HashMap<String, String>();
            ids.put("gatewayId", gatewayId);
            ids.put("resourceId", preferenceId);
            resource.remove(ids);
            return true;
        }
        catch (Exception e) {
            logger.error("Error while deleting gateway profile...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public boolean removeDataStoragePreferenceFromGateway(String gatewayId, String preferenceId) throws AppCatalogException {
        try {
            StoragePreferenceResource resource = new StoragePreferenceResource();
            HashMap<String, String> ids = new HashMap<String, String>();
            ids.put("gatewayId", gatewayId);
            ids.put("storageResourceId", preferenceId);
            resource.remove(ids);
            return true;
        }
        catch (Exception e) {
            logger.error("Error while deleting gateway profile...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public boolean isGatewayResourceProfileExists(String gatewayId) throws AppCatalogException {
        try {
            GatewayProfileResource resource = new GatewayProfileResource();
            return resource.isExists(gatewayId);
        }
        catch (Exception e) {
            logger.error("Error while retrieving gateway profile...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public ComputeResourcePreference getComputeResourcePreference(String gatewayId, String hostId) throws AppCatalogException {
        try {
            ComputeHostPreferenceResource prefResource = new ComputeHostPreferenceResource();
            List<AppCatalogResource> computePrefList = prefResource.get("gatewayId", gatewayId);
            for (AppCatalogResource resource : computePrefList) {
                ComputeHostPreferenceResource cmP = (ComputeHostPreferenceResource)resource;
                if (cmP.getResourceId() == null || cmP.getResourceId().equals("") || !cmP.getResourceId().equals(hostId)) continue;
                return AppCatalogThriftConversion.getComputeResourcePreference(cmP);
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving compute resource preference...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        return null;
    }

    public StoragePreference getStoragePreference(String gatewayId, String storageId) throws AppCatalogException {
        try {
            StoragePreferenceResource prefResource = new StoragePreferenceResource();
            List<AppCatalogResource> computePrefList = prefResource.get("gatewayId", gatewayId);
            for (AppCatalogResource resource : computePrefList) {
                StoragePreferenceResource dsP = (StoragePreferenceResource)resource;
                if (dsP.getStorageResourceId() == null || dsP.getStorageResourceId().equals("") || !dsP.getStorageResourceId().equals(storageId)) continue;
                return AppCatalogThriftConversion.getDataStoragePreference(dsP);
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving data storage preference...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        return null;
    }

    public List<ComputeResourcePreference> getAllComputeResourcePreferences(String gatewayId) throws AppCatalogException {
        try {
            ComputeHostPreferenceResource prefResource = new ComputeHostPreferenceResource();
            List<AppCatalogResource> computePrefList = prefResource.get("gatewayId", gatewayId);
            return AppCatalogThriftConversion.getComputeResourcePreferences(computePrefList);
        }
        catch (Exception e) {
            logger.error("Error while retrieving compute resource preference...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public List<StoragePreference> getAllStoragePreferences(String gatewayId) throws AppCatalogException {
        try {
            StoragePreferenceResource prefResource = new StoragePreferenceResource();
            List<AppCatalogResource> dataStoragePrefList = prefResource.get("gatewayId", gatewayId);
            return AppCatalogThriftConversion.getDataStoragePreferences(dataStoragePrefList);
        }
        catch (Exception e) {
            logger.error("Error while retrieving data storage preference...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public List<String> getGatewayProfileIds(String gatewayName) throws AppCatalogException {
        try {
            GatewayProfileResource profileResource = new GatewayProfileResource();
            List<AppCatalogResource> resourceList = profileResource.get("gatewayID", gatewayName);
            ArrayList<String> gatewayIds = new ArrayList<String>();
            if (resourceList != null && !resourceList.isEmpty()) {
                for (AppCatalogResource resource : resourceList) {
                    gatewayIds.add(((GatewayProfileResource)resource).getGatewayID());
                }
            }
            return gatewayIds;
        }
        catch (Exception e) {
            logger.error("Error while retrieving gateway ids...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public List<GatewayResourceProfile> getAllGatewayProfiles() throws AppCatalogException {
        try {
            ArrayList<GatewayResourceProfile> gatewayResourceProfileList = new ArrayList<GatewayResourceProfile>();
            GatewayProfileResource profileResource = new GatewayProfileResource();
            List<AppCatalogResource> resourceList = profileResource.getAll();
            if (resourceList != null && !resourceList.isEmpty()) {
                for (AppCatalogResource resource : resourceList) {
                    GatewayProfileResource gatewayProfileResource = (GatewayProfileResource)resource;
                    List<ComputeResourcePreference> computeResourcePreferences = this.getAllComputeResourcePreferences(gatewayProfileResource.getGatewayID());
                    List<StoragePreference> dataStoragePreferences = this.getAllStoragePreferences(gatewayProfileResource.getGatewayID());
                    GatewayResourceProfile gatewayResourceProfile = AppCatalogThriftConversion.getGatewayResourceProfile(gatewayProfileResource, computeResourcePreferences, dataStoragePreferences);
                    gatewayResourceProfileList.add(gatewayResourceProfile);
                }
            }
            return gatewayResourceProfileList;
        }
        catch (Exception e) {
            logger.error("Error while retrieving gateway ids...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }
}

