/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.statistics.query;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class StatisticsRecord {
    private AtomicInteger nestedDepth = new AtomicInteger();
    private Collection<String> records = null;
    private List<String> queries = new LinkedList<String>();
    private String operation = null;

    public StatisticsRecord() {
        this.init();
    }

    private void init() {
        this.records = Boolean.toString(true).equals(System.getProperty("carbon.registry.statistics.preserve.duplicate.table.accesses")) ? new LinkedList<String>() : new LinkedHashSet<String>();
    }

    public StatisticsRecord(StatisticsRecord record) {
        this.init();
        this.nestedDepth.set(record.nestedDepth.get());
        this.records.addAll(record.records);
        this.queries.addAll(record.queries);
        this.operation = record.operation;
    }

    public int increment() {
        return this.nestedDepth.getAndIncrement();
    }

    public int decrement() {
        return this.nestedDepth.decrementAndGet();
    }

    public String[] getTableRecords() {
        return this.records.toArray(new String[this.records.size()]);
    }

    public void addRecord(String record) {
        this.records.add(record);
    }

    public String[] getQueries() {
        return this.queries.toArray(new String[this.queries.size()]);
    }

    public void addQuery(String query) {
        this.queries.add(query);
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }
}

