/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentity.model.UnlinkIdentityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class UnlinkIdentityRequestMarshaller
implements Marshaller<Request<UnlinkIdentityRequest>, UnlinkIdentityRequest> {
    public Request<UnlinkIdentityRequest> marshall(UnlinkIdentityRequest unlinkIdentityRequest) {
        if (unlinkIdentityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)unlinkIdentityRequest, "AmazonCognitoIdentity");
        String target = "AWSCognitoIdentityService.UnlinkIdentity";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag loginsToRemoveList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (unlinkIdentityRequest.getIdentityId() != null) {
                jsonWriter.key("IdentityId").value((Object)unlinkIdentityRequest.getIdentityId());
            }
            if (unlinkIdentityRequest.getLogins() != null) {
                jsonWriter.key("Logins");
                jsonWriter.object();
                for (Map.Entry<String, String> loginsListValue : unlinkIdentityRequest.getLogins().entrySet()) {
                    if (loginsListValue.getValue() == null) continue;
                    jsonWriter.key(loginsListValue.getKey());
                    jsonWriter.value((Object)loginsListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!((loginsToRemoveList = (ListWithAutoConstructFlag)unlinkIdentityRequest.getLoginsToRemove()) == null || loginsToRemoveList.isAutoConstruct() && loginsToRemoveList.isEmpty())) {
                jsonWriter.key("LoginsToRemove");
                jsonWriter.array();
                for (String loginsToRemoveListValue : loginsToRemoveList) {
                    if (loginsToRemoveListValue == null) continue;
                    jsonWriter.value((Object)loginsToRemoveListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

