/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.xml;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.bval.jsr303.xml.AnnotationProxyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProxy
implements Annotation,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Annotation> annotationType;
    private final Map<String, Object> values;

    public <A extends Annotation> AnnotationProxy(AnnotationProxyBuilder<A> descriptor) {
        this.annotationType = descriptor.getType();
        this.values = this.getAnnotationValues(descriptor);
    }

    private <A extends Annotation> Map<String, Object> getAnnotationValues(AnnotationProxyBuilder<A> descriptor) {
        Method[] declaredMethods;
        HashMap<String, Object> result = new HashMap<String, Object>();
        int processedValuesFromDescriptor = 0;
        for (Method m : declaredMethods = SecureActions.getDeclaredMethods(this.annotationType)) {
            if (descriptor.contains(m.getName())) {
                result.put(m.getName(), descriptor.getValue(m.getName()));
                ++processedValuesFromDescriptor;
                continue;
            }
            if (m.getDefaultValue() != null) {
                result.put(m.getName(), m.getDefaultValue());
                continue;
            }
            throw new IllegalArgumentException("No value provided for " + m.getName());
        }
        if (processedValuesFromDescriptor != descriptor.size()) {
            throw new RuntimeException("Trying to instanciate " + this.annotationType + " with unknown paramters.");
        }
        return result;
    }

    @Override
    public Object invoke(Object proxy2, Method method, Object[] args) throws Throwable {
        if (this.values.containsKey(method.getName())) {
            return this.values.get(method.getName());
        }
        return method.invoke((Object)this, args);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('@').append(this.annotationType().getName()).append('(');
        boolean comma = false;
        for (String m : this.getMethodsSorted()) {
            if (comma) {
                result.append(", ");
            }
            result.append(m).append('=').append(this.values.get(m));
            comma = true;
        }
        result.append(")");
        return result.toString();
    }

    private SortedSet<String> getMethodsSorted() {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(this.values.keySet());
        return result;
    }
}

