/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util;

import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtils {
    private static DummySecurityManager MANAGER = new DummySecurityManager();

    public static Class[] getClassContext() {
        return MANAGER.getClassContext();
    }

    public static Class getClassContextAt(int i) {
        Class[] classes = MANAGER.getClassContext();
        if (classes != null && classes.length > i) {
            return classes[i];
        }
        return null;
    }

    public static ClassLoader getClassLoaderContextAt(int i) {
        Class[] classes = MANAGER.getClassContext();
        if (classes != null && classes.length > i) {
            return classes[i].getClassLoader();
        }
        return null;
    }

    public static InputStream getResourceAsStream(String name) {
        ClassLoader contextLoader;
        InputStream in;
        ClassLoader loader = ClassLoaderUtils.getClassLoaderContextAt(3);
        InputStream inputStream = in = loader == null ? null : loader.getResourceAsStream(name);
        if (in == null && (contextLoader = Thread.currentThread().getContextClassLoader()) != null && contextLoader != loader) {
            in = contextLoader.getResourceAsStream(name);
        }
        return in;
    }

    public static Class forName(String name) throws ClassNotFoundException {
        ClassLoader loader = ClassLoaderUtils.getClassLoaderContextAt(3);
        try {
            return Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException e) {
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            if (contextLoader == null || contextLoader == loader) {
                throw e;
            }
            return Class.forName(name, true, contextLoader);
        }
    }

    public static Class<?> loadClass(String className, Class<?> callingClass) throws ClassNotFoundException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return ClassLoaderUtils.loadClass2(className, callingClass);
    }

    private static Class<?> loadClass2(String className, Class<?> callingClass) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            block5: {
                try {
                    if (ClassLoaderUtils.class.getClassLoader() != null) {
                        return ClassLoaderUtils.class.getClassLoader().loadClass(className);
                    }
                }
                catch (ClassNotFoundException exc) {
                    if (callingClass == null || callingClass.getClassLoader() == null) break block5;
                    return callingClass.getClassLoader().loadClass(className);
                }
            }
            throw ex;
        }
    }

    private static class DummySecurityManager
    extends SecurityManager {
        private DummySecurityManager() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

