/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ParameterStaxUnmarshaller
implements Unmarshaller<Parameter, StaxUnmarshallerContext> {
    private static ParameterStaxUnmarshaller instance;

    public Parameter unmarshall(StaxUnmarshallerContext context) throws Exception {
        Parameter parameter = new Parameter();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return parameter;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ParameterKey", targetDepth)) {
                    parameter.setParameterKey(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ParameterValue", targetDepth)) {
                    parameter.setParameterValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("UsePreviousValue", targetDepth)) continue;
                parameter.setUsePreviousValue(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return parameter;
    }

    public static ParameterStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ParameterStaxUnmarshaller();
        }
        return instance;
    }
}

