/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil;

import eu.unicore.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConditionalGetServerOutHandler
extends AbstractSoapInterceptor {
    private static final Logger logger = Log.getLogger("unicore.client", ConditionalGetServerOutHandler.class);
    private static final ThreadLocal<String> etags = new ThreadLocal();
    private static final ThreadLocal<String> lastModified = new ThreadLocal();
    private static final ThreadLocal<Boolean> notModified = new ThreadLocal();
    public static final String CG_HEADER_NS = "http://www.unicore.eu/unicore/ws";
    public static final String CG_HEADER = "ConditionalGet";
    private static final QName headerQName = new QName("http://www.unicore.eu/unicore/ws", "ConditionalGet");

    public ConditionalGetServerOutHandler() {
        super("pre-protocol");
    }

    public Element buildHeader() {
        Element header = null;
        try {
            String etag = etags.get();
            String modifiedTime = lastModified.get();
            Boolean noMod = notModified.get();
            if (noMod == null && etag == null && modifiedTime == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<cget:ConditionalGet xmlns:cget=\"http://www.unicore.eu/unicore/ws\">");
            if (noMod != null) {
                sb.append("<cget:NotModified/>");
            } else {
                if (etag != null) {
                    sb.append("<cget:Etag>" + etag + "</cget:Etag>");
                }
                if (modifiedTime != null) {
                    sb.append("<cget:LastModified>" + modifiedTime + "</cget:LastModified>");
                }
            }
            sb.append("</cget:ConditionalGet>");
            try {
                header = DOMUtils.readXml((InputStream)new ByteArrayInputStream(sb.toString().getBytes())).getDocumentElement();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (logger.isDebugEnabled()) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DOMUtils.writeXml((Node)header, (OutputStream)bos);
                    logger.debug(bos.toString());
                }
                catch (Exception e) {
                    logger.warn("", e);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleMessage(SoapMessage message) {
        try {
            if (!MessageUtils.isOutbound((Message)message)) {
                return;
            }
            Element header = this.buildHeader();
            if (header == null) {
                return;
            }
            List h = message.getHeaders();
            h.add(new Header(headerQName, (Object)header));
        }
        finally {
            etags.remove();
            lastModified.remove();
            notModified.remove();
        }
    }

    public static void setEtag(String etag) {
        etags.set(etag);
    }

    public static void setLastModified(String time) {
        lastModified.set(time);
    }

    public static void setNotModified() {
        notModified.set(Boolean.TRUE);
    }
}

