/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.proto;

import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.exceptions.SAMLServerException;
import eu.unicore.samly2.proto.AbstractStatusResponse;
import eu.unicore.security.dsig.DSigException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;
import xmlbeans.org.oasis.saml2.assertion.AssertionType;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.protocol.ResponseDocument;
import xmlbeans.org.oasis.saml2.protocol.ResponseType;
import xmlbeans.org.oasis.saml2.protocol.StatusType;

public class AssertionResponse
extends AbstractStatusResponse<ResponseDocument, ResponseType> {
    public AssertionResponse(NameIDType issuer, String inResponseTo) {
        this(issuer, inResponseTo, AssertionResponse.createOKStatus());
    }

    public AssertionResponse(NameIDType issuer, String inResponseTo, SAMLServerException error) {
        this(issuer, inResponseTo, AssertionResponse.createErrorStatus(error));
    }

    protected AssertionResponse(NameIDType issuer, String inResponseTo, StatusType status) {
        ResponseDocument xbdoc = ResponseDocument.Factory.newInstance();
        this.init(xbdoc, xbdoc.addNewResponse(), issuer, inResponseTo);
        ((ResponseType)this.getXMLBean()).setStatus(status);
    }

    public void addAssertion(Assertion ass) {
        AssertionType at = ((ResponseType)this.getXMLBean()).addNewAssertion();
        at.set(ass.getXMLBean());
    }

    @Override
    public void sign(PrivateKey pk, X509Certificate[] cert) throws DSigException {
        Document doc = this.signInt(pk, cert);
        try {
            this.xmlDocuemnt = ResponseDocument.Factory.parse(doc);
            this.xmlResp = ((ResponseDocument)this.xmlDocuemnt).getResponse();
        }
        catch (XmlException e) {
            throw new DSigException("Parsing signed document failed", e);
        }
    }
}

