/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AuthorizeSnapshotAccessRequestMarshaller
implements Marshaller<Request<AuthorizeSnapshotAccessRequest>, AuthorizeSnapshotAccessRequest> {
    public Request<AuthorizeSnapshotAccessRequest> marshall(AuthorizeSnapshotAccessRequest authorizeSnapshotAccessRequest) {
        if (authorizeSnapshotAccessRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)authorizeSnapshotAccessRequest, "AmazonRedshift");
        request.addParameter("Action", "AuthorizeSnapshotAccess");
        request.addParameter("Version", "2012-12-01");
        if (authorizeSnapshotAccessRequest.getSnapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)authorizeSnapshotAccessRequest.getSnapshotIdentifier()));
        }
        if (authorizeSnapshotAccessRequest.getSnapshotClusterIdentifier() != null) {
            request.addParameter("SnapshotClusterIdentifier", StringUtils.fromString((String)authorizeSnapshotAccessRequest.getSnapshotClusterIdentifier()));
        }
        if (authorizeSnapshotAccessRequest.getAccountWithRestoreAccess() != null) {
            request.addParameter("AccountWithRestoreAccess", StringUtils.fromString((String)authorizeSnapshotAccessRequest.getAccountWithRestoreAccess()));
        }
        return request;
    }
}

