/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#include "user_profile_model_types.h"

#include <algorithm>
#include <ostream>

#include <thrift/TToString.h>

namespace apache { namespace airavata { namespace model { namespace user {

int _kStatusValues[] = {
  Status::ACTIVE,
  Status::CONFIRMED,
  Status::APPROVED,
  Status::DELETED,
  Status::DUPLICATE,
  Status::GRACE_PERIOD,
  Status::INVITED,
  Status::DENIED,
  Status::PENDING,
  Status::PENDING_APPROVAL,
  Status::PENDING_CONFIRMATION,
  Status::SUSPENDED,
  Status::DECLINED,
  Status::EXPIRED
};
const char* _kStatusNames[] = {
  "ACTIVE",
  "CONFIRMED",
  "APPROVED",
  "DELETED",
  "DUPLICATE",
  "GRACE_PERIOD",
  "INVITED",
  "DENIED",
  "PENDING",
  "PENDING_APPROVAL",
  "PENDING_CONFIRMATION",
  "SUSPENDED",
  "DECLINED",
  "EXPIRED"
};
const std::map<int, const char*> _Status_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(14, _kStatusValues, _kStatusNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kUSCitizenshipValues[] = {
  USCitizenship::US_CITIZEN,
  USCitizenship::US_PERMANENT_RESIDENT,
  USCitizenship::OTHER_NON_US_CITIZEN
};
const char* _kUSCitizenshipNames[] = {
  "US_CITIZEN",
  "US_PERMANENT_RESIDENT",
  "OTHER_NON_US_CITIZEN"
};
const std::map<int, const char*> _USCitizenship_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(3, _kUSCitizenshipValues, _kUSCitizenshipNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kethnicityValues[] = {
  ethnicity::HISPANIC_LATINO,
  ethnicity::NOT_HISPANIC_LATINO
};
const char* _kethnicityNames[] = {
  "HISPANIC_LATINO",
  "NOT_HISPANIC_LATINO"
};
const std::map<int, const char*> _ethnicity_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(2, _kethnicityValues, _kethnicityNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kraceValues[] = {
  race::ASIAN,
  race::AMERICAN_INDIAN_OR_ALASKAN_NATIVE,
  race::BLACK_OR_AFRICAN_AMERICAN,
  race::NATIVE_HAWAIIAN_OR_PACIFIC_ISLANDER,
  race::WHITE
};
const char* _kraceNames[] = {
  "ASIAN",
  "AMERICAN_INDIAN_OR_ALASKAN_NATIVE",
  "BLACK_OR_AFRICAN_AMERICAN",
  "NATIVE_HAWAIIAN_OR_PACIFIC_ISLANDER",
  "WHITE"
};
const std::map<int, const char*> _race_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(5, _kraceValues, _kraceNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kdisabilityValues[] = {
  disability::HEARING_IMAPAIRED,
  disability::VISUAL_IMPAIRED,
  disability::MOBILITY_OR_ORTHOPEDIC_IMPAIRMENT,
  disability::OTHER_IMPAIRMENT
};
const char* _kdisabilityNames[] = {
  "HEARING_IMAPAIRED",
  "VISUAL_IMPAIRED",
  "MOBILITY_OR_ORTHOPEDIC_IMPAIRMENT",
  "OTHER_IMPAIRMENT"
};
const std::map<int, const char*> _disability_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(4, _kdisabilityValues, _kdisabilityNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));


NSFDemographics::~NSFDemographics() throw() {
}


void NSFDemographics::__set_airavataInternalUserId(const std::string& val) {
  this->airavataInternalUserId = val;
}

void NSFDemographics::__set_gender(const std::string& val) {
  this->gender = val;
__isset.gender = true;
}

void NSFDemographics::__set_usCitizenship(const USCitizenship::type val) {
  this->usCitizenship = val;
__isset.usCitizenship = true;
}

void NSFDemographics::__set_ethnicities(const std::vector<ethnicity::type> & val) {
  this->ethnicities = val;
__isset.ethnicities = true;
}

void NSFDemographics::__set_races(const std::vector<race::type> & val) {
  this->races = val;
__isset.races = true;
}

void NSFDemographics::__set_disabilities(const std::vector<disability::type> & val) {
  this->disabilities = val;
__isset.disabilities = true;
}

uint32_t NSFDemographics::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_airavataInternalUserId = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->airavataInternalUserId);
          isset_airavataInternalUserId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gender);
          this->__isset.gender = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast0;
          xfer += iprot->readI32(ecast0);
          this->usCitizenship = (USCitizenship::type)ecast0;
          this->__isset.usCitizenship = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->ethnicities.clear();
            uint32_t _size1;
            ::apache::thrift::protocol::TType _etype4;
            xfer += iprot->readListBegin(_etype4, _size1);
            this->ethnicities.resize(_size1);
            uint32_t _i5;
            for (_i5 = 0; _i5 < _size1; ++_i5)
            {
              int32_t ecast6;
              xfer += iprot->readI32(ecast6);
              this->ethnicities[_i5] = (ethnicity::type)ecast6;
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.ethnicities = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->races.clear();
            uint32_t _size7;
            ::apache::thrift::protocol::TType _etype10;
            xfer += iprot->readListBegin(_etype10, _size7);
            this->races.resize(_size7);
            uint32_t _i11;
            for (_i11 = 0; _i11 < _size7; ++_i11)
            {
              int32_t ecast12;
              xfer += iprot->readI32(ecast12);
              this->races[_i11] = (race::type)ecast12;
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.races = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->disabilities.clear();
            uint32_t _size13;
            ::apache::thrift::protocol::TType _etype16;
            xfer += iprot->readListBegin(_etype16, _size13);
            this->disabilities.resize(_size13);
            uint32_t _i17;
            for (_i17 = 0; _i17 < _size13; ++_i17)
            {
              int32_t ecast18;
              xfer += iprot->readI32(ecast18);
              this->disabilities[_i17] = (disability::type)ecast18;
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.disabilities = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_airavataInternalUserId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t NSFDemographics::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("NSFDemographics");

  xfer += oprot->writeFieldBegin("airavataInternalUserId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->airavataInternalUserId);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.gender) {
    xfer += oprot->writeFieldBegin("gender", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeString(this->gender);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.usCitizenship) {
    xfer += oprot->writeFieldBegin("usCitizenship", ::apache::thrift::protocol::T_I32, 3);
    xfer += oprot->writeI32((int32_t)this->usCitizenship);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.ethnicities) {
    xfer += oprot->writeFieldBegin("ethnicities", ::apache::thrift::protocol::T_LIST, 4);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_I32, static_cast<uint32_t>(this->ethnicities.size()));
      std::vector<ethnicity::type> ::const_iterator _iter19;
      for (_iter19 = this->ethnicities.begin(); _iter19 != this->ethnicities.end(); ++_iter19)
      {
        xfer += oprot->writeI32((int32_t)(*_iter19));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.races) {
    xfer += oprot->writeFieldBegin("races", ::apache::thrift::protocol::T_LIST, 5);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_I32, static_cast<uint32_t>(this->races.size()));
      std::vector<race::type> ::const_iterator _iter20;
      for (_iter20 = this->races.begin(); _iter20 != this->races.end(); ++_iter20)
      {
        xfer += oprot->writeI32((int32_t)(*_iter20));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.disabilities) {
    xfer += oprot->writeFieldBegin("disabilities", ::apache::thrift::protocol::T_LIST, 6);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_I32, static_cast<uint32_t>(this->disabilities.size()));
      std::vector<disability::type> ::const_iterator _iter21;
      for (_iter21 = this->disabilities.begin(); _iter21 != this->disabilities.end(); ++_iter21)
      {
        xfer += oprot->writeI32((int32_t)(*_iter21));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(NSFDemographics &a, NSFDemographics &b) {
  using ::std::swap;
  swap(a.airavataInternalUserId, b.airavataInternalUserId);
  swap(a.gender, b.gender);
  swap(a.usCitizenship, b.usCitizenship);
  swap(a.ethnicities, b.ethnicities);
  swap(a.races, b.races);
  swap(a.disabilities, b.disabilities);
  swap(a.__isset, b.__isset);
}

NSFDemographics::NSFDemographics(const NSFDemographics& other22) {
  airavataInternalUserId = other22.airavataInternalUserId;
  gender = other22.gender;
  usCitizenship = other22.usCitizenship;
  ethnicities = other22.ethnicities;
  races = other22.races;
  disabilities = other22.disabilities;
  __isset = other22.__isset;
}
NSFDemographics& NSFDemographics::operator=(const NSFDemographics& other23) {
  airavataInternalUserId = other23.airavataInternalUserId;
  gender = other23.gender;
  usCitizenship = other23.usCitizenship;
  ethnicities = other23.ethnicities;
  races = other23.races;
  disabilities = other23.disabilities;
  __isset = other23.__isset;
  return *this;
}
void NSFDemographics::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "NSFDemographics(";
  out << "airavataInternalUserId=" << to_string(airavataInternalUserId);
  out << ", " << "gender="; (__isset.gender ? (out << to_string(gender)) : (out << "<null>"));
  out << ", " << "usCitizenship="; (__isset.usCitizenship ? (out << to_string(usCitizenship)) : (out << "<null>"));
  out << ", " << "ethnicities="; (__isset.ethnicities ? (out << to_string(ethnicities)) : (out << "<null>"));
  out << ", " << "races="; (__isset.races ? (out << to_string(races)) : (out << "<null>"));
  out << ", " << "disabilities="; (__isset.disabilities ? (out << to_string(disabilities)) : (out << "<null>"));
  out << ")";
}


UserProfile::~UserProfile() throw() {
}


void UserProfile::__set_userModelVersion(const std::string& val) {
  this->userModelVersion = val;
}

void UserProfile::__set_airavataInternalUserId(const std::string& val) {
  this->airavataInternalUserId = val;
}

void UserProfile::__set_userId(const std::string& val) {
  this->userId = val;
}

void UserProfile::__set_gatewayId(const std::string& val) {
  this->gatewayId = val;
}

void UserProfile::__set_emails(const std::vector<std::string> & val) {
  this->emails = val;
}

void UserProfile::__set_firstName(const std::string& val) {
  this->firstName = val;
}

void UserProfile::__set_lastName(const std::string& val) {
  this->lastName = val;
}

void UserProfile::__set_middleName(const std::string& val) {
  this->middleName = val;
__isset.middleName = true;
}

void UserProfile::__set_namePrefix(const std::string& val) {
  this->namePrefix = val;
__isset.namePrefix = true;
}

void UserProfile::__set_nameSuffix(const std::string& val) {
  this->nameSuffix = val;
__isset.nameSuffix = true;
}

void UserProfile::__set_orcidId(const std::string& val) {
  this->orcidId = val;
__isset.orcidId = true;
}

void UserProfile::__set_phones(const std::vector<std::string> & val) {
  this->phones = val;
__isset.phones = true;
}

void UserProfile::__set_country(const std::string& val) {
  this->country = val;
__isset.country = true;
}

void UserProfile::__set_nationality(const std::vector<std::string> & val) {
  this->nationality = val;
__isset.nationality = true;
}

void UserProfile::__set_homeOrganization(const std::string& val) {
  this->homeOrganization = val;
__isset.homeOrganization = true;
}

void UserProfile::__set_orginationAffiliation(const std::string& val) {
  this->orginationAffiliation = val;
__isset.orginationAffiliation = true;
}

void UserProfile::__set_creationTime(const int64_t val) {
  this->creationTime = val;
}

void UserProfile::__set_lastAccessTime(const int64_t val) {
  this->lastAccessTime = val;
}

void UserProfile::__set_validUntil(const int64_t val) {
  this->validUntil = val;
}

void UserProfile::__set_State(const Status::type val) {
  this->State = val;
}

void UserProfile::__set_comments(const std::string& val) {
  this->comments = val;
__isset.comments = true;
}

void UserProfile::__set_labeledURI(const std::vector<std::string> & val) {
  this->labeledURI = val;
__isset.labeledURI = true;
}

void UserProfile::__set_gpgKey(const std::string& val) {
  this->gpgKey = val;
__isset.gpgKey = true;
}

void UserProfile::__set_timeZone(const std::string& val) {
  this->timeZone = val;
__isset.timeZone = true;
}

void UserProfile::__set_nsfDemographics(const NSFDemographics& val) {
  this->nsfDemographics = val;
__isset.nsfDemographics = true;
}

uint32_t UserProfile::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_userModelVersion = false;
  bool isset_airavataInternalUserId = false;
  bool isset_userId = false;
  bool isset_gatewayId = false;
  bool isset_emails = false;
  bool isset_firstName = false;
  bool isset_lastName = false;
  bool isset_creationTime = false;
  bool isset_lastAccessTime = false;
  bool isset_validUntil = false;
  bool isset_State = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->userModelVersion);
          isset_userModelVersion = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->airavataInternalUserId);
          isset_airavataInternalUserId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->userId);
          isset_userId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayId);
          isset_gatewayId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->emails.clear();
            uint32_t _size24;
            ::apache::thrift::protocol::TType _etype27;
            xfer += iprot->readListBegin(_etype27, _size24);
            this->emails.resize(_size24);
            uint32_t _i28;
            for (_i28 = 0; _i28 < _size24; ++_i28)
            {
              xfer += iprot->readString(this->emails[_i28]);
            }
            xfer += iprot->readListEnd();
          }
          isset_emails = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->firstName);
          isset_firstName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->lastName);
          isset_lastName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->middleName);
          this->__isset.middleName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->namePrefix);
          this->__isset.namePrefix = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->nameSuffix);
          this->__isset.nameSuffix = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 11:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->orcidId);
          this->__isset.orcidId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 12:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->phones.clear();
            uint32_t _size29;
            ::apache::thrift::protocol::TType _etype32;
            xfer += iprot->readListBegin(_etype32, _size29);
            this->phones.resize(_size29);
            uint32_t _i33;
            for (_i33 = 0; _i33 < _size29; ++_i33)
            {
              xfer += iprot->readString(this->phones[_i33]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.phones = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 13:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->country);
          this->__isset.country = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 14:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->nationality.clear();
            uint32_t _size34;
            ::apache::thrift::protocol::TType _etype37;
            xfer += iprot->readListBegin(_etype37, _size34);
            this->nationality.resize(_size34);
            uint32_t _i38;
            for (_i38 = 0; _i38 < _size34; ++_i38)
            {
              xfer += iprot->readString(this->nationality[_i38]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.nationality = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 15:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->homeOrganization);
          this->__isset.homeOrganization = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 16:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->orginationAffiliation);
          this->__isset.orginationAffiliation = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 17:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->creationTime);
          isset_creationTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 18:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->lastAccessTime);
          isset_lastAccessTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 19:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->validUntil);
          isset_validUntil = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 20:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast39;
          xfer += iprot->readI32(ecast39);
          this->State = (Status::type)ecast39;
          isset_State = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 21:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->comments);
          this->__isset.comments = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 22:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->labeledURI.clear();
            uint32_t _size40;
            ::apache::thrift::protocol::TType _etype43;
            xfer += iprot->readListBegin(_etype43, _size40);
            this->labeledURI.resize(_size40);
            uint32_t _i44;
            for (_i44 = 0; _i44 < _size40; ++_i44)
            {
              xfer += iprot->readString(this->labeledURI[_i44]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.labeledURI = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 23:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gpgKey);
          this->__isset.gpgKey = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 24:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->timeZone);
          this->__isset.timeZone = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 25:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->nsfDemographics.read(iprot);
          this->__isset.nsfDemographics = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_userModelVersion)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_airavataInternalUserId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_userId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_gatewayId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_emails)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_firstName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_lastName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_creationTime)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_lastAccessTime)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_validUntil)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_State)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t UserProfile::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("UserProfile");

  xfer += oprot->writeFieldBegin("userModelVersion", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->userModelVersion);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("airavataInternalUserId", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->airavataInternalUserId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("userId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->userId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("gatewayId", ::apache::thrift::protocol::T_STRING, 4);
  xfer += oprot->writeString(this->gatewayId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("emails", ::apache::thrift::protocol::T_LIST, 5);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->emails.size()));
    std::vector<std::string> ::const_iterator _iter45;
    for (_iter45 = this->emails.begin(); _iter45 != this->emails.end(); ++_iter45)
    {
      xfer += oprot->writeString((*_iter45));
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("firstName", ::apache::thrift::protocol::T_STRING, 6);
  xfer += oprot->writeString(this->firstName);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("lastName", ::apache::thrift::protocol::T_STRING, 7);
  xfer += oprot->writeString(this->lastName);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.middleName) {
    xfer += oprot->writeFieldBegin("middleName", ::apache::thrift::protocol::T_STRING, 8);
    xfer += oprot->writeString(this->middleName);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.namePrefix) {
    xfer += oprot->writeFieldBegin("namePrefix", ::apache::thrift::protocol::T_STRING, 9);
    xfer += oprot->writeString(this->namePrefix);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.nameSuffix) {
    xfer += oprot->writeFieldBegin("nameSuffix", ::apache::thrift::protocol::T_STRING, 10);
    xfer += oprot->writeString(this->nameSuffix);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.orcidId) {
    xfer += oprot->writeFieldBegin("orcidId", ::apache::thrift::protocol::T_STRING, 11);
    xfer += oprot->writeString(this->orcidId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.phones) {
    xfer += oprot->writeFieldBegin("phones", ::apache::thrift::protocol::T_LIST, 12);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->phones.size()));
      std::vector<std::string> ::const_iterator _iter46;
      for (_iter46 = this->phones.begin(); _iter46 != this->phones.end(); ++_iter46)
      {
        xfer += oprot->writeString((*_iter46));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.country) {
    xfer += oprot->writeFieldBegin("country", ::apache::thrift::protocol::T_STRING, 13);
    xfer += oprot->writeString(this->country);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.nationality) {
    xfer += oprot->writeFieldBegin("nationality", ::apache::thrift::protocol::T_LIST, 14);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->nationality.size()));
      std::vector<std::string> ::const_iterator _iter47;
      for (_iter47 = this->nationality.begin(); _iter47 != this->nationality.end(); ++_iter47)
      {
        xfer += oprot->writeString((*_iter47));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.homeOrganization) {
    xfer += oprot->writeFieldBegin("homeOrganization", ::apache::thrift::protocol::T_STRING, 15);
    xfer += oprot->writeString(this->homeOrganization);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.orginationAffiliation) {
    xfer += oprot->writeFieldBegin("orginationAffiliation", ::apache::thrift::protocol::T_STRING, 16);
    xfer += oprot->writeString(this->orginationAffiliation);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldBegin("creationTime", ::apache::thrift::protocol::T_I64, 17);
  xfer += oprot->writeI64(this->creationTime);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("lastAccessTime", ::apache::thrift::protocol::T_I64, 18);
  xfer += oprot->writeI64(this->lastAccessTime);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("validUntil", ::apache::thrift::protocol::T_I64, 19);
  xfer += oprot->writeI64(this->validUntil);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("State", ::apache::thrift::protocol::T_I32, 20);
  xfer += oprot->writeI32((int32_t)this->State);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.comments) {
    xfer += oprot->writeFieldBegin("comments", ::apache::thrift::protocol::T_STRING, 21);
    xfer += oprot->writeString(this->comments);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.labeledURI) {
    xfer += oprot->writeFieldBegin("labeledURI", ::apache::thrift::protocol::T_LIST, 22);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->labeledURI.size()));
      std::vector<std::string> ::const_iterator _iter48;
      for (_iter48 = this->labeledURI.begin(); _iter48 != this->labeledURI.end(); ++_iter48)
      {
        xfer += oprot->writeString((*_iter48));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.gpgKey) {
    xfer += oprot->writeFieldBegin("gpgKey", ::apache::thrift::protocol::T_STRING, 23);
    xfer += oprot->writeString(this->gpgKey);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.timeZone) {
    xfer += oprot->writeFieldBegin("timeZone", ::apache::thrift::protocol::T_STRING, 24);
    xfer += oprot->writeString(this->timeZone);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.nsfDemographics) {
    xfer += oprot->writeFieldBegin("nsfDemographics", ::apache::thrift::protocol::T_STRUCT, 25);
    xfer += this->nsfDemographics.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(UserProfile &a, UserProfile &b) {
  using ::std::swap;
  swap(a.userModelVersion, b.userModelVersion);
  swap(a.airavataInternalUserId, b.airavataInternalUserId);
  swap(a.userId, b.userId);
  swap(a.gatewayId, b.gatewayId);
  swap(a.emails, b.emails);
  swap(a.firstName, b.firstName);
  swap(a.lastName, b.lastName);
  swap(a.middleName, b.middleName);
  swap(a.namePrefix, b.namePrefix);
  swap(a.nameSuffix, b.nameSuffix);
  swap(a.orcidId, b.orcidId);
  swap(a.phones, b.phones);
  swap(a.country, b.country);
  swap(a.nationality, b.nationality);
  swap(a.homeOrganization, b.homeOrganization);
  swap(a.orginationAffiliation, b.orginationAffiliation);
  swap(a.creationTime, b.creationTime);
  swap(a.lastAccessTime, b.lastAccessTime);
  swap(a.validUntil, b.validUntil);
  swap(a.State, b.State);
  swap(a.comments, b.comments);
  swap(a.labeledURI, b.labeledURI);
  swap(a.gpgKey, b.gpgKey);
  swap(a.timeZone, b.timeZone);
  swap(a.nsfDemographics, b.nsfDemographics);
  swap(a.__isset, b.__isset);
}

UserProfile::UserProfile(const UserProfile& other49) {
  userModelVersion = other49.userModelVersion;
  airavataInternalUserId = other49.airavataInternalUserId;
  userId = other49.userId;
  gatewayId = other49.gatewayId;
  emails = other49.emails;
  firstName = other49.firstName;
  lastName = other49.lastName;
  middleName = other49.middleName;
  namePrefix = other49.namePrefix;
  nameSuffix = other49.nameSuffix;
  orcidId = other49.orcidId;
  phones = other49.phones;
  country = other49.country;
  nationality = other49.nationality;
  homeOrganization = other49.homeOrganization;
  orginationAffiliation = other49.orginationAffiliation;
  creationTime = other49.creationTime;
  lastAccessTime = other49.lastAccessTime;
  validUntil = other49.validUntil;
  State = other49.State;
  comments = other49.comments;
  labeledURI = other49.labeledURI;
  gpgKey = other49.gpgKey;
  timeZone = other49.timeZone;
  nsfDemographics = other49.nsfDemographics;
  __isset = other49.__isset;
}
UserProfile& UserProfile::operator=(const UserProfile& other50) {
  userModelVersion = other50.userModelVersion;
  airavataInternalUserId = other50.airavataInternalUserId;
  userId = other50.userId;
  gatewayId = other50.gatewayId;
  emails = other50.emails;
  firstName = other50.firstName;
  lastName = other50.lastName;
  middleName = other50.middleName;
  namePrefix = other50.namePrefix;
  nameSuffix = other50.nameSuffix;
  orcidId = other50.orcidId;
  phones = other50.phones;
  country = other50.country;
  nationality = other50.nationality;
  homeOrganization = other50.homeOrganization;
  orginationAffiliation = other50.orginationAffiliation;
  creationTime = other50.creationTime;
  lastAccessTime = other50.lastAccessTime;
  validUntil = other50.validUntil;
  State = other50.State;
  comments = other50.comments;
  labeledURI = other50.labeledURI;
  gpgKey = other50.gpgKey;
  timeZone = other50.timeZone;
  nsfDemographics = other50.nsfDemographics;
  __isset = other50.__isset;
  return *this;
}
void UserProfile::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "UserProfile(";
  out << "userModelVersion=" << to_string(userModelVersion);
  out << ", " << "airavataInternalUserId=" << to_string(airavataInternalUserId);
  out << ", " << "userId=" << to_string(userId);
  out << ", " << "gatewayId=" << to_string(gatewayId);
  out << ", " << "emails=" << to_string(emails);
  out << ", " << "firstName=" << to_string(firstName);
  out << ", " << "lastName=" << to_string(lastName);
  out << ", " << "middleName="; (__isset.middleName ? (out << to_string(middleName)) : (out << "<null>"));
  out << ", " << "namePrefix="; (__isset.namePrefix ? (out << to_string(namePrefix)) : (out << "<null>"));
  out << ", " << "nameSuffix="; (__isset.nameSuffix ? (out << to_string(nameSuffix)) : (out << "<null>"));
  out << ", " << "orcidId="; (__isset.orcidId ? (out << to_string(orcidId)) : (out << "<null>"));
  out << ", " << "phones="; (__isset.phones ? (out << to_string(phones)) : (out << "<null>"));
  out << ", " << "country="; (__isset.country ? (out << to_string(country)) : (out << "<null>"));
  out << ", " << "nationality="; (__isset.nationality ? (out << to_string(nationality)) : (out << "<null>"));
  out << ", " << "homeOrganization="; (__isset.homeOrganization ? (out << to_string(homeOrganization)) : (out << "<null>"));
  out << ", " << "orginationAffiliation="; (__isset.orginationAffiliation ? (out << to_string(orginationAffiliation)) : (out << "<null>"));
  out << ", " << "creationTime=" << to_string(creationTime);
  out << ", " << "lastAccessTime=" << to_string(lastAccessTime);
  out << ", " << "validUntil=" << to_string(validUntil);
  out << ", " << "State=" << to_string(State);
  out << ", " << "comments="; (__isset.comments ? (out << to_string(comments)) : (out << "<null>"));
  out << ", " << "labeledURI="; (__isset.labeledURI ? (out << to_string(labeledURI)) : (out << "<null>"));
  out << ", " << "gpgKey="; (__isset.gpgKey ? (out << to_string(gpgKey)) : (out << "<null>"));
  out << ", " << "timeZone="; (__isset.timeZone ? (out << to_string(timeZone)) : (out << "<null>"));
  out << ", " << "nsfDemographics="; (__isset.nsfDemographics ? (out << to_string(nsfDemographics)) : (out << "<null>"));
  out << ")";
}

}}}} // namespace
