/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#ifndef messaging_events_TYPES_H
#define messaging_events_TYPES_H

#include <iosfwd>

#include <thrift/Thrift.h>
#include <thrift/TApplicationException.h>
#include <thrift/protocol/TProtocol.h>
#include <thrift/transport/TTransport.h>

#include <thrift/cxxfunctional.h>
#include "status_models_types.h"
#include "application_io_models_types.h"
#include "airavata_commons_types.h"


namespace apache { namespace airavata { namespace model { namespace messaging { namespace event {

struct MessageLevel {
  enum type {
    INFO = 0,
    DEBUG = 1,
    ERROR = 2,
    ACK = 3
  };
};

extern const std::map<int, const char*> _MessageLevel_VALUES_TO_NAMES;

struct MessageType {
  enum type {
    EXPERIMENT = 0,
    EXPERIMENT_CANCEL = 1,
    TASK = 2,
    PROCESS = 3,
    JOB = 4,
    LAUNCHPROCESS = 5,
    TERMINATEPROCESS = 6,
    PROCESSOUTPUT = 7,
    DB_EVENT = 8
  };
};

extern const std::map<int, const char*> _MessageType_VALUES_TO_NAMES;

class ExperimentStatusChangeEvent;

class ProcessIdentifier;

class TaskIdentifier;

class TaskStatusChangeEvent;

class TaskStatusChangeRequestEvent;

class ProcessStatusChangeEvent;

class ProcessStatusChangeRequestEvent;

class TaskOutputChangeEvent;

class JobIdentifier;

class ExperimentSubmitEvent;

class ProcessSubmitEvent;

class ProcessTerminateEvent;

class JobStatusChangeEvent;

class JobStatusChangeRequestEvent;

class Message;


class ExperimentStatusChangeEvent {
 public:

  ExperimentStatusChangeEvent(const ExperimentStatusChangeEvent&);
  ExperimentStatusChangeEvent& operator=(const ExperimentStatusChangeEvent&);
  ExperimentStatusChangeEvent() : state(( ::apache::airavata::model::status::ExperimentState::type)0), experimentId(), gatewayId() {
  }

  virtual ~ExperimentStatusChangeEvent() throw();
   ::apache::airavata::model::status::ExperimentState::type state;
  std::string experimentId;
  std::string gatewayId;

  void __set_state(const  ::apache::airavata::model::status::ExperimentState::type val);

  void __set_experimentId(const std::string& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const ExperimentStatusChangeEvent & rhs) const
  {
    if (!(state == rhs.state))
      return false;
    if (!(experimentId == rhs.experimentId))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const ExperimentStatusChangeEvent &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ExperimentStatusChangeEvent & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(ExperimentStatusChangeEvent &a, ExperimentStatusChangeEvent &b);

inline std::ostream& operator<<(std::ostream& out, const ExperimentStatusChangeEvent& obj)
{
  obj.printTo(out);
  return out;
}


class ProcessIdentifier {
 public:

  ProcessIdentifier(const ProcessIdentifier&);
  ProcessIdentifier& operator=(const ProcessIdentifier&);
  ProcessIdentifier() : processId(), experimentId(), gatewayId() {
  }

  virtual ~ProcessIdentifier() throw();
  std::string processId;
  std::string experimentId;
  std::string gatewayId;

  void __set_processId(const std::string& val);

  void __set_experimentId(const std::string& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const ProcessIdentifier & rhs) const
  {
    if (!(processId == rhs.processId))
      return false;
    if (!(experimentId == rhs.experimentId))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const ProcessIdentifier &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ProcessIdentifier & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(ProcessIdentifier &a, ProcessIdentifier &b);

inline std::ostream& operator<<(std::ostream& out, const ProcessIdentifier& obj)
{
  obj.printTo(out);
  return out;
}


class TaskIdentifier {
 public:

  TaskIdentifier(const TaskIdentifier&);
  TaskIdentifier& operator=(const TaskIdentifier&);
  TaskIdentifier() : taskId(), processId(), experimentId(), gatewayId() {
  }

  virtual ~TaskIdentifier() throw();
  std::string taskId;
  std::string processId;
  std::string experimentId;
  std::string gatewayId;

  void __set_taskId(const std::string& val);

  void __set_processId(const std::string& val);

  void __set_experimentId(const std::string& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const TaskIdentifier & rhs) const
  {
    if (!(taskId == rhs.taskId))
      return false;
    if (!(processId == rhs.processId))
      return false;
    if (!(experimentId == rhs.experimentId))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const TaskIdentifier &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const TaskIdentifier & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(TaskIdentifier &a, TaskIdentifier &b);

inline std::ostream& operator<<(std::ostream& out, const TaskIdentifier& obj)
{
  obj.printTo(out);
  return out;
}


class TaskStatusChangeEvent {
 public:

  TaskStatusChangeEvent(const TaskStatusChangeEvent&);
  TaskStatusChangeEvent& operator=(const TaskStatusChangeEvent&);
  TaskStatusChangeEvent() : state(( ::apache::airavata::model::status::TaskState::type)0) {
  }

  virtual ~TaskStatusChangeEvent() throw();
   ::apache::airavata::model::status::TaskState::type state;
  TaskIdentifier taskIdentity;

  void __set_state(const  ::apache::airavata::model::status::TaskState::type val);

  void __set_taskIdentity(const TaskIdentifier& val);

  bool operator == (const TaskStatusChangeEvent & rhs) const
  {
    if (!(state == rhs.state))
      return false;
    if (!(taskIdentity == rhs.taskIdentity))
      return false;
    return true;
  }
  bool operator != (const TaskStatusChangeEvent &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const TaskStatusChangeEvent & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(TaskStatusChangeEvent &a, TaskStatusChangeEvent &b);

inline std::ostream& operator<<(std::ostream& out, const TaskStatusChangeEvent& obj)
{
  obj.printTo(out);
  return out;
}


class TaskStatusChangeRequestEvent {
 public:

  TaskStatusChangeRequestEvent(const TaskStatusChangeRequestEvent&);
  TaskStatusChangeRequestEvent& operator=(const TaskStatusChangeRequestEvent&);
  TaskStatusChangeRequestEvent() : state(( ::apache::airavata::model::status::TaskState::type)0) {
  }

  virtual ~TaskStatusChangeRequestEvent() throw();
   ::apache::airavata::model::status::TaskState::type state;
  TaskIdentifier taskIdentity;

  void __set_state(const  ::apache::airavata::model::status::TaskState::type val);

  void __set_taskIdentity(const TaskIdentifier& val);

  bool operator == (const TaskStatusChangeRequestEvent & rhs) const
  {
    if (!(state == rhs.state))
      return false;
    if (!(taskIdentity == rhs.taskIdentity))
      return false;
    return true;
  }
  bool operator != (const TaskStatusChangeRequestEvent &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const TaskStatusChangeRequestEvent & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(TaskStatusChangeRequestEvent &a, TaskStatusChangeRequestEvent &b);

inline std::ostream& operator<<(std::ostream& out, const TaskStatusChangeRequestEvent& obj)
{
  obj.printTo(out);
  return out;
}


class ProcessStatusChangeEvent {
 public:

  ProcessStatusChangeEvent(const ProcessStatusChangeEvent&);
  ProcessStatusChangeEvent& operator=(const ProcessStatusChangeEvent&);
  ProcessStatusChangeEvent() : state(( ::apache::airavata::model::status::ProcessState::type)0) {
  }

  virtual ~ProcessStatusChangeEvent() throw();
   ::apache::airavata::model::status::ProcessState::type state;
  ProcessIdentifier processIdentity;

  void __set_state(const  ::apache::airavata::model::status::ProcessState::type val);

  void __set_processIdentity(const ProcessIdentifier& val);

  bool operator == (const ProcessStatusChangeEvent & rhs) const
  {
    if (!(state == rhs.state))
      return false;
    if (!(processIdentity == rhs.processIdentity))
      return false;
    return true;
  }
  bool operator != (const ProcessStatusChangeEvent &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ProcessStatusChangeEvent & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(ProcessStatusChangeEvent &a, ProcessStatusChangeEvent &b);

inline std::ostream& operator<<(std::ostream& out, const ProcessStatusChangeEvent& obj)
{
  obj.printTo(out);
  return out;
}


class ProcessStatusChangeRequestEvent {
 public:

  ProcessStatusChangeRequestEvent(const ProcessStatusChangeRequestEvent&);
  ProcessStatusChangeRequestEvent& operator=(const ProcessStatusChangeRequestEvent&);
  ProcessStatusChangeRequestEvent() : state(( ::apache::airavata::model::status::ProcessState::type)0) {
  }

  virtual ~ProcessStatusChangeRequestEvent() throw();
   ::apache::airavata::model::status::ProcessState::type state;
  ProcessIdentifier processIdentity;

  void __set_state(const  ::apache::airavata::model::status::ProcessState::type val);

  void __set_processIdentity(const ProcessIdentifier& val);

  bool operator == (const ProcessStatusChangeRequestEvent & rhs) const
  {
    if (!(state == rhs.state))
      return false;
    if (!(processIdentity == rhs.processIdentity))
      return false;
    return true;
  }
  bool operator != (const ProcessStatusChangeRequestEvent &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ProcessStatusChangeRequestEvent & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(ProcessStatusChangeRequestEvent &a, ProcessStatusChangeRequestEvent &b);

inline std::ostream& operator<<(std::ostream& out, const ProcessStatusChangeRequestEvent& obj)
{
  obj.printTo(out);
  return out;
}


class TaskOutputChangeEvent {
 public:

  TaskOutputChangeEvent(const TaskOutputChangeEvent&);
  TaskOutputChangeEvent& operator=(const TaskOutputChangeEvent&);
  TaskOutputChangeEvent() {
  }

  virtual ~TaskOutputChangeEvent() throw();
  std::vector< ::apache::airavata::model::application::io::OutputDataObjectType>  output;
  TaskIdentifier taskIdentity;

  void __set_output(const std::vector< ::apache::airavata::model::application::io::OutputDataObjectType> & val);

  void __set_taskIdentity(const TaskIdentifier& val);

  bool operator == (const TaskOutputChangeEvent & rhs) const
  {
    if (!(output == rhs.output))
      return false;
    if (!(taskIdentity == rhs.taskIdentity))
      return false;
    return true;
  }
  bool operator != (const TaskOutputChangeEvent &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const TaskOutputChangeEvent & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(TaskOutputChangeEvent &a, TaskOutputChangeEvent &b);

inline std::ostream& operator<<(std::ostream& out, const TaskOutputChangeEvent& obj)
{
  obj.printTo(out);
  return out;
}


class JobIdentifier {
 public:

  JobIdentifier(const JobIdentifier&);
  JobIdentifier& operator=(const JobIdentifier&);
  JobIdentifier() : jobId(), taskId(), processId(), experimentId(), gatewayId() {
  }

  virtual ~JobIdentifier() throw();
  std::string jobId;
  std::string taskId;
  std::string processId;
  std::string experimentId;
  std::string gatewayId;

  void __set_jobId(const std::string& val);

  void __set_taskId(const std::string& val);

  void __set_processId(const std::string& val);

  void __set_experimentId(const std::string& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const JobIdentifier & rhs) const
  {
    if (!(jobId == rhs.jobId))
      return false;
    if (!(taskId == rhs.taskId))
      return false;
    if (!(processId == rhs.processId))
      return false;
    if (!(experimentId == rhs.experimentId))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const JobIdentifier &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const JobIdentifier & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(JobIdentifier &a, JobIdentifier &b);

inline std::ostream& operator<<(std::ostream& out, const JobIdentifier& obj)
{
  obj.printTo(out);
  return out;
}


class ExperimentSubmitEvent {
 public:

  ExperimentSubmitEvent(const ExperimentSubmitEvent&);
  ExperimentSubmitEvent& operator=(const ExperimentSubmitEvent&);
  ExperimentSubmitEvent() : experimentId(), gatewayId() {
  }

  virtual ~ExperimentSubmitEvent() throw();
  std::string experimentId;
  std::string gatewayId;

  void __set_experimentId(const std::string& val);

  void __set_gatewayId(const std::string& val);

  bool operator == (const ExperimentSubmitEvent & rhs) const
  {
    if (!(experimentId == rhs.experimentId))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    return true;
  }
  bool operator != (const ExperimentSubmitEvent &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ExperimentSubmitEvent & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(ExperimentSubmitEvent &a, ExperimentSubmitEvent &b);

inline std::ostream& operator<<(std::ostream& out, const ExperimentSubmitEvent& obj)
{
  obj.printTo(out);
  return out;
}


class ProcessSubmitEvent {
 public:

  ProcessSubmitEvent(const ProcessSubmitEvent&);
  ProcessSubmitEvent& operator=(const ProcessSubmitEvent&);
  ProcessSubmitEvent() : processId(), gatewayId(), experimentId(), tokenId() {
  }

  virtual ~ProcessSubmitEvent() throw();
  std::string processId;
  std::string gatewayId;
  std::string experimentId;
  std::string tokenId;

  void __set_processId(const std::string& val);

  void __set_gatewayId(const std::string& val);

  void __set_experimentId(const std::string& val);

  void __set_tokenId(const std::string& val);

  bool operator == (const ProcessSubmitEvent & rhs) const
  {
    if (!(processId == rhs.processId))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(experimentId == rhs.experimentId))
      return false;
    if (!(tokenId == rhs.tokenId))
      return false;
    return true;
  }
  bool operator != (const ProcessSubmitEvent &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ProcessSubmitEvent & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(ProcessSubmitEvent &a, ProcessSubmitEvent &b);

inline std::ostream& operator<<(std::ostream& out, const ProcessSubmitEvent& obj)
{
  obj.printTo(out);
  return out;
}


class ProcessTerminateEvent {
 public:

  ProcessTerminateEvent(const ProcessTerminateEvent&);
  ProcessTerminateEvent& operator=(const ProcessTerminateEvent&);
  ProcessTerminateEvent() : processId(), gatewayId(), tokenId() {
  }

  virtual ~ProcessTerminateEvent() throw();
  std::string processId;
  std::string gatewayId;
  std::string tokenId;

  void __set_processId(const std::string& val);

  void __set_gatewayId(const std::string& val);

  void __set_tokenId(const std::string& val);

  bool operator == (const ProcessTerminateEvent & rhs) const
  {
    if (!(processId == rhs.processId))
      return false;
    if (!(gatewayId == rhs.gatewayId))
      return false;
    if (!(tokenId == rhs.tokenId))
      return false;
    return true;
  }
  bool operator != (const ProcessTerminateEvent &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ProcessTerminateEvent & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(ProcessTerminateEvent &a, ProcessTerminateEvent &b);

inline std::ostream& operator<<(std::ostream& out, const ProcessTerminateEvent& obj)
{
  obj.printTo(out);
  return out;
}


class JobStatusChangeEvent {
 public:

  JobStatusChangeEvent(const JobStatusChangeEvent&);
  JobStatusChangeEvent& operator=(const JobStatusChangeEvent&);
  JobStatusChangeEvent() : state(( ::apache::airavata::model::status::JobState::type)0) {
  }

  virtual ~JobStatusChangeEvent() throw();
   ::apache::airavata::model::status::JobState::type state;
  JobIdentifier jobIdentity;

  void __set_state(const  ::apache::airavata::model::status::JobState::type val);

  void __set_jobIdentity(const JobIdentifier& val);

  bool operator == (const JobStatusChangeEvent & rhs) const
  {
    if (!(state == rhs.state))
      return false;
    if (!(jobIdentity == rhs.jobIdentity))
      return false;
    return true;
  }
  bool operator != (const JobStatusChangeEvent &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const JobStatusChangeEvent & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(JobStatusChangeEvent &a, JobStatusChangeEvent &b);

inline std::ostream& operator<<(std::ostream& out, const JobStatusChangeEvent& obj)
{
  obj.printTo(out);
  return out;
}


class JobStatusChangeRequestEvent {
 public:

  JobStatusChangeRequestEvent(const JobStatusChangeRequestEvent&);
  JobStatusChangeRequestEvent& operator=(const JobStatusChangeRequestEvent&);
  JobStatusChangeRequestEvent() : state(( ::apache::airavata::model::status::JobState::type)0) {
  }

  virtual ~JobStatusChangeRequestEvent() throw();
   ::apache::airavata::model::status::JobState::type state;
  JobIdentifier jobIdentity;

  void __set_state(const  ::apache::airavata::model::status::JobState::type val);

  void __set_jobIdentity(const JobIdentifier& val);

  bool operator == (const JobStatusChangeRequestEvent & rhs) const
  {
    if (!(state == rhs.state))
      return false;
    if (!(jobIdentity == rhs.jobIdentity))
      return false;
    return true;
  }
  bool operator != (const JobStatusChangeRequestEvent &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const JobStatusChangeRequestEvent & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(JobStatusChangeRequestEvent &a, JobStatusChangeRequestEvent &b);

inline std::ostream& operator<<(std::ostream& out, const JobStatusChangeRequestEvent& obj)
{
  obj.printTo(out);
  return out;
}

typedef struct _Message__isset {
  _Message__isset() : updatedTime(false), messageLevel(false) {}
  bool updatedTime :1;
  bool messageLevel :1;
} _Message__isset;

class Message {
 public:

  Message(const Message&);
  Message& operator=(const Message&);
  Message() : event(), messageId("DO_NOT_SET_AT_CLIENTS"), messageType((MessageType::type)0), updatedTime(0), messageLevel((MessageLevel::type)0) {
  }

  virtual ~Message() throw();
  std::string event;
  std::string messageId;
  MessageType::type messageType;
  int64_t updatedTime;
  MessageLevel::type messageLevel;

  _Message__isset __isset;

  void __set_event(const std::string& val);

  void __set_messageId(const std::string& val);

  void __set_messageType(const MessageType::type val);

  void __set_updatedTime(const int64_t val);

  void __set_messageLevel(const MessageLevel::type val);

  bool operator == (const Message & rhs) const
  {
    if (!(event == rhs.event))
      return false;
    if (!(messageId == rhs.messageId))
      return false;
    if (!(messageType == rhs.messageType))
      return false;
    if (__isset.updatedTime != rhs.__isset.updatedTime)
      return false;
    else if (__isset.updatedTime && !(updatedTime == rhs.updatedTime))
      return false;
    if (__isset.messageLevel != rhs.__isset.messageLevel)
      return false;
    else if (__isset.messageLevel && !(messageLevel == rhs.messageLevel))
      return false;
    return true;
  }
  bool operator != (const Message &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Message & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(Message &a, Message &b);

inline std::ostream& operator<<(std::ostream& out, const Message& obj)
{
  obj.printTo(out);
  return out;
}

}}}}} // namespace

#endif
