/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#include "application_io_models_types.h"

#include <algorithm>
#include <ostream>

#include <thrift/TToString.h>

namespace apache { namespace airavata { namespace model { namespace application { namespace io {

int _kDataTypeValues[] = {
  DataType::STRING,
  DataType::INTEGER,
  DataType::FLOAT,
  DataType::URI,
  DataType::URI_COLLECTION,
  DataType::STDOUT,
  DataType::STDERR
};
const char* _kDataTypeNames[] = {
  "STRING",
  "INTEGER",
  "FLOAT",
  "URI",
  "URI_COLLECTION",
  "STDOUT",
  "STDERR"
};
const std::map<int, const char*> _DataType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(7, _kDataTypeValues, _kDataTypeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));


InputDataObjectType::~InputDataObjectType() throw() {
}


void InputDataObjectType::__set_name(const std::string& val) {
  this->name = val;
}

void InputDataObjectType::__set_value(const std::string& val) {
  this->value = val;
__isset.value = true;
}

void InputDataObjectType::__set_type(const DataType::type val) {
  this->type = val;
__isset.type = true;
}

void InputDataObjectType::__set_applicationArgument(const std::string& val) {
  this->applicationArgument = val;
__isset.applicationArgument = true;
}

void InputDataObjectType::__set_standardInput(const bool val) {
  this->standardInput = val;
__isset.standardInput = true;
}

void InputDataObjectType::__set_userFriendlyDescription(const std::string& val) {
  this->userFriendlyDescription = val;
__isset.userFriendlyDescription = true;
}

void InputDataObjectType::__set_metaData(const std::string& val) {
  this->metaData = val;
__isset.metaData = true;
}

void InputDataObjectType::__set_inputOrder(const int32_t val) {
  this->inputOrder = val;
__isset.inputOrder = true;
}

void InputDataObjectType::__set_isRequired(const bool val) {
  this->isRequired = val;
__isset.isRequired = true;
}

void InputDataObjectType::__set_requiredToAddedToCommandLine(const bool val) {
  this->requiredToAddedToCommandLine = val;
__isset.requiredToAddedToCommandLine = true;
}

void InputDataObjectType::__set_dataStaged(const bool val) {
  this->dataStaged = val;
__isset.dataStaged = true;
}

void InputDataObjectType::__set_storageResourceId(const std::string& val) {
  this->storageResourceId = val;
__isset.storageResourceId = true;
}

void InputDataObjectType::__set_isReadOnly(const bool val) {
  this->isReadOnly = val;
__isset.isReadOnly = true;
}

uint32_t InputDataObjectType::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_name = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->name);
          isset_name = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->value);
          this->__isset.value = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast0;
          xfer += iprot->readI32(ecast0);
          this->type = (DataType::type)ecast0;
          this->__isset.type = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->applicationArgument);
          this->__isset.applicationArgument = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->standardInput);
          this->__isset.standardInput = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->userFriendlyDescription);
          this->__isset.userFriendlyDescription = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->metaData);
          this->__isset.metaData = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->inputOrder);
          this->__isset.inputOrder = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->isRequired);
          this->__isset.isRequired = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->requiredToAddedToCommandLine);
          this->__isset.requiredToAddedToCommandLine = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 11:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->dataStaged);
          this->__isset.dataStaged = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 12:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->storageResourceId);
          this->__isset.storageResourceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 13:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->isReadOnly);
          this->__isset.isReadOnly = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_name)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t InputDataObjectType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("InputDataObjectType");

  xfer += oprot->writeFieldBegin("name", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->name);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.value) {
    xfer += oprot->writeFieldBegin("value", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeString(this->value);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.type) {
    xfer += oprot->writeFieldBegin("type", ::apache::thrift::protocol::T_I32, 3);
    xfer += oprot->writeI32((int32_t)this->type);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.applicationArgument) {
    xfer += oprot->writeFieldBegin("applicationArgument", ::apache::thrift::protocol::T_STRING, 4);
    xfer += oprot->writeString(this->applicationArgument);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.standardInput) {
    xfer += oprot->writeFieldBegin("standardInput", ::apache::thrift::protocol::T_BOOL, 5);
    xfer += oprot->writeBool(this->standardInput);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.userFriendlyDescription) {
    xfer += oprot->writeFieldBegin("userFriendlyDescription", ::apache::thrift::protocol::T_STRING, 6);
    xfer += oprot->writeString(this->userFriendlyDescription);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.metaData) {
    xfer += oprot->writeFieldBegin("metaData", ::apache::thrift::protocol::T_STRING, 7);
    xfer += oprot->writeString(this->metaData);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.inputOrder) {
    xfer += oprot->writeFieldBegin("inputOrder", ::apache::thrift::protocol::T_I32, 8);
    xfer += oprot->writeI32(this->inputOrder);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.isRequired) {
    xfer += oprot->writeFieldBegin("isRequired", ::apache::thrift::protocol::T_BOOL, 9);
    xfer += oprot->writeBool(this->isRequired);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.requiredToAddedToCommandLine) {
    xfer += oprot->writeFieldBegin("requiredToAddedToCommandLine", ::apache::thrift::protocol::T_BOOL, 10);
    xfer += oprot->writeBool(this->requiredToAddedToCommandLine);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.dataStaged) {
    xfer += oprot->writeFieldBegin("dataStaged", ::apache::thrift::protocol::T_BOOL, 11);
    xfer += oprot->writeBool(this->dataStaged);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.storageResourceId) {
    xfer += oprot->writeFieldBegin("storageResourceId", ::apache::thrift::protocol::T_STRING, 12);
    xfer += oprot->writeString(this->storageResourceId);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.isReadOnly) {
    xfer += oprot->writeFieldBegin("isReadOnly", ::apache::thrift::protocol::T_BOOL, 13);
    xfer += oprot->writeBool(this->isReadOnly);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(InputDataObjectType &a, InputDataObjectType &b) {
  using ::std::swap;
  swap(a.name, b.name);
  swap(a.value, b.value);
  swap(a.type, b.type);
  swap(a.applicationArgument, b.applicationArgument);
  swap(a.standardInput, b.standardInput);
  swap(a.userFriendlyDescription, b.userFriendlyDescription);
  swap(a.metaData, b.metaData);
  swap(a.inputOrder, b.inputOrder);
  swap(a.isRequired, b.isRequired);
  swap(a.requiredToAddedToCommandLine, b.requiredToAddedToCommandLine);
  swap(a.dataStaged, b.dataStaged);
  swap(a.storageResourceId, b.storageResourceId);
  swap(a.isReadOnly, b.isReadOnly);
  swap(a.__isset, b.__isset);
}

InputDataObjectType::InputDataObjectType(const InputDataObjectType& other1) {
  name = other1.name;
  value = other1.value;
  type = other1.type;
  applicationArgument = other1.applicationArgument;
  standardInput = other1.standardInput;
  userFriendlyDescription = other1.userFriendlyDescription;
  metaData = other1.metaData;
  inputOrder = other1.inputOrder;
  isRequired = other1.isRequired;
  requiredToAddedToCommandLine = other1.requiredToAddedToCommandLine;
  dataStaged = other1.dataStaged;
  storageResourceId = other1.storageResourceId;
  isReadOnly = other1.isReadOnly;
  __isset = other1.__isset;
}
InputDataObjectType& InputDataObjectType::operator=(const InputDataObjectType& other2) {
  name = other2.name;
  value = other2.value;
  type = other2.type;
  applicationArgument = other2.applicationArgument;
  standardInput = other2.standardInput;
  userFriendlyDescription = other2.userFriendlyDescription;
  metaData = other2.metaData;
  inputOrder = other2.inputOrder;
  isRequired = other2.isRequired;
  requiredToAddedToCommandLine = other2.requiredToAddedToCommandLine;
  dataStaged = other2.dataStaged;
  storageResourceId = other2.storageResourceId;
  isReadOnly = other2.isReadOnly;
  __isset = other2.__isset;
  return *this;
}
void InputDataObjectType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "InputDataObjectType(";
  out << "name=" << to_string(name);
  out << ", " << "value="; (__isset.value ? (out << to_string(value)) : (out << "<null>"));
  out << ", " << "type="; (__isset.type ? (out << to_string(type)) : (out << "<null>"));
  out << ", " << "applicationArgument="; (__isset.applicationArgument ? (out << to_string(applicationArgument)) : (out << "<null>"));
  out << ", " << "standardInput="; (__isset.standardInput ? (out << to_string(standardInput)) : (out << "<null>"));
  out << ", " << "userFriendlyDescription="; (__isset.userFriendlyDescription ? (out << to_string(userFriendlyDescription)) : (out << "<null>"));
  out << ", " << "metaData="; (__isset.metaData ? (out << to_string(metaData)) : (out << "<null>"));
  out << ", " << "inputOrder="; (__isset.inputOrder ? (out << to_string(inputOrder)) : (out << "<null>"));
  out << ", " << "isRequired="; (__isset.isRequired ? (out << to_string(isRequired)) : (out << "<null>"));
  out << ", " << "requiredToAddedToCommandLine="; (__isset.requiredToAddedToCommandLine ? (out << to_string(requiredToAddedToCommandLine)) : (out << "<null>"));
  out << ", " << "dataStaged="; (__isset.dataStaged ? (out << to_string(dataStaged)) : (out << "<null>"));
  out << ", " << "storageResourceId="; (__isset.storageResourceId ? (out << to_string(storageResourceId)) : (out << "<null>"));
  out << ", " << "isReadOnly="; (__isset.isReadOnly ? (out << to_string(isReadOnly)) : (out << "<null>"));
  out << ")";
}


OutputDataObjectType::~OutputDataObjectType() throw() {
}


void OutputDataObjectType::__set_name(const std::string& val) {
  this->name = val;
}

void OutputDataObjectType::__set_value(const std::string& val) {
  this->value = val;
__isset.value = true;
}

void OutputDataObjectType::__set_type(const DataType::type val) {
  this->type = val;
__isset.type = true;
}

void OutputDataObjectType::__set_applicationArgument(const std::string& val) {
  this->applicationArgument = val;
__isset.applicationArgument = true;
}

void OutputDataObjectType::__set_isRequired(const bool val) {
  this->isRequired = val;
__isset.isRequired = true;
}

void OutputDataObjectType::__set_requiredToAddedToCommandLine(const bool val) {
  this->requiredToAddedToCommandLine = val;
__isset.requiredToAddedToCommandLine = true;
}

void OutputDataObjectType::__set_dataMovement(const bool val) {
  this->dataMovement = val;
__isset.dataMovement = true;
}

void OutputDataObjectType::__set_location(const std::string& val) {
  this->location = val;
__isset.location = true;
}

void OutputDataObjectType::__set_searchQuery(const std::string& val) {
  this->searchQuery = val;
__isset.searchQuery = true;
}

void OutputDataObjectType::__set_outputStreaming(const bool val) {
  this->outputStreaming = val;
__isset.outputStreaming = true;
}

void OutputDataObjectType::__set_storageResourceId(const std::string& val) {
  this->storageResourceId = val;
__isset.storageResourceId = true;
}

uint32_t OutputDataObjectType::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_name = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->name);
          isset_name = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->value);
          this->__isset.value = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast3;
          xfer += iprot->readI32(ecast3);
          this->type = (DataType::type)ecast3;
          this->__isset.type = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->applicationArgument);
          this->__isset.applicationArgument = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->isRequired);
          this->__isset.isRequired = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->requiredToAddedToCommandLine);
          this->__isset.requiredToAddedToCommandLine = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->dataMovement);
          this->__isset.dataMovement = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->location);
          this->__isset.location = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->searchQuery);
          this->__isset.searchQuery = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->outputStreaming);
          this->__isset.outputStreaming = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 11:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->storageResourceId);
          this->__isset.storageResourceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_name)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t OutputDataObjectType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("OutputDataObjectType");

  xfer += oprot->writeFieldBegin("name", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->name);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.value) {
    xfer += oprot->writeFieldBegin("value", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeString(this->value);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.type) {
    xfer += oprot->writeFieldBegin("type", ::apache::thrift::protocol::T_I32, 3);
    xfer += oprot->writeI32((int32_t)this->type);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.applicationArgument) {
    xfer += oprot->writeFieldBegin("applicationArgument", ::apache::thrift::protocol::T_STRING, 4);
    xfer += oprot->writeString(this->applicationArgument);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.isRequired) {
    xfer += oprot->writeFieldBegin("isRequired", ::apache::thrift::protocol::T_BOOL, 5);
    xfer += oprot->writeBool(this->isRequired);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.requiredToAddedToCommandLine) {
    xfer += oprot->writeFieldBegin("requiredToAddedToCommandLine", ::apache::thrift::protocol::T_BOOL, 6);
    xfer += oprot->writeBool(this->requiredToAddedToCommandLine);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.dataMovement) {
    xfer += oprot->writeFieldBegin("dataMovement", ::apache::thrift::protocol::T_BOOL, 7);
    xfer += oprot->writeBool(this->dataMovement);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.location) {
    xfer += oprot->writeFieldBegin("location", ::apache::thrift::protocol::T_STRING, 8);
    xfer += oprot->writeString(this->location);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.searchQuery) {
    xfer += oprot->writeFieldBegin("searchQuery", ::apache::thrift::protocol::T_STRING, 9);
    xfer += oprot->writeString(this->searchQuery);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.outputStreaming) {
    xfer += oprot->writeFieldBegin("outputStreaming", ::apache::thrift::protocol::T_BOOL, 10);
    xfer += oprot->writeBool(this->outputStreaming);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.storageResourceId) {
    xfer += oprot->writeFieldBegin("storageResourceId", ::apache::thrift::protocol::T_STRING, 11);
    xfer += oprot->writeString(this->storageResourceId);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(OutputDataObjectType &a, OutputDataObjectType &b) {
  using ::std::swap;
  swap(a.name, b.name);
  swap(a.value, b.value);
  swap(a.type, b.type);
  swap(a.applicationArgument, b.applicationArgument);
  swap(a.isRequired, b.isRequired);
  swap(a.requiredToAddedToCommandLine, b.requiredToAddedToCommandLine);
  swap(a.dataMovement, b.dataMovement);
  swap(a.location, b.location);
  swap(a.searchQuery, b.searchQuery);
  swap(a.outputStreaming, b.outputStreaming);
  swap(a.storageResourceId, b.storageResourceId);
  swap(a.__isset, b.__isset);
}

OutputDataObjectType::OutputDataObjectType(const OutputDataObjectType& other4) {
  name = other4.name;
  value = other4.value;
  type = other4.type;
  applicationArgument = other4.applicationArgument;
  isRequired = other4.isRequired;
  requiredToAddedToCommandLine = other4.requiredToAddedToCommandLine;
  dataMovement = other4.dataMovement;
  location = other4.location;
  searchQuery = other4.searchQuery;
  outputStreaming = other4.outputStreaming;
  storageResourceId = other4.storageResourceId;
  __isset = other4.__isset;
}
OutputDataObjectType& OutputDataObjectType::operator=(const OutputDataObjectType& other5) {
  name = other5.name;
  value = other5.value;
  type = other5.type;
  applicationArgument = other5.applicationArgument;
  isRequired = other5.isRequired;
  requiredToAddedToCommandLine = other5.requiredToAddedToCommandLine;
  dataMovement = other5.dataMovement;
  location = other5.location;
  searchQuery = other5.searchQuery;
  outputStreaming = other5.outputStreaming;
  storageResourceId = other5.storageResourceId;
  __isset = other5.__isset;
  return *this;
}
void OutputDataObjectType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "OutputDataObjectType(";
  out << "name=" << to_string(name);
  out << ", " << "value="; (__isset.value ? (out << to_string(value)) : (out << "<null>"));
  out << ", " << "type="; (__isset.type ? (out << to_string(type)) : (out << "<null>"));
  out << ", " << "applicationArgument="; (__isset.applicationArgument ? (out << to_string(applicationArgument)) : (out << "<null>"));
  out << ", " << "isRequired="; (__isset.isRequired ? (out << to_string(isRequired)) : (out << "<null>"));
  out << ", " << "requiredToAddedToCommandLine="; (__isset.requiredToAddedToCommandLine ? (out << to_string(requiredToAddedToCommandLine)) : (out << "<null>"));
  out << ", " << "dataMovement="; (__isset.dataMovement ? (out << to_string(dataMovement)) : (out << "<null>"));
  out << ", " << "location="; (__isset.location ? (out << to_string(location)) : (out << "<null>"));
  out << ", " << "searchQuery="; (__isset.searchQuery ? (out << to_string(searchQuery)) : (out << "<null>"));
  out << ", " << "outputStreaming="; (__isset.outputStreaming ? (out << to_string(outputStreaming)) : (out << "<null>"));
  out << ", " << "storageResourceId="; (__isset.storageResourceId ? (out << to_string(storageResourceId)) : (out << "<null>"));
  out << ")";
}

}}}}} // namespace
