/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core;

import java.util.concurrent.locks.Lock;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CommandConfirmationHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.ResponseHandler;

public interface Channel {
    public long getID();

    public int getReconnectID();

    public boolean supports(byte var1);

    public boolean supports(byte var1, int var2);

    default public boolean requireSpecialVotingHandling() {
        return false;
    }

    public boolean send(Packet var1);

    public boolean send(Packet var1, int var2);

    public boolean sendBatched(Packet var1);

    public void flushConnection();

    public boolean send(Packet var1, boolean var2);

    public boolean sendAndFlush(Packet var1);

    public Packet sendBlocking(Packet var1, byte var2) throws ActiveMQException;

    public Packet sendBlocking(Packet var1, int var2, byte var3) throws ActiveMQException;

    public Packet sendBlocking(Packet var1, int var2, byte var3, long var4, boolean var6) throws ActiveMQException;

    public void setHandler(ChannelHandler var1);

    public ChannelHandler getHandler();

    public void endOfBatch();

    public void close();

    public void transferConnection(CoreRemotingConnection var1);

    public void replayCommands(int var1);

    public int getLastConfirmedCommandID();

    public boolean isLocked();

    public void lock();

    public void unlock();

    public void returnBlocking();

    public void returnBlocking(Throwable var1);

    public Lock getLock();

    public CoreRemotingConnection getConnection();

    public void confirm(Packet var1);

    public void setCommandConfirmationHandler(CommandConfirmationHandler var1);

    public void setResponseHandler(ResponseHandler var1);

    public void flushConfirmations();

    public void handlePacket(Packet var1);

    public void clearCommands();

    public int getConfirmationWindowSize();

    public void setTransferring(boolean var1);
}

