/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.processor.BaseProcessorSupport;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.ExchangeHelper;

public class SetVariablesProcessor
extends BaseProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private final List<Expression> variableNames;
    private final List<Expression> expressions;

    public SetVariablesProcessor(List<Expression> variableNames, List<Expression> expressions) {
        this.variableNames = variableNames;
        this.expressions = expressions;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            int variableIndex = 0;
            for (Expression expression : this.expressions) {
                Object newVariable = expression.evaluate(exchange, Object.class);
                if (exchange.getException() != null) {
                    callback.done(true);
                    return true;
                }
                String key = (String)this.variableNames.get(variableIndex++).evaluate(exchange, String.class);
                ExchangeHelper.setVariable((Exchange)exchange, (String)key, (Object)newVariable);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("setVariables[");
        int variableIndex = 0;
        for (Expression expression : this.expressions) {
            if (variableIndex > 0) {
                sb.append("; ");
            }
            sb.append(this.variableNames.get(variableIndex++).toString());
            sb.append(", ");
            sb.append(expression.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public List<Expression> getVariableNames() {
        return this.variableNames;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }
}

