/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request.notification;

import java.util.HashMap;
import java.util.Map;

public enum NotificationCommandType {
    REGISTER("register"),
    UNREGISTER("unregister"),
    ADD("add"),
    REMOVE("remove"),
    PING("ping"),
    OPEN("open"),
    LIST("list");

    private final String type;
    private static final Map<String, NotificationCommandType> COMMANDS_BY_NAME;

    private NotificationCommandType(String pPType) {
        this.type = pPType;
    }

    public String getType() {
        return this.type;
    }

    public static NotificationCommandType getTypeByName(String pName) {
        if (pName == null) {
            throw new IllegalArgumentException("No command given");
        }
        NotificationCommandType command = COMMANDS_BY_NAME.get(pName.toLowerCase());
        if (command == null) {
            throw new UnsupportedOperationException("No command with name '" + pName + "' exists");
        }
        return command;
    }

    static {
        COMMANDS_BY_NAME = new HashMap<String, NotificationCommandType>();
        for (NotificationCommandType t : NotificationCommandType.values()) {
            COMMANDS_BY_NAME.put(t.getType(), t);
        }
    }
}

