/*
	FTPGET

	Written by:  Eric Jorgensen (2000)

	This is a windows utility for downloading multiple files 
	(with identicle file names)  from multiple ftp servers into
	a single folder.  It is useful for programs like analog that
	process log files in situations where you would want to 
	process log files from multiple web servers.


*/

#include "stdafx.h"
#include "ftpget.h"
#include <stdlib.h>
#include <wininet.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
									// Function headers
void Usage();
void Bail(char *msg);
bool samefile(LPCSTR filename,WIN32_FIND_DATA &wfdata);

									// global settings
CString g_csServer;
CString g_csFile;
CString g_csLoginName("anonymous");
CString g_csPassword("ftpget_program");
bool g_bOverwrite = false;
bool g_bAppendServerName = true;
bool g_bVerbose = false;
int g_iPort = 0;


/******* FUNCTION HEADER *************************************************
	int main(int argc, char *argv[])

  DESCRIPTION:		gets files from an ftp location

  NOTES:			

**************************************************************************/
int main(int argc, char *argv[])
{
	int argp = 3;
	HINTERNET ihandle;
	HINTERNET iftphandle;
	HINTERNET ifilehandle;
	WIN32_FIND_DATA wfdata;
	CString cs_LocalFileName;
	char buffer[1000],*spot;
	CString csdir,csfile,csname;
	int filecount = 0,foundfiles = 0;

									// read arguments
	if(argc < 3) Usage();

	g_csServer = argv[1];
	g_csFile = argv[2];

	while(argp < argc) {
		csname = argv[argp];
		argp++;

		if(!stricmp(csname,"USERNAME")) {
			g_csLoginName = argv[argp++];	
		}
		else if(!stricmp(csname,"PASSWORD")) {
			g_csPassword = argv[argp++];	
		}
		else if(!stricmp(csname,"OVERWRITE")) {
			g_bOverwrite = true;	
		}
		else if(!stricmp(csname,"NODECORATE")) {
			g_bAppendServerName = false;	
		}
		else if(!stricmp(csname,"VERBOSE")) {
			g_bVerbose = true;	
		}
		else if(!stricmp(csname,"PORT")) {
			g_iPort = atoi(argv[argp++]);	
		}
	}

									// open up the ftp connection

	ihandle = InternetOpen("Pfreight FtpGet",INTERNET_OPEN_TYPE_PRECONFIG,NULL,NULL,0);
	if(!ihandle) Bail("InternetOpen");
	if(!g_iPort) g_iPort = INTERNET_DEFAULT_FTP_PORT;
	
	iftphandle = InternetConnect(ihandle,g_csServer,g_iPort,g_csLoginName,g_csPassword,INTERNET_SERVICE_FTP,0,NULL);
	if(!iftphandle) Bail("InternetConnect");

									// Fix unix-style firectory spacers
	while(spot = strrchr(buffer,'/')) *spot = '\\';

									// break apart directory and filename
	strcpy(buffer,g_csFile);
	if(spot = strrchr(buffer,'\\')) {
		*spot = 0;
		csdir = buffer;
		csfile = spot+1;
	}
	else csfile = buffer;


									// Look for files
	FtpSetCurrentDirectory(iftphandle,csdir);
	ifilehandle = FtpFindFirstFile(iftphandle,csfile,&wfdata,INTERNET_FLAG_RELOAD,NULL); 
	while(ifilehandle) {
		foundfiles++;
									// Create local filename
		if(g_bAppendServerName) {
			cs_LocalFileName = g_csServer;
			cs_LocalFileName += "_";
			cs_LocalFileName += wfdata.cFileName;
		}
		else {
			cs_LocalFileName = wfdata.cFileName;
		}

									// Copy to local directory
		if(!samefile(cs_LocalFileName,wfdata) || g_bOverwrite) {
			filecount++;
			if(g_bVerbose) printf("Copying %s to %s\n",wfdata.cFileName,cs_LocalFileName);
			if(!FtpGetFile(iftphandle,wfdata.cFileName,cs_LocalFileName,false,FILE_ATTRIBUTE_NORMAL,FTP_TRANSFER_TYPE_ASCII,NULL)) {
				Bail("FtpGetFile");
			}
		}

		if(!InternetFindNextFile(ifilehandle,&wfdata)) break;
	}

	printf("Copied %d out of %d file%s\n",filecount,foundfiles, foundfiles == 1 ? "" : "s");

	InternetCloseHandle(ifilehandle);

	return 0;
}

/******* FUNCTION HEADER *************************************************
	void Usage()

  DESCRIPTION:		Displays the usage of this program

  NOTES:			

**************************************************************************/
void Usage()
{
	printf("USAGE:  ftpget (server) (filename) [(options)]\n\n"

		 	"  This will copy the specified file(s) to the local directory.  By default,\n"
			"  if the file already exists in the local directory and it is the same size,\n"
			"  it will not be copied.\n\n"

			"  Options:\n"
			"     USERNAME (name)         ftp username [default: anonymous]\n"
			"     PASSWORD (password)     ftp password [default: ftpget_program]\n"
			"     PORT (#)                port number to use on remote server [default: 21]\n"
			"     OVERWRITE               force overwrite local files\n"
			"     NODECORATE              don't append server name to local file name\n"
			"     VERBOSE                 tell me what's going on\n");

	exit(1);
}


/******* FUNCTION HEADER *************************************************
	void Bail(char msg)

  DESCRIPTION:	Exit the program and report the last known error		

  NOTES:			

**************************************************************************/
void Bail(char *msg)
{
	int err = GetLastError();
						   

	LPVOID lpMsgBuf;
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		err,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);

	printf("ERROR:  %s failed with error %d (%s)\n",msg,err,lpMsgBuf);
	LocalFree( lpMsgBuf );
	exit(2);
}

/******* FUNCTION HEADER *************************************************
	bool samefile(char *filename,WIN32_FIND_DATA &wfdata)

  DESCRIPTION:		returns true if the local file exists and is the smae
					size of the file described by wfdata

  NOTES:			

**************************************************************************/
bool samefile(LPCSTR filename,WIN32_FIND_DATA &wfdata)
{
	WIN32_FIND_DATA localfiledata;
	HANDLE h;

	h = FindFirstFile(filename,&localfiledata);

	if(h == INVALID_HANDLE_VALUE) return false;

	FindClose(h);

	if( localfiledata.nFileSizeLow == wfdata.nFileSizeLow &&  
		localfiledata.nFileSizeHigh == wfdata.nFileSizeHigh) return true;
	else return false;
}




