/*
 * File:     test.h
 * Purpose:  Demo for toolbar class library
 *
 *                       wxWindows 1.50
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                        Date: 7-9-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

// Define a new application
class MyApp: public wxApp
{
  public:
    wxFrame *OnInit(void);
};

// Define a new canvas which can receive some events
class MyCanvas: public wxCanvas
{
  public:
    MyCanvas(wxFrame *frame, int x, int y, int w, int h, int style = wxRETAINED);
    void OnPaint(void);
    void OnEvent(wxMouseEvent& event);
    void OnChar(int ch);
    void OnSize(int w, int h);
};

// Define a frame which can handle resizing with a toolbar plus one subwindow
class wxFrameWithToolBar: public wxFrame
{
  public:
    wxToolBar *frameToolBar;
    wxFrameWithToolBar(wxFrame *frame, char *title, int x, int y, int w, int h,
            int style = wxSDI | wxDEFAULT_FRAME);
    void OnSize(int w, int h);  // Default OnSize handler
    inline void SetToolBar(wxToolBar *tb) { frameToolBar = tb; }
    inline wxToolBar *GetToolBar(void) { return frameToolBar; }
};

// Define a new frame
class MyFrame: public wxFrameWithToolBar
{
  public:
    MyCanvas *canvas;
    MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h);
    Bool OnClose(void);
    void OnMenuCommand(int id);
    void OnMenuSelect(int id);
    void Draw(wxDC& dc);
};

class TestToolBar: public wxToolBar
{
  public:
  TestToolBar(wxFrame *frame, int x = 0, int y = 0, int w = -1, int h = -1,
            int style = 0, int direction = wxVERTICAL, int RowsOrColumns = 2);
  Bool OnLeftClick(int toolIndex, Bool toggled);
  void OnMouseEnter(int toolIndex);
};

class TestRibbon: public wxToolBar
{
  public:
  TestRibbon(wxFrame *frame, int x = 0, int y = 0, int w = -1, int h = -1,
            int style = 0, int direction = wxVERTICAL, int RowsOrColumns = 2);
  Bool OnLeftClick(int toolIndex, Bool toggled);
  void OnMouseEnter(int toolIndex);
};

#define TEST_QUIT       100
#define TEST_ABOUT      101
