/*
 * server.h
 * RPC Server demo for wxWindows class library
 *
 */

// Define a new application
class MyApp: public wxApp
{
  public:
    wxFrame *OnInit(void);
};

// Define a new frame
class MyFrame: public wxFrame
{
  public:
    MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h);
    Bool OnClose(void);
    void OnMenuCommand(int id);
};

// IPC stuff

class myRPCConnection: public rpcConnection
{
 public:
  myRPCConnection(char *buf, int size);
};

class myRPCServer: public rpcServer
{
 public:
  myRPCServer(void);
  wxConnection *OnAcceptConnection(char *topic);
};

class IPCDialogBox: public wxDialogBox
{
 public:
 myRPCConnection *connection;
 IPCDialogBox(wxFrame *Parent, char *Title, Bool Modal, 
              int x, int y, int width, int height, myRPCConnection *the_connection);
};

// RPC Function definitions
PrologExpr *ServerTest(wxConnection *, char *functor, wxList *args);
PrologExpr *ServerHello(wxConnection *, char *functor, wxList *args);
PrologExpr *ServerPopup(wxConnection *, char *functor, wxList *args);

#define SERVER_QUIT   1
#define SERVER_ADVISE 2

