/*
 * client.cc
 * Client IPC demo for wxWindows class library
 * This can be used with the server demo in this directory,
 * or in fact to test any wxWindows RPC server, e.g. HARDY.
 * Useage:
 *   client <port number> <host name>
 * E.g.
 *   client 1234 bute
 */

#include <afxwin.h>
#include <strstream.h>
#include "wx.h"
#include "read.h"
#include "prorpc.h"
#include "client.h"

MyFrame *frame = NULL;

// This statement initialises the whole application
MyApp myApp;

char ipc_buffer[4000];
wxListBox *the_list = NULL;

myRPCConnection *the_connection = NULL;

// The `main program' equivalent, creating the windows and returning the
// main frame
wxFrame *MyApp::OnInit(void)
{
  // Create the main frame window
  frame = new MyFrame(NULL, "Client", 400, 0, 400, 300);

  // Give it an icon
  wxIcon *icon = new wxIcon("conn_icn");
  frame->SetIcon(icon);

  // Make a menubar
  wxMenu *file_menu = new wxMenu;

  file_menu->Append(CLIENT_EXECUTE, "RPC");
  file_menu->Append(CLIENT_QUIT, "Quit");

  wxMenuBar *menu_bar = new wxMenuBar;

  menu_bar->Append(file_menu, "File");

  // Associate the menu bar with the frame
  frame->SetMenuBar(menu_bar);

  // Initialize IPC
  wxIPCInitialize();

  char *server_name = "4242";
  char *host = "bute";
  if (argc > 1)
    server_name = argv[1];
  if (argc > 2)
    host = argv[2];

  // Create a new client
  myRPCClient *client = new myRPCClient;
  the_connection = (myRPCConnection *)client->MakeConnection(host, server_name, "RPC");
  if (the_connection)
    the_connection->StartAdvise("test");

  // Essential - return the main frame window
  return frame;
}

// Define my frame constructor
MyFrame::MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h):
  wxFrame(frame, title, x, y, w, h)
{
}

// Intercept menu commands
void MyFrame::OnMenuCommand(int id)
{
  switch (id)
  {
    case CLIENT_EXECUTE:
    {
      if (the_connection)
      {
        char *s = wxGetTextFromUser("Enter an RPC call", "Input", "test(\"hello\").");
        if (s)
	{
          PrologDatabase db;
          db.ReadPrologFromString(s);
          wxNode *first = db.First();
          if (first)
          {
            PrologExpr *expr = (PrologExpr *)first->Data();
            PrologExpr *new_copy = expr->Copy();
            PrologExpr *answer = the_connection->Call(new_copy);

            if (answer)
	    {
              char buf[300];
              ostrstream stream(buf, 300);
              answer->WritePrologClause(stream);
              stream << (char)0;
              stream.flush();
              wxMessageBox(buf, "Return value", wxOK);
	    }
          }
	}
      }
      break;
    }
    case CLIENT_QUIT:
    {
      OnClose();
      delete this;
      break;
    }
  }
}

// Define the behaviour for the frame closing
// - must delete all frames except for the main one.
Bool MyFrame::OnClose(void)
{
  return TRUE;
}

myRPCClient::myRPCClient(void)
{
}

wxConnection *myRPCClient::OnMakeConnection(void)
{
  return new myRPCConnection;
}

myRPCConnection::myRPCConnection(void)
{
}

Bool myRPCConnection::OnAdvise(char *topic, char *item, char *data, int size, int format)
{
  if (the_connection)
    (void)the_connection->Call(wxMakeCall("popup", wxMakeString(data), 0));
  return TRUE;
}
