/*
 * File:	bgencpp.cc
 * Purpose:	wxWindows GUI builder: C++ generation
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include "wx.h"
#include "wx_help.h"
#include <ctype.h>
#include <stdlib.h>
#include <iostream.h>

#include "wxbuild.h"
#include "bapp.h"
#include "namegen.h"
#include "bframe.h"
#include "bsubwin.h"
#include "bgencpp.h"
#include "bgdi.h"

// Compiler types, as integers
#define COMPILER_MS_C7    1
#define COMPILER_MS_C8    2
#define COMPILER_MS_NT    3

Bool BuildApp::CheckCompleteCPP(void)
{
  ShowReportWindow();
  ClearReportWindow();
  
  if (!topLevelFrame)
  {
    Report("No top frame -- generation aborted.\n");
    wxMessageBox("Please create a top level frame.", "Error");
    return FALSE;
  }
  if (!(topLevelFrame->className && strlen(topLevelFrame->className) > 0))
  {
    char *s = wxGetTextFromUser("Enter a class name for the top level frame.");
    if (s)
    {
      topLevelFrame->className = copystring(s);
    }
    else
    {
      Report("No class name for top level frame -- generation aborted.\n");
      return FALSE;
    }
  }
  if (!(appClass && strlen(appClass) > 0))
  {
    char *s = wxGetTextFromUser("Enter a class name for the whole application.");
    if (s)
    {
      appClass = copystring(s);
    }
    else
    {
      Report("No class name for application -- generation aborted.\n");
      return FALSE;
    }
  }
  if (!(buildName && strlen(buildName) > 0))
  {
    char *s = wxGetTextFromUser("Enter a source code root name.");
    if (s)
    {
      buildName = copystring(s);
    }
    else
    {
      Report("No source code root name -- generation aborted.\n");
      return FALSE;
    }
  }
#ifdef wx_msw
  char *dir = projectDirDOS;
#endif
#ifdef wx_x
  char *dir = projectDirUNIX;
#endif
  if (!DirExists(dir))
  {
    char buf[400];
    sprintf(buf, "Create directory %s?", dir);
    if (wxMessageBox(buf, "Message", wxYES_NO) == wxYES)
    {
      wxMkdir(dir);
      Report("Project directory "); Report(dir); Report(" created.\n");
    }
    else
    {
      Report("No project directory -- generation aborted.\n");
      return FALSE;
    }
  }
  return TRUE;
}

Bool BuildApp::GenerateCPP(void)
{
  if (!CheckCompleteCPP())
    return FALSE;

  nameSpace.ClearNameSpace();
  currentMenuItemId = 1;
  
  MainFrame->SetStatusText("Generating C++...");

  // Set up files
#ifdef wx_msw
  char *dir = projectDirDOS;
#endif
#ifdef wx_x
  char *dir = projectDirUNIX;
#endif
  char headerName[400];
  strcpy(headerName, dir);
#ifdef wx_msw
  strcat(headerName, "\\");
#endif
#ifdef wx_x
  strcat(headerName, "/");
#endif
  strcat(headerName, buildName);
  strcat(headerName, ".h");

  char appName[400];
  strcpy(appName, dir);
#ifdef wx_msw
  strcat(appName, "\\");
#endif
#ifdef wx_x
  strcat(appName, "/");
#endif
  strcat(appName, buildName);
  strcat(appName, extensionCPP);
  
  ofstream headerFile(headerName);
  if (headerFile.bad())
  {
    Report("Could not create header file ");
    Report(headerName);
    Report(" -- compilation aborted.\n");
    wxMessageBox("Cannot create header file.", "Error");
    return FALSE;
  }
  ofstream appFile(appName);
  if (appFile.bad())
  {
    Report("Could not create source file ");
    Report(appName);
    Report(" -- compilation aborted.\n");
    wxMessageBox("Cannot create source file.", "Error");
    return FALSE;
  }

  WriteFileHeaderCPP(headerFile, headerName, buildDescription, buildAuthors, buildDate);
  WriteFileHeaderCPP(appFile, appName, buildDescription, buildAuthors, buildDate);

  WriteMutualExclusionCPP(headerFile, headerName);
  WriteExtraIncludesCPP(headerFile);
  WriteIncludesCPP(appFile, headerName);

  WriteAppClassCPP(headerFile, appClass);
  WriteAppInitCPP(appFile, appClass);

  WriteWindowClassDeclarationsCPP(headerFile);
  WriteWindowClassImplementationsCPP(appFile);

  // End mutual exclusion in header
  headerFile << "#endif // mutual exclusion\n";

  if (genMakefiles)
    GenerateMakefiles();
  if (genRCFile)
    GenerateRCFile();
  if (genDefFile)
    GenerateDefFile();

  // Set status line.
  char statusBuf[300];
  sprintf(statusBuf, "Wrote %s.", buildName);
  MainFrame->SetStatusText(statusBuf);
  Report("Generation successful.\n");

  return TRUE;
}

void BuildApp::WriteFileHeaderCPP(ostream& stream, char *fileName, char *description,
  char *authors, char *date)
{
  stream << "/*\n * File:    " << fileName << "\n";
  stream <<     " * Purpose: main application module, generated by wxBuilder.\n";
  if (description)
    stream << " * Description:\n * " << description << "\n";
  if (authors)
      stream << " * Author:  " << authors << "\n";
  if (date)
      stream << " * Date:    " << date << "\n";
  stream << " */\n\n";

}

void BuildApp::WriteMutualExclusionCPP(ostream& stream, char *name)
{
  char buffer[200];
  char buffer1[200];
  strcpy(buffer1, FileNameFromPath(name));
  int j = 0;
  for (int i = 0; i < (int)strlen(buffer); i++)
   if (isalpha(buffer1[i]))
   {
     buffer[j] = buffer1[i];
     j ++;
   }
  buffer[j] = 0;
  stream << "#ifndef " << buffer << "\n#define " << buffer << "\n\n";
}

void BuildApp::WriteExtraIncludesCPP(ostream& stream)
{
  // Check for toolbars used
  Bool useToolbars = FALSE;
  wxNode *node = topLevelWindows.First();
  while (node)
  {
    BuildWindowData *win = (BuildWindowData *)node->Data();
    if (wxSubType(win->windowType, wxTYPE_FRAME))
    {
      if (((BuildFrameData *)win)->toolbar)
      {
        useToolbars = TRUE;
        node = NULL;
      }
      else node = node->Next();
    }
    else node = node->Next();
  }
  if (useToolbars)
  {
    stream << "#include \"wx_tbar.h\"\n";
  }
}

void BuildApp::WriteIncludesCPP(ostream& stream, char *headerName)
{
  stream << "#include \"wx.h\"\n#include \"wx_help.h\"\n";
  stream << "#include \"" << headerName << "\"\n\n";
}

void BuildApp::WriteAppClassCPP(ostream& stream, char *className)
{
  // Forward declarations of all top-level window classes.
  stream << "/*\n * Forward declarations of all top-level window classes.\n */\n";
  wxNode *node = topLevelWindows.First();
  while (node)
  {
    BuildWindowData *winData = (BuildWindowData *)node->Data();
    stream << "class  " << winData->className << ";\n";
    node = node->Next();
  }
  stream << "\n";

  stream << "/*\n * Class representing the entire Application\n */\n";
  stream << "class " << className << ": public wxApp\n{\n";
  stream << " public:\n";

  // Have all top-level windows as members of the App, so we can reference
  // them.
  node = topLevelWindows.First();
  while (node)
  {
    BuildWindowData *winData = (BuildWindowData *)node->Data();
    stream << "  " << winData->className << " *" << winData->memberName << ";\n";
    node = node->Next();
  }
  // GDI objects are also members.
  node = TheFontManager.First();
  while (node)
  {
    BuildFontData *data = (BuildFontData *)node->Data();
    stream << "  wxFont *" << data->fontName << ";\n";
    node = node->Next();
  }
  stream << "\n";
  
  stream << "  wxFrame *OnInit(void);\n";
  stream << "  Bool ParseCommandLine(void);\n";
  stream << "};\n\n";

}

void BuildApp::WriteAppInitCPP(ostream& stream, char *className)
{
  // Declare an instance of the application class
  stream << "// Declare an instance of the application: allows the program to start\n";
  stream << className << " theApp;\n\n";

  nameSpace.BeginBlock();

  // Create a new top level frame.
  // All the interesting frame stuff is done in the frame constructor.

  stream << "// Called to initialize the program\n";
  stream << "wxFrame *" << className << "::OnInit(void)\n{\n";

  // Initialize fonts
  wxNode *node = TheFontManager.First();
  while (node)
  {
    BuildFontData *data = (BuildFontData *)node->Data();
    stream << "  " << data->fontName << " = new wxFont(";
    stream << data->fontSize << ", ";
    if (strcmp(data->fontFamily, "Roman") == 0)
      stream << "wxROMAN, ";
    else if (strcmp(data->fontFamily, "Decorative") == 0)
      stream << "wxDECORATIVE, ";
    else if (strcmp(data->fontFamily, "Script") == 0)
      stream << "wxSCRIPT, ";
    else if (strcmp(data->fontFamily, "Modern") == 0)
      stream << "wxMODERN, ";
    else
      stream << "wxSWISS, ";
    if (strcmp(data->fontStyle, "Italic") == 0)
      stream << "wxITALIC, ";
    else if (strcmp(data->fontStyle, "Slant") == 0)
      stream << "wxSLANT, ";
    else
      stream << "wxNORMAL, ";
    if (strcmp(data->fontWeight, "Light") == 0)
      stream << "wxLIGHT";
    else if (strcmp(data->fontWeight, "Bold") == 0)
      stream << "wxBOLD";
    else
      stream << "wxNORMAL";
    stream << ");\n";

    node = node->Next();
  }
  stream << "\n";


  // Initialize all the top-level window members to NULL.
  stream << "  // Initialize all the top-level window members to NULL.\n";
  node = topLevelWindows.First();
  while (node)
  {
    BuildWindowData *winData = (BuildWindowData *)node->Data();
    stream << "  " << winData->memberName << " = NULL;\n";
    node = node->Next();
  }

  stream << "  if (!ParseCommandLine())\n    return NULL;\n\n";

  stream << "  " << topLevelFrame->memberName << " = \n    ";

  topLevelFrame->GenerateConstructorCall(stream, "NULL");
  stream << ";\n\n";

  // Return the top level frame
  stream << "  return " << topLevelFrame->memberName << ";\n}\n\n";

  nameSpace.EndBlock();

  WriteCommandParsingCPP(stream);
}

// Write class declarations and callback function prototypes
void BuildApp::WriteWindowClassDeclarationsCPP(ostream& stream)
{
  wxNode *node = topLevelWindows.First();
  while (node)
  {
    BuildWindowData *winData = (BuildWindowData *)node->Data();
    winData->WriteClassDeclaration(stream);
    node = node->Next();
  }
}

void BuildApp::WriteWindowClassImplementationsCPP(ostream& stream)
{
  wxNode *node = topLevelWindows.First();
  while (node)
  {
    BuildWindowData *winData = (BuildWindowData *)node->Data();
    winData->WriteClassImplementation(stream);
    node = node->Next();
  }
}

void BuildApp::WriteCommandParsingCPP(ostream& stream)
{
  stream << "// Parses the command line\n";
  stream << "Bool " << appClass << "::ParseCommandLine(void)\n{\n";
  stream << "  return TRUE;\n";
  stream << "}\n\n";
}

Bool BuildApp::GenerateMakefiles(void)
{
  if (strcmp(compilerDOS, "Microsoft C/C++ Vsn 7") == 0)
    GenerateMakefileMS(COMPILER_MS_C7);
  else if (strcmp(compilerDOS, "Microsoft Visual C++") == 0)
    GenerateMakefileMS(COMPILER_MS_C8);
  else if (strcmp(compilerDOS, "Microsoft C++ for NT") == 0)
    GenerateMakefileMS(COMPILER_MS_NT);
  else if (strcmp(compilerDOS, "Borland C++") == 0)
    GenerateMakefileBorland();
  else if (strcmp(compilerDOS, "Symantec C++") == 0)
    GenerateMakefileSymantec();
  GenerateMakefileUNIX();
  return TRUE;
}

Bool BuildApp::GenerateMakefileMS(int compType)
{
#ifdef wx_msw
  char *dir = projectDirDOS;
#endif
#ifdef wx_x
  char *dir = projectDirUNIX;
#endif

  char makeName[400];
  strcpy(makeName, dir);
#ifdef wx_msw
  strcat(makeName, "\\");
#endif
#ifdef wx_x
  strcat(makeName, "/");
#endif
  if (compType == COMPILER_MS_NT)
    strcat(makeName, "makefile.nt");
  else
    strcat(makeName, "makefile.dos");

  ofstream stream(makeName);
  if (stream.bad())
  {
    wxMessageBox("Cannot create DOS makefile.", "Error");
    return FALSE;
  }
  stream << "# Windows makefile for " << buildName << ", for MS C++\n";
  stream << "# Generated by wxBuilder.\n\n";
  stream << "# Change WXDIR to wherever wxWindows is found.\n";

  if (compType == COMPILER_MS_NT)
  {
    stream << "!include <ntwin32.mak>\n";
    stream << "OS_SPEC=/nologo -DWINNT -DMS_WINDOWS -Dwx_msw\n";
    stream << "ALLFLAGS= $(OS_SPEC) $(cflags) $(cvars) $(cdebug)\n";
  }
  
  stream << "WXDIR = " << wxDirDOS << "\n";
  stream << "WXLIB = $(WXDIR)\\lib\\wx.lib\n";
  stream << "WXINC = $(WXDIR)\\include\n\n";
  stream << "TOOLBARDIR = $(WXDIR)\\utils\\toolbar\n";
  stream << "TOOLBARINC = $(TOOLBARDIR)\\src\n";
  stream << "TOOLBARLIB = $(TOOLBARDIR)\\lib\\toolbar.lib\n\n";
  stream << "FAFALIB = $(WXDIR)\\contrib\\fafa\\fafa.lib\n\n";
  stream << "THISDIR = " << projectDirDOS << "\n\n";

  stream << "OBJECTS = " << buildName << ".obj\n\n";
  stream << "LIBS=$(WXLIB) $(GRAPHICSLIB) $(TOOLBARLIB) $(FAFALIB) oldnames.lib libw llibcew commdlg ddeml shell ctl3d\n\n";
  stream << "!ifndef FINAL\n";
  stream << "FINAL=0\n";
  stream << "!endif\n\n";

  stream << "INC=/I$(WXDIR)\\include\\base /I$(WXDIR)\\include\\msw /I$(TOOLBARINC)\n";

  if (compType != COMPILER_MS_NT)
  {
    stream << "PRECOMP=/YuWX.H\n";

    stream << "!if \"$(FINAL)\" == \"0\"\n";
    stream << "OPT=/Od\n";
    stream << "CPPFLAGS= /AL /W3 /Zi /G2sw $(OPT) $(PRECOMP) /Dwx_msw $(INC) /Fp$(WXDIR)\\src\\msw\\wx.pch\n";
    stream << "LINKFLAGS=/NOD /CO /ONERROR:NOEXE\n";
    stream << "!else\n";
    stream << "OPT=/Ox\n";
    stream << "CPPFLAGS= /AL /W3 /G2sw $(OPT) $(PRECOMP) /Dwx_msw $(INC) /Fp$(WXDIR)\\src\\msw\\wx.pch\n";
    stream << "LINKFLAGS=/NOD /ONERROR:NOEXE\n";
    stream << "!endif\n\n";
  }
  
  stream << "all:    wx " << buildName << ".exe\n\n";
  stream << "toolbar:\n";
  stream << "\tcd $(TOOLBARDIR)\\src\n";
  if (compType == COMPILER_MS_NT)
    stream << "\tnmake -f makefile.nt FINAL=$(FINAL)\n";
  else
    stream << "\tnmake -f makefile.dos FINAL=$(FINAL) OPT=$(OPT) PRECOMP=$(PRECOMP)\n";
  stream << "\tcd $(THISDIR)\n\n";

  stream << "wx:\n";
  stream << "\tcd $(WXDIR)\\src\\msw\n";
  if (compType == COMPILER_MS_NT)
    stream << "\tnmake -f makefile.nt FINAL=$(FINAL)\n";
  else
    stream << "\tnmake -f makefile.dos FINAL=$(FINAL) OPT=$(OPT) PRECOMP=$(PRECOMP)\n";
  stream << "\tcd $(THISDIR)\n\n";

  if (compType == COMPILER_MS_NT)
  {
    stream << buildName << ".obj: " << buildName << ".h " << buildName << ".cc\n";
    stream << "\t$(cc) @<<\n";
    stream << "$(ALLFLAGS) $(INC) /c /Tp $*.cc\n";
    stream << "<<\n\n";
  }
  else
  {
    stream << buildName << ".obj: " << buildName << ".h " << buildName << ".cc\n";
    stream << "\tcl @<<\n";
    stream << "$(CPPFLAGS) /c /Tp $*.cc\n";
    stream << "<<\n\n";
  }
  
  if (compType == COMPILER_MS_NT)
  {
    stream << buildName << ".res :      " << buildName << ".rc $(WXDIR)\\include\\msw\\wx.rc\n";
    stream << "\t$(rc) -r /i$(WXDIR)\\include\\msw /i$(WXDIR)\\contrib\\fafa -fotmp.tmp " << buildName << ".rc\n";
    stream << "\t$(cvtres) -$(CPU) -o " << buildName << ".res tmp.tmp\n";
    stream << "\tdel tmp.tmp\n\n";
  }
  else
  {
    stream << buildName << ".res :      " << buildName << ".rc $(WXDIR)\\include\\msw\\wx.rc\n";
    stream << "\trc /i$(WXDIR)\\include\\msw /i$(WXDIR)\\contrib\\fafa -r " << buildName << "\n\n";
  }
  
  if (compType == COMPILER_MS_NT)
  {
    stream << buildName << ".exe:      $(WXDIR)\\src\\msw\\dummy.obj $(WXLIB) $(OBJECTS) " << buildName << ".def " << buildName << ".res\n";
    stream << "\t$(link) @<<\n";
    stream << "-out:" << buildName << ".exe\n";
    stream << "-machine:$(CPU)\n";
    stream << "-subsystem:windows\n";
    stream << "$(LINKFLAGS)\n";
    stream << "$(WXDIR)\\src\\msw\\dummy.obj " << buildName << ".obj " << buildName << ".res\n";
    stream << "$(WXLIB)\n";
    stream << "shell32.lib $(guilibs)\n";
    stream << "<<\n";
  }
  else
  {
    stream << buildName << ".exe:      $(WXDIR)\\src\\msw\\dummy.obj $(WXLIB) $(OBJECTS) " << buildName << ".def " << buildName << ".res\n";
    stream << "\tlink $(LINKFLAGS) @<<\n";
    stream << "$(WXDIR)\\src\\msw\\dummy.obj $(OBJECTS)\n";
    stream << buildName << ".exe,\n";
    stream << "nul,\n";
    stream << "$(LIBS),\n";
    stream << buildName << ".def\n";
    stream << "<<\n";
    stream << "\trc -K " << buildName << ".res\n\n";
  }
  
  stream << "clean:\n\t-erase *.obj *.exe *.res\n";

  return TRUE;
}

Bool BuildApp::GenerateMakefileBorland(void)
{
  return FALSE;
}

Bool BuildApp::GenerateMakefileSymantec(void)
{
  return FALSE;
}

Bool BuildApp::GenerateMakefileUNIX(void)
{
  char makeName[400];
#ifdef wx_msw
  char *dir = projectDirDOS;
#endif
#ifdef wx_x
  char *dir = projectDirUNIX;
#endif
  strcpy(makeName, dir);
#ifdef wx_msw
  strcat(makeName, "\\");
#endif
#ifdef wx_x
  strcat(makeName, "/");
#endif
  strcat(makeName, "makefile.unx");

  ofstream stream(makeName);
  if (stream.bad())
  {
    Report("Could not create UNIX makefile.\n");
    wxMessageBox("Cannot create UNIX makefile.", "Error");
    return FALSE;
  }
  stream << "# UNIX makefile for " << buildName << "\n";
  stream << "# Generated by wxBuilder.\n\n";
  stream << "# Change WXDIR to wherever wxWindows is found.\n\n";
  stream << "CC = " << compilerUNIX << "\n";
  stream << "GUISUFFIX=_ol\n\n";

  stream << "# Replace X include/lib directories with your own.\n";
  stream << "XINCLUDE=" << XIncludes << "\n";
  stream << "XLIB=" << XLibs << "\n\n";

  stream << "WXDIR = " << wxDirUNIX << "\n";
  stream << "WXLIB = $(WXDIR)/lib/libwx$(GUISUFFIX).a\n";
  stream << "WXINC = $(WXDIR)/include\n";
  stream << "INC = -I$(WXINC)/base -I$(WXINC)/x\n";
  stream << "THISDIR = " << projectDirUNIX << "\n";
  stream << "OBJDIR = objects$(GUISUFFIX)\n\n";
  stream << "OBJECTS = " << buildName << ".o\n";

  stream << "TOOLBARDIR = $(WXDIR)/utils/toolbar\n";
  stream << "TOOLBARINC = $(TOOLBARDIR)/src\n";
  stream << "TOOLBARLIB = $(TOOLBARDIR)/lib/libtbar$(GUISUFFIX).a\n";

  stream << "DEBUG = -ggdb\n";
  stream << "WARN = -Wall\n";
  stream << "OPT = -O\n";

  stream << "GUI = -Dwx_xview\n";
  stream << "XVIEW_LINK = $(WXDIR)/src/x/objects_ol/sb_scrol.o\n\n";

  stream << "CPPFLAGS = $(XINCLUDE) $(INC) -I$(TOOLBARINC) $(GUI) $(DEBUG) $(WARN)\n";
  stream << "LDFLAGS = $(XLIB) -L$(WXDIR)/lib -L$(TOOLBARDIR)/lib\n";
  stream << "LDLIBS = -ltbar_ol -lwx_ol -lxview -lolgx -lX11 -lm -lg++\n\n";
  stream << "all: $(OBJDIR) " << buildName << "$(GUISUFFIX)\n\n";
  stream << ".SUFFIXES:\n\n";

  stream << "motif:\n";
  stream << "\tmake -f makefile.unx " << buildName << "_motif GUISUFFIX=_motif GUI=-Dwx_motif OPT=$(OPT) LDLIBS='-lwx_motif -ltbar_motif -lXm -lXt -lX11 -lm";
  if (strlen(compilerUNIX) > 2 && (strncmp(compilerUNIX, "gcc", 3) == 0))
    stream << " -lg++";
  stream << "' XVIEW_LINK=\n";

  stream << "hp:\n";
  stream << "\tmake -f makefile.unx " << buildName << "_hp GUISUFFIX=_hp GUI=-Dwx_hp OPT=$(OPT) LDLIBS='-lwx_hp -ltbar_hp -lXm -lXt -lX11 -lm";
  if (strlen(compilerUNIX) > 2 && (strncmp(compilerUNIX, "gcc", 3) == 0))
    stream << " -lg++";
  stream << "' XVIEW_LINK='' \\\n";
  stream << "\tCC=CC DEBUG='-g' WARN='-w' OPT='' \\\n";
  stream << "\tXINCLUDE='-I/usr/include/Motif1.2 -I/usr/include/X11R5' \\\n";
  stream << "\tXLIB='-L/usr/lib/Motif1.2 -L/usr/lib/X11R5'\n\n";

  stream << "xview:\n";
  stream << "\tmake -f makefile.unx " << buildName << "_ol GUISUFFIX=_ol GUI=-Dwx_xview OPT=$(OPT) LDLIBS='-lwx_ol -ltbar_ol -lXm -lxview -lolgx -lX11 -lm";
  if (strlen(compilerUNIX) > 2 && (strncmp(compilerUNIX, "gcc", 3) == 0))
    stream << " -lg++";
  stream << "'\n\n";
  
  stream << "wx_motif:\n";
  stream << "\tcd $(WXDIR)/src/x; make -f makefile.unx motif OPT=$(OPT)\n\n";
  stream << "wx_ol:\n";
  stream << "\tcd $(WXDIR)/src/x; make -f makefile.unx xview OPT=$(OPT)\n\n";
  stream << "wx_hp:\n";
  stream << "\tcd $(WXDIR)/src/x; make -f makefile.unx hp OPT=$(OPT)\n\n";

  stream << "toolbar_motif:\n";
  stream << "\tcd $(TOOLBARDIR)/src; make -f makefile.unx motif OPT=$(OPT)\n\n";
  stream << "toolbar_ol:\n";
  stream << "\tcd $(TOOLBARDIR)/src; make -f makefile.unx xview OPT=$(OPT)\n\n";
  stream << "toolbar_hp:\n";
  stream << "\tcd $(TOOLBARDIR)/src; make -f makefile.unx hp OPT=$(OPT)\n\n";

  stream << "$(OBJDIR):\n\tmkdir $(OBJDIR)\n\n";

  stream << buildName << ".o: " << buildName << ".h " << buildName << ".cc\n";

  stream << buildName << ":\t" << "$(OBJECTS) $(WXLIB) $(TOOLBARLIB)\n";
  stream << "\t$(CC) $(CPPFLAGS) $(LDFLAGS) -o " << buildName << " " << buildName << ".o $(XVIEW_LINK) $(LDLIBS)\n\n";

  stream << "cleaneach:\n";
  stream << "\trm -f $(OBJDIR)/*.o " << buildName << "$(GUISUFFIX) core\n\n";

  stream << "clean_ol:\n\tmake -f makefile.unx GUISUFFIX=_ol cleaneach\n\n";
  stream << "clean_hp:\n\tmake -f makefile.unx GUISUFFIX=_hp cleaneach\n\n";
  stream << "clean_motif:\n\tmake -f makefile.unx GUISUFFIX=_motif cleaneach\n\n";

  return TRUE;
}

Bool BuildApp::GenerateRCFile(void)
{
#ifdef wx_msw
  char *dir = projectDirDOS;
#endif
#ifdef wx_x
  char *dir = projectDirUNIX;
#endif

  char rcName[400];
  strcpy(rcName, dir);
#ifdef wx_msw
  strcat(rcName, "\\");
#endif
#ifdef wx_x
  strcat(rcName, "/");
#endif
  strcat(rcName, buildName);
  strcat(rcName, ".rc");

  ofstream stream(rcName);
  if (stream.bad())
  {
    Report("Could not create RC makefile.\n");
    wxMessageBox("Cannot create RC file.", "Error");
    return FALSE;
  }
  wxNode *node = buildApp.topLevelWindows.First();
  while (node)
  {
    BuildWindowData *win = (BuildWindowData *)node->Data();
    win->GenerateResourceEntries(stream);
    node = node->Next();
  }
  stream << "\nrcinclude wx.rc\n";
  return TRUE;
}

Bool BuildApp::GenerateDefFile(void)
{
#ifdef wx_msw
  char *dir = projectDirDOS;
#endif
#ifdef wx_x
  char *dir = projectDirUNIX;
#endif
  char defName[400];
  strcpy(defName, dir);
#ifdef wx_msw
  strcat(defName, "\\");
#endif
#ifdef wx_x
  strcat(defName, "/");
#endif
  strcat(defName, buildName);
  strcat(defName, ".def");

  ofstream stream(defName);
  if (stream.bad())
  {
    Report("Could not create DEF file.\n");
    wxMessageBox("Cannot create DEF file.", "Error");
    return FALSE;
  }
  stream << "; " << buildName << "\n";
  stream << "; Generated by wxBuilder\n";
  stream << ";\n";
  stream << "NAME          " << buildName << "app\n";
  stream << "DESCRIPTION   'A wxWindows application'\n";
  stream << ";\n";
  stream << "EXETYPE      WINDOWS\n";
  stream << "STUB         'WINSTUB.EXE'\n";
  stream << ";\n";
  stream << "CODE         PRELOAD MOVEABLE DISCARDABLE\n";
  stream << "DATA         PRELOAD MOVEABLE MULTIPLE\n";
  stream << ";\n";
  stream << "HEAPSIZE     1024\n";
  stream << "STACKSIZE    8192\n";
  return TRUE;
}

