/*
 * File:	bapp.cc
 * Purpose:	wxWindows GUI builder
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include "wx.h"
#include "wx_help.h"
#include "wx_types.h"
#include <ctype.h>
#include <stdlib.h>

#include "wxbuild.h"
#include "namegen.h"
#include "bapp.h"
#include "bframe.h"
#include "bmenu.h"
#include "bsubwin.h"
#include "bitem.h"
#include "btoolbar.h"
#include "bactions.h"
#include "bgdi.h"

#define BUILDERSECTION "wxBuilder"

extern void ClearTree(void);

// This statement initialises the whole application
BuildApp     buildApp;

// Bitmaps for palette
wxBitmap *PaletteFrameBitmap = NULL;
wxBitmap *PaletteDialogBoxBitmap = NULL;
wxBitmap *PalettePanelBitmap = NULL;
wxBitmap *PaletteCanvasBitmap = NULL;
wxBitmap *PaletteTextWindowBitmap = NULL;
wxBitmap *PaletteMessageBitmap = NULL;
wxBitmap *PaletteButtonBitmap = NULL;
wxBitmap *PaletteCheckBoxBitmap = NULL;
wxBitmap *PaletteListBoxBitmap = NULL;
wxBitmap *PaletteRadioBoxBitmap = NULL;
wxBitmap *PaletteChoiceBitmap = NULL;
wxBitmap *PaletteTextBitmap = NULL;
wxBitmap *PaletteMultiTextBitmap = NULL;
wxBitmap *PaletteSliderBitmap = NULL;
wxBitmap *PaletteArrowBitmap = NULL;

// Bitmaps for toolbar
wxBitmap *ToolbarLoadBitmap = NULL;
wxBitmap *ToolbarSaveBitmap = NULL;
wxBitmap *ToolbarVertBitmap = NULL;
wxBitmap *ToolbarAlignTBitmap = NULL;
wxBitmap *ToolbarAlignBBitmap = NULL;
wxBitmap *ToolbarHorizBitmap = NULL;
wxBitmap *ToolbarAlignLBitmap = NULL;
wxBitmap *ToolbarAlignRBitmap = NULL;
wxBitmap *ToolbarCPPBitmap = NULL;
wxBitmap *ToolbarTreeBitmap = NULL;
wxBitmap *ToolbarHelpBitmap = NULL;

// The `main program' equivalent, creating the windows and returning the
// main frame
wxFrame *BuildApp::OnInit(void)
{
  int i = 1;
  
  // Read input file if given without using -f
  if (argc > 1 && (argv[1][0] != '-'))
  {
    projectFilename = copystring(argv[1]);
    i ++;
  }

  while (i < argc)
  {
    if (strcmp(argv[i], "-f") == 0)
    {
      i ++;
      if (i == argc)
      {
        wxError("-f must take a filename!", "Warning");
      }
      else
      {
        projectFilename = copystring(argv[i]);
        i ++;
      }
    }
    else
    {
      char buf[200];
      sprintf(buf, "Unrecognised wxBuilder option %s", argv[i]);
      wxError(buf, "Warning");
      i++;
    }
  }

  wxAllTypes.AddType(wxTYPE_TOOLBAR, wxTYPE_CANVAS, "toolbar");

  handCursor = new wxCursor(wxCURSOR_HAND);
  crossCursor = new wxCursor(wxCURSOR_CROSS);
  // Create a small font
  SmallButtonFont = new wxFont(11, wxROMAN, wxNORMAL, wxNORMAL);
  SmallLabelFont = new wxFont(12, wxROMAN, wxITALIC, wxBOLD);
  TextWindowFont = new wxFont(12, wxSWISS, wxNORMAL, wxNORMAL);
  GraphicsInitialize();
  InitializeDefaults();
  
  // Create the main frame window
  MainFrame = new BuildFrame(NULL, "wxBuilder [unnamed]", mainX, mainY, mainWidth, mainHeight);

  // Load palette bitmaps
  ToolbarLoadBitmap = new wxBitmap("LOADTOOL");
  ToolbarSaveBitmap = new wxBitmap("SAVETOOL");
  ToolbarVertBitmap = new wxBitmap("VERTTOOL");
  ToolbarAlignTBitmap = new wxBitmap("ALIGNTTOOL");
  ToolbarAlignBBitmap = new wxBitmap("ALIGNBTOOL");
  ToolbarHorizBitmap = new wxBitmap("HORIZTOOL");
  ToolbarAlignLBitmap = new wxBitmap("ALIGNLTOOL");
  ToolbarAlignRBitmap = new wxBitmap("ALIGNRTOOL");
  ToolbarCPPBitmap = new wxBitmap("CPPTOOL");
  ToolbarTreeBitmap = new wxBitmap("TREETOOL");
  ToolbarHelpBitmap = new wxBitmap("HELPTOOL");

  // Create the toolbar
  MainFrame->toolbar = new EditorToolBar(MainFrame, 0, 0, -1, -1, 0,
                                        wxHORIZONTAL, 30);
  MainFrame->toolbar->SetMargins(2, 2);
  MainFrame->toolbar->GetDC()->SetBackground(wxGREY_BRUSH);

  int width = ToolbarLoadBitmap->GetWidth();
  int currentX = 2;
  MainFrame->toolbar->AddTool(TOOLBAR_LOAD_FILE, ToolbarLoadBitmap, NULL,
                   FALSE, (float)currentX, -1, NULL);
  currentX += width + 2;
  MainFrame->toolbar->AddTool(TOOLBAR_SAVE_FILE, ToolbarSaveBitmap, NULL,
                   FALSE, (float)currentX, -1, NULL);
  currentX += width + 2;
  MainFrame->toolbar->AddTool(TOOLBAR_FORMAT_HORIZ, ToolbarVertBitmap, NULL,
                   FALSE, (float)currentX, -1, NULL);
  currentX += width + 2;
  MainFrame->toolbar->AddTool(TOOLBAR_FORMAT_VERT_TOP_ALIGN, ToolbarAlignTBitmap, NULL,
                   FALSE, (float)currentX, -1, NULL);
  currentX += width + 2;
  MainFrame->toolbar->AddTool(TOOLBAR_FORMAT_VERT_BOT_ALIGN, ToolbarAlignBBitmap, NULL,
                   FALSE, (float)currentX, -1, NULL);
  currentX += width + 2;
  MainFrame->toolbar->AddTool(TOOLBAR_FORMAT_VERT, ToolbarHorizBitmap, NULL,
                   FALSE, (float)currentX, -1, NULL);
  currentX += width + 2;
  MainFrame->toolbar->AddTool(TOOLBAR_FORMAT_HORIZ_LEFT_ALIGN, ToolbarAlignLBitmap, NULL,
                   FALSE, (float)currentX, -1, NULL);
  currentX += width + 2;
  MainFrame->toolbar->AddTool(TOOLBAR_FORMAT_HORIZ_RIGHT_ALIGN, ToolbarAlignRBitmap, NULL,
                   FALSE, (float)currentX, -1, NULL);
  currentX += width + 2;
  MainFrame->toolbar->AddTool(TOOLBAR_GEN_CPP, ToolbarCPPBitmap, NULL,
                   FALSE, (float)currentX, -1, NULL);
  currentX += width + 2;
  MainFrame->toolbar->AddTool(TOOLBAR_TREE, ToolbarTreeBitmap, NULL,
                   FALSE, (float)currentX, -1, NULL);
  currentX += width + 2;
  MainFrame->toolbar->AddTool(TOOLBAR_HELP, ToolbarHelpBitmap, NULL,
                   FALSE, (float)currentX, -1, NULL);
  currentX += width + 2;

  MainFrame->OnSize(-1, -1);

  // Load palette bitmaps
  PaletteFrameBitmap = new wxBitmap("FRAMETOOL");
  PaletteDialogBoxBitmap = new wxBitmap("DIALOGBOXTOOL");
  PalettePanelBitmap = new wxBitmap("PANELTOOL");
  PaletteCanvasBitmap = new wxBitmap("CANVASTOOL");
  PaletteTextWindowBitmap = new wxBitmap("TEXTWINDOWTOOL");
  PaletteMessageBitmap = new wxBitmap("MESSAGETOOL");
  PaletteButtonBitmap = new wxBitmap("BUTTONTOOL");
  PaletteCheckBoxBitmap = new wxBitmap("CHECKBOXTOOL");
  PaletteListBoxBitmap = new wxBitmap("LISTBOXTOOL");
  PaletteRadioBoxBitmap = new wxBitmap("RADIOBOXTOOL");
  PaletteChoiceBitmap = new wxBitmap("CHOICETOOL");
  PaletteTextBitmap = new wxBitmap("TEXTTOOL");
  PaletteMultiTextBitmap = new wxBitmap("MULTITEXTTOOL");
  PaletteSliderBitmap = new wxBitmap("SLIDERTOOL");
  PaletteArrowBitmap = new wxBitmap("ARROWTOOL");

  EditorPaletteFrame = new EditorToolPaletteFrame(MainFrame, "wxWindows Objects", paletteX, paletteY, 100, 200,
         wxSDI | wxCAPTION);
  EditorPaletteFrame->palette = new EditorToolPalette(EditorPaletteFrame, 0, 0, -1, -1, 0,
                                        wxHORIZONTAL, 5);
  EditorPaletteFrame->palette->SetMargins(2, 2);
  EditorPaletteFrame->palette->GetDC()->SetBackground(wxGREY_BRUSH);
  EditorPaletteFrame->palette->AddTool(PALETTE_ARROW, PaletteArrowBitmap, NULL, TRUE);
  EditorPaletteFrame->palette->AddTool(PALETTE_FRAME, PaletteFrameBitmap, NULL, TRUE);
  EditorPaletteFrame->palette->AddTool(PALETTE_DIALOG_BOX, PaletteDialogBoxBitmap, NULL, TRUE);
  EditorPaletteFrame->palette->AddTool(PALETTE_PANEL, PalettePanelBitmap, NULL, TRUE);
  EditorPaletteFrame->palette->AddTool(PALETTE_CANVAS, PaletteCanvasBitmap, NULL, TRUE);
  EditorPaletteFrame->palette->AddTool(PALETTE_TEXT_WINDOW, PaletteTextWindowBitmap, NULL, TRUE);
  EditorPaletteFrame->palette->AddTool(PALETTE_MESSAGE, PaletteMessageBitmap, NULL, TRUE);
  EditorPaletteFrame->palette->AddTool(PALETTE_BUTTON, PaletteButtonBitmap, NULL, TRUE);
  EditorPaletteFrame->palette->AddTool(PALETTE_CHECKBOX, PaletteCheckBoxBitmap, NULL, TRUE);
  EditorPaletteFrame->palette->AddTool(PALETTE_RADIOBOX, PaletteRadioBoxBitmap, NULL, TRUE);
  EditorPaletteFrame->palette->AddTool(PALETTE_LISTBOX, PaletteListBoxBitmap, NULL, TRUE);
  EditorPaletteFrame->palette->AddTool(PALETTE_CHOICE, PaletteChoiceBitmap, NULL, TRUE);
  EditorPaletteFrame->palette->AddTool(PALETTE_TEXT, PaletteTextBitmap, NULL, TRUE);
  EditorPaletteFrame->palette->AddTool(PALETTE_MULTITEXT, PaletteMultiTextBitmap, NULL, TRUE);
  EditorPaletteFrame->palette->AddTool(PALETTE_SLIDER, PaletteSliderBitmap, NULL, TRUE);

  EditorPaletteFrame->palette->Layout();
  float maxWidth, maxHeight;
  EditorPaletteFrame->palette->GetMaxSize(&maxWidth, &maxHeight);
  EditorPaletteFrame->SetClientSize((int)maxWidth, (int)maxHeight);
  EditorPaletteFrame->palette->ToggleTool(PALETTE_ARROW, TRUE);
  EditorPaletteFrame->palette->currentlySelected = PALETTE_ARROW;
  EditorPaletteFrame->Show(TRUE);
  EditorPaletteFrame->palette->OnPaint();

  HelpInstance = new wxHelpInstance(TRUE);
  HelpInstance->Initialize("wxbuild");

  if (projectFilename)
  {
    LoadProject(projectFilename, FALSE);
  }

  return MainFrame;
}

BuildApp::BuildApp(void)
{
  topLevelFrame = NULL;
  projectFilename = NULL;
  buildName = copystring("noname");
  buildDescription = NULL;
  buildAuthors = NULL;
  buildDate = NULL;
  appClass = copystring("AppClass");
  buildMDIType = wxSDI;
  extensionCPP = copystring(".cc");
  currentMenuItemId = 1;
  testMode = FALSE;

  mainX = 250;
  mainY = 10;
  mainWidth = 400;
  mainHeight = 400;

  paletteX = 10;
  paletteY = 150;

  reportX = 50;
  reportY = 50;
  reportWidth = 350;
  reportHeight = 200;

  projectDirUNIX = copystring("project");
  projectDirDOS = copystring("project");
  commandLine = copystring("");
  genMakefiles = TRUE;
  genRCFile = TRUE;
  genDefFile = TRUE;
  separateFiles = FALSE;
  XIncludes = copystring("-I/usr/include/X11R5 -I/usr/include/motif1.2");
  XLibs = copystring("-L/usr/lib/X11R5 -L/usr/lib/motif1.2");
  windowsInclude = copystring("-Ic:\\c700\\include");
  wxDirUNIX = copystring("/usr/lib/wx");
  wxDirDOS = copystring("c:\\wx");
  guiTarget = copystring("motif");

  autoCompile = FALSE;
  autoRun = FALSE;

  compilerDOS = copystring("Microsoft C/C++ Vsn 7");
  compilerUNIX = copystring("gcc-2.1");
}

BuildApp::~BuildApp(void)
{
}

// Set up defaults from WIN.INI/.Xdefaults
void BuildApp::InitializeDefaults(void)
{
  wxGetResource(BUILDERSECTION, "target", &guiTarget);
  wxGetResource(BUILDERSECTION, "autoRun", &autoRun);
  wxGetResource(BUILDERSECTION, "autoCompile", &autoCompile);
  wxGetResource(BUILDERSECTION, "compilerDOS", &compilerDOS);
  wxGetResource(BUILDERSECTION, "compilerUNIX", &compilerUNIX);
  wxGetResource(BUILDERSECTION, "xIncludes", &XIncludes);
  wxGetResource(BUILDERSECTION, "xLib", &XLibs);
  wxGetResource(BUILDERSECTION, "windowsInclude", &windowsInclude);
  wxGetResource(BUILDERSECTION, "wxDirUNIX", &wxDirUNIX);
  wxGetResource(BUILDERSECTION, "wxDirDOS", &wxDirDOS);

  wxGetResource(BUILDERSECTION, "mainX", &mainX);
  wxGetResource(BUILDERSECTION, "mainY", &mainY);
  wxGetResource(BUILDERSECTION, "mainWidth", &mainWidth);
  wxGetResource(BUILDERSECTION, "mainHeight", &mainHeight);

  wxGetResource(BUILDERSECTION, "reportX", &reportX);
  wxGetResource(BUILDERSECTION, "reportY", &reportY);
  wxGetResource(BUILDERSECTION, "reportWidth", &reportWidth);
  wxGetResource(BUILDERSECTION, "reportHeight", &reportHeight);

  wxGetResource(BUILDERSECTION, "treeX", &treeX);
  wxGetResource(BUILDERSECTION, "treeY", &treeY);
  wxGetResource(BUILDERSECTION, "treeWidth", &treeWidth);
  wxGetResource(BUILDERSECTION, "treeHeight", &treeHeight);

  wxGetResource(BUILDERSECTION, "paletteX", &paletteX);
  wxGetResource(BUILDERSECTION, "paletteY", &paletteY);
}

// Write defaults into WIN.INI (not .Xdefaults!)
void BuildApp::WriteDefaults(void)
{
#ifdef wx_msw
  wxWriteResource(BUILDERSECTION, "target", guiTarget);
  wxWriteResource(BUILDERSECTION, "autoRun", autoRun);
  wxWriteResource(BUILDERSECTION, "autoCompile", autoCompile);
  wxWriteResource(BUILDERSECTION, "compilerDOS", compilerDOS);
  wxWriteResource(BUILDERSECTION, "compilerUNIX", compilerUNIX);
  wxWriteResource(BUILDERSECTION, "xIncludes", XIncludes);
  wxWriteResource(BUILDERSECTION, "xLib", XLibs);
  wxWriteResource(BUILDERSECTION, "windowsInclude", windowsInclude);
  wxWriteResource(BUILDERSECTION, "wxDirUNIX", wxDirUNIX);
  wxWriteResource(BUILDERSECTION, "wxDirDOS", wxDirDOS);

  wxWriteResource(BUILDERSECTION, "mainX", mainX);
  wxWriteResource(BUILDERSECTION, "mainY", mainY);
  wxWriteResource(BUILDERSECTION, "mainWidth", mainWidth);
  wxWriteResource(BUILDERSECTION, "mainHeight", mainHeight);
  wxWriteResource(BUILDERSECTION, "reportX", reportX);
  wxWriteResource(BUILDERSECTION, "reportY", reportY);
  wxWriteResource(BUILDERSECTION, "reportWidth", reportWidth);
  wxWriteResource(BUILDERSECTION, "reportHeight", reportHeight);
  wxWriteResource(BUILDERSECTION, "treeX", treeX);
  wxWriteResource(BUILDERSECTION, "treeY", treeY);
  wxWriteResource(BUILDERSECTION, "treeWidth", treeWidth);
  wxWriteResource(BUILDERSECTION, "treeHeight", treeHeight);
  wxWriteResource(BUILDERSECTION, "paletteX", paletteX);
  wxWriteResource(BUILDERSECTION, "paletteY", paletteY);
#endif
}

void BuildApp::EditGlobalSettings(void)
{
  wxDialogBox *dialog = new wxDialogBox(NULL, "Global Settings", TRUE, 10, 10);
  dialog->SetLabelFont(SmallLabelFont);
  dialog->SetButtonFont(SmallButtonFont);

  BuildForm *form = new BuildForm("Changing project and global settings");
  
  form->Add(wxMakeFormString("Windows compiler", &compilerDOS, wxFORM_CHOICE,
              new wxList(wxMakeConstraintStrings(
    "Microsoft C/C++ Vsn 7",
    "Microsoft Visual C++",
    "Microsoft C++ for NT",
    "Symantec C++",
    "Borland C++",
//    "Zortech C++",
    NULL), NULL), NULL, wxVERTICAL, 200));
  form->Add(wxMakeFormNewLine());

  form->Add(wxMakeFormString("UNIX compiler", &compilerUNIX, wxFORM_DEFAULT, NULL, NULL, wxVERTICAL,
               200));
  form->Add(wxMakeFormString("X GUI target", &guiTarget, wxFORM_CHOICE,
              new wxList(wxMakeConstraintStrings("xview", "motif", "hp", NULL), NULL),
            NULL, wxVERTICAL, 150));
  form->Add(wxMakeFormNewLine());
  form->Add(wxMakeFormString("X includes", &XIncludes, wxFORM_DEFAULT, NULL, NULL, wxVERTICAL,
               300));
  form->Add(wxMakeFormNewLine());
  form->Add(wxMakeFormString("X libs", &XLibs, wxFORM_DEFAULT, NULL, NULL, wxVERTICAL,
               300));
  form->Add(wxMakeFormNewLine());
  form->Add(wxMakeFormString("wxWindows directory under Windows", &wxDirDOS, wxFORM_DEFAULT, NULL, NULL, wxVERTICAL,
               300));
  form->Add(wxMakeFormNewLine());
  form->Add(wxMakeFormString("wxWindows directory under UNIX", &wxDirUNIX, wxFORM_DEFAULT, NULL, NULL, wxVERTICAL,
               300));
  form->Add(wxMakeFormNewLine());
  form->Add(wxMakeFormBool("Auto compile", &autoCompile));
  form->Add(wxMakeFormBool("Auto run", &autoRun));

  form->AssociatePanel(dialog);
  form->dialog = dialog;

  dialog->Fit();
  dialog->Centre(wxBOTH);

  dialog->Show(TRUE);
}

void BuildApp::EditProjectSettings(void)
{
  wxDialogBox *dialog = new wxDialogBox(NULL, "Project Settings", TRUE, 10, 10);
  dialog->SetLabelFont(SmallLabelFont);
  dialog->SetButtonFont(SmallButtonFont);

  BuildForm *form = new BuildForm("Changing project and global settings");
  
  form->Add(wxMakeFormString("Root name", &buildName, wxFORM_DEFAULT, NULL, NULL, wxVERTICAL,
               160));
  form->Add(wxMakeFormNewLine());
  form->Add(wxMakeFormString("Directory under Windows", &projectDirDOS, wxFORM_DEFAULT, NULL, NULL, wxVERTICAL,
               240));
  form->Add(wxMakeFormNewLine());
  form->Add(wxMakeFormString("Directory under UNIX", &projectDirUNIX, wxFORM_DEFAULT, NULL, NULL, wxVERTICAL,
               240));
  form->Add(wxMakeFormNewLine());

  form->Add(wxMakeFormString("Command line", &commandLine, wxFORM_DEFAULT, NULL, NULL, wxVERTICAL,
               300));
  form->Add(wxMakeFormNewLine());

  form->Add(wxMakeFormBool("Generate makefiles", &genMakefiles));
  form->Add(wxMakeFormBool("Generate RC file", &genRCFile));
  form->Add(wxMakeFormBool("Generate DEF file", &genDefFile));
  form->Add(wxMakeFormNewLine());

  form->Add(wxMakeFormBool("Generate separate file per window", &separateFiles));

  form->AssociatePanel(dialog);
  form->dialog = dialog;

  dialog->Fit();
  dialog->Centre(wxBOTH);

  dialog->Show(TRUE);
}

Bool BuildApp::WritePrologAttributes(PrologExpr *expr, PrologDatabase *database)
{
  expr->AddAttributeValue("wxbuilder_version", buildVersion);
  if (topLevelFrame)
    expr->AddAttributeValue("top_level_frame", topLevelFrame->id);
  if (buildName)
    expr->AddAttributeValueString("name", buildName);
  if (buildDescription)
    expr->AddAttributeValueString("description", buildDescription);
  if (buildAuthors)
    expr->AddAttributeValueString("authors", buildAuthors);
  if (buildDate)
    expr->AddAttributeValueString("date", buildDate);
  if (projectDirDOS)
    expr->AddAttributeValueString("project_dir_dos", projectDirDOS);
  if (projectDirUNIX)
    expr->AddAttributeValueString("project_dir_unix", projectDirUNIX);
  if (commandLine)
    expr->AddAttributeValueString("command_line", commandLine);

  expr->AddAttributeValue("generate_makefiles", (long)genMakefiles);
  expr->AddAttributeValue("generate_rc_file", (long)genRCFile);
  expr->AddAttributeValue("generate_def_file", (long)genDefFile);
  expr->AddAttributeValue("generate_separate_files", (long)separateFiles);
  
  expr->AddAttributeValue("mdi", (long)buildMDIType);
  if (extensionCPP)
    expr->AddAttributeValueString("extension", extensionCPP);
  return TRUE;
}

Bool BuildApp::ReadPrologAttributes(PrologExpr *expr, PrologDatabase *database)
{
  expr->AssignAttributeValue("top_level_frame", &topLevelFrameId);
  expr->AssignAttributeValue("name", &buildName);
  expr->AssignAttributeValue("description", &buildDescription);
  expr->AssignAttributeValue("authors", &buildAuthors);
  expr->AssignAttributeValue("date", &buildDate);
  expr->AssignAttributeValue("project_dir_dos", &projectDirDOS);
  expr->AssignAttributeValue("project_dir_unix", &projectDirUNIX);
  expr->AssignAttributeValue("command_line", &commandLine);
  expr->AssignAttributeValue("generate_makefiles", &genMakefiles);
  expr->AssignAttributeValue("generate_rc_file", &genRCFile);
  expr->AssignAttributeValue("generate_def_file", &genDefFile);
  expr->AssignAttributeValue("generate_separate_files", &separateFiles);
  expr->AssignAttributeValue("mdi", &buildMDIType);
  expr->AssignAttributeValue("extension", &extensionCPP);
  
  return TRUE;
}

Bool BuildApp::SaveProject(char *filename)
{
  if (filename && !projectFilename)
    projectFilename = copystring(filename);
    
  if (!filename || !projectFilename)
  {
    char *file = wxFileSelector("Select a project file to save to", PathOnly(projectFilename),  FileNameFromPath(projectFilename), "wxp", "*.wxp");
    if (file)
    {
      projectFilename = copystring(file);
    }
    else return FALSE;
  }
  if (projectFilename)
  {
    char buf[300];
    sprintf(buf, "wxBuilder [%s]", FileNameFromPath(projectFilename));
    MainFrame->SetTitle(buf);

    PrologDatabase database;

    // First write the project header
    PrologExpr *clause = new PrologExpr("project");
    WritePrologAttributes(clause, &database);
    database.Append(clause);

    // Now all the top-level windows
    wxNode *node = topLevelWindows.First();
    while (node)
    {
      BuildWindowData *win = (BuildWindowData *)node->Data();

      win->WriteRecursively(&database);
      node = node->Next();
    }
    TheFontManager.WriteFonts(&database);
    
    ofstream stream(projectFilename);
    database.WriteProlog(stream);
    MakeModified(FALSE);
  }
  else return FALSE;

  return TRUE;
}

Bool BuildApp::LoadProject(char *filename, Bool interactive)
{
//  if (filename && !projectFilename)
//    projectFilename = copystring(filename);
  if (interactive)
  {
    char *file = wxFileSelector("Select a project file to load from", PathOnly(projectFilename),  FileNameFromPath(projectFilename), "wxp", "*.wxp");
    if (file)
    {
      projectFilename = copystring(file);
    }
    else return FALSE;
  }

  if (projectFilename)
  {
    // Create a database hashing on the "id" attribute,
    // so we can quickly find structures we've built up so far.
    PrologDatabase database(PrologInteger, "id");

    if (!database.ReadProlog(projectFilename))
    {
      wxMessageBox("Could not load file.", "Error");
      return FALSE;
    }
    TheFontManager.Show(FALSE);
    database.BeginFind();
    PrologExpr *header = database.FindClauseByFunctor("project");
    if (!header)
    {
      wxMessageBox("Not a valid project file.", "Error");
      return FALSE;
    }
    ReadPrologAttributes(header, &database);

    // Only now clear the current project, when we're more
    // confident of progressing.
    ClearProject();

    // Find all the menus
    database.BeginFind();
    PrologExpr *expr = database.FindClauseByFunctor("menu_item");
    while (expr)
    {
      long parentId = 0;
      long id = 0;

      BuildMenuItem *item = new BuildMenuItem;
      item->ReadPrologAttributes(expr, &database);
      expr->AssignAttributeValue("parent", &parentId);
      expr->AssignAttributeValue("id", &id);
      RegisterId(id);
      expr->SetClientData(item);

      PrologExpr *parentExpr = database.HashFind("menu_item", parentId);
      if (parentExpr)
      {
        item->parent = (BuildMenuItem *)parentExpr->GetClientData();
        if (item->parent)
          item->parent->menus.Append(item);
      }

      expr = database.FindClauseByFunctor("menu_item");
    }

    // Find all the windows
    database.BeginFind();
    expr = database.FindClauseByFunctor("window");
    while (expr)
    {
      int windowType = 0;
      long parentId = 0;
      int id = 0;
      expr->AssignAttributeValue("type", &windowType);
      expr->AssignAttributeValue("parent", &parentId);
      expr->AssignAttributeValue("id", &id);
      RegisterId(id);

      switch (windowType)
      {
        case wxTYPE_FRAME:
        {
          BuildFrameData *data = new BuildFrameData(NULL);
          expr->SetClientData(data);
          
          data->ReadPrologAttributes(expr, &database);
          data->ReadActions(expr, &database);

          if (topLevelFrameId == data->id)
            topLevelFrame = data;
          topLevelWindows.Append(data);

          // Add menu bar
          int menuBarId = 0;
          expr->AssignAttributeValue("menu_bar", &menuBarId);
          PrologExpr *menuExpr = database.HashFind("menu_item", menuBarId);
          if (menuExpr)
          {
            BuildMenuItem *menuBar = (BuildMenuItem *)menuExpr->GetClientData();
            if (menuBar)
            {
              delete data->buildMenuBar;
              data->buildMenuBar = menuBar;
            }
          }

          // Add toolbar
          int toolBarId = 0;
          expr->AssignAttributeValue("tool_bar", &toolBarId);
          PrologExpr *toolbarExpr = database.HashFind("window", toolBarId);
          if (toolbarExpr)
          {
            BuildToolbarData *toolBar = (BuildToolbarData *)toolbarExpr->GetClientData();
            if (toolBar)
            {
              data->toolbar = toolBar;
              toolBar->buildParent = data;
            }
          }
          break;
        }
        case wxTYPE_DIALOG_BOX:
        {
          BuildDialogBoxData *data = new BuildDialogBoxData(NULL);
          expr->SetClientData(data);
          
          data->ReadPrologAttributes(expr, &database);
          data->ReadActions(expr, &database);

          topLevelWindows.Append(data);

          break;
        }
        case wxTYPE_PANEL:
        {
          BuildFrameData *parentFrame = NULL;
          PrologExpr *parentExpr = database.HashFind("window", parentId);
          if (parentExpr)
            parentFrame = (BuildFrameData *)parentExpr->GetClientData();

          if (!parentFrame)
          {
            wxMessageBox("Subwindow has no parent frame!", "Error");
            break;
          }

          BuildPanelData *data = new BuildPanelData(parentFrame);
          expr->SetClientData(data);

          data->ReadPrologAttributes(expr, &database);
          data->ReadActions(expr, &database);

          break;
        }
        case wxTYPE_CANVAS:
        {
          BuildFrameData *parentFrame = NULL;
          PrologExpr *parentExpr = database.HashFind("window", parentId);
          if (parentExpr)
            parentFrame = (BuildFrameData *)parentExpr->GetClientData();

          if (!parentFrame)
          {
            wxMessageBox("Subwindow has no parent frame!", "Error");
            break;
          }

          BuildCanvasData *data = new BuildCanvasData(parentFrame);
          expr->SetClientData(data);

          data->ReadPrologAttributes(expr, &database);
          data->ReadActions(expr, &database);

          break;
        }
        case wxTYPE_TEXT_WINDOW:
        {
          BuildFrameData *parentFrame = NULL;
          PrologExpr *parentExpr = database.HashFind("window", parentId);
          if (parentExpr)
            parentFrame = (BuildFrameData *)parentExpr->GetClientData();

          if (!parentFrame)
          {
            wxMessageBox("Subwindow has no parent frame!", "Error");
            break;
          }

          BuildTextWindowData *data = new BuildTextWindowData(parentFrame);
          expr->SetClientData(data);

          data->ReadPrologAttributes(expr, &database);
          data->ReadActions(expr, &database);

          break;
        }
        case wxTYPE_BUTTON:
        {
          BuildPanelData *parentPanel = NULL;
          PrologExpr *parentExpr = database.HashFind("window", parentId);
          if (parentExpr)
            parentPanel = (BuildPanelData *)parentExpr->GetClientData();

          if (!parentPanel)
          {
            wxMessageBox("Panel item has no parent panel!", "Error");
            break;
          }

          BuildButtonData *data = new BuildButtonData(parentPanel);
          expr->SetClientData(data);

          data->ReadPrologAttributes(expr, &database);
          data->ReadActions(expr, &database);
          break;
        }
        case wxTYPE_CHECK_BOX:
        {
          BuildPanelData *parentPanel = NULL;
          PrologExpr *parentExpr = database.HashFind("window", parentId);
          if (parentExpr)
            parentPanel = (BuildPanelData *)parentExpr->GetClientData();

          if (!parentPanel)
          {
            wxMessageBox("Panel item has no parent panel!", "Error");
            break;
          }

          BuildCheckBoxData *data = new BuildCheckBoxData(parentPanel);
          expr->SetClientData(data);

          data->ReadPrologAttributes(expr, &database);
          data->ReadActions(expr, &database);
          break;
        }
        case wxTYPE_MESSAGE:
        {
          BuildPanelData *parentPanel = NULL;
          PrologExpr *parentExpr = database.HashFind("window", parentId);
          if (parentExpr)
            parentPanel = (BuildPanelData *)parentExpr->GetClientData();

          if (!parentPanel)
          {
            wxMessageBox("Panel item has no parent panel!", "Error");
            break;
          }

          BuildMessageData *data = new BuildMessageData(parentPanel);
          expr->SetClientData(data);

          data->ReadPrologAttributes(expr, &database);
          data->ReadActions(expr, &database);
          break;
        }
        case wxTYPE_TEXT:
        {
          BuildPanelData *parentPanel = NULL;
          PrologExpr *parentExpr = database.HashFind("window", parentId);
          if (parentExpr)
            parentPanel = (BuildPanelData *)parentExpr->GetClientData();

          if (!parentPanel)
          {
            wxMessageBox("Panel item has no parent panel!", "Error");
            break;
          }

          BuildTextData *data = new BuildTextData(parentPanel);
          expr->SetClientData(data);

          data->ReadPrologAttributes(expr, &database);
          data->ReadActions(expr, &database);
          break;
        }
        case wxTYPE_MULTI_TEXT:
        {
          BuildPanelData *parentPanel = NULL;
          PrologExpr *parentExpr = database.HashFind("window", parentId);
          if (parentExpr)
            parentPanel = (BuildPanelData *)parentExpr->GetClientData();

          if (!parentPanel)
          {
            wxMessageBox("Panel item has no parent panel!", "Error");
            break;
          }

          BuildMultiTextData *data = new BuildMultiTextData(parentPanel);
          expr->SetClientData(data);

          data->ReadPrologAttributes(expr, &database);
          data->ReadActions(expr, &database);
          break;
        }
        case wxTYPE_LIST_BOX:
        {
          BuildPanelData *parentPanel = NULL;
          PrologExpr *parentExpr = database.HashFind("window", parentId);
          if (parentExpr)
            parentPanel = (BuildPanelData *)parentExpr->GetClientData();

          if (!parentPanel)
          {
            wxMessageBox("Panel item has no parent panel!", "Error");
            break;
          }

          BuildListBoxData *data = new BuildListBoxData(parentPanel);
          expr->SetClientData(data);

          data->ReadPrologAttributes(expr, &database);
          data->ReadActions(expr, &database);
          break;
        }
        case wxTYPE_RADIO_BOX:
        {
          BuildPanelData *parentPanel = NULL;
          PrologExpr *parentExpr = database.HashFind("window", parentId);
          if (parentExpr)
            parentPanel = (BuildPanelData *)parentExpr->GetClientData();

          if (!parentPanel)
          {
            wxMessageBox("Panel item has no parent panel!", "Error");
            break;
          }

          BuildRadioBoxData *data = new BuildRadioBoxData(parentPanel);
          expr->SetClientData(data);

          data->ReadPrologAttributes(expr, &database);
          data->ReadActions(expr, &database);
          break;
        }
        case wxTYPE_TOOLBAR:
        {
          // Parent will be assigned later
          BuildToolbarData *data = new BuildToolbarData(NULL, FALSE);
          expr->SetClientData(data);

          data->ReadPrologAttributes(expr, &database);
          data->ReadActions(expr, &database);
          break;
        }
        case wxTYPE_CHOICE:
        {
          BuildPanelData *parentPanel = NULL;
          PrologExpr *parentExpr = database.HashFind("window", parentId);
          if (parentExpr)
            parentPanel = (BuildPanelData *)parentExpr->GetClientData();

          if (!parentPanel)
          {
            wxMessageBox("Panel item has no parent panel!", "Error");
            break;
          }

          BuildChoiceData *data = new BuildChoiceData(parentPanel);
          expr->SetClientData(data);

          data->ReadPrologAttributes(expr, &database);
          data->ReadActions(expr, &database);
          break;
        }
        default:
        {
          wxMessageBox("Unrecognised window type.", "Error");
          break;
        }
      }
      expr = database.FindClauseByFunctor("window");
    }
    ResolveActionReferences(&database);
    TheFontManager.ReadFonts(&database);
    char buf[300];
    sprintf(buf, "wxBuilder [%s]", FileNameFromPath(projectFilename));
    MainFrame->SetTitle(buf);
    UpdateWindowList(topLevelFrame);
  }
  else return FALSE;
  return TRUE;
}

void BuildApp::ResolveActionReferences(PrologDatabase *database)
{
  // Find all the windows
  database->BeginFind();
  PrologExpr *expr = database->FindClauseByFunctor("window");
  while (expr)
  {
    BuildWindowData *win = (BuildWindowData *)expr->GetClientData();
    if (win)
    {
      wxNode *node = win->buildActions.First();
      while (node)
      {
        BuildAction *action = (BuildAction *)node->Data();
        if (action->actionWindowId > -1)
        {
          PrologExpr *winExpr = database->HashFind("window", action->actionWindowId);
          if (winExpr)
            action->actionWindow = (BuildWindowData *)winExpr->GetClientData();
        }
        node = node->Next();
      }
    }
    expr = database->FindClauseByFunctor("window");
  }
}

Bool BuildApp::ClearProject(void)
{
  MakeModified(FALSE);
  wxNode *node = topLevelWindows.First();
  while (node)
  {
    BuildWindowData *data = (BuildWindowData *)node->Data();
    DeleteWindow(data);
    node = topLevelWindows.First();
  }
  ClearTree();
  MainFrame->SetTitle("wxBuilder [unnamed]");
  return TRUE;
}

Bool BuildApp::Modified(void)
{
  if (topLevelFrame || (topLevelWindows.Number() > 0))
    return TRUE;
  else
    return FALSE;
}

// Format panel items
Bool BuildApp::FormatItems(int formatTool)
{
  if (BuildSelections.Number() == 0)
  {
    wxMessageBox("Please select panel items to format", "Warning");
    return FALSE;
  }
  // Ensure all panel items have the same parent
  BuildWindowData *parent = NULL;
  wxNode *node = BuildSelections.First();
  while (node)
  {
    BuildWindowData *data = (BuildWindowData *)node->Data();
    if (!parent)
      parent = data->buildParent;
    if ((!data->buildParent) ||
        (!wxSubType(data->buildParent->windowType, wxTYPE_PANEL)) ||
        (data->buildParent != parent))
    {
      wxMessageBox("Selections must be panel items and have same parent.", "Error");
      return FALSE;
    }
    node = node->Next();
  }

  BuildWindowData *first = GetFirstSelection();
  int firstX, firstY;
  int firstW, firstH;
  first->userWindow->GetPosition(&firstX, &firstY);
  first->userWindow->GetSize(&firstW, &firstH);
  int centreX = (int)(firstX + (firstW / 2));
  int centreY = (int)(firstY + (firstH / 2));

  node = BuildSelections.First();
  while (node)
  {
    BuildWindowData *win = (BuildWindowData *)node->Data();
    wxNode *next = node->Next();
    if (win->userWindow && (win != first))
    {
      int x, y, w, h;
      win->userWindow->GetPosition(&x, &y);
      win->userWindow->GetSize(&w, &h);

      int newX, newY;

      switch (formatTool)
      {
        case TOOLBAR_FORMAT_HORIZ:
        {
          newX = x;
          newY = (int)(centreY - (h/2.0));
          break;
        }
        case TOOLBAR_FORMAT_VERT:
        {
          newX = (int)(centreX - (w/2.0));
          newY = y;
          break;
        }
        case TOOLBAR_FORMAT_HORIZ_LEFT_ALIGN:
        {
          newX = firstX;
          newY = y;
          break;
        }
        case TOOLBAR_FORMAT_VERT_TOP_ALIGN:
        {
          newX = x;
          newY = firstY;
          break;
        }
        case TOOLBAR_FORMAT_HORIZ_RIGHT_ALIGN:
        {
          newX = firstX + firstW - w;
          newY = y;
          break;
        }
        case TOOLBAR_FORMAT_VERT_BOT_ALIGN:
        {
          newX = x;
          newY = firstY + firstH - h;
          break;
        }
        default:
          newX = x; newY = y;
          break;
      }

      win->userWindow->SetSize(newX, newY, -1, -1);
      win->PositionWindowObject();
    }
    win->windowObject->Select(FALSE);
    node = next;
  }
  MainFrame->canvas->Redraw();

  return TRUE;
}

void BuildApp::AssociateObjectWithEditor(BuildWindowData *bwin)
{
  if (MainFrame->currentWindow == bwin)
    return;
  MainFrame->ClearEditor();
  MainFrame->currentWindow = bwin;
  bwin->AddWindowObject(MainFrame->canvas, TRUE);
}

void BuildApp::DisassociateObjectWithEditor(BuildWindowData *bwin)
{
  if (!MainFrame)
    return;
    
  if (MainFrame->currentWindow != bwin)
    return;

  DeselectAll();
  
  MainFrame->ClearEditor();
  MainFrame->currentWindow = NULL;
}

Bool BuildApp::ShowObjectEditor(BuildWindowData *bwin)
{
  if (!bwin->userWindow)
    bwin->MakeRealWindow();
  if (!bwin->userWindow)
    return FALSE;
  
  if (MainFrame)
  {
    AssociateObjectWithEditor(bwin);
    MainFrame->Show(TRUE);
    EditorPaletteFrame->Show(TRUE);
    bwin->userWindow->Show(TRUE);
  }
  return TRUE;
}

void BuildApp::UpdateWindowList(BuildWindowData *bwin)
{
  MainFrame->buildWindowsItem->Clear();
  wxNode *node = topLevelWindows.First();
  while (node)
  {
    BuildWindowData *win = (BuildWindowData *)node->Data();
    MainFrame->buildWindowsItem->Append(win->name, (char *)win);
    node = node->Next();
  }
  if (bwin)
  {
    int sel = MainFrame->buildWindowsItem->FindString(bwin->name);
    if (sel > -1)
      MainFrame->buildWindowsItem->SetSelection(sel);
  }
}

BuildWindowData *BuildApp::FindCurrentWindow(void)
{
  int sel = MainFrame->buildWindowsItem->GetSelection();
  if (sel > -1)
  {
    BuildWindowData *win = (BuildWindowData *)MainFrame->buildWindowsItem->GetClientData(sel);
    return win;
  }
  else return NULL;
}

// Delete an arbitrary window object
Bool BuildApp::DeleteWindow(BuildWindowData *window)
{
  if (window == topLevelFrame)
    topLevelFrame = NULL;

  if (MainFrame && (MainFrame->currentWindow == window))
  {
    MainFrame->canvas->Clear();
  }

  window->DestroyRealWindow();
  topLevelWindows.DeleteObject(window);
  delete window;

  UpdateWindowList();
  MakeModified();

  return TRUE;
}


