/*
 * File:	bgdi.cc
 * Purpose:	wxWindows GUI builder
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include "wx.h"
#include "wx_help.h"
#include "wx_types.h"
#include <ctype.h>
#include <stdlib.h>

#include "wxbuild.h"
#include "namegen.h"
#include "bapp.h"
#include "bframe.h"
#include "bmenu.h"
#include "bsubwin.h"
#include "bitem.h"
#include "btoolbar.h"
#include "bgdi.h"

FontManager TheFontManager;

BuildFontData::BuildFontData(void)
{
  fontName = NULL;
  fontFamily = copystring("Swiss");
  fontStyle = copystring("Normal");
  fontWeight = copystring("Normal");
  fontSize = 10;
  font = NULL;
}

BuildFontData::~BuildFontData(void)
{
  if (fontName) delete[] fontName;
  delete[] fontFamily;
  delete[] fontStyle;
  delete[] fontWeight;
}

wxFont *BuildFontData::CreateFont(void)
{
  if (font)
    return font;
    
  int familyInt = wxDEFAULT;
  if (strcmp(fontFamily, "Roman") == 0)
    familyInt = wxROMAN;
  else if (strcmp(fontFamily, "Decorative") == 0)
    familyInt = wxDECORATIVE;
  else if (strcmp(fontFamily, "Modern") == 0)
    familyInt = wxMODERN;
  else if (strcmp(fontFamily, "Script") == 0)
    familyInt = wxSCRIPT;
  else familyInt = wxSWISS;

  int styleInt = wxNORMAL;
  if (strcmp(fontStyle, "Italic") == 0)
    styleInt = wxITALIC;
  else if (strcmp(fontStyle, "Slant") == 0)
    styleInt = wxSLANT;
  else if (strcmp(fontStyle, "Normal") == 0)
    styleInt = wxNORMAL;

  int weightInt = wxNORMAL;
  if (strcmp(fontWeight, "Light") == 0)
    styleInt = wxLIGHT;
  else if (strcmp(fontWeight, "Bold") == 0)
    styleInt = wxBOLD;
  else if (strcmp(fontWeight, "Normal") == 0)
    styleInt = wxNORMAL;

  font = wxTheFontList->FindOrCreateFont(fontSize, familyInt, styleInt, weightInt);
  return font;
}

Bool BuildFontData::Edit(void)
{
  char nameBuf[200];
  sprintf(nameBuf, "Editing Font");
  wxDialogBox *dialog = new wxDialogBox(NULL, nameBuf, TRUE, 10, 10);
  dialog->SetLabelFont(SmallLabelFont);
  dialog->SetButtonFont(SmallButtonFont);

  BuildForm *form = new BuildForm;
  form->dialog = dialog;

  form->Add(wxMakeFormString("Font name", &fontName, wxFORM_DEFAULT, NULL, NULL,
             wxVERTICAL, 180));

  form->Add(wxMakeFormNewLine());

  form->Add(wxMakeFormShort("Point size", &fontSize,
            wxFORM_DEFAULT, NULL, NULL, wxVERTICAL, 180));

  form->Add(wxMakeFormString("Font family", &fontFamily, wxFORM_CHOICE,
            new wxList(wxMakeConstraintStrings(
  "Roman"            ,
  "Decorative"       ,
  "Modern"           ,
  "Swiss"            ,
  "Script"           ,
  NULL),
  NULL), NULL, wxVERTICAL, 180));

  form->Add(wxMakeFormNewLine());

  form->Add(wxMakeFormString("Font style", &fontStyle, wxFORM_CHOICE,
            new wxList(wxMakeConstraintStrings(
  "Italic"      ,
  "Slant"       ,
  "Normal"      ,
  NULL),
  NULL), NULL, wxVERTICAL, 180));

  form->Add(wxMakeFormString("Font weight", &fontWeight, wxFORM_CHOICE,
            new wxList(wxMakeConstraintStrings(
  "Light"      ,
  "Bold"       ,
  "Normal"     ,
  NULL),
  NULL), NULL, wxVERTICAL, 180));
  
  form->AssociatePanel(dialog);

  dialog->Fit();
  dialog->Centre(wxBOTH);

  dialog->Show(TRUE);
  font = NULL;
  return TRUE;
}

/*
 * Font manager
 *
 */

FontManager::FontManager(void)
{
  dialog = NULL;
}

FontManager::~FontManager(void)
{
}

void FontManager::Show(Bool show)
{
  if (show)
  {
    if (dialog) dialog->Show(TRUE);
    else
    {
      dialog = new FontManagerDialog(NULL, "wxBuilder Font Manager", 100, 100, 400, 400);
      dialog->SetLabelFont(SmallLabelFont);
      dialog->SetButtonFont(SmallButtonFont);
      dialog->SetLabelPosition(wxVERTICAL);
      (void)new wxButton(dialog, (wxFunction)FontOkProc, "Ok");
      (void)new wxButton(dialog, (wxFunction)FontHelpProc, "Help");
      dialog->NewLine();
      dialog->listbox = new wxListBox(dialog, (wxFunction)FontManagerProc,
              "Fonts", wxSINGLE, -1, -1, 300, 200);
      dialog->NewLine();
      (void)new wxButton(dialog, (wxFunction)AddFontProc, "Add font");
      (void)new wxButton(dialog, (wxFunction)DeleteFontProc, "Delete font");

      wxNode *node = First();
      while (node)
      {
        BuildFontData *data = (BuildFontData *)node->Data();
        dialog->listbox->Append(data->fontName, (char *)data);
        node = node->Next();
      }
      
      dialog->Fit();
      dialog->Show(TRUE);
    }
  }
  else
  {
    if (dialog)
    {
      dialog->Show(FALSE);
      delete dialog;
    }
    dialog = NULL;
  }
}

void FontManager::ReadFonts(PrologDatabase *database)
{
  wxNode *node = First();
  while (node)
  {
    BuildFontData *data = (BuildFontData *)node->Data();
    delete data;
    node = node->Next();
  }
  Clear();
  
  database->BeginFind();
  PrologExpr *clause = database->FindClauseByFunctor("fonts");
  if (!clause)
    return;
  int i = 1;
  
  char nameBuf[20];

  PrologExpr *fontExpr = NULL;
  sprintf(nameBuf, "font%d", i);

  while (fontExpr = clause->AttributeValue(nameBuf))
  {
    PrologExpr *nameExpr = fontExpr->Nth(0);
    PrologExpr *familyExpr = fontExpr->Nth(1);
    PrologExpr *styleExpr = fontExpr->Nth(2);
    PrologExpr *weightExpr = fontExpr->Nth(3);
    PrologExpr *sizeExpr = fontExpr->Nth(4);

    BuildFontData *data = new BuildFontData;
    data->fontName = copystring(nameExpr->StringValue());
    delete[] data->fontFamily;
    delete[] data->fontStyle;
    delete[] data->fontWeight;
    data->fontFamily = copystring(familyExpr->StringValue());
    data->fontWeight = copystring(weightExpr->StringValue());
    data->fontStyle = copystring(styleExpr->StringValue());
    data->fontSize = (int)sizeExpr->IntegerValue();
    Append(data->fontName, data);
    i ++;
    sprintf(nameBuf, "font%d", i);
  }
}

void FontManager::WriteFonts(PrologDatabase *database)
{
  PrologExpr *clause = new PrologExpr("fonts");
  wxNode *node = First();
  int i = 1;
  char buf[30];
  while (node)
  {
    BuildFontData *data = (BuildFontData *)node->Data();
    sprintf(buf, "font%d", i);
    PrologExpr *expr = new PrologExpr(PrologList);
    expr->Append(new PrologExpr(PrologString, data->fontName));
    expr->Append(new PrologExpr(PrologString, data->fontFamily));
    expr->Append(new PrologExpr(PrologString, data->fontStyle));
    expr->Append(new PrologExpr(PrologString, data->fontWeight));
    expr->Append(new PrologExpr((long)data->fontSize));
    clause->AddAttributeValue(buf, expr);
    node = node->Next();
    i ++;
  }
  database->Append(clause);
}

FontManagerDialog::FontManagerDialog(wxFrame *frame, char *title, int x, int y, int w, int h):
  wxDialogBox(frame, title, FALSE, x, y, w, h)
{
  listbox = NULL;
}

void FontManagerProc(wxListBox& lbox, wxCommandEvent& event)
{
  int sel = lbox.GetSelection();
  if (sel > -1)
  {
    BuildFontData *data = (BuildFontData *)lbox.GetClientData(sel);
    data->Edit();
  }
}

void FontOkProc(wxButton& but, wxCommandEvent& event)
{
  FontManagerDialog *dialog = (FontManagerDialog *)but.GetParent();
  dialog->Show(FALSE);
  delete dialog;
  TheFontManager.dialog = NULL;
}

void FontHelpProc(wxButton& but, wxCommandEvent& event)
{
  HelpInstance->LoadFile();
  HelpInstance->KeywordSearch("Managing GDI objects");
}

void AddFontProc(wxButton& but, wxCommandEvent& event)
{
  BuildFontData *data = new BuildFontData;
  data->Edit();
  TheFontManager.Append(data->fontName, data);
  TheFontManager.dialog->listbox->Append(data->fontName, (char *)data);
}

void DeleteFontProc(wxButton& but, wxCommandEvent& event)
{
  int sel = TheFontManager.dialog->listbox->GetSelection();
  if (sel > -1)
  {
    BuildFontData *data = (BuildFontData *)TheFontManager.dialog->listbox->GetClientData(sel);
    TheFontManager.DeleteObject(data);
    TheFontManager.dialog->listbox->Delete(sel);
    delete data;
  }
}

wxFont *FindFont(char *fontName)
{
  wxNode *node = TheFontManager.Find(fontName);
  if (node)
  {
    BuildFontData *data = (BuildFontData *)node->Data();
    return data->CreateFont();
  }
  return NULL;
}

