/* ***********************************************************************
 * *******   RCPARSER.CC: Part of the rcParser library for wxWin toolkit *
 * *******   se at RCOBJECT.CC beginning for more information
 * ********************************************************************** */


#include   <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include <wx_hash.h>
#include <wx_list.h>
#include <wx_utils.h>
#include <wb_main.h>

#include  "..\include\rcparser.h"


// ********************* CLASS Condition **************************************

int Condition::Push( int fValue)
{
  if(N < 10)
  {
    fLevels[N] = (fValue != 0);
    ++N;
    return 1;
  }
  else
    return 0;
}

int Condition::Pop( void)
{
  if(N > 0)
  {
    --N;
    return 1;
  }
  else
    return 0;
}

int Condition::Invert( void)
{
  if(N > 0)
  {
    fLevels[N - 1] = ! fLevels[N - 1];
    return 1;
  }
  return 0;
}

int Condition::Set( void)
{ 
  for( int i = 0 ; i < N ; ++i)
    if(fLevels[i] == 0)
      return 0;
  return 1;
}

// **************** END OF CLASS Condition DEFINITIONS ****************************

// ***************** ParsedFile CLASS DEFINITION OF MEMBERS ***********************


PTR_MESSAGE_FUNC  pmfWarning = 0,
                  pmfError   = 0;


ParsedFile::ParsedFile( FILE *f, char *szFileName, int nMaxLineLength)
{
  len  = nMaxLineLength;
  s    = new char [len + 1];
  F    = f;
  s[0] = '\0';

  name = new char[strlen( szFileName) + 1];
  strcpy( name, szFileName);
  NL   = 0;
}

ParsedFile::~ParsedFile()
{
  if(s != 0)
    delete []s;
}

int  ParsedFile::ReadNextLine( void)
{
  if( (pmfWarning == 0) || (pmfError == 0))
  { // default values!
    pmfWarning = wxError;
    pmfError   = wxFatalError;
  }

  if( fgets( s, len, F) == 0)
    return (ferror( F) ? -1 : 0);
  else
  { int i;

    ++NL;                       // increase Number of Lines read
    if( strtok( s, "\n") == 0)  // most quick way to strip trailing new line...
      if( (strlen( s) == 1) && (s[0] == '\n')) // we must do this manually
        strcpy( s, " ");                       // se bellow!
    if( (i = strlen( s)) == 0) // we cannot allow this, as this signals EOF 8>(
    {
      strcpy( s, " ");         // oh, stupidity is your name...
      ++i;
    }
    return i;
  }
}

int  IsEND( char *s)
{ char *szBuf = new char[strlen( s) + 1];

  strcpy( szBuf, s);

  char *str = strtok( szBuf, " \t\n");

  if(str != 0)
    if( (stricmp( str, "END") == 0) || (stricmp( str, "}") == 0))
    {
      delete[] szBuf;
      return 1;
    }
  delete []szBuf;
  return 0;
}


int ParsedFile::SkipUntilEND( int FirstBeginRead)
// skips to the end of the block(inclusive). Understands nested BEGIN - END pairs!
// PLAY RULES: we enter this with COMPLETE nested block, i.e. including the
//             starting BEGIN / "{"!
{ int   nLevel = 1;             // entering with the level of 1 ...

  if( !FirstBeginRead)
  {
    while( ReadNextLine() > 0)  // read lines until...
      if( IsBEGIN())            // ... we find the starting BEGIN mark
        break;
    if( !IsBEGIN())
      return 0;
  }
  do
  {
    if( ReadNextLine() <= 0)
      return 0;
    if( !StripOutComments())
      return 0;
    if( IsBEGIN())
      ++nLevel;
    else if( IsEND( s))
      --nLevel;
  } while(nLevel > 0);
  return 1;
}

static char *Xstrchr( const char *s, int c)
{ char  *ptr;
  int    i,
         len = strlen( s),
         fIn = 0;

  for( i = 0, ptr = (char *)s ; i < len ; ++i, ++ptr)
    if(*ptr == '\"')  // start of string specification, where 'c' occurrence is ignored
      fIn = !fIn;     // check if unchecked and vice versa
    else if(*ptr == c)
      if(!fIn)
        return ptr;
  return 0;
}

int  ParsedFile::StripOutComments( void)
{ char *ptr;
  int   fOpened = 0;

  // the order is important: first we check for usual C -style comment...
  if( (ptr = Xstrchr( s, '/')) != 0)
  {
    if(ptr[1] == '*')  // we got it
    {
      if( strstr( ptr + 2, "*/") == 0)
        fOpened = 1;
      *ptr = 0;
    }
  }

  if( (ptr = Xstrchr( s, ';')) != 0)  // if anywhere except in label specification...
    *ptr = 0;
  if( (ptr = Xstrchr( s, '/')) != 0)
  {
    if(ptr[1] == '/')   // so we get the "//" sequence!
      *ptr = 0;
  }
  // so, now:
  if( fOpened)
    return 3;
  if( strlen( s) == 0)
    return 2;
 else
    return 1;
  // hmm, seems we cannot get error return value (0)!
}

int ParsedFile::HasClosingComment( void)
{
  return( strstr( s, "*/") != 0);
}

int ParsedFile::IsPreprocessor( void)
{ char *ptr = s;

  while( (*ptr == ' ') || (*ptr == '\t'))
    ++ptr;
  return (*ptr == '#');
}

int ParsedFile::IsBEGIN( void)
{ char *szBuf = new char[len + 1],
       *ptr;

  strcpy( szBuf, s);
  ptr = strtok( szBuf, " \t");
  if(ptr != 0)
    if( stricmp( ptr, "BEGIN") == 0)
    {
      delete []szBuf;
      return 1;
    }
    else if( strcmp( ptr, "{") == 0)
    {
      delete []szBuf;
      return 1;
    }
  delete []szBuf;
  return 0;
}

int ParsedFile::IsRCInclude( void)
{ char *szBuf = new char[len + 1],
       *ptr;

  strcpy( szBuf, s);
  ptr = strtok( szBuf, " \t");
  if(ptr != 0)
    if( stricmp( ptr, "rcinclude") == 0)
      if( strtok( 0, " \t\n") != 0)  // and something after that, too ;-)
      {
        delete []szBuf;
        return 1;
      }
      else
        ;     // this is a syntax error, so what about reporting it?
  delete []szBuf;
  return 0;
}

char *ParsedFile::GetTheString( void)
{
  return s;
}

void ParsedFile::Warning( char *szWhere, char *szWhat)
{ char *szBuf = new char[ strlen( szWhere) + strlen( szWhat) + 128];

  if(szBuf == 0)
    return;
  sprintf( szBuf, "File '%s'%c Line %i\n%s:%c '%s'",
                  name, (strlen( name)>40) ? '\n' : ' ', NL,
                  szWhere, (strlen( szWhat)>40) ? '\n' : ' ', szWhat);
  pmfWarning( szBuf, "rcParser Library Warning");
  delete []szBuf;
  return;
}

void ParsedFile::Error( char *szWhere, char *szWhat)
{ char *szBuf = new char[ strlen( szWhere) + strlen( szWhat) + 128];

  if(szBuf == 0)
    wxExit();
  sprintf( szBuf, "File '%s'%c Line %i\n%s:%c '%s'",
                  name, (strlen( name)>40) ? '\n' : ' ', NL,
                  szWhere, (strlen( szWhat)>40) ? '\n' : ' ', szWhat);
  pmfError( szBuf, "rcParser Library Error");
  delete []szBuf;
  return;
}


// ************ END OF ParsedFile CLASS DEFINITIONS *************************


// *********************** CLASS ParsedString DEFINITIONS *********************

ParsedString::ParsedString( char *str, char *separators)
{ char   *ptr;

  szBuf = new char[strlen( str) + 1];
  N     = 0;
  if(szBuf == 0)
    return;
  strcpy( szBuf, str);
  ptr = strtok( szBuf, separators);
  while(ptr != 0)
  {
    wxlSegments.Append( (wxObject *)ptr);
    ++N;
    ptr = strtok( 0, separators);
  }
}

ParsedString::~ParsedString()
{
  wxlSegments.Clear();
  if(szBuf != 0)
    delete []szBuf;
}

char * ParsedString::GetSegment( int i)
{
  if((i < 0) || (i >= N) || (szBuf == 0))
    return 0;
  return (char *) ((wxlSegments.Nth( i))->Data());
}

// ***************************************************************************************

