SIGN		[+-]
DIGIT		[0-9]
ALPHA		[a-zA-Z_]
ALPHADIGIT	[a-zA-Z_0-9]
STRINGCHAR	[^"\\]
WORDCHAR	[^'\\]

%{
#include <string.h>
#ifdef wx_x
extern char *malloc();
#endif
#define Return(x) return x;

int lex_buffer_length = 0;
char *lex_buffer = NULL;
int lex_string_ptr = 0;
int lex_read_from_string = 0;

#undef input
#undef unput
/* #undef output */

void LexFromFile(fd)
FILE *fd;
{
  lex_read_from_string = 0;
  yyin = fd;
}

void LexFromString(buffer)
char *buffer;
{
  lex_read_from_string = 1;
  lex_buffer = buffer;
  lex_buffer_length = strlen(buffer);
  lex_string_ptr = 0;
}

char input()
{
  if (lex_read_from_string)
  {
    if (lex_string_ptr == lex_buffer_length)
      return 0;
    else
    {
      char c = lex_buffer[lex_string_ptr];
      lex_string_ptr ++;
      if (c == 10)
        yylineno ++;
      return c;
    }
  }
  else
  {
    return (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar);
  }
}



unput(c)
char c;
{
  if (lex_read_from_string)
  {
    if (c == 10)
      yylineno --;
    lex_string_ptr --;
  }
  else
  {
    yytchar= (c);
    if(yytchar=='\n') yylineno--;
    *yysptr++=yytchar;
  }
}

%}

%%

{SIGN}?{DIGIT}+			  {yylval.s = strdup(yytext); Return(INTEGER);}

{ALPHA}{ALPHADIGIT}*		  {yylval.s = strdup(yytext); Return(WORD);}

"'"{WORDCHAR}*"'"	          {int len = strlen(yytext);
                                   yytext[len-1] = 0;
                                   yylval.s = strdup(yytext+1); 
                                   Return(WORD);}

\"({STRINGCHAR}|\\\"|\|\\\\|\\)*\"  {yylval.s = strdup(yytext); Return(STRING);}

"("				  Return(OPEN);

")"				  Return(CLOSE);

","				  Return(COMMA);

"["                               Return(OPEN_SQUARE);

"]"                               Return(CLOSE_SQUARE);

"="                               Return(EQUALS);

"."				  Return(PERIOD);

[ \t]				  ;

\n				  ;

"/*"    {       loop:
                          while (input() != '*');
                          switch (input())
                                  {
                                  case '/': break;
                                  case '*': unput('*');
                                  default: goto loop;
                                  }
                          }

.				  Return(ERROR);

