/*
 * File:	wx_timer.cc
 * Purpose:	wxTimer implementation (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include <time.h>
#include <sys/types.h>
#ifdef __sgi
#include <sys/time.h>
#else
#include <sys/timeb.h>
#endif
#include "wx_timer.h"
#include "wx_list.h"
#include "wx_main.h"
#include "wx_frame.h"
#include "wx_utils.h"

#ifdef wx_motif
#include <Xm/Xm.h>
#endif

// Can't find an include file with this in!!
extern "C" int ftime(struct timeb *);

#ifdef wx_motif
void wxTimerCallback(wxTimer *timer)
{
  if (timer->timerId==0)
    return ; // Avoid to process spurious timer events
  if (!timer->oneShot)
    timer->timerId = XtAppAddTimeOut(wxTheApp->appContext, timer->milli, 
                                     (XtTimerCallbackProc) wxTimerCallback, (XtPointer) timer);
  else
    timer->timerId = 0;
  timer->Notify();
}
#endif

#ifdef wx_xview
Notify_value wxTimerFunc(Notify_client client, int which);
#endif

wxTimer::wxTimer(void)
{
#ifdef wx_motif
  timerId = 0;
#endif
#ifdef wx_xview
  timerval.it_value.tv_usec = 0;
  timerval.it_interval.tv_usec = 0;
#endif
}

wxTimer::~wxTimer(void)
{
  Stop();
}

Bool wxTimer::Start(int milliseconds,Bool mode)
{
  oneShot = mode ;
  if (milliseconds < 0)
    milliseconds = lastMilli;

  if (milliseconds <= 0)
    return FALSE;

  lastMilli = milli = milliseconds;

#ifdef wx_motif
  timerId = XtAppAddTimeOut(wxTheApp->appContext, milliseconds,
                               (XtTimerCallbackProc) wxTimerCallback, (XtPointer) this);
  return TRUE;
#endif
#ifdef wx_xview
  if (milliseconds > -1)
  {
    long secs = (long)(milliseconds/1000);
    long usecs = (long)(milliseconds - 1000*secs)*1000;

    timerval.it_value.tv_sec = secs;
    timerval.it_interval.tv_sec = secs;

    timerval.it_value.tv_usec = usecs;
    timerval.it_interval.tv_usec = usecs;
  }

  notify_set_itimer_func((Notify_client)this, (Notify_func)wxTimerFunc, ITIMER_REAL,
                         &timerval, NULL);
  return TRUE;
#endif
}

void wxTimer::Stop(void)
{
#ifdef wx_motif
  if (timerId > 0)
  {
    XtRemoveTimeOut(timerId);
    timerId = 0;
  }
#endif
#ifdef wx_xview
  notify_set_itimer_func((Notify_client)this, NOTIFY_FUNC_NULL, ITIMER_REAL,
                         NULL, NULL);
#endif
  milli = 0 ;
}

#ifdef wx_xview
Notify_value wxTimerFunc(Notify_client client, int which)
{
  wxTimer *timer = (wxTimer *)client;
  if (timer->milli==0)
    return NOTIFY_DONE ; // Avoid to process spurious timer events
  timer->Notify();
  if (timer->oneShot)
    timer->Stop() ;
  return NOTIFY_DONE;
}
#endif

