/*
 * File:	wx_main.cc
 * Purpose:	wxApp implementation (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include <iostream.h>
#include <string.h>
#include <pwd.h>
#include <stdlib.h>

#include "common.h"
#include "wx_mgstr.h"
#include "wx_frame.h"
#include "wx_main.h"
#include "wx_utils.h"
#include "wx_gdi.h"
#include "wx_dc.h"
#include "wx_dialg.h"
#include "wx_privt.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

Colormap wxMainColormap = 0;
XrmDatabase wxResourceDatabase = 0;
extern void wxFlushResources(void); // Defined in wx_utils.cc

#ifdef wx_xview
#include <xview/cms.h>
extern Xv_Server xv_default_server;
#endif

#ifdef wx_motif
#include <Xm/Xm.h>
#include <X11/Shell.h>
wxHashTable *wxWidgetHashTable = NULL;
#endif

void wxCleanUp(void);

#ifdef wx_xview
Xv_Server xview_server;
#endif

#ifdef _LINUX_DLL
int __linux_dll_main(int argc, char *argv[])
#else
int main(int argc, char *argv[])
#endif
{
  if (!wxTheApp)
  {
    cerr << "wxWindows error: You have to define an instance of wxApp!\n";
    exit(0);
  }

  if (!wxTheApp->wx_class)
    wxTheApp->wx_class = copystring(argv[0]);

#ifdef wx_xview
  xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
  xview_server = xv_default_server;
#endif
#ifdef wx_motif
  XtToolkitInitialize() ;
  wxTheApp->appContext = XtCreateApplicationContext() ;
  Display *dpy = XtOpenDisplay(wxTheApp->appContext,(String)NULL,NULL,
                            wxTheApp->wx_class,NULL,
                            0,&argc,argv) ;
//                            0,(unsigned int *)&argc,argv) ;
  if (!dpy)
  {
    cerr << "wxWindows could not open display for " << wxTheApp->wx_class << ": exiting.\n";
    exit(-1);
  }
  wxTheApp->topLevel = XtAppCreateShell((String)NULL,wxTheApp->wx_class,
                                     applicationShellWidgetClass,dpy,
                                     NULL,0) ;

  // Add general resize proc
  XtActionsRec rec;
  rec.string = "resize";
  rec.proc = (XtActionProc)wxWidgetResizeProc;
  XtAppAddActions(wxTheApp->appContext, &rec, 1);
  wxWidgetHashTable = new wxHashTable(wxKEY_INTEGER);
#endif
  wxCommonInit();

#ifdef wx_motif
  Display *display = XtDisplay(wxTheApp->topLevel);
#endif
#ifdef wx_xview
  Xv_Screen screen = xv_get(xview_server, SERVER_NTH_SCREEN, 0);
  Xv_opaque root_window = xv_get(screen, XV_ROOT);
  Display *display = (Display *)xv_get(root_window, XV_DISPLAY);
#endif
//  wxMainColormap = DefaultColormap(display, DefaultScreen(display));
  wxMainColormap = DefaultColormapOfScreen(XScreenOfDisplay(display, DefaultScreen(display)));

  wxTheApp->argc = argc;
  wxTheApp->argv = argv;

  wxTheApp->wx_frame = wxTheApp->OnInit();

  // In XView, must ALWAYS have a main window.
  if (wxTheApp->wx_frame)
    wxTheApp->MainLoop();

  int retValue = wxTheApp->OnExit();
  wxCleanUp();
  return retValue;
}

// Cleans up any wxWindows internal structures left lying around
void wxCleanUp(void)
{
  wxCommonCleanUp();

#ifdef wx_xview
  delete wxFontPool;
#endif
  wxFlushResources();
}

wxApp::wxApp(int language):wxbApp(language)
{
  wx_frame = NULL;
  wxTheApp = this;
  death_processed = FALSE;
  work_proc = NULL ;
#ifdef wx_motif
  wx_class = NULL;
#endif
  wxSetLanguage(language);
}

wxApp::~wxApp(void)
{
}

Bool wxApp::Initialized(void)
{
  return (wx_frame != NULL);
}

/*
 * Keep trying to process messages until WM_QUIT
 * received
 */

int wxApp::MainLoop(void)
{
#ifdef wx_motif
//  XtRealizeWidget(wxTheApp->topLevel);
  if (work_proc)
    XtAppAddWorkProc(wxTheApp->appContext,(XtWorkProc)work_proc,(XtPointer)this) ;
  XtAppMainLoop(wxTheApp->appContext);
  return 0;
#endif
#ifdef wx_xview
  Frame frame = (Frame)(wx_frame->GetHandle());
  xv_main_loop(frame);
  return 0;
#endif
}

Bool wxApp::Pending(void)
{
#ifdef wx_motif
  XFlush(XtDisplay(wxTheApp->topLevel));
  return (XtAppPending(wxTheApp->appContext)) ;
#endif
#ifdef wx_xview
  return(FALSE) ; // Until I find what to do...
#endif
}

void wxApp::Dispatch(void)
{
#ifdef wx_motif
XEvent event;
  XtAppNextEvent(wxTheApp->appContext, &event);
  XtDispatchEvent(&event);
#endif
#ifdef wx_xview
  return ; // Until I found what to do...
#endif
}

void wxExit(void)
{
  int retValue = 0;
  if (wxTheApp)
    retValue = wxTheApp->OnExit();
  wxCleanUp();

  exit(retValue);
}

// Yield to incoming messages
Bool wxYield(void)
{
  return TRUE;
}

