/*
 * File:	wx_ipc.cc
 * Purpose:	Interprocess communication implementation (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include <iostream.h>
#include <stdio.h>
#include <math.h>
// #include <X11/Xfuncs.h> /* bzero, bcopy */

#ifdef __sgi
#include <bstring.h>
#endif
#ifdef __hpux
#include <strings.h>
#endif

#include "common.h"
#include "wx_setup.h"

#if USE_IPC

#include "wx_main.h"
#include "wx_frame.h"
#include "wx_utils.h"
#include "wx_ipc.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#ifdef        UNIX_ADDRESSING
#include <sys/un.h>
#endif
#include <netdb.h>

#define wxFAMILY(s) s.addr.sa_family
#ifdef        UNIX_ADDRESSING
#define wxNAMELEN(s) (wxFAMILY(s) == AF_INET \
		    ? sizeof(s.inaddr) \
		    : strlen(s.unaddr.sun_path) + sizeof(s.unaddr) - sizeof(s.unaddr.sun_path))
#else
#define wxNAMELEN(s) sizeof(s.inaddr)
#endif

extern errno;
int wx_socket_create(int port);
// Add NULL-terminated string to buffer, returning next start point
int wxAddString(int start, char *info, char *buffer, int size = -1);

// Get next NULL-terminated string from buffer
char *wxGetNextString(char *buffer);

extern Bool wxIPCInitialized;

#ifdef wx_xview
#include <xview/xview.h>
#include <xview/panel.h>
Notify_value wx_input_ready(Notify_client client, int fd);
Notify_value wx_accept_connection(Notify_client client, int fd);
#endif

#ifdef wx_motif
Bool wx_input_ready(XtPointer client, int *fid, XtInputId *id);
Bool wx_accept_connection(XtPointer client, int *fid, XtInputId *id);
#endif

/*
 * Initialization
 *
 */

void wxIPCInitialize(void)
{
  if (wxIPCInitialized)
    return;
  wxIPCInitialized = TRUE;
}

wxIPCObject::wxIPCObject(void)
{
  service_name = NULL;
}

wxIPCObject::~wxIPCObject(void)
{
}

/*
 * Server
 *
 */

wxServer::wxServer(void)
{
}

Bool wxServer::Create(char *server_name)
{
  service_name = copystring(server_name);

  // Under UNIX, server should be an integer inside a string!
  int the_port = 0;
  sscanf(server_name, "%d", &the_port);

  /* Create a socket listening on specified port */
  server_socket = wx_socket_create(the_port);
  if (server_socket < 0)
    return FALSE;

  Bool notify_toplevel = FALSE;
  wxConnection *toplevel = this->OnAcceptConnection("STDIO");
  if (toplevel)
  {
    toplevel->input_fd = 0;
    toplevel->output_fd = 1;
    notify_toplevel = TRUE;
    toplevel->topic_name = copystring("STDIO");
  }
  else toplevel = new wxConnection(NULL, 0); // Create a dummy connection

  toplevel->server = this;
  connections.Append(toplevel);

  /* Register stdin (IF APP ALLOWS IT) and the socket with the notifier */

#ifdef wx_xview
  // stdin
  if (notify_toplevel)
    notify_set_input_func((Notify_client)toplevel, (Notify_func)&wx_input_ready, 0);

  // Top level port
  notify_set_input_func((Notify_client)toplevel, (Notify_func)&wx_accept_connection, server_socket);
#endif
#ifdef wx_motif
  XtAppAddInput(wxTheApp->appContext, server_socket, (void*)XtInputReadMask, (XtInputCallbackProc) wx_accept_connection, (XtPointer)toplevel);
#endif
  return TRUE;
}

wxServer::~wxServer(void)
{
#ifdef wx_motif
#endif
#ifdef wx_xview
  close(server_socket);
#endif
}

/*
 * Client
 *
 */


wxClient::wxClient(void)
{
}

wxClient::~wxClient(void)
{
}

Bool wxClient::ValidHost(char *host)
{
  if (gethostbyname(host))
    return TRUE;
  else
    return FALSE;
}

wxConnection *wxClient::MakeConnection(char *host, char *server_name, char *topic)
{
    int port;
    sscanf(server_name, "%d", &port);

    union {struct sockaddr addr;
#ifdef        UNIX_ADDRESSING
	   struct sockaddr_un unaddr;
#endif
	   struct sockaddr_in inaddr;} s;

    struct hostent *server;

    int fd;

    bzero((caddr_t)&s.inaddr, sizeof(s.inaddr));
    server = gethostbyname(host);
    if(server == (struct hostent *)0)
    {
      perror("sockio: gethostbyname failed");
      return NULL;
    }
    bcopy((caddr_t)server->h_addr, (caddr_t)&s.inaddr.sin_addr, server->h_length);
    s.inaddr.sin_family = AF_INET;
    s.inaddr.sin_port = htons(port);

    fd = socket(wxFAMILY(s), SOCK_STREAM, 0);
    if(fd < 0)
    {
	perror("sockio: socket failed");
        return NULL;
    }

    if (connect(fd, &s.addr, wxNAMELEN(s)) == 0)
    {
      // Send topic name, and enquire whether this has succeeded
      char buf[200];
      buf[0] = wxCONNECT;
      strcpy(buf+1, topic);
      write(fd, buf, strlen(topic)+2);
      read(fd, buf, 200);
      // OK! Confirmation.
      if (buf[0] == wxCONNECT)
      {
        wxConnection *connection = OnMakeConnection();
        if (connection)
        {
          connections.Append(connection);
          connection->input_fd = fd;
          connection->output_fd = fd;
          connection->client = this;

          // Register with the notifier
          connection->Notify(TRUE);
          return connection;
        }
        else { close(fd); return NULL; }
      }
      else
      {
        close(fd);
        return NULL;
      }
    }
    else
    {
      close(fd);
      return NULL;
    }
/*
	if(errno == ENOENT)
	{
	    fprintf(stderr, "socket doesn't exist, retrying after 5 secs\n");
	    sleep(5);
	}
	else
	{
	    perror("sockio: connect failed");
	    exit(1);
	}
*/
}

/*
 * Connection
 */

wxConnection::wxConnection(char *buffer, int size):wxbConnection(buffer, size)
{
#ifdef wx_x
  input_fd = 0;
  output_fd = 0;
#endif
}

wxConnection::wxConnection(void)
{
#ifdef wx_x
  input_fd = 0;
  output_fd = 0;
#endif
#ifdef wx_motif
  xtInputId = 0;
#endif
}

wxConnection::~wxConnection(void)
{
#ifdef wx_motif
  if (xtInputId > 0)
   XtRemoveInput(xtInputId);
#endif
#ifdef wx_xview
  notify_set_input_func((Notify_client)this, (Notify_func)0, input_fd);
#endif
  if (input_fd != 0)
    close(input_fd);
  if (output_fd != 0)
    close(output_fd);

  if (server)
    server->connections.DeleteObject(this);
  if (client)
    client->connections.DeleteObject(this);
  if (topic_name)
    delete[] topic_name;
}

// Calls that CLIENT can make
Bool wxConnection::Disconnect(void)
{
  buf_ptr[0] = wxDISCONNECT;
  write(output_fd, buf_ptr, 1);
#ifdef wx_motif
  if (xtInputId)
    XtRemoveInput(xtInputId);
  xtInputId = 0;
#endif
#ifdef wx_xview
  notify_set_input_func((Notify_client)this, (Notify_func)0, input_fd);
#endif
  if (input_fd != 0)
    close(input_fd);
  if (output_fd != 0)
    close(output_fd);
  input_fd = 0;
  output_fd = 0;

  return TRUE;
}

Bool wxConnection::Execute(char *data, int size, int format)
{
  if (size < 0)
    size = strlen(data);

  char format_buf[10];
  sprintf(format_buf, "%d", format);

  buf_ptr[0] = wxEXECUTE;
  int pos = wxAddString(1, format_buf, buf_ptr);
  pos = wxAddString(pos, data, buf_ptr, size);

  write(output_fd, buf_ptr, pos);
  return TRUE;
}

char *wxConnection::Request(char *item, int *size, int format)
{
  char format_buf[10];
  sprintf(format_buf, "%d", format);

  buf_ptr[0] = wxREQUEST;
  int pos = wxAddString(1, item, buf_ptr);
  pos = wxAddString(pos, format_buf, buf_ptr);

#ifdef wx_xview
  Notify(FALSE);
#endif
  write(output_fd, buf_ptr, pos);
  read(input_fd, buf_ptr, buf_size);
#ifdef wx_xview
  Notify(TRUE);
#endif

  if (buf_ptr[0] == wxFAIL)
    return NULL;
  else
  {
    char *new_item = buf_ptr + 1;
    char *data = wxGetNextString(new_item);
    if (size) *size = data-new_item;
    return data;
  }
}

Bool wxConnection::Poke(char *item, char *data, int size, int format)
{
  char format_buf[10];
  sprintf(format_buf, "%d", format);

  if (size < 0)
    size = strlen(data);

  buf_ptr[0] = wxPOKE;
  int pos = wxAddString(1, item, buf_ptr);
  pos = wxAddString(pos, format_buf, buf_ptr);
  pos = wxAddString(pos, data, buf_ptr, size);

  write(output_fd, buf_ptr, pos);
  return TRUE;
}

Bool wxConnection::StartAdvise(char *item)
{
  buf_ptr[0] = wxADVISE_START;
  int pos = wxAddString(1, item, buf_ptr);

#ifdef wx_xview
  Notify(FALSE);
#endif

  write(output_fd, buf_ptr, pos);
  read(input_fd, buf_ptr, buf_size);

#ifdef wx_xview
  Notify(TRUE);
#endif

  if (buf_ptr[0] != wxFAIL)
    return TRUE;
  else
    return FALSE;
}

Bool wxConnection::StopAdvise(char *item)
{
  buf_ptr[0] = wxADVISE_STOP;
  int pos = wxAddString(1, item, buf_ptr);

#ifdef wx_xview
  Notify(FALSE);
#endif

  write(output_fd, buf_ptr, pos);
  read(input_fd, buf_ptr, buf_size);

#ifdef wx_xview
  Notify(TRUE);
#endif

  if (buf_ptr[0] != wxFAIL)
    return TRUE;
  else
    return FALSE;
}

// Calls that SERVER can make
Bool wxConnection::Advise(char *item, char *data, int size, int format)
{
  char format_buf[10];
  sprintf(format_buf, "%d", format);

  buf_ptr[0] = wxADVISE;
  int pos = wxAddString(1, item, buf_ptr);
  pos = wxAddString(pos, format_buf, buf_ptr);
  pos = wxAddString(pos, data, buf_ptr, size);

  write(output_fd, buf_ptr, pos);
  return TRUE;
}

void wxConnection::Notify(Bool notify)
{
#ifdef wx_motif
  if (!notify)
  {
    if (xtInputId > 0)
    {
      XtRemoveInput(xtInputId);
      xtInputId = 0;
    }
  }
  else
    xtInputId = XtAppAddInput(wxTheApp->appContext, input_fd, (void*)XtInputReadMask, (XtInputCallbackProc) wx_input_ready, this);
#endif
#ifdef wx_xview
  if (notify)
    notify_set_input_func((Notify_client)this, (Notify_func)wx_input_ready, input_fd);
  else
    notify_set_input_func((Notify_client)this, NOTIFY_FUNC_NULL, input_fd);
#endif
}

#ifdef wx_xview
#define NOTIFY_RETURN_TYPE Notify_value
Notify_value wx_input_ready(Notify_client client, int fd)
#endif
#ifdef wx_motif
#define NOTIFY_RETURN_TYPE Bool
Bool wx_input_ready(XtPointer client, int *fid, XtInputId *id)
#endif
{
#ifdef wx_motif
//  int fd = *fid;
#endif
    wxConnection *connection = (wxConnection *)client;

#ifdef wx_motif
    if (connection->xtInputId == 0)
      return (NOTIFY_RETURN_TYPE)FALSE;
#endif

    int nread = read(connection->input_fd, connection->buf_ptr, connection->buf_size);

    if ((nread >= 0) && (nread < connection->buf_size))
      connection->buf_ptr[nread] = 0;

    switch(nread)
    { 
      case -1:			/* Error - give up */
        connection->Notify(FALSE);
        connection->OnDisconnect();
        return (NOTIFY_RETURN_TYPE)FALSE;
        break;

      case 0:			/* EOF - de-register descriptor */
      {
        connection->Notify(FALSE);
        connection->OnDisconnect();
        return (NOTIFY_RETURN_TYPE)FALSE;
        break;
      }
      default:
        break;
   }
   switch (connection->buf_ptr[0])
   {
     case wxEXECUTE:
     {
       char *format_buf = connection->buf_ptr + 1;
       char *data = wxGetNextString(format_buf);

       int format = wxCF_TEXT;
       sscanf(format_buf, "%d", &format);

       int size = nread - (data - connection->buf_ptr);
       connection->OnExecute(connection->topic_name, data, size, format);
       break;
     }
     case wxADVISE:
     {
       char *item = connection->buf_ptr + 1;
       char *format_buf = wxGetNextString(item);;
       char *data = wxGetNextString(format_buf);

       int format = wxCF_TEXT;
       sscanf(format_buf, "%d", &format);

       int size = nread - (data - connection->buf_ptr);
       connection->OnAdvise(connection->topic_name, item, data, size, format);
       break;
     }
     case wxADVISE_START:
     {
       char *item = connection->buf_ptr + 1;
       Bool ok = connection->OnStartAdvise(connection->topic_name, item);
       if (ok)
       {
         connection->buf_ptr[0] = wxADVISE_START;
         connection->buf_ptr[1] = 0;
         write(connection->output_fd, connection->buf_ptr, 2);
       }
       else
       {
         connection->buf_ptr[0] = wxFAIL;
         connection->buf_ptr[1] = 0;
         write(connection->output_fd, connection->buf_ptr, 2);
       }

       break;
     }
     case wxADVISE_STOP:
     {
       char *item = connection->buf_ptr + 1;
       Bool ok = connection->OnStopAdvise(connection->topic_name, item);
       if (ok)
       {
         connection->buf_ptr[0] = wxADVISE_STOP;
         connection->buf_ptr[1] = 0;
         write(connection->output_fd, connection->buf_ptr, 2);
       }
       else
       {
         connection->buf_ptr[0] = wxFAIL;
         connection->buf_ptr[1] = 0;
         write(connection->output_fd, connection->buf_ptr, 2);
       }

       break;
     }
     case wxPOKE:
     {
       char *item = connection->buf_ptr + 1;
       char *format_buf = wxGetNextString(item);;
       char *data = wxGetNextString(format_buf);

       int format = wxCF_TEXT;
       sscanf(format_buf, "%d", &format);

       int size = nread - (data - connection->buf_ptr);
       connection->OnPoke(connection->topic_name, item, data, size, format);
       break;
     }
     case wxREQUEST:
     {
       char *item = connection->buf_ptr + 1;
       char *format_buf = wxGetNextString(item);;

       int format = wxCF_TEXT;
       sscanf(format_buf, "%d", &format);

       int user_size = -1;
       char *user_data = connection->OnRequest(connection->topic_name, item, &user_size, format);
       if (user_data)
       {
         connection->buf_ptr[0] = wxREQUEST_REPLY;
         int pos = wxAddString(1, item, connection->buf_ptr);
         pos = wxAddString(pos, user_data, connection->buf_ptr, user_size);

         write(connection->output_fd, connection->buf_ptr, pos);
       }
       else
       {
         connection->buf_ptr[0] = wxFAIL;
         connection->buf_ptr[1] = 0;
         write(connection->output_fd, connection->buf_ptr, 2);
       }
       break;
     }
     default:
       break;
   }
   return (NOTIFY_RETURN_TYPE)FALSE;
}

#ifdef wx_xview
Notify_value wx_accept_connection(Notify_client client, int fd)
#endif
#ifdef wx_motif
Bool wx_accept_connection(XtPointer client, int *fid, XtInputId *id)
#endif
{
#ifdef wx_motif
  int fd = *fid;
#endif

  struct sockaddr_in addr;
  int newsock, addrlen = sizeof(addr);
  wxConnection *top_connection = (wxConnection *)client;

  /* Accept the connection, getting a new socket */

  newsock = accept(fd, (struct sockaddr *)&addr, &addrlen);
  if(newsock == -1)
 	printf("Error in accept\n");
  char buf[300];

  read(newsock, buf, 300);

  if (buf[0] == wxCONNECT)
  {
    char *topic_name = copystring(buf + 1);

    /* Register new socket with the notifier */
    wxConnection *new_connection = top_connection->server->OnAcceptConnection(topic_name);
    if (new_connection)
    {
      // Acknowledge success
      buf[0] = wxCONNECT;
      buf[1] = 0;
      write(newsock, buf, 2);

      new_connection->input_fd = newsock;
      new_connection->output_fd = newsock;
      new_connection->server = top_connection->server;
      new_connection->topic_name = topic_name;
      top_connection->server->connections.Append(new_connection);

#ifdef wx_xview
      notify_set_input_func((Notify_client)new_connection, (Notify_func)&wx_input_ready, newsock);
#endif
#ifdef wx_motif
      new_connection->xtInputId = XtAppAddInput(wxTheApp->appContext, newsock, (void*)XtInputReadMask, (XtInputCallbackProc) wx_input_ready, (XtPointer)new_connection);
#endif
    }
    else
    {
      // Send failure message
      buf[0] = wxFAIL;
      buf[1] = 0;
      write(newsock, buf, 2);
    }
  }
  return (NOTIFY_RETURN_TYPE)FALSE;
}

/*
 * Create an internet socket listening on the specified port.
 */

int wx_socket_create(int port)
{
  struct sockaddr_in addr; int sock;

  addr.sin_family = AF_INET; 
  addr.sin_addr.s_addr = htonl(INADDR_ANY); 
  addr.sin_port = htons(port);

  sock = socket(AF_INET, SOCK_STREAM, 0);
  if(bind(sock, (struct sockaddr *)&addr, sizeof(addr)) == -1)
  {
    printf("Error in bind\n");
    return -1;
  }

  listen(sock, 5);

  return sock;
}

/*

#ifdef wx_xview
static Notify_value
wx_child_died(Notify_client me, int pid, union wait *status, struct rusage *rusage)
{
  if (WIFEXITED(*status))
  {
    wxChild *child = (wxChild *)me;
    child->OnDeath();
    delete child;
    return NOTIFY_DONE;
  } else
    return NOTIFY_IGNORED;
}
#endif

// Pipes
wxChild::wxChild(void)
{
  the_pid = -1;
}

Bool wxChild::Create(char *command, char *argv[])
{
#ifdef wx_motif
  return FALSE;
#endif
#ifdef wx_xview
  int to_subprocess[2], from_subprocess[2];

  pipe(to_subprocess); pipe(from_subprocess);

  int pid = fork();

  the_pid = pid;
  switch(pid)
  {
    case -1:
    return FALSE;

    case 0:			// child

    // Copy pipe descriptors to stdin and stdout
    dup2(to_subprocess[0], 0); 	dup2(from_subprocess[1], 1);

    // Close unwanted descriptors

    close(to_subprocess[0]); 	close(to_subprocess[1]);
    close(from_subprocess[0]); 	close(from_subprocess[1]);

    // Exec new process

//	execlp("prolog", "prolog", (char *)0); execvp(command, argv);

  // If we get here it failed; give up

    perror("exec");
    _exit(1);		// Use _exit() not exit() after failed exec

    default:			// parent

	break;
  }

  // Close unneeded descriptors

  close(to_subprocess[0]); close(from_subprocess[1]);

  (void)notify_set_wait3_func((Notify_client)this, (Notify_func)wx_child_died, pid);

  wxConnection *connection = this->OnSpawn(pid);
  connection->input_fd = from_subprocess[0];
  connection->output_fd = to_subprocess[1];

  if (connection)
  {
    connection->Notify(TRUE);
    return TRUE;
  }
  else
  { close(to_subprocess[1]); 
    close(from_subprocess[0]);
    return FALSE;
  }
#endif
#ifdef wx_msw
  return FALSE;
#endif
  }

void wxChild::OnDeath(void)
{
}

// Default behaviour
wxConnection *wxChild::OnSpawn(int pid)
{
  return new wxConnection;
}
*/

#endif // USE_IPC
