/*
 * File:	wx_frame.cc
 * Purpose:	wxFrame implementation (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include <iostream.h>

#include "common.h"
#include "wx_frame.h"
#include "wx_gdi.h"
#include "wx_main.h"
#include "wx_utils.h"
#include "wx_privt.h"

#ifdef wx_motif
#include <Xm/Xm.h>
#include <X11/Shell.h>
#if XmVersion >= 1002
#include <Xm/XmAll.h>
#endif
#include <Xm/BulletinB.h>
#include <Xm/Form.h>
#include <Xm/MainW.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/AtomMgr.h>
#include <Xm/LabelG.h>
#if   XmVersion > 1000
#include <Xm/Protocols.h>
#endif
void wxCloseFrameCallback(Widget, XtPointer, XmAnyCallbackStruct *cbs);
#endif

#ifdef wx_xview
#include <xview/frame.h>
Notify_value wxFrameInterposer(Frame x_frame, Event *x_event, Notify_arg arg,
                               Notify_event_type type);
Notify_value wxDummyFrameInterposer(Frame x_frame, Event *x_event, Notify_arg arg,
                               Notify_event_type type);
Notify_value
wxFrameCloseInterposer(Notify_client client, Destroy_status status);
#endif

#ifdef wx_motif
Bool wxTopLevelUsed = FALSE;
#endif

wxFrame::wxFrame(void)
{
  frame_type = 0;
  wx_menu_bar = NULL;
  status_line_exists = FALSE;
  icon = NULL;
  modal_showing = FALSE;
  window_parent = NULL;
  frameTitle = NULL;
  lastWidth = -1 ;
  lastHeight = -1 ;
#ifdef wx_motif
  for (int i = 0; i < wxMAX_STATUS; i++)
    statusTextWidget[i] = 0;
  statusLineForm = 0;
  frameShell = NULL;
  menuBarWidget = NULL;
  statusLineWidget = NULL;
  frameWidget = NULL;
  workArea = NULL;
  clientArea = NULL;
  handle = NULL;
#endif
#ifdef wx_xview
  handle = NULL;
  menu_bar_panel = NULL;
  y_offset = 0;
  for (int i = 0; i < wxMAX_STATUS; i++)
    statusText[i] = 0;
#endif
}

wxFrame::wxFrame(wxFrame *Parent, char *title, int x, int y,
                 int width, int height, int style, char *name):
  wxbFrame(Parent, title, x, y, width, height, style, name)
{
  Create(Parent, title, x, y, width, height, style, name);
}

Bool wxFrame::Create(wxFrame *Parent, char *title, int x, int y,
                 int width, int height, int style, char *name)
{
  wxbFrame::Create(Parent, title, x, y, width, height, style, name);

  if (title)
    frameTitle = copystring(title);

  frame_type = style & (wxSDI | wxMDI_PARENT | wxMDI_CHILD);
  wx_menu_bar = NULL;
  status_line_exists = FALSE;
  icon = NULL;
  modal_showing = FALSE;
  if (Parent) Parent->AddChild(this);
  window_parent = Parent;
  lastWidth = -1 ;
  lastHeight = -1 ;
#ifdef wx_motif
  windowName = copystring(name);
  statusLineForm = 0;
  statusLineWidget = 0;
  for (int i = 0; i < wxMAX_STATUS; i++)
    statusTextWidget[i] = 0;

/*
  if (Parent==(wxFrame *)NULL)
  {
    if (wxTopLevelUsed)
      frameShell = XtAppCreateShell(NULL, windowName, topLevelShellWidgetClass, XtDisplay(wxTheApp->topLevel), NULL, 0);
    else
    {
      frameShell = wxTheApp->topLevel;
    }
    wxTopLevelUsed = TRUE;
  }
  else
*/
//    frameShell = XmCreateBulletinBoardDialog(XtParent(Parent->frameShell),
//    frameShell = XmCreateBulletinBoardDialog(Parent->frameShell,
//                                             name,NULL,0) ;

  if (wxTopLevelUsed)
    frameShell = XtAppCreateShell(NULL, windowName, topLevelShellWidgetClass, XtDisplay(wxTheApp->topLevel), NULL, 0);
  else
  {
    frameShell = wxTheApp->topLevel;
    wxTopLevelUsed = TRUE;
  }

  XtVaSetValues(frameShell, 
                 // Allows menu to resize
                 XmNallowShellResize, True,
                 XmNdeleteResponse, XmDO_NOTHING,
                 XmNmappedWhenManaged, False,
                 XmNiconic, (style & wxICONIZE) ? TRUE : FALSE,
                 NULL);

  if (title)
    XtVaSetValues(frameShell, 
                  XmNtitle, title,
                  NULL);

  menuBarWidget = NULL;
  statusLineWidget = NULL;

  frameWidget = XtVaCreateManagedWidget("main_window",
                    xmMainWindowWidgetClass, frameShell,
                    XmNresizePolicy, XmRESIZE_NONE,
                    NULL);

  workArea = XtVaCreateWidget("form",
                    xmFormWidgetClass, frameWidget,
                    XmNresizePolicy, XmRESIZE_NONE,
                    NULL);

  clientArea = XtVaCreateWidget("client",
                    xmBulletinBoardWidgetClass, workArea,
                    XmNmarginWidth, 0,
                    XmNmarginHeight, 0,
                    XmNrightAttachment, XmATTACH_FORM,
                    XmNleftAttachment, XmATTACH_FORM,
                    XmNtopAttachment, XmATTACH_FORM,
                    XmNbottomAttachment, XmATTACH_FORM,
//                    XmNresizePolicy, XmRESIZE_ANY,
                    NULL);

  XtVaSetValues(frameWidget,
    XmNworkWindow, workArea,
    NULL);


  XtManageChild(clientArea);
//  XtManageChild(statusLineWidget);
  XtManageChild(workArea);

  if (wxWidgetHashTable->Get((long)workArea))
  {
    wxError("Widget table clash in wx_frame.cc");
  }
  wxWidgetHashTable->Put((long)workArea, this);

  XtTranslations ptr ;

  XtOverrideTranslations(workArea,
              ptr = XtParseTranslationTable("<Configure>: resize()"));

  XtFree((char *)ptr);

  if (x > -1)
    XtVaSetValues(frameShell, XmNx, x, NULL);
  if (y > -1)
    XtVaSetValues(frameShell, XmNy, y, NULL);
  if (width > -1)
    XtVaSetValues(frameShell, XmNwidth, width, NULL);
  if (height > -1)
    XtVaSetValues(frameShell, XmNheight, height, NULL);

  handle = (char *)frameWidget;

  XtRealizeWidget(frameShell);

  // Intercept CLOSE messages from the window manager
  Atom WM_DELETE_WINDOW = XmInternAtom(XtDisplay(frameShell), "WM_DELETE_WINDOW", False);
//  XmAddWMProtocolCallback(frameShell, WM_DELETE_WINDOW, (XtCallbackProc) wxCloseFrameCallback, (caddr_t)this);
#if XmREVISION > 1
  XmAddWMProtocolCallback(frameShell, WM_DELETE_WINDOW, (XtCallbackProc) wxCloseFrameCallback, (XtPointer)this);
#else
#if XmREVISION == 1
  XmAddWMProtocolCallback(frameShell, WM_DELETE_WINDOW, (XtCallbackProc) wxCloseFrameCallback, (caddr_t)this);
#else
  XmAddWMProtocolCallback(frameShell, WM_DELETE_WINDOW, (void (*)())wxCloseFrameCallback, (caddr_t)this);
#endif
#endif

  PreResize();
  OnSize(width, height);
#endif
#ifdef wx_xview
  for (int i=0;i<wxMAX_STATUS;i++)
    statusText[i] = NULL ;

  Frame parent;
  if (Parent == (wxFrame *)NULL)
    {
      parent = (Frame)NULL;
    }
  else
    {
      parent = (Frame)(Parent->GetHandle());
    };

  Frame frame = (Frame) xv_create(parent, FRAME, FRAME_LABEL, title,
                              WIN_CLIENT_DATA, (char *)this,
                              XV_SHOW, FALSE,
                              FRAME_CLOSED, (style & wxICONIZE) ? TRUE : FALSE,
                              NULL);

  if (x > -1)
    xv_set(frame, XV_X, x, NULL);

  if (y > -1)
    xv_set(frame, XV_Y, y, NULL);

  if (width > -1)
    xv_set(frame, XV_WIDTH, width, NULL);

  if (height > -1)
    xv_set(frame, XV_HEIGHT, height, NULL);

  handle = (char *)frame;

  menu_bar_panel = NULL;
  y_offset = 0;

  // Have to do this interposition to receive frame resize events
  (void)notify_interpose_event_func(frame, (Notify_func)wxFrameInterposer, NOTIFY_SAFE);
  (void)notify_interpose_destroy_func(frame, (Notify_func)wxFrameCloseInterposer);
#endif
  return TRUE;
}

// For ~wxFrame, see wx_item.cc

#ifdef wx_motif
Bool wxFrame::PreResize(void)
{
  // Set status line, if any
  if (status_line_exists)
  {
    Dimension clientW, clientH;
    XtVaGetValues(clientArea, XmNwidth, &clientW, XmNheight, &clientH, NULL);
    Dimension xx, yy;
    XtVaGetValues(statusLineWidget, XmNwidth, &xx, XmNheight, &yy, NULL);

    XtUnmanageChild(statusLineWidget);
    XtVaSetValues(statusLineWidget, XmNx, 0, XmNy, clientH - yy, XmNwidth, clientW, NULL);

    if (statusLineForm)
      XtVaSetValues(statusLineForm,  XmNwidth, clientW, NULL);

    XtManageChild(statusLineWidget);
  }

  int width, height;
  GetSize(&width, &height);

  if (width == lastWidth && height == lastHeight)
    return FALSE;
  else
  {
    return TRUE;
  }
}
#endif

// Get size *available for subwindows* i.e. excluding menu bar etc.
// For XView, this is the same as GetSize
void wxFrame::GetClientSize(int *x, int *y)
{
#ifdef wx_motif
  Dimension xx, yy;
  XtVaGetValues(workArea, XmNwidth, &xx, XmNheight, &yy, NULL);

  if (status_line_exists)
  {
    Dimension ys;
    XtVaGetValues(statusLineWidget, XmNheight, &ys, NULL);
    yy -= ys;
  }

  *x = xx; *y = yy;
#endif
#ifdef wx_xview
  Frame x_frame = (Frame)handle;

  *x = (int)xv_get(x_frame, XV_WIDTH);
  *y = (int)xv_get(x_frame, XV_HEIGHT) - y_offset;
#endif
}

// Set the client size (i.e. leave the calculation of borders etc.
// to wxWindows)
void wxFrame::SetClientSize(int width, int height)
{
#ifdef wx_motif
  // Calculate how large the new main window should be
  // by finding the difference between the client area and the
  // main window area, and adding on to the new client area
/*
  Dimension current_frame_width, current_frame_height;
  Dimension current_form_width, current_form_height;
  XtVaGetValues(frameShell, XmNwidth, &current_frame_width, XmNheight, &current_frame_height, NULL);
  XtVaGetValues(workArea, XmNwidth, &current_form_width, XmNheight, &current_form_height, NULL);
  int diffX = current_frame_width - current_form_width;
  int diffY = current_frame_height - current_form_height;

  if (width > -1)
    XtVaSetValues(frameShell, XmNwidth, width + diffX, NULL);
  if (height > -1)
  {
    int real_height = height + diffY;
    if (status_line_exists)
    {
      Dimension ys;
      XtVaGetValues(statusLineWidget, XmNheight, &ys, NULL);
      real_height += ys;
    }
    XtVaSetValues(frameShell, XmNheight, real_height, NULL);
  }
*/
  if (width > -1)
    XtVaSetValues(workArea, XmNwidth, width, NULL);

  if (height > -1)
  {
    if (status_line_exists)
    {
      Dimension ys;
      XtVaGetValues(statusLineWidget, XmNheight, &ys, NULL);
      height += ys;
    }
    XtVaSetValues(workArea, XmNheight, height, NULL);
  }
  PreResize();
  OnSize(width, height);
#endif
#ifdef wx_xview
  Frame x_frame = (Frame)handle;

  if (width > -1 && height > -1)
    (void)xv_set(x_frame, XV_WIDTH, width, XV_HEIGHT, height + y_offset, NULL);

  OnSize(width, height);
#endif
  GetSize(&lastWidth, &lastHeight);
}

void wxFrame::GetSize(int *width, int *height)
{
#ifdef wx_motif
  Dimension xx, yy;
  XtVaGetValues(frameShell, XmNwidth, &xx, XmNheight, &yy, NULL);
  *width = xx; *height = yy;
#endif
#ifdef wx_xview
  Xv_opaque x_win = (Xv_opaque)handle;

  *width = (int)xv_get(x_win, XV_WIDTH);
  *height = (int)xv_get(x_win, XV_HEIGHT);
#endif
}

void wxFrame::GetPosition(int *x, int *y)
{
#ifdef wx_motif
  Widget widget = (Widget)handle;
  Dimension xx, yy;
  XtVaGetValues(widget, XmNx, &xx, XmNy, &yy, NULL);
  *x = xx; *y = yy;
#endif
#ifdef wx_xview
  Xv_opaque x_win = (Xv_opaque)handle;

  *x = (int)xv_get(x_win, XV_X);
  *y = (int)xv_get(x_win, XV_Y);
#endif
}

void wxFrame::SetSize(int x, int y, int width, int height)
{
#ifdef wx_motif
  if (x > -1)
    XtVaSetValues(frameShell, XmNx, x, NULL);
  if (y > -1)
    XtVaSetValues(frameShell, XmNy, y, NULL);
  if (width > -1)
    XtVaSetValues(frameWidget, XmNwidth, width, NULL);
  if (height > -1)
    XtVaSetValues(frameWidget, XmNheight, height, NULL);
  PreResize();
  OnSize(width, height);
#endif
#ifdef wx_xview
  Xv_opaque x_win = (Xv_opaque)handle;

  if (x == -1 || y == -1)
  {
    int xx,yy ;
    GetPosition(&xx, &yy);
    if (x == -1) x = xx ;
    if (y == -1) y = yy ;
  }

  if (width == -1 || height == -1)
  {
    int ww,hh ;
    GetSize(&ww, &hh);
    if (width == -1) width = ww ;
    if (height == -1) height = hh ;
  }

  (void)xv_set(x_win, XV_X, x, XV_Y, y, XV_WIDTH, width, XV_HEIGHT, height, NULL);

  OnSize(width, height);
#endif
  GetSize(&lastWidth, &lastHeight);
}

void wxFrame::Show(Bool show)
{
#ifdef wx_motif
  if (show)
  {
    XtMapWidget(frameShell);
    XRaiseWindow(XtDisplay(frameShell), XtWindow(frameShell));
  }
  else
    XtUnmapWidget(frameShell);
#endif
#ifdef wx_xview
  Xv_opaque window = (Xv_opaque)handle;
  xv_set(window, XV_SHOW, show, NULL);
#endif
}

#ifdef wx_xview
Notify_value wxDummyFrameInterposer(Frame x_frame, Event *x_event, Notify_arg arg,
                               Notify_event_type type)
{
  return (Notify_value)1;
}

Notify_value wxFrameInterposer(Frame x_frame, Event *x_event, Notify_arg arg,
                               Notify_event_type type)
{
  wxFrame *frame = (wxFrame *)xv_get(x_frame, WIN_CLIENT_DATA);

//  cout << event_action(x_event) << "\n";

  if (frame && event_action(x_event) == WIN_RESIZE)
    {
//      cout << "Frame resized\n";
        int width, height;
        frame->GetSize(&width, &height);
        if (!(width == frame->lastWidth && height == frame->lastHeight))
	{
          frame->lastWidth = width; frame->lastHeight = height;
          frame->OnSize(width, height);
	}

       return notify_next_event_func(x_frame, (long unsigned int)x_event, arg, type);
    }
  else return notify_next_event_func(x_frame, (long unsigned int)x_event, arg, type);
}

Notify_value
wxFrameCloseInterposer(Notify_client client, Destroy_status status)
{
  wxFrame *frame = (wxFrame *)xv_get(client, WIN_CLIENT_DATA);

  if (status == DESTROY_CHECKING)
  {
    if (frame)
    {
      Bool answer = frame->OnClose();
      if (!answer)
        notify_veto_destroy(client);
    }
  }
  else if (status == DESTROY_CLEANUP)
  {
    // Should we destroy the wxFrame or wot?
    // Try to delete the wxFrame without allowing the Frame
    // to be deleted, since this will be done by XView

    if (frame)
    {
      frame->Show(FALSE);
      (void)notify_interpose_event_func((Frame)frame->handle, (Notify_func)wxDummyFrameInterposer, NOTIFY_SAFE);
      xv_set((Frame)frame->handle, WIN_CLIENT_DATA, NULL, NULL);

      frame->handle = NULL;
      frame->DestroyChildren();
      delete frame;
      if (frame == wxTheApp->wx_frame)
        wxTheApp->wx_frame = NULL;
    }
    return notify_next_destroy_func(client, status);
  }
  else if (status == DESTROY_SAVE_YOURSELF)
  {
    // Do nothing - this is an Open Look specific feature
  }
  else  if (status == DESTROY_PROCESS_DEATH)
  { 
    if (!wxTheApp->death_processed)
    {
      wxTheApp->OnExit();
      wxTheApp->death_processed = TRUE;
    }
  };
  return NOTIFY_DONE;
}

#endif

#ifdef wx_motif
void wxCloseFrameCallback(Widget widget, XtPointer client_data, XmAnyCallbackStruct *cbs)
{
  wxFrame *frame = (wxFrame *)client_data;
  if (frame->OnClose())
    delete frame;
}
#endif

void wxFrame::Iconize(Bool iconize)
{
  if (!iconize)
    Show(TRUE);
#ifdef wx_motif
  XtVaSetValues(frameShell, XmNiconic, iconize, NULL);
#endif
#ifdef wx_xview
  Xv_opaque window = (Xv_opaque)handle;
  xv_set(window, FRAME_CLOSED, iconize, NULL);
#endif
}

// Equivalent to maximize/restore in Windows
void wxFrame::Maximize(Bool maximize)
{
  Show(TRUE);
#ifdef wx_motif
  if (maximize)
    XtVaSetValues(frameShell, XmNiconic, FALSE, NULL);
#endif
#ifdef wx_xview
  Xv_opaque window = (Xv_opaque)handle;
  if (maximize)
    xv_set(window, FRAME_CLOSED, FALSE, NULL);
#endif
}

Bool wxFrame::Iconized(void)
{
#ifdef wx_motif
  Bool iconic;
  XtVaGetValues(frameShell, XmNiconic, &iconic, NULL);
  return iconic;
#endif
#ifdef wx_xview
  Xv_opaque window = (Xv_opaque)handle;
  return xv_get(window, FRAME_CLOSED);
#endif
}


void wxFrame::SetTitle(char *title)
{
  if (frameTitle)
    delete[] frameTitle;

  frameTitle = copystring(title);

#ifdef wx_motif
  if (title)
    XtVaSetValues(frameShell, 
                  XmNtitle, title,
                  XmNiconName, title,
                  NULL);
#endif
#ifdef wx_xview
  Frame xframe = (Frame)handle;
  xv_set(xframe, FRAME_LABEL, title, NULL);
  if (icon)
  {
    xv_set(icon->x_icon, XV_LABEL, title, NULL);
    xv_set(xframe, FRAME_ICON, icon->x_icon, NULL);
  }
#endif
}

char *wxFrame::GetTitle(void)
{
  return frameTitle;
}


void wxFrame::SetIcon(wxIcon *wx_icon)
{
/*
  if (icon)
    delete icon;
*/
  icon = wx_icon;
#ifdef wx_motif
  if (!wx_icon->x_pixmap)
    return;

  XtVaSetValues(frameShell, XtNiconPixmap, wx_icon->x_pixmap, NULL);

  // The following isn't necessary and doesn't even work (P.587 of Heller)
/*
  Display *dpy = XtDisplay(wxTheApp->topLevel);
  Window window, root;
  XtVaGetValues(frameShell, XtNiconWindow, &window, NULL);
  if (!window)
  {
    int x, y;
    unsigned int width, height, border_width, depth;
    if (!XGetGeometry(dpy, wx_icon->x_pixmap, &root, &x, &y, &width, &height, &border_width,
                      &depth) ||
        !(window = XCreateSimpleWindow(dpy, root, 0, 0, width, height, (unsigned)0, 
          CopyFromParent, CopyFromParent)))
    {
      XtVaSetValues(frameShell, XmNiconPixmap, wx_icon->x_pixmap, NULL);
      return;
    }
    XSetWindowBackgroundPixmap(dpy, window, wx_icon->x_pixmap);
    XClearWindow(dpy, window);
  }
*/
#endif
#ifdef wx_xview
  Frame xframe = (Frame)handle;
  char *label = (char *)xv_get(xframe, FRAME_LABEL);
  xv_set(wx_icon->x_icon, XV_LABEL, label, NULL);
  xv_set(xframe, FRAME_ICON, wx_icon->x_icon, NULL);
#endif
}


void wxFrame::CreateStatusLine(int number, char *name)
{
  if (status_line_exists)
    return;

  nb_status = number;
  status_line_exists = TRUE;

#ifdef wx_motif
  int i;
  statusLineWidget = XtVaCreateManagedWidget(name,
      xmFrameWidgetClass,      clientArea,
      XmNshadowType,           XmSHADOW_IN,
      NULL);

  if (number == 1)
  {
    sprintf(wxBuffer,"status_text%d",0) ;
    statusTextWidget[0] = XtVaCreateManagedWidget(wxBuffer,
#if USE_GADGETS
        xmLabelGadgetClass,      statusLineWidget,
#else
        xmLabelWidgetClass,      statusLineWidget,
#endif
        XmNalignment,            XmALIGNMENT_BEGINNING,
        NULL);
  }
  else
  {
    statusLineForm = XtVaCreateManagedWidget("form",
                xmFormWidgetClass, statusLineWidget,NULL) ;
    for (i=0;i<number;i++)
    {
      sprintf(wxBuffer,"status_text%d",i) ;
      statusTextWidget[i] = XtVaCreateManagedWidget(wxBuffer,
#if USE_GADGETS
          xmLabelGadgetClass,      statusLineForm,
#else
          xmLabelWidgetClass,      statusLineForm,
#endif
          XmNalignment,            XmALIGNMENT_BEGINNING,
          NULL);
    }
    Widget attach_me = NULL  ;
    for (i=0;i<number/2;i++)
    {
      XtVaSetValues(statusTextWidget[i],
          XmNleftAttachment ,  i==0? XmATTACH_FORM:XmATTACH_WIDGET,
          XmNleftWidget ,      attach_me ,
          XmNrightAttachment , XmATTACH_NONE ,
          NULL) ;
      attach_me = statusTextWidget[i] ;
    }
    for (i=number-1;i>=number/2;i--)
    {
      XtVaSetValues(statusTextWidget[i],
          XmNrightAttachment ,i==number-1? XmATTACH_FORM : XmATTACH_WIDGET,
          XmNrightWidget ,    attach_me ,
          XmNleftAttachment , XmATTACH_NONE ,
          NULL) ;
      attach_me = statusTextWidget[i] ;
    }
  }

  XtRealizeWidget(statusLineWidget);
//  XtRealizeWidget(statusTextWidget);
  if (statusLineForm)
    XtRealizeWidget(statusLineForm);
  for(i=0;i<number;i++)
    XtRealizeWidget(statusTextWidget[i]);

  for (i=0;i<number;i++)
    SetStatusText(" ",i);

/*
  // Initialize it to set it to the desired height
  XmString str = XmStringCreateSimple(" ");
  XtVaSetValues(statusTextWidget,
                  XmNrecomputeSize, True,
                  XmNlabelString, str,
                  NULL);
  XmStringFree(str);
*/

  PreResize();
#endif
#ifdef wx_xview
  Frame xframe = (Frame)handle;
  xv_set(xframe, FRAME_SHOW_FOOTER, TRUE, NULL);
#endif
}

void wxFrame::SetStatusText(char *text, int number)
{
  if (!status_line_exists)
    return;
#ifdef wx_motif
  if (!text) text = " ";
  sprintf(wxBuffer, " %s", text);

  // First check if the string is the same as what's there.
  XmString textString;
  char *s;
  XtVaGetValues(statusTextWidget[number],
                  XmNlabelString, &textString,
                  NULL);

  if (XmStringGetLtoR(textString, XmSTRING_DEFAULT_CHARSET, &s))
  {
    Bool theSame = (strcmp(s, wxBuffer) == 0);
    XtFree(s);
    if (theSame)
      return;
  }

  // Not the same, so carry on

  XmString str = XmStringCreateSimple(wxBuffer);
  XtVaSetValues(statusTextWidget[number],
//                  XmNrecomputeSize, False,
                  XmNlabelString, str,
                  NULL);
  XmStringFree(str);
  PreResize();  // Stretch it back to full width!
#endif
#ifdef wx_xview
  Frame xframe = (Frame)handle;
//  xv_set(xframe, FRAME_LEFT_FOOTER, text, NULL);
  if (statusText[number])
    delete statusText[number] ;
  statusText[number] = copystring(text) ;

  char tmp[256] ;
  tmp[0]='\0' ;
  if ((float)number < ((float)nb_status/2.0))
  {
    for (int i=0;((float)i) < ((float)(nb_status/2.0));i++)
    {
      if (statusText[i])
        strcat(tmp,statusText[i]) ;
      strcat(tmp," ") ;
    }
    xv_set(xframe, FRAME_LEFT_FOOTER, tmp , NULL);
  }
  else
  {
    for (int i=nb_status/2;i<nb_status;i++)
    {
      if (statusText[i])
        strcat(tmp,statusText[i]) ;
      strcat(tmp," ") ;
    }
    xv_set(xframe, FRAME_RIGHT_FOOTER, tmp, NULL);
  }
#endif
}

void wxFrame::LoadAccelerators(char *table)
{
}

void wxFrame::Fit(void)
{
  int maxX = 0;
  int maxY = 0;
  wxNode *node = GetChildren()->First();
  while (node)
  {
    wxWindow *win = (wxWindow *)node->Data();
    if ((wxSubType(win->__type, wxTYPE_PANEL) &&
         !wxSubType(win->__type, wxTYPE_DIALOG_BOX)) ||
        wxSubType(win->__type, wxTYPE_TEXT_WINDOW) ||
        wxSubType(win->__type, wxTYPE_CANVAS))
    {
      int x, y, w, h;
      win->GetPosition(&x, &y);
      win->GetSize(&w, &h);
      if ((x + w) > maxX)
        maxX = x + w;
      if ((y + h) > maxY)
        maxY = y + h;
    }
    node = node->Next();
  }
  SetClientSize(maxX, maxY);
}

