/*
 * File:	wx_dialg.cc
 * Purpose:	wxDialogBox and miscellaneous dialog functions (X version)
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include <iostream.h>
#include <stdio.h>
#include "common.h"
#include "wx_lbox.h"
#include "wx_buttn.h"
#include "wx_choic.h"
#include "wx_check.h"
#include "wx_messg.h"
#include "wx_txt.h"
#include "wx_mtxt.h"
#include "wx_dialg.h"
#include "wx_utils.h"
#include "wx_frame.h"
#include "wx_privt.h"
#include "wx_main.h"

#define wxDIALOG_DEFAULT_X 300
#define wxDIALOG_DEFAULT_Y 300

#ifdef wx_motif
#include <X11/Shell.h>
#if XmVersion >= 1002
#include <Xm/XmAll.h>
#endif
#include <Xm/Label.h>
#include <Xm/BulletinB.h>
#include <Xm/Frame.h>
#include <Xm/Text.h>
#include <Xm/DialogS.h>
#include <Xm/FileSB.h>
#include <Xm/RowColumn.h>
#include <Xm/LabelG.h>
#include <Xm/AtomMgr.h>
#if   XmVersion > 1000
#include <Xm/Protocols.h>
#endif
void wxCloseDialogCallback(Widget widget, XtPointer client_data, XmAnyCallbackStruct *cbs);

char *wxMotifFileSelector(char *message,
                     char *default_path, char *default_filename, 
                     char *default_extension, char *wildcard, int flags,
                     wxFrame *parent, int x, int y);
#endif

#ifdef wx_xview
#include <dirent.h>
#include <unistd.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>

extern "C" Frame xv_window_loop(Frame);
extern "C" void xv_window_return(Frame);

extern void wxPanelEventProc(Panel panel, Event *event); // See wx_item.cc
Notify_value wxDialogInterposer(Frame x_frame, Event *x_event, Notify_arg arg,
                               Notify_event_type type);
Notify_value
wxDialogCloseInterposer(Notify_client client, Destroy_status status);

// Sometimes calls notify function after frame has died, so set this when frame
// is deleted, to do nothing.
Notify_value wxDummyDialogInterposer(Frame x_frame, Event *x_event, Notify_arg arg,
                               Notify_event_type type);
char *wxXFileSelector(wxFrame *parent, char *path, char *file, char *message, int flags, char *wild_card)
;
#endif

// Dialog box - like panel but doesn't need a frame, and is modal or
// non-modal
wxDialogBox::wxDialogBox(void)
{
  dialogTitle = NULL;
#ifdef wx_motif
  borderWidget = 0;
  wxType = 1;
  invisibleResize = FALSE ;

  has_child = FALSE ;

  hSpacing = PANEL_HSPACING;
  vSpacing = PANEL_VSPACING;
  
  initial_hspacing = hSpacing ;
  initial_vspacing = vSpacing ;

  current_hspacing = hSpacing ;
  current_vspacing = vSpacing ;
  new_line = TRUE;
  firstRowWidget = NULL;
  lastWidget = NULL;
  dialogShell = NULL;
  panelWidget = NULL;
  handle = NULL;
#endif
#ifdef wx_xview
  frame = 0;
  handle = NULL;
#endif
  modal = FALSE;
}

#ifdef wx_motif
void UnmapBulletinBoard(Widget dialog,wxDialogBox *client,XtPointer call)
{
  client->modal_showing = FALSE ;
  client->is_show = FALSE ;
}
#endif

wxDialogBox::wxDialogBox(wxFrame *Parent, char *Title, Bool Modal, 
                         int x, int y, int width, int height,
                         int style, char *name):
  wxbDialogBox(Parent, Title, Modal, x, y, width, height, style, name)
{
  Create(Parent, Title, Modal, x, y, width, height, style, name);
}

Bool wxDialogBox::Create(wxFrame *Parent, char *Title, Bool Modal, 
                         int x, int y, int width, int height,
                         int style, char *name)
{
  wxbDialogBox::Create(Parent, Title, Modal, x, y, width, height, style, name);


  has_child = FALSE ;

  hSpacing = PANEL_HSPACING;
  vSpacing = PANEL_VSPACING;
  
  initial_hspacing = hSpacing ;
  initial_vspacing = vSpacing ;

  current_hspacing = hSpacing ;
  current_vspacing = vSpacing ;

  if (Title)
    dialogTitle = copystring(Title);

  if (Parent) Parent->AddChild(this);
  window_parent = Parent;

  is_show = FALSE;

  if (x < 0) x = wxDIALOG_DEFAULT_X;
  if (y < 0) y = wxDIALOG_DEFAULT_Y;

#ifdef wx_motif
  invisibleResize = style & wxMOTIF_RESIZE ;
  windowName = copystring(name);

  borderWidget = 0;
  wxType = 1;
  hSpacing = PANEL_HSPACING;
  vSpacing = PANEL_VSPACING;
  absolutePositioning = FALSE;

  new_line = TRUE;
  firstRowWidget = NULL;
  lastWidget = NULL;

  if (style & wxABSOLUTE_POSITIONING)
    absolutePositioning = TRUE;

//  dialogShell = XtAppCreateShell(NULL, windowName,
//         topLevelShellWidgetClass, XtDisplay(wxTheApp->topLevel), NULL, 0);

  // Create dialog box as BulletinBoard. It seems better to me (Patrick), Dialog are
  // always over parent's frame.
  // Side effect: no Minimize/Maximize buttons
  if (Parent)
    dialogShell = XmCreateBulletinBoardDialog(Parent->frameShell,windowName,NULL,0);
  else
    dialogShell = XmCreateBulletinBoardDialog(wxTheApp->topLevel,windowName,NULL,0);

  // We don't want margins, since there is enough elsewhere.
  if (invisibleResize)
  {
    XtVaSetValues(dialogShell,
          XmNmarginHeight,   0,
          XmNmarginWidth,    0,
          XmNresizePolicy, XmRESIZE_ANY,
          NULL) ;
    panelWidget = XtVaCreateManagedWidget("panel",
                  absolutePositioning ?
                     xmBulletinBoardWidgetClass: xmFormWidgetClass, dialogShell,
                  XmNx, 0,
                  XmNy, 0,
                  NULL);
  }
  else
  {
    XtVaSetValues(dialogShell,
          XmNmarginHeight,   0,
          XmNmarginWidth,    0,
//          XmNresizePolicy, XmRESIZE_ANY, // ALS's CHANGE, BEFORE I DID MINE!!!
          NULL) ;
    panelWidget = XtVaCreateManagedWidget("panel",
                  absolutePositioning ?
                     xmBulletinBoardWidgetClass: xmFormWidgetClass, dialogShell,
                  XmNx, 0,
                  XmNy, 0,
                  XmNresizePolicy, XmRESIZE_NONE,
                  NULL);
  }


/*
  if (Title)
    XtVaSetValues(dialogShell, 
                  XmNtitle, Title,
                  NULL);

  XtVaSetValues(dialogShell, 
                 XmNallowShellResize, True,
                 XmNdeleteResponse, XmDO_NOTHING,
                 XmNmappedWhenManaged, False,
                 NULL);
*/

  Widget shell = XtParent(dialogShell) ;
  XtVaSetValues(shell,
                XmNallowShellResize,True,
                NULL) ;

 if (Title)
  {
    XmString str = XmStringCreateSimple(Title);
    XtVaSetValues(dialogShell,
                  XmNdialogTitle, str,
                  NULL);
    XmStringFree(str);
  }

  /*
   * CAN ANYONE explain why the border of a dialog box is messed up by widgets,
   * to the bottom and right of the box? Why does the form allow this to happen?
   * This attempt below doesn't work, it obliterates the bottom and right
   * borders, but at least it looks more consistent than mouse-bites.
   *
   */

  // Put a rowcolumn to the right and along the bottom as a border
  if (invisibleResize)
  {
    // I don't know if it is really necessary, and I've no time to
    // verify this. Nevertheless, old method (invisibleResize) uses them.
    XtVaCreateManagedWidget("rowcol",
                  xmRowColumnWidgetClass, panelWidget,
                  XmNorientation, XmVERTICAL,
                  XmNtopAttachment,        XmATTACH_FORM,
                  XmNbottomAttachment,     XmATTACH_FORM,
                  XmNrightAttachment,      XmATTACH_FORM,
                  XmNwidth, 2,
                  NULL);
    XtVaCreateManagedWidget("rowcol",
                  xmRowColumnWidgetClass, panelWidget,
                  XmNorientation, XmHORIZONTAL,
                  XmNleftAttachment,        XmATTACH_FORM,
                  XmNbottomAttachment,     XmATTACH_FORM,
                  XmNrightAttachment,      XmATTACH_FORM,
                  XmNheight, 2,
                  NULL);
  }

  if (wxWidgetHashTable->Get((long)panelWidget))
  {
    wxError("Widget table clash in wx_dialg.cc");
  }
  wxWidgetHashTable->Put((long)panelWidget, this);

  // Intercept CLOSE messages from the window manager
  Atom WM_DELETE_WINDOW = XmInternAtom(XtDisplay(shell), "WM_DELETE_WINDOW", False);
#if XmREVISION > 1
  XmAddWMProtocolCallback(shell, WM_DELETE_WINDOW, (XtCallbackProc) wxCloseDialogCallback, (XtPointer)this);
#else
#if XmREVISION == 1
  XmAddWMProtocolCallback(shell, WM_DELETE_WINDOW, (XtCallbackProc) wxCloseDialogCallback, (caddr_t)this);
#else
  XmAddWMProtocolCallback(shell, WM_DELETE_WINDOW, (void (*)())wxCloseDialogCallback, (caddr_t)this);
#endif
#endif

  XtTranslations ptr ;
  XtOverrideTranslations(panelWidget,
              ptr = XtParseTranslationTable("<Configure>: resize()"));
  XtFree((char *)ptr);

  if (invisibleResize)
  {
    if (x > -1)
      XtVaSetValues(dialogShell, XmNx, x,
                    NULL);
    if (y > -1)
      XtVaSetValues(dialogShell, XmNy, y,
                    NULL);

    if (width > -1)
      XtVaSetValues(panelWidget, XmNwidth, width, NULL);
    if (height > -1)
      XtVaSetValues(panelWidget, XmNheight, height, NULL);
  }

  XtRealizeWidget(dialogShell);

  XtAddCallback(dialogShell,XmNunmapCallback,
               (XtCallbackProc)UnmapBulletinBoard,this) ;

  // Positioning of the dialog doesn't work properly unless the dialog
  // is managed, so we manage without mapping to the screen.
  // To show, we map the shell (actually it's parent).

  if (!invisibleResize)
    XtVaSetValues(XtParent(dialogShell), XmNmappedWhenManaged, FALSE, NULL);

  handle = (char *)panelWidget;
  if (!invisibleResize)
  {
    XtManageChild(dialogShell);
    SetSize(x, y, width, height);
  }
//  XtMapWidget(XtParent(dialogShell)); // TEST ONLY
#endif
#ifdef wx_xview
  Frame parent;
  if (Parent == (wxFrame *)NULL)
    {
      parent = (Frame)NULL;
    }
  else
    {
      parent = (Frame)(Parent->GetHandle());
    };

  // The kind of frame created is given by style, so you can
  // create frame with pushpin -- but note that on other platforms,
  // you must probably emulate pushpin with a checkbox.
  // Currently, wxEnhDialogBox provides this.
  // default style is to create FRAME, except for wxEnhDialogBox.
  //
  if (style&wxXVIEW_CMD)
    frame = (Frame) xv_create(parent, FRAME_CMD, FRAME_LABEL, Title,
			      XV_X, x, XV_Y, y,
                              WIN_CLIENT_DATA, (char *)this,
                              NULL);
  else
    frame = (Frame) xv_create(parent, FRAME, FRAME_LABEL, Title,
			      XV_X, x, XV_Y, y,
                              WIN_CLIENT_DATA, (char *)this,
                              NULL);

  Bool scrollable = style & wxVSCROLL;

  Panel x_panel;
  if (style&wxXVIEW_CMD)
  {
    x_panel = (Panel)xv_get(frame,FRAME_CMD_PANEL) ;
    xv_set(x_panel,
                                   PANEL_BACKGROUND_PROC, wxPanelEventProc,
                                   PANEL_ACCEPT_KEYSTROKE, TRUE,
                                   WIN_CLIENT_DATA, (char *)this,
                                   NULL);
  }
  else
    x_panel = (Panel)xv_create(frame, scrollable ? SCROLLABLE_PANEL : PANEL,
                                   PANEL_BACKGROUND_PROC, wxPanelEventProc,
                                   PANEL_ACCEPT_KEYSTROKE, TRUE,
                                   WIN_CLIENT_DATA, (char *)this,
                                   NULL);
  Scrollbar sb; 
  if (scrollable)
    sb = xv_create(x_panel, SCROLLBAR,
                   NULL);


  if (width > -1)
  {
    xv_set(frame, XV_WIDTH, width, NULL);
    xv_set(x_panel, XV_WIDTH, width, NULL);
  }

  if (height > -1)
  {
    xv_set(frame, XV_HEIGHT, height, NULL);
    xv_set(x_panel, XV_HEIGHT, height, NULL);
  }

//  xv_set(frame, XV_SHOW, TRUE, NULL); // EXPERIMENT


  handle = (char *)x_panel;
  // Have to do this interposition to receive frame resize events
  (void)notify_interpose_event_func(frame, (Notify_func)wxDialogInterposer, NOTIFY_SAFE);
  (void)notify_interpose_destroy_func(frame, (Notify_func)wxDialogCloseInterposer);
#endif
  modal = Modal;
  return TRUE;
}

wxDialogBox::~wxDialogBox()
{
  if (dialogTitle)
    delete[] dialogTitle;
#ifdef wx_motif
  modal_showing = FALSE;
  if (!invisibleResize)
    XtUnmapWidget(dialogShell);
#endif
#ifdef wx_xview
  if (frame)
  {
    (void)notify_interpose_event_func(frame, (Notify_func)wxDummyDialogInterposer, NOTIFY_SAFE);
    xv_set(frame, WIN_CLIENT_DATA, NULL, NULL);
    xv_destroy_safe(frame);
  }
#endif
}

#ifdef wx_xview
Notify_value wxDummyDialogInterposer(Frame x_frame, Event *x_event, Notify_arg arg,
                                     Notify_event_type type)
{
  return (Notify_value)0;
}

Notify_value wxDialogInterposer(Frame x_frame, Event *x_event, Notify_arg arg,
                               Notify_event_type type)
{
  wxDialogBox *dialog = (wxDialogBox *)xv_get(x_frame, WIN_CLIENT_DATA);

  if (dialog && event_action(x_event) == WIN_RESIZE)
    {
       int width, height;
       dialog->GetSize(&width, &height);
       dialog->OnSize(width, height);

       return notify_next_event_func(x_frame, (long unsigned int)x_event, arg, type);
    }
  else return notify_next_event_func(x_frame, (long unsigned int)x_event, arg, type);
}

Notify_value
wxDialogCloseInterposer(Notify_client client, Destroy_status status)
{
  wxDialogBox *dialog = (wxDialogBox *)xv_get(client, WIN_CLIENT_DATA);

  if (status == DESTROY_CHECKING)
  {
    if (dialog)
    {
      Bool answer = dialog->OnClose();
      if (!answer || dialog->modal)
        notify_veto_destroy(client);
    }
  }
  else if (status == DESTROY_CLEANUP)
  {
    // Try to delete the wxDialogBox without allowing the Frame
    // to be deleted, since this will be done by XView
    if (dialog)
    {
      dialog->Show(FALSE);
      (void)notify_interpose_event_func(dialog->frame, (Notify_func)wxDummyDialogInterposer, NOTIFY_SAFE);
      xv_set(dialog->frame, WIN_CLIENT_DATA, NULL, NULL);

      dialog->frame = 0;
      dialog->DestroyChildren();
      delete dialog;
    }
    return notify_next_destroy_func(client, status);
  }
  else if (status == DESTROY_SAVE_YOURSELF)
  {
    // Do nothing - this is an Open Look specific feature
  }
  else  if (status == DESTROY_PROCESS_DEATH)
  { 
  };
  return NOTIFY_DONE;
}

#endif

#ifdef wx_motif
void wxDialogBox::PostDestroyChildren(void)
{
}

/*
 * It's necessary to put this dialog-specific stuff in the base class
 * because for some reason wxDialogBox::PostDestroyChildren
 * doesn't get called from ~wxWindow. Perhaps this is because C++
 * is crap. Why should the virtual member function calling rules
 * be changed just because we're in a destructor?!!
 *
 */

void wxWindow::PostDestroyChildren(void)
{
  if (wxType == 1)
  {
    wxDialogBox *box = (wxDialogBox *)this;
    XtDestroyWidget(box->dialogShell);

    // Now process all events, because otherwise
    // this might remain on the screen
    XSync(XtDisplay(wxTheApp->topLevel), FALSE);
    XEvent event;
    while (XtAppPending(wxTheApp->appContext))
    {
      XFlush(XtDisplay(wxTheApp->topLevel));
      XtAppNextEvent(wxTheApp->appContext, &event);
      XtDispatchEvent(&event);
    }
  }
}

void wxCloseDialogCallback(Widget widget, XtPointer client_data, XmAnyCallbackStruct *cbs)
{
  wxDialogBox *dialog = (wxDialogBox *)client_data;
  if (dialog && dialog->OnClose())
  {
    dialog->Show(FALSE);
    delete dialog;
  }
}

#endif

void wxDialogBox::Fit(void)
{
#ifdef wx_motif
  wxPanel::Fit(); // Doesn't work properly for dialog boxes, Motif 1.2
#endif
#ifdef wx_xview
  Panel panel = (Panel)handle;
  window_fit(panel);

  // Make sure that panel isn't too big too fit on the screen.
  // Assume that we'll be using a scrolling panel if it's really
  // big.
  int y = (int)xv_get(panel, XV_HEIGHT);
  int dx, dy;
  wxDisplaySize(&dx, &dy);
  if ((y + 40) > dy)
  {
    xv_set(panel, XV_HEIGHT, dy-40, NULL);
  }

  window_fit(frame);
#endif
}

void wxDialogBox::Iconize(Bool iconize)
{
#ifdef wx_motif
  // Can't iconize a dialog in Motif
//  XtVaSetValues(dialogShell, XmNiconic, iconize, NULL);
#endif
#ifdef wx_xview
  xv_set(frame, FRAME_CLOSED, iconize, NULL);
#endif
}

Bool wxDialogBox::Iconized(void)
{
#ifdef wx_motif
/*
  Bool iconic;
  XtVaGetValues(dialogShell, XmNiconic, &iconic, NULL);

  return iconic;
*/
  return FALSE;
#endif
#ifdef wx_xview
  return xv_get(frame, FRAME_CLOSED);
#endif
}

void wxDialogBox::SetSize(int x, int y, int width, int height)
{
#ifdef wx_motif
  Widget shell = XtParent((Widget)handle) ;
//  Widget shellParent = XtParent(shell);

  if (width > -1)
    XtVaSetValues((Widget)handle, XmNwidth, width, NULL);
  if (height > -1)
    XtVaSetValues((Widget)handle, XmNheight, height, NULL);
  if (invisibleResize)
  {
    if (width > -1)
      XtVaSetValues(dialogShell, XmNwidth, width, NULL);
    if (height > -1)
      XtVaSetValues(dialogShell, XmNheight, height, NULL);
  }

  if (x > -1)
    XtVaSetValues(shell, XmNx, x, NULL);
  if (y > -1)
    XtVaSetValues(shell, XmNy, y, NULL);
  if (!invisibleResize)
  {
    if (width > -1)
      XtVaSetValues(shell, XmNwidth, width, NULL);
    if (height > -1)
      XtVaSetValues(shell, XmNheight, height, NULL);
  }

  OnSize(width, height);
#endif
#ifdef wx_xview
  if (x == -1 || y == -1)
  {
    int xx,yy ;
    GetPosition(&xx, &yy);
    if (x == -1) x = xx ;
    if (y == -1) y = yy ;
  }
  (void)xv_set(frame, XV_X, x, XV_Y, y, NULL);

  if (width == -1 || height == -1)
  {
    int ww,hh ;
    GetSize(&ww, &hh);
    if (width == -1) width = ww ;
    if (height == -1) height = hh ;
  }
  (void)xv_set(frame, XV_WIDTH, width, XV_HEIGHT, height, NULL);

  OnSize(width, height);
#endif
}

void wxDialogBox::SetClientSize(int width, int height)
{
#ifdef wx_motif
  if (!invisibleResize)
  {
    int xx, yy;
    GetPosition(&xx, &yy);
    SetSize(xx, yy, width, height);
  }
  else
  {
    if (width > -1)
      XtVaSetValues((Widget)handle, XmNwidth, width, NULL);
    if (height > -1)
      XtVaSetValues((Widget)handle, XmNheight, height, NULL);
  }
  OnSize(width, height);
#endif
#ifdef wx_xview
  if (width > -1 && height > -1)
    (void)xv_set(frame, XV_WIDTH, width, XV_HEIGHT, height, NULL);
#endif
}

void wxDialogBox::GetPosition(int *x, int *y)
{
#ifdef wx_motif
  Dimension xx, yy;
  XtVaGetValues(dialogShell, XmNx, &xx, XmNy, &yy, NULL);
  *x = xx; *y = yy;
#endif
#ifdef wx_xview
  *x = (int)xv_get(frame, XV_X);
  *y = (int)xv_get(frame, XV_Y);
#endif
}

Bool wxDialogBox::IsShown(void)
{
  return is_show;
}

void wxDialogBox::Show(Bool show)
{
  is_show = show;
#ifdef wx_motif
  if (show)
  {
    if (!invisibleResize)
      XtMapWidget(XtParent(dialogShell));
    else
      XtManageChild(dialogShell) ; 

//    XRaiseWindow(XtDisplay(dialogShell), XtWindow(dialogShell));
//    XtManageChild(dialogShell) ; // Don't manage, map!
    if (modal)
    {
      modal_showing = TRUE;
      XtAddGrab(dialogShell, TRUE, FALSE);
      XEvent event;
      while (modal_showing || XtAppPending(wxTheApp->appContext))
      {
        XtAppNextEvent(wxTheApp->appContext, &event);
        XtDispatchEvent(&event);
      }
    }
    else
      modal_showing = FALSE;
  }
  else
  {
    if (modal_showing)
      XtRemoveGrab(dialogShell);

    if (!invisibleResize)
      XtUnmapWidget(XtParent(dialogShell));
    else
      XtUnmanageChild(dialogShell) ;

    modal_showing = FALSE;
  }
#endif
#ifdef wx_xview
  if (show)
    {
      xv_set(frame, XV_SHOW, TRUE, NULL);

      if (modal)
      {
        xv_set(frame, WIN_GRAB_ALL_INPUT, FALSE, NULL);
        xv_window_loop(frame);
       }
    }
  else
    {
     xv_set(frame, WIN_GRAB_ALL_INPUT, FALSE, NULL);

     xv_set(frame, XV_SHOW, FALSE, NULL);
     if (modal)
     {
       xv_window_return(0);
     }
    }
#endif
}


void wxDialogBox::SetTitle(char *title)
{
  if (dialogTitle)
    delete[] dialogTitle;

  dialogTitle = copystring(title);

#ifdef wx_motif
  if (title)
    XtVaSetValues(dialogShell, 
                  XmNtitle, title,
                  XmNiconName, title,
                  NULL);
#endif
#ifdef wx_xview
  xv_set(frame, FRAME_LABEL, title, NULL);
/*
  if (icon)
  {
    xv_set(icon->x_icon, XV_LABEL, title, NULL);
    xv_set(frame, FRAME_ICON, icon->x_icon, NULL);
  }
*/
#endif
}

char *wxDialogBox::GetTitle(void)
{
  return dialogTitle;
}

/*
 * Common dialogs code
 *
 */

// Pop up a message box
int wxMessageBox(char *message, char *caption, int style,
                 wxFrame *parent, int x, int y)
{
  return wxbMessageBox(message, caption, style, parent, x, y);
}
    		 
char *wxFileSelector(char *message,
                     char *default_path, char *default_filename, 
                     char *default_extension, char *wildcard, int flags,
                     wxFrame *parent, int x, int y)
{
  if (x < 0) x = wxDIALOG_DEFAULT_X;
  if (y < 0) y = wxDIALOG_DEFAULT_Y;
#ifdef wx_motif
  return wxMotifFileSelector(message, default_path, default_filename, 
                     default_extension, wildcard, flags,
                     parent, x, y);
#endif
#ifdef wx_xview
  char buf[400];
  if (!default_path)
    default_path = getcwd(buf, 400);
  if (!default_filename)
    default_filename = "";

  return wxXFileSelector(parent, default_path, default_filename, message, flags, wildcard);
#endif
}

#ifdef wx_xview
void wxReadDir(wxListBox *filebox, wxListBox *dirbox, char *path, char *filename, DIR *dirp)
{
  filebox->Show(FALSE);
  filebox->Clear();
  dirbox->Show(FALSE);
  dirbox->Clear();
  struct dirent *dir;

  dirbox->Append("..");

  DIR *dirstream = NULL;
  if ((dir=readdir(dirp))==NULL)
  {
	printf("There has been an error in opening the directory\n");
	return;
  }

  char buf[400];

  // Skip the first directory (.)

  wxStringList files;
  wxStringList dirs;

  while((dir=readdir(dirp))!=NULL)
  {
    strcpy(buf, path);
    int len = strlen(buf);

    if (buf[len - 1] != '/')
      strcat(buf, "/");

    strcat(buf, dir->d_name);
    // The readdir is necessary on some systems since opendir
    // can open a file successfully, but readdir fails
    // on reading from a file.
    if ((dirstream = opendir(buf)) && (readdir(dirstream)))
    {
      closedir(dirstream);

      if (dir->d_name[0] != '.')
        dirs.Add(dir->d_name);
    }
    else if (!wxIsWild(filename) || wxMatchWild(filename, dir->d_name))
      files.Add(dir->d_name);

  }
  files.Sort();
  dirs.Sort();

  wxNode *node = files.First();
  while (node)
  {
    char *s = (char *)node->Data();
    filebox->Append(s);
    delete[] s;
    delete node;
    node = files.First();
  }

  node = dirs.First();
  while (node)
  {
    char *s = (char *)node->Data();
    dirbox->Append(s);
    delete[] s;
    delete node;
    node = dirs.First();
  }

  filebox->Show(TRUE);
  dirbox->Show(TRUE);
}

class wxXFileSelDialog: public wxDialogBox
{
 public:
  char *wild_card;
  wxText *name_item;
  wxText *path_item;
  wxListBox *list_item;
  wxListBox *file_item;
  wxListBox *dir_item;
  wxXFileSelDialog(wxFrame *frame, char *title, Bool modal = FALSE,
              int x = -1, int y = -1, int
              width = -1, int height = -1);
};

wxXFileSelDialog::wxXFileSelDialog(wxFrame *frame, char *title, Bool modal,
              int x, int y, int width, int height):
  wxDialogBox(frame, title, modal, x, y, width, height)
{
}

void wxXFileSelPath(wxText& text, wxEvent& event)
{
}

void wxStripOneDir(char *dir)
{
  int len = strlen(dir);
  if (len > 1)
  {
    int i = len - 1;
    char ch = 0;
    while (ch != '/' && i > 0)
    {
      ch = dir[i];
      i --;
    }
    i ++;
    if (i == 0)
      i ++;
    dir[i] = 0;
  }
}


void wxXFileSelDirList(wxListBox& listbox, wxEvent& event)
{
  char *name = copystring(listbox.GetStringSelection());
  wxXFileSelDialog *dialog = (wxXFileSelDialog *)listbox.GetParent();

  char *path = copystring(dialog->path_item->GetValue());
  char buf[500];
  strcpy(buf, path);

  int len = strlen(buf);

  if (strcmp(name, "..") == 0)
  {
    wxStripOneDir(buf);
  }
  else
  {
    if (buf[len - 1] != '/')
      strcat(buf, "/");
    strcat(buf, name);
  }

  DIR *dirstream = NULL;
  if (dirstream = opendir(buf))
  {
    dialog->path_item->SetValue(buf);
    wxReadDir(dialog->file_item, &listbox, buf, dialog->name_item->GetValue(), dirstream);
    closedir(dirstream);
  }
  else dialog->name_item->SetValue(name);
}

void wxXFileSelFileList(wxListBox& listbox, wxEvent& event)
{
  char *name = copystring(listbox.GetStringSelection());
  wxXFileSelDialog *dialog = (wxXFileSelDialog *)listbox.GetParent();

  dialog->name_item->SetValue(name);
}

int wxXFileSelResponse = 0;
char *wxXFileSelAnswer = NULL;

void wxXFileSelOK(wxButton& ok, wxEvent& event)
{
  wxXFileSelDialog *dialog = (wxXFileSelDialog *)ok.GetParent();
  char *nameval = dialog->name_item->GetValue();
  char *pathval = dialog->path_item->GetValue();
  if (wxIsWild(nameval))
  {
    DIR *dirstream = NULL;
    if (dirstream = opendir(pathval))
    {
      wxReadDir(dialog->file_item, dialog->dir_item, pathval, nameval, dirstream);
      closedir(dirstream);
    }
    return;
  }

  char *name = copystring(nameval);
  char *path = copystring(pathval);

  char buf[400];
  strcpy(buf, path);
  int len = strlen(buf);
  if (buf[len - 1] != '/')
    strcat(buf, "/");
  strcat(buf, name);

  delete[] name;
  delete[] path;

  if (wxXFileSelAnswer)
    delete[] wxXFileSelAnswer;

  wxXFileSelAnswer = copystring(buf);  

  dialog->Show(FALSE);
  delete dialog;

  wxXFileSelResponse = 1;
}

void wxXFileSelCancel(wxButton& cancel, wxEvent& event)
{
  wxXFileSelDialog *dialog = (wxXFileSelDialog *)cancel.GetParent();
  wxXFileSelResponse = 0;
  dialog->Show(FALSE);
  delete dialog;
}

char *wxXFileSelector(wxFrame *parent, char *path, char *file, char *message, int flags, char *wild_card)
{
  wxXFileSelResponse = 0;
  DIR *dirstream;
  if (!path)
  {
    char buf[400];
    path = getcwd(buf, 400);
  }
  if (!file)
    file = "";

  if ((dirstream=opendir(path))!=NULL)
  {
    wxXFileSelDialog *dialog = new wxXFileSelDialog(parent, "File selector", TRUE, 150, 150, 800, 800);

    (void)new wxMessage(dialog, message);
    dialog->NewLine();
    wxText *name_text = new wxText(dialog, (wxFunction)NULL, "Name", file, -1, -1, 300, -1);
    dialog->NewLine();
    wxText *path_text = new wxText(dialog, (wxFunction)wxXFileSelPath, "Path", path, -1, -1, 350, -1);
    dialog->NewLine();
    wxListBox *filebox = new wxListBox(dialog, (wxFunction)wxXFileSelFileList, "Files", wxSINGLE,
                                       4, 80, 200, 300);
    wxListBox *dirbox = new wxListBox(dialog, (wxFunction)wxXFileSelDirList, "Directories", wxSINGLE,
                                      -1, -1, 200, 300);
    dialog->NewLine();

    (void)new wxButton(dialog, (wxFunction)wxXFileSelOK, "OK");
    (void)new wxButton(dialog, (wxFunction)wxXFileSelCancel, "Cancel");

    dialog->path_item = path_text;
    dialog->name_item = name_text;
    dialog->dir_item = dirbox;
    dialog->file_item = filebox;
    dialog->wild_card = wild_card;

    dialog->Fit();

    char *initial_name = file;
    if (((initial_name == NULL) || (strcmp(initial_name, "") == 0)) &&
        wild_card)
    {
      initial_name = wild_card;
      dialog->name_item->SetValue(initial_name);
    }

    wxReadDir(filebox, dirbox, path, initial_name, dirstream);
    dialog->Show(TRUE);

    if (wxXFileSelResponse == 0)
      return NULL;
    else
    {
      if ((flags & wxOVERWRITE_PROMPT) && FileExists(wxXFileSelAnswer))
      {
        char buf[200];
        sprintf(buf, "Overwrite existing file %s?", wxXFileSelAnswer);
        int ans = wxMessageBox(buf, "Warning", wxYES_NO);
        if (ans == wxYES)
        {
          strcpy(wxBuffer, wxXFileSelAnswer);
          return wxBuffer;
        }
        else return NULL;
      }
      else
      {
        strcpy(wxBuffer, wxXFileSelAnswer);
        return wxBuffer;
      }
    }
  }
  else return NULL;
}
#endif

#ifdef wx_motif
char *wxFileSelectorAnswer = NULL;
Bool wxFileSelectorReturned = FALSE;

void wxFileSelCancel(Widget fs, XtPointer client_data, XmFileSelectionBoxCallbackStruct *cbs)
{
  wxFileSelectorAnswer = NULL;
  wxFileSelectorReturned = TRUE;
}

void wxFileSelOk(Widget fs, XtPointer client_data, XmFileSelectionBoxCallbackStruct *cbs)
{
  char *filename = NULL;
  if (!XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename))
  {
    wxFileSelectorAnswer = NULL;
    wxFileSelectorReturned = TRUE;
  }
  else
  {
    if (filename)
    {
      if (wxFileSelectorAnswer) delete[] wxFileSelectorAnswer;
      wxFileSelectorAnswer = copystring(filename);
      XtFree(filename);
    }
    wxFileSelectorReturned = TRUE;
  }
}

char *wxMotifFileSelector(char *message,
                     char *default_path, char *default_filename, 
                     char *default_extension, char *wildcard, int flags,
                     wxFrame *parent, int x, int y)
{
  static char fileBuf[400];
  Widget parentWidget;
  if (parent)
    parentWidget = parent->frameShell;
  else
    parentWidget = wxTheApp->wx_frame->frameShell;

  Widget fileSel = XmCreateFileSelectionDialog(parentWidget, "file_selector", NULL, 0);
  XtUnmanageChild(XmFileSelectionBoxGetChild(fileSel, XmDIALOG_HELP_BUTTON));

  Widget shell = XtParent(fileSel);

  if (message)
    XtVaSetValues(shell, XmNtitle, message, NULL);


  char *entirePath = NULL;

  if (default_path && default_filename)
  {
    sprintf(wxBuffer, "%s/%s", default_path, default_filename);
    entirePath = copystring(wxBuffer);
  }
  else if (default_path && !default_filename)
  {
    sprintf(wxBuffer, "%s/", default_path);
    entirePath = copystring(wxBuffer);
  }
  else if ((!default_path) && default_filename)
  {
    sprintf(wxBuffer, "%s", default_filename);
    entirePath = copystring(wxBuffer);
  }

  if (entirePath)
  {
    Widget selectionWidget = XmFileSelectionBoxGetChild(fileSel, XmDIALOG_TEXT);
    XmTextSetString(selectionWidget, entirePath);
    delete[] entirePath;
  }

  if (wildcard)
  {
    if (default_path)
      sprintf(wxBuffer, "%s/%s", default_path, wildcard);
    else
      sprintf(wxBuffer, "%s", wildcard);

    Widget filterWidget = XmFileSelectionBoxGetChild(fileSel, XmDIALOG_FILTER_TEXT);
    XmTextSetString(filterWidget, wxBuffer);
    XmFileSelectionDoSearch(fileSel, NULL);
  }

  XtAddCallback(fileSel, XmNcancelCallback, (XtCallbackProc)wxFileSelCancel, (XtPointer)NULL);
  XtAddCallback(fileSel, XmNokCallback, (XtCallbackProc)wxFileSelOk, (XtPointer)NULL);

//#if XmVersion > 1000
// I'm not sure about what you mean with XmVersion.
// If this is for Motif1.1/Motif1.2, then check XmVersion>=1200
// (Motif1.1.4 ==> XmVersion 1100 )
// Nevertheless, I put here a #define, so anyone can choose in (I)makefile...
//
#ifndef DEFAULT_FILE_SELECTOR_SIZE
  int width = 600;
  int height = 500;
  XtVaSetValues(fileSel,
                 XmNwidth, width,
                 XmNheight, height,
                 XmNresizePolicy, XmRESIZE_NONE,
                 NULL);
#endif

  XtManageChild(fileSel);

  if (wxFileSelectorAnswer)
    delete[] wxFileSelectorAnswer;

  wxFileSelectorAnswer = NULL;
  wxFileSelectorReturned = FALSE;

  XtAddGrab(XtParent(fileSel), TRUE, FALSE);
  XEvent event;
  while (!wxFileSelectorReturned)
  {
    XtAppNextEvent(wxTheApp->appContext, &event);
    XtDispatchEvent(&event);
  }
  XtRemoveGrab(XtParent(fileSel));

//  XtDestroyWidget(fileSel);
  XtUnmapWidget(XtParent(fileSel));
  XtDestroyWidget(XtParent(fileSel));

  // Now process all events, because otherwise
  // this might remain on the screen
  XSync(XtDisplay(wxTheApp->topLevel), FALSE);
  while (XtAppPending(wxTheApp->appContext))
  {
    XFlush(XtDisplay(wxTheApp->topLevel));
    XtAppNextEvent(wxTheApp->appContext, &event);
    XtDispatchEvent(&event);
  }

  if (wxFileSelectorAnswer)
  {
    strcpy(fileBuf, wxFileSelectorAnswer);
    return fileBuf;
  }
  else return NULL;
}
#endif
