/*
 * File:	wx_utils.cc
 * Purpose:	Various utilities
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include "wx.h"
#pragma hdrstop

#include <iostream.h>
#include <fstream.h>
#include <ctype.h>
#include <direct.h>

#ifdef __BORLANDC__
#include <dir.h>
#else
#include <dos.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdarg.h>

/*
#include <windows.h>
#include "common.h"
#include "wx_utils.h"
#include "wx_main.h"
*/

// Get hostname. Under Windows, it's "windows". We don't deal with
// networks yet.
Bool wxGetHostName(char *buf, int maxSize)
{
  strncpy(buf, "windows", maxSize - 1);
  return TRUE;
}

// Get user ID e.g. jacs
Bool wxGetUserId(char *buf, int maxSize)
{
  strncpy(buf, "user", maxSize - 1);
  return TRUE;
}

// Get user name e.g. Julian Smart
Bool wxGetUserName(char *buf, int maxSize)
{
  strncpy(buf, "unknown", maxSize - 1);
  return TRUE;
}

// Execute a command (e.g. another program) in a
// system-independent manner.
// Well - not quite. Note that under UNIX, the call will only
// return immediately if an ampersand is appended to the command.
// Under Windows, the call returns immediately.
Bool wxExecute(char *command)
{
  int error = WinExec(command, SW_SHOW);
  if (error >= 32)
    return TRUE;
  else
    return FALSE;
}

Bool wxRemoveFile(char *file)
{
// Zortech -- what's the proper define?
#ifdef ZTC
  int flag = unlink(file);
#else
  int flag = remove(file);
#endif
  if (flag == 0) return TRUE;
  return FALSE;
}

Bool wxMkdir(char *dir)
{
  return (mkdir(dir) == 0);
}

Bool wxRmdir(char *dir)
{
  return (rmdir(dir) == 0);
}

Bool DirExists(char *dir)
{
// Not sure about these...
#ifdef WIN32
 WIN32_FIND_DATA fileInfo;
#else
#ifdef __BORLANDC__
  struct ffblk fileInfo;
#else
  struct _find_t fileInfo;
#endif
#endif

#ifdef WIN32
  wxMessageBox("Don't know how to test for a directory under NT!\nSee wx_utils.cc, DirExists.");
  // Something like FindFirstFile(dir, &fileInfo);
  return TRUE;
#else
  return (_dos_findfirst(dir, _A_SUBDIR, &fileInfo) == 0);
#endif
}

// Get a temporary filename, opening and closing the file.
void wxGetTempFileName(char *prefix, char *buf)
{
  ::GetTempFileName(0, prefix, 0, buf);
}

// Get free memory in bytes, or -1 if cannot determine amount (e.g. on UNIX)
long wxGetFreeMemory(void)
{
  return (long)GetFreeSpace(0);
}

// Sleep for nSecs seconds under UNIX, do nothing under Windows
// XView implementation according to the Heller manual
void wxSleep(int nSecs)
{
}

// Consume all events until no more left
void wxFlushEvents(void)
{
}

// Output a debug mess., in a system dependent fashion.
void wxDebugMsg(char *fmt ...)
{
  va_list ap;
  static char buffer[512];

  va_start(ap, fmt);

  wvsprintf(buffer,fmt,ap) ;
  OutputDebugString(buffer) ;

  va_end(ap);
}

// Non-fatal error: pop up message box and (possibly) continue
void wxError(char *msg, char *title)
{
  sprintf(wxBuffer, "%s\nContinue?", msg);
  if (MessageBox(NULL, (LPCSTR)wxBuffer, (LPCSTR)title,
             MB_ICONSTOP | MB_YESNO) == IDNO)
    wxExit();
}

// Fatal error: pop up message box and abort
void wxFatalError(char *msg, char *title)
{
  sprintf(wxBuffer, "%s: %s", title, msg);
  FatalAppExit(0, (LPCSTR)wxBuffer);
}

// Emit a beeeeeep
void wxBell(void)
{
#ifdef WIN32
  Beep(1000,1000) ;	// 1kHz during 1 sec.
#else
  MessageBeep(-1) ;
#endif
}


// Reading and writing resources (eg WIN.INI, .Xdefaults)
#if USE_RESOURCES
Bool wxWriteResource(char *section, char *entry, char *value, char *file)
{
  if (file)
    return WritePrivateProfileString((LPCSTR)section, (LPCSTR)entry, (LPCSTR)value, (LPCSTR)file);
  else
    return WriteProfileString((LPCSTR)section, (LPCSTR)entry, (LPCSTR)value);
}

Bool wxWriteResource(char *section, char *entry, float value, char *file)
{
  char buf[50];
  sprintf(buf, "%.4f", value);
  return wxWriteResource(section, entry, buf, file);
}

Bool wxWriteResource(char *section, char *entry, long value, char *file)
{
  char buf[50];
  sprintf(buf, "%ld", value);
  return wxWriteResource(section, entry, buf, file);
}

Bool wxWriteResource(char *section, char *entry, int value, char *file)
{
  char buf[50];
  sprintf(buf, "%d", value);
  return wxWriteResource(section, entry, buf, file);
}

Bool wxGetResource(char *section, char *entry, char **value, char *file)
{
  if (file)
  {
    int n = GetPrivateProfileString((LPCSTR)section, (LPCSTR)entry, (LPCSTR)"$$default",
                                    (LPSTR)wxBuffer, 1000, (LPCSTR)file);
    if ((n != 0) && (strcmp(wxBuffer, "$$default") != 0))
    {
      *value = copystring(wxBuffer);
      return TRUE;
    }
    else return FALSE;
  }
  else
  {
    int n = GetProfileString((LPCSTR)section, (LPCSTR)entry, (LPCSTR)"$$default",
                                    (LPSTR)wxBuffer, 1000);
    if ((n != 0) && (strcmp(wxBuffer, "$$default") != 0))
    {
      *value = copystring(wxBuffer);
      return TRUE;
    }
    else return FALSE;
  }
}

Bool wxGetResource(char *section, char *entry, float *value, char *file)
{
  char *s = NULL;
  Bool succ = wxGetResource(section, entry, &s, file);
  if (succ)
  {
    *value = (float)strtod(s, NULL);
    delete[] s;
    return TRUE;
  }
  else return FALSE;
}

Bool wxGetResource(char *section, char *entry, long *value, char *file)
{
  char *s = NULL;
  Bool succ = wxGetResource(section, entry, &s, file);
  if (succ)
  {
    *value = strtol(s, NULL, 10);
    delete[] s;
    return TRUE;
  }
  else return FALSE;
}

Bool wxGetResource(char *section, char *entry, int *value, char *file)
{
  char *s = NULL;
  Bool succ = wxGetResource(section, entry, &s, file);
  if (succ)
  {
    *value = (int)strtol(s, NULL, 10);
    delete[] s; 
    return TRUE;
  }
  else return FALSE;
}
#endif // USE_RESOURCES
