/*
 * File:	wx_text.cc
 * Purpose:	wxTextWindow implementation
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include "wx.h"
#pragma hdrstop

#include "wx_privt.h"
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>

/*
#include <windows.h>
#include "common.h"
#include "wx_main.h"
#include "wx_text.h"
#include "wx_utils.h"
#include "wx_frame.h"
*/

#if (!EDITABLE_TEXT_WINDOW)
class wxTextWnd : public wxSubWnd
{
public:
  wxStringList lines;
  int no_lines;
  int current_line;

  int cxChar;
  int cyChar;

  int cxClient;
  int cyClient;

  wxTextWnd(wxWnd *parent, wxWindow *wx_win,
             int x, int y, int width, int height, DWORD style);
  ~wxTextWnd();

  void CalcNewSize(int x, int y);

  void OnCreate(void);
  BOOL OnPaint(void);
  void OnSize(int x, int y, UINT);

  void WriteText(char *text);

};
#endif // EDITABLE_TEXT_WINDOW

wxTextWindow::wxTextWindow(void)
{
  file_name = NULL;
#if EDITABLE_TEXT_WINDOW
  wxWinType = wxTYPE_HWND;
#else
  wxWinType = wxTYPE_XWND;
#endif
  handle = NULL;
}

wxTextWindow::wxTextWindow(wxFrame *frame, int x, int y, int width, int height,
                           int style, char *name):
  wxbTextWindow(frame, x, y, width, height, style, name)

{
  Create(frame, x, y, width, height, style, name);
}

Bool wxTextWindow::Create(wxFrame *frame, int x, int y, int width, int height,
                           int style, char *name)
{
  file_name = NULL;
  insertionPoint = 0;
#if EDITABLE_TEXT_WINDOW
  wxWinType = wxTYPE_HWND;
#else
  wxWinType = wxTYPE_XWND;
#endif
  wxWnd *cparent = NULL;
  if (frame)
    cparent = (wxWnd *)frame->handle;

#if EDITABLE_TEXT_WINDOW
  windows_id = (int)NewId();
  HWND edit = CreateWindowEx(0, "EDIT", label,
               ES_MULTILINE | ES_AUTOHSCROLL | ES_LEFT | ES_WANTRETURN |
               WS_BORDER | WS_VISIBLE | WS_CHILD | WS_TABSTOP |
               WS_HSCROLL | WS_VSCROLL,
               0, 0, 0, 0, cparent->handle, (HMENU)windows_id,
               wxhInstance, NULL);
#if CTL3D
  Ctl3dSubclassCtl(edit);
#endif

  ms_handle = (char *)edit;

/*
  HDC the_dc = GetWindowDC((HWND)ms_handle) ;
  if (buttonFont && buttonFont->GetInternalFont(the_dc))
    SendMessage((HWND)ms_handle,WM_SETFONT,
                (WPARAM)buttonFont->GetInternalFont(the_dc),0L);
  ReleaseDC((HWND)ms_handle,the_dc) ;
*/

  SetSize(x, y, width, height);
#else
  DWORD ms_flags = WS_HSCROLL | WS_VSCROLL | WS_CHILD | WS_VISIBLE;
  if (style & wxBORDER)
    ms_flags |= WS_BORDER;
  handle = (char *)new wxTextWnd(cparent, this, x, y, width, height, ms_flags);
#endif
  if (frame) frame->AddChild(this);
  return TRUE;
}

wxTextWindow::~wxTextWindow(void)
{
  if (file_name)
    delete[] file_name;
}

Bool wxTextWindow::LoadFile(char *file)
{
  if (!file || !FileExists(file))
    return FALSE;

  if (file_name)
    delete[] file_name;

 file_name = copystring(file);

 Clear();

 ifstream input(file, ios::nocreate | ios::in);

 if (!input.bad())
 {
#if EDITABLE_TEXT_WINDOW
  int no_lines = 0;
  int pos = 0;
  while (!input.eof())
  {
    input.getline(wxBuffer, 500);
    int len = strlen(wxBuffer);
    wxBuffer[len] = 13;
    wxBuffer[len+1] = 10;
    wxBuffer[len+2] = 0;
    SendMessage((HWND)ms_handle, EM_SETSEL, 0, MAKELONG(pos, pos));
    SendMessage((HWND)ms_handle, EM_REPLACESEL, 0, (LPARAM)wxBuffer);
    pos += strlen(wxBuffer);
    no_lines ++;
  }
#else
   wxTextWnd *text_win = (wxTextWnd *)handle;
   while (!input.eof())
   {
     input.getline(wxBuffer, 500);
//     text_win->lines[text_win->no_lines] = copystring(wxBuffer);
     text_win->lines.Add(wxBuffer);
     text_win->no_lines ++;
   }
   if (text_win->no_lines > 0)
     text_win->current_line = text_win->no_lines - 1;
   else text_win->current_line = 0;


   RECT rect;
   GetClientRect(text_win->handle, &rect);
   text_win->OnSize(rect.right, rect.bottom, 0);
   InvalidateRgn(text_win->handle, NULL, TRUE);
   UpdateWindow(text_win->handle);
#endif
   return TRUE;
 }
 return FALSE;
}

// If file is null, try saved file name first
// Returns TRUE if succeeds.
Bool wxTextWindow::SaveFile(char *file)
{
  if (!file)
    file = file_name;
  if (!file)
    return FALSE;
#if EDITABLE_TEXT_WINDOW
 return FALSE;
#else
 if (file_name) delete[] file_name;
 file_name = copystring(file);

 ofstream output(file);

 if (!output.bad())
 {
  wxTextWnd *text_win = (wxTextWnd *)handle;
/*
  for (int i = 0; i < text_win->no_lines; i++)
  {
    if (text_win->lines[i])
      output << text_win->lines[i] << "\n";
  }
*/
  wxNode *node = text_win->lines.First();
  while (node)
  {
    char *s = (char *)node->Data();
    if (s)
      output << s << "\n";
    node = node->Next();
  }
  return TRUE;
 }
 return FALSE;
#endif
}

void wxTextWindow::WriteText(char *text)
{
#if EDITABLE_TEXT_WINDOW
    SendMessage((HWND)ms_handle, EM_REPLACESEL, 0, (LPARAM)text);
#else
  char *the_text = copystring(text);  // Necessary in case text points to
                                      // wxBuffer

  wxTextWnd *text_win = (wxTextWnd *)handle;
  int len = strlen(the_text);

  Bool text_end = FALSE;

  int i = 0;
  while (!text_end)
  {
    int j = 0;
    Bool eol = FALSE;
    wxNode *current_node = text_win->lines.Nth(text_win->current_line);
    char *s = (char *)current_node->Data();
    int old_line_length = strlen(s);
    strcpy(wxBuffer, s);

    while (!eol && !text_end)
    {
      if (i == len)
      {
        wxBuffer[j+old_line_length] = 0;
        text_end = TRUE;
      }
      else
      {
        char ch = the_text[i];

        if (ch == '\n' || (j+old_line_length) > 490)
        {
          eol = TRUE;
          wxBuffer[j+old_line_length] = 0;
          if ((j + old_line_length) > 490)
          {
            i --; j --;
          }
        }
        else
        {
          wxBuffer[j+old_line_length] = ch;
        }
        i ++;
        j ++;
      }
    }
    delete[] s;
    current_node->SetData((wxObject *)copystring(wxBuffer));

    HDC dc = GetDC(text_win->handle);
    SetTextColor(dc, GetSysColor(COLOR_WINDOWTEXT));
    SetBkColor(dc, GetSysColor(COLOR_WINDOW));
    HFONT oldFont = ::SelectObject(dc, font->GetInternalFont(dc));

    int x = (text_win->cxChar) * (1 - text_win->xscroll_position);
    int y = (text_win->cyChar) * (text_win->current_line - text_win->yscroll_position);
    TextOut(dc, x, y, wxBuffer, strlen(wxBuffer));
    ::SelectObject(dc, oldFont);
    ReleaseDC(text_win->handle, dc);

    if (eol)
    {
      text_win->current_line ++;
      text_win->no_lines ++;
      text_win->lines.Add("");

      RECT rect;
      GetClientRect(text_win->handle, &rect);
      text_win->CalcNewSize(rect.right, rect.bottom);

      if (y >= (rect.bottom - text_win->cyChar))
        text_win->OnVScroll(SB_BOTTOM, 0, NULL);

//        (void)wxYield();
    }
  }
  delete[] the_text;
#endif
}

void wxTextWindow::SetSize(int x, int y, int w, int h)
{
  int currentX, currentY;
  GetPosition(&currentX, &currentY);
  if (x == -1)
    x = currentX;
  if (y == -1)
    y = currentY;

  int currentW,currentH;
  GetSize(&currentW, &currentH);
  if (w == -1)
    w = currentW ;
  if (h == -1)
    h = currentH ;

#if EDITABLE_TEXT_WINDOW
  MoveWindow(ms_handle, x, y, w, h, TRUE);
#else
  wxWnd *wnd = (wxWnd *)handle;
  if (wnd)
    MoveWindow(wnd->handle, x, y, w, h, TRUE);
#endif
  OnSize(w, h);
}

void wxTextWindow::Clear(void)
{
#if EDITABLE_TEXT_WINDOW
 SendMessage((HWND)ms_handle, WM_SETTEXT, 0, (LPARAM)"");
#else
  wxTextWnd *text_win = (wxTextWnd *)handle;
  wxNode *node = text_win->lines.First();
  while (node)
  {
    char *s = (char *)node->Data();
    delete[] s;
    delete node;
    node = text_win->lines.First();
  }
  text_win->lines.Add("");
  text_win->no_lines = 1;
  text_win->current_line = 0;

  RECT rect;
  GetClientRect(text_win->handle, &rect);
  text_win->OnSize(rect.right, rect.bottom, 0);
  InvalidateRgn(text_win->handle, NULL, TRUE);
#endif
}

Bool wxTextWindow::Modified(void)
{
  return FALSE;
}

// Not clear whether Clear is required as well as DiscardEdits
void wxTextWindow::DiscardEdits(void)
{
  Clear();
}

char *wxTextWindow::GetContents(void)
{
  wxTextWnd *text_win = (wxTextWnd *)handle;
  // Count size of buffer required
  int i = 0;
  wxNode *node = text_win->lines.First();
  while (node)
  {
    char *s = (char *)node->Data();
    i += strlen(s) + 1; // Add one for a newline
    node = node->Next();
  }
  char *buf = new char[i+1];
  i = 0;
  node = text_win->lines.First();
  while (node)
  {
    char *s = (char *)node->Data();
    int len = strlen(s);
    for (int j = 0; j < len; j++)
    {
      buf[i] = s[j];
      i ++;
    }
    buf[i] = '\n';
    i ++;
    
    node = node->Next();
  }
  buf[i] = 0;
  
  return buf;
}

/*
 * Functions yet to be implemented
 *
 */
 
int wxTextWindow::GetNumberOfLines(void)
{
  wxTextWnd *text_win = (wxTextWnd *)handle;
  return text_win->lines.Number();
}

void wxTextWindow::SetInsertionPoint(long pos)
{
  insertionPoint = pos;
}

void wxTextWindow::SetInsertionPointEnd(void)
{
}

long wxTextWindow::GetInsertionPoint(void)
{
  return insertionPoint;
}

long wxTextWindow::GetLastPosition(void)
{
  return 0;
}

long wxTextWindow::XYToPosition(long x, long y)
{
  return 0;
}

void wxTextWindow::PositionToXY(long *x, long *y)
{
}

void wxTextWindow::ShowPosition(long pos)
{
}

int wxTextWindow::GetLineLength(long lineNo)
{
  wxTextWnd *text_win = (wxTextWnd *)handle;
  wxNode *node = text_win->lines.Nth((int)lineNo);
  if (node)
  {
    char *s = (char *)node->Data();
    return strlen(s);
  }
  return -1;
}

int wxTextWindow::GetLineText(long lineNo, char *buf)
{
  wxTextWnd *text_win = (wxTextWnd *)handle;
  wxNode *node = text_win->lines.Nth((int)lineNo);
  if (node)
  {
    char *s = (char *)node->Data();
    strcpy(buf, s);
    return strlen(s);
  }
  buf[0] = 0;
  return -1;
}

void wxTextWindow::Replace(long from, long to, char *value)
{
}

void wxTextWindow::Remove(long from, long to)
{
}

void wxTextWindow::Highlight(long from, long to)
{
}

void wxTextWindow::SetEditable(Bool editable)
{
}

#if (!EDITABLE_TEXT_WINDOW)
wxTextWnd::wxTextWnd(wxWnd *parent, wxWindow *wx_win,
                       int x, int y, int width, int height, DWORD style):
  wxSubWnd(parent, "wxCanvasClass", wx_win, x, y, width, height, style)
{
  no_lines = 1;
  current_line = 0;
//  lines = new char *[wxTEXT_MAX_LINES];
//  lines[0] = new char[1];
//  lines[0][0] = 0;
  lines.Add("");

  OnCreate();
  ShowScrollBar(handle, SB_BOTH, TRUE);
}

wxTextWnd::~wxTextWnd()
{
/*
  if (lines)
  {
    int i;
    for (i = 0; i < no_lines; i++)
    {
      delete[] lines[i];
      lines[i] = NULL;
    }
    delete[] lines;
  }
*/
}

BOOL wxTextWnd::OnPaint()
{
  RECT rect;
  if (GetUpdateRect(handle, &rect, FALSE))
  {
    PAINTSTRUCT ps;
    // Hold a pointer to the dc so long as the OnPaint() message
    // is being processed
    HDC dc = BeginPaint(handle, &ps);

    COLORREF bkgnd_color = GetSysColor(COLOR_WINDOW);
    ::SetTextColor(dc, GetSysColor(COLOR_WINDOWTEXT));
    ::SetBkColor(dc, bkgnd_color);
    HFONT oldFont = ::SelectObject(dc, wx_window->font->GetInternalFont(dc));

    HBRUSH brush = CreateSolidBrush(bkgnd_color);
    ::FillRect(dc, &rect, brush);
    DeleteObject(brush);

    int nStart = yscroll_position;
    int nEnd = min(no_lines, yscroll_position + (rect.bottom/cyChar) + 1);

    int i;
    int x,y;
/*
    for (i = nStart; i < nEnd; i++)
    {
      x = cxChar * (1 - xscroll_position);
      y = cyChar * (i - yscroll_position);
      TextOut(dc, x, y, lines[i], strlen(lines[i]));
    }
*/
    wxNode *node = lines.Nth(nStart);
    i = nStart;
    while (node && (i < nEnd))
    {
      char *s = (char *)node->Data();
      x = cxChar * (1 - xscroll_position);
      y = cyChar * (i - yscroll_position);
      TextOut(dc, x, y, s, strlen(s));
      i ++;
      node = node->Next();
    }
    ::SelectObject(dc, oldFont);
    EndPaint(handle, &ps);
    return 0;
  }
  return 1;
}

void wxTextWnd::OnCreate(void)
{
  TEXTMETRIC tm;
  HDC dc = GetDC(handle);
  GetTextMetrics(dc, &tm);
  ReleaseDC(handle, dc);
  cxChar = tm.tmAveCharWidth;
  cyChar = tm.tmHeight + tm.tmExternalLeading;
  yscroll_pixels_per_line = cyChar;
  xscroll_pixels_per_line = cxChar;
  xscroll_lines = 300;
  yscroll_lines = 0;
  ReleaseDC(handle, dc);
}

void wxTextWnd::OnSize(int x, int y, UINT)
{
  CalcNewSize(x, y);
  InvalidateRgn(handle, NULL, TRUE);
}

void wxTextWnd::CalcNewSize(int x, int y)
{
  cxClient = x;
  cyClient = y;

  int nMaxWidth = xscroll_lines*xscroll_pixels_per_line;

  int nVscrollMax = max(0, (int)(no_lines + 2 - cyClient/cyChar));
  yscroll_position = min(yscroll_position, nVscrollMax);

  SetScrollRange(handle, SB_VERT, 0, nVscrollMax, FALSE);
  SetScrollPos(handle, SB_VERT, yscroll_position, TRUE);

  int nHscrollMax = max(0, (int)(2 + nMaxWidth - cxClient/cxChar));
  xscroll_position = min(xscroll_position, nHscrollMax);

  SetScrollRange(handle, SB_HORZ, 0, nHscrollMax, FALSE);
  SetScrollPos(handle, SB_HORZ, xscroll_position, TRUE);

  yscroll_lines = no_lines;

  yscroll_lines_per_page = max(1, cyClient/cyChar);
  xscroll_lines_per_page = 10;
}

#endif // EDITABLE_TEXT_WINDOW
