/*
 * File:	wx_main.cc
 * Purpose:	wxApp implementation
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include "wx.h"
#pragma hdrstop
#include "wx_privt.h"
#include <iostream.h>
#include <string.h>

// NT defines APIENTRY, 3.x not
#if !defined(APIENTRY)
#define APIENTRY FAR PASCAL
#endif
 
#ifdef WIN32
#define _EXPORT /**/
#else
#define _EXPORT _export
#endif
 
#if !defined(WIN32)
#define DLGPROC FARPROC
#endif

#if FAFA_LIB
extern "C" int InitFafa(HANDLE);
extern "C" void EndFafa(void);
#endif

/*
#include <windows.h>
#include "common.h"
#include "wx_mgstr.h"
#include "wx_frame.h"
#include "wx_main.h"
#include "wx_utils.h"
#include "wx_gdi.h"
#include "wx_dc.h"
#include "wx_dialg.h"
*/

#if CTL3D
#include <ctl3d.h>
#endif

HANDLE wxhInstance = 0;
extern wxList *wxWinHandleList;
char *wxFrameClassName = "wxFrameClass";
char *wxMDIFrameClassName = "wxMDIFrameClass";
char *wxMDIChildFrameClassName = "wxMDIChildFrameClass";
char *wxPanelClassName = "wxPanelClass";
char *wxCanvasClassName = "wxCanvasClass";
HICON wxSTD_FRAME_ICON = NULL;
HICON wxSTD_MDICHILDFRAME_ICON = NULL;
HICON wxSTD_MDIPARENTFRAME_ICON = NULL;
HFONT wxSTATUS_LINE_FONT = NULL;
LONG APIENTRY _EXPORT
  wxWndProc(HWND hWnd, UINT message, UINT wParam, LONG lParam);

void wxInitialize(HANDLE hInstance)
{
#if CTL3D
  if (!Ctl3dRegister(hInstance))                                       
    wxFatalError("Cannot register CTL3D");

  Ctl3dAutoSubclass(hInstance);
#endif
#if FAFA_LIB
  InitFafa(hInstance);
#endif

  wxSTD_FRAME_ICON = LoadIcon(hInstance, "wxSTD_FRAME");
  wxSTD_MDIPARENTFRAME_ICON = LoadIcon(hInstance, "wxSTD_MDIPARENTFRAME");
  wxSTD_MDICHILDFRAME_ICON = LoadIcon(hInstance, "wxSTD_MDICHILDFRAME");
  wxSTATUS_LINE_FONT = CreateFont(16, 0, 0, 0, FW_NORMAL, 0, 0, 0,
                    ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
                    PROOF_QUALITY, DEFAULT_PITCH | FF_SWISS,
                    "Arial");

  // Register the frame window class.
  WNDCLASS wndclass;   // Structure used to register Windows class.

  wndclass.style         = CS_HREDRAW | CS_VREDRAW;
  wndclass.lpfnWndProc   = wxWndProc;
  wndclass.cbClsExtra    = 0;
  wndclass.cbWndExtra    = 4;
  wndclass.hInstance     = hInstance;
  wndclass.hIcon         = wxSTD_FRAME_ICON;
  wndclass.hCursor       = LoadCursor( NULL, IDC_ARROW );
  wndclass.hbrBackground = GetStockObject( WHITE_BRUSH );
  wndclass.lpszMenuName  = NULL;
  wndclass.lpszClassName = wxFrameClassName;
  RegisterClass( &wndclass );

  // Register the MDI frame window class.
  WNDCLASS wndclass1;   // Structure used to register Windows class.

  wndclass1.style         = CS_HREDRAW | CS_VREDRAW;
  wndclass1.lpfnWndProc   = wxWndProc;
  wndclass1.cbClsExtra    = 0;
  wndclass1.cbWndExtra    = 4;
  wndclass1.hInstance     = hInstance;
  wndclass1.hIcon         = wxSTD_MDIPARENTFRAME_ICON;
  wndclass1.hCursor       = LoadCursor( NULL, IDC_ARROW );
  wndclass1.hbrBackground = NULL;
  wndclass1.lpszMenuName  = NULL;
  wndclass1.lpszClassName = wxMDIFrameClassName;
  RegisterClass( &wndclass1 );

  // Register the MDI child frame window class.
  WNDCLASS wndclass4;   // Structure used to register Windows class.

  wndclass4.style         = CS_HREDRAW | CS_VREDRAW;
  wndclass4.lpfnWndProc   = wxWndProc;
  wndclass4.cbClsExtra    = 0;
  wndclass4.cbWndExtra    = 4;
  wndclass4.hInstance     = hInstance;
  wndclass4.hIcon         = wxSTD_MDICHILDFRAME_ICON;
  wndclass4.hCursor       = LoadCursor( NULL, IDC_ARROW );
  wndclass4.hbrBackground = NULL;
  wndclass4.lpszMenuName  = NULL;
  wndclass4.lpszClassName = wxMDIChildFrameClassName;
  RegisterClass( &wndclass4 );

  // Register the panel window class.
  WNDCLASS wndclass2;   // Structure used to register Windows class.
  memset(&wndclass2, 0, sizeof(WNDCLASS));   // start with NULL defaults
  // Use CS_OWNDC to avoid messing about restoring the context
  // for every graphic operation.
  wndclass2.style         = CS_HREDRAW | CS_VREDRAW;
  wndclass2.lpfnWndProc   = wxWndProc;
  wndclass2.cbClsExtra    = 0;
  wndclass2.cbWndExtra    = 4;
  wndclass2.hInstance     = hInstance;
  wndclass2.hIcon         = NULL;
  wndclass2.hCursor       = NULL;
  wndclass2.hbrBackground = GetStockObject( LTGRAY_BRUSH );
  wndclass2.lpszMenuName  = NULL;
  wndclass2.lpszClassName = wxPanelClassName;
  RegisterClass( &wndclass2 );

  // Register the canvas and textsubwindow class name
  WNDCLASS wndclass3;   // Structure used to register Windows class.
  memset(&wndclass3, 0, sizeof(WNDCLASS));   // start with NULL defaults
  // Use CS_OWNDC to avoid messing about restoring the context
  // for every graphic operation.
  wndclass3.style         = CS_HREDRAW | CS_VREDRAW | CS_OWNDC | CS_DBLCLKS ; 
  wndclass3.lpfnWndProc   = wxWndProc;
  wndclass3.cbClsExtra    = 0;
  wndclass3.cbWndExtra    = 4;
  wndclass3.hInstance     = hInstance;
  wndclass3.hIcon         = NULL;
  wndclass3.hCursor       = NULL;
  wndclass3.hbrBackground = NULL;
  wndclass3.lpszMenuName  = NULL;
  wndclass3.lpszClassName = wxCanvasClassName;
  RegisterClass( &wndclass3);

  wxWinHandleList = new wxList(wxKEY_INTEGER);

  wxCommonInit();
}

// Cleans up any wxWindows internal structures left lying around
void wxCleanUp(void)
{
  wxCommonCleanUp();
  
  if (wxSTD_FRAME_ICON)
    DestroyIcon(wxSTD_FRAME_ICON);
  if (wxSTD_MDICHILDFRAME_ICON)
    DestroyIcon(wxSTD_MDICHILDFRAME_ICON);
  DeleteObject(wxSTATUS_LINE_FONT);
#if CTL3D
    Ctl3dUnregister(wxhInstance);
#endif
#if FAFA_LIB
  EndFafa() ;
#endif
  if (wxWinHandleList)
    delete wxWinHandleList ;
}

#ifndef _WINDLL

// Main windows entry point
int APIENTRY WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR m_lpCmdLine,
                    int nCmdShow )
{
  wxhInstance = hInstance;

  wxInitialize(hInstance);

  // Split command line into tokens, as in usual main(argc, argv)
  // form
  char **command = new char*[50];
  int count = 0;
  char *token = 0;
  char *buf = new char[500]; // Hangs around until end of app. in case
                             // user carries pointers to the tokens

  Bool flag = TRUE;
  int i = 0;
  buf[0] = 0;

#ifndef _WINDLL // m_lpCmdLine isn't accessible from a DLL,
                // (it seems to crash anyhow)
  while (flag)
  {
    if (m_lpCmdLine[i] == 0)
    {
      buf[i] = 0;
      flag = FALSE;
    }
    else
    {
      buf[i] = m_lpCmdLine[i];
      i ++;
    }
  }
#endif

  // Get application name
  char name[200];
  ::GetModuleFileName(hInstance, name, 199);
  command[count] = copystring(name);
  count ++;

  token = strtok(buf, " ");
  if (token)
  {
    command[count] = token;
    count ++;

    while (token != NULL)
    {
      token = strtok(NULL, " ");
      if (token)
      {
        command[count] = token;
        count ++;
      }
    }
  }

  if (!wxTheApp)
  {
    wxMessageBox("wxWindows error: You have to define an instance of wxApp!\n");
    return 0;
  }


  wxTheApp->argc = count;
  wxTheApp->argv = command;
  wxTheApp->hInstance = hInstance;

  wxTheApp->wx_frame = wxTheApp->OnInit();
  if (wxTheApp->wx_frame && wxTheApp->wx_frame->handle)
  {
    wxTheApp->wx_frame->Show(TRUE);
    int retValue = wxTheApp->MainLoop();
    wxCleanUp();
    delete [] buf ;
    delete [] command[0] ;
    delete [] command ;
    return retValue;
  }
  else
  {
    wxCleanUp();
    delete [] buf ;
    delete [] command[0] ;
    delete [] command ;
    return 1;
  }
}

#endif // not _WINDLL

#ifdef _WINDLL
extern "C"
int APIENTRY LibMain(HINSTANCE hInstance,
	WORD wDataSegment, WORD wHeapSize, LPSTR lpszCmdLine)
{
  wxhInstance = hInstance;
  wxInitialize(hInstance);

  wxTheApp->argc = 0;
  wxTheApp->argv = NULL;
  wxTheApp->hInstance = hInstance;

  wxTheApp->wx_frame = wxTheApp->OnInit();
  if (wxTheApp->wx_frame && wxTheApp->wx_frame->handle)
    wxTheApp->wx_frame->Show(TRUE);

  return 1;
}
#endif // _WINDLL

wxApp::wxApp(int language):wxbApp(language)
{
  wx_frame = NULL;
  wxTheApp = this;
  death_processed = FALSE;
  work_proc = NULL ;
  wx_class = NULL;
  wxSetLanguage(language);
}

wxApp::~wxApp(void)
{
}

Bool wxApp::Initialized(void)
{
#ifndef _WINDLL
  if (wx_frame)
    return TRUE;
  else
    return FALSE;
#endif
#ifdef _WINDLL // Assume initialized if DLL (no way of telling)
  return TRUE;
#endif
}

/*
 * Get and process a message, returning FALSE if WM_QUIT
 * received.
 *
 */
BOOL wxApp::DoMessage(void)
{
  if (!::GetMessage(&current_msg, NULL, NULL, NULL))
  {
    return FALSE;
  }

  // Process the message
  if (!ProcessMessage(&current_msg))
  {
    ::TranslateMessage(&current_msg);
    ::DispatchMessage(&current_msg);
  }
  return TRUE;
}

/*
 * Keep trying to process messages until WM_QUIT
 * received
 */

int wxApp::MainLoop(void)
{
  // I put the var. into the class object, so wxApp::Dispatch can reset it.
  //Bool keep_going = TRUE;
  keep_going = TRUE;
  while (keep_going)
  {
    while (!::PeekMessage(&current_msg, NULL, NULL, NULL, PM_NOREMOVE) &&
           OnIdle()) {}
    if (!DoMessage())
      keep_going = FALSE;
  }

  return current_msg.wParam;
}

Bool wxApp::Pending(void)
{
    OnIdle() ;
    return (::PeekMessage(&current_msg, NULL, NULL, NULL, PM_NOREMOVE)) ;
}

void wxApp::Dispatch(void)
{
    if (!DoMessage())
      keep_going = FALSE;
}

/*
 * Give all windows a chance to preprocess
 * the message. Some may have accelerator tables, or have
 * MDI complications.
 */
BOOL wxApp::ProcessMessage(MSG *msg)
{
  HWND hWnd;

  // Anyone for a message? Try youngest descendants first.
  for (hWnd = msg->hwnd; hWnd != NULL; hWnd = ::GetParent(hWnd))
  {
    wxWnd *wnd = wxFindWinFromHandle(hWnd);
    if (wnd)
    {
       if (wnd->ProcessMessage(msg))
         return TRUE;

       // STOP if we've reached the top of the hierarchy!
       if (wx_frame && (wnd == (wxWnd *)wx_frame->handle))
          return FALSE;
    }
  }

  if (wx_frame && ((wxWnd *)wx_frame->handle)->ProcessMessage(msg))
     return TRUE;
  else return FALSE;
}

BOOL wxApp::OnIdle(void)
{
  if (work_proc)
    (*work_proc)(this) ;
  return FALSE;
}

void wxExit(void)
{
  if (wxTheApp)
    (void)wxTheApp->OnExit();
  wxCleanUp();
  FatalAppExit(0, "Fatal error: exiting");
}

// Yield to incoming messages
Bool wxYield(void)
{
  MSG msg;
  // We want to go back to the main message loop
  // if we see a WM_QUIT. (?)
  while (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE) && msg.message != WM_QUIT)
  {
    if (!wxTheApp->DoMessage())
      break;
  }

  return TRUE;
}

