/*
 * File:	wx_frame.cc
 * Purpose:	wxFrame implementation
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

#include "wx.h"
#pragma hdrstop
#include "wx_privt.h"
#include <iostream.h>

/*
#include <windows.h>
#include "common.h"
#include "wx_frame.h"
#include "wx_gdi.h"
#include "wx_main.h"
#include "wx_utils.h"
*/

extern wxList wxModelessWindows;

wxPen *wxStatusGreyPen = NULL;
wxPen *wxStatusWhitePen = NULL;
extern HFONT wxSTATUS_LINE_FONT;

#define IDM_WINDOWTILE  4001
#define IDM_WINDOWCASCADE 4002
#define IDM_WINDOWICONS 4003
#define IDM_WINDOWNEXT 4004
#define wxFIRST_MDI_CHILD 4100

// Status border dimensions
#define         wxTHICK_LINE_BORDER 3
#define         wxTHICK_LINE_WIDTH  1

wxFrame::wxFrame(void)
{
  frame_type = 0;
  wx_menu_bar = NULL;
  status_line_exists = FALSE;
  icon = NULL;
  modal_showing = FALSE;
  window_parent = NULL;
  for (int i = 0; i < wxMAX_STATUS; i++)
    status_window[i] = NULL;
  wx_iconized = FALSE;
  wxWinType = 0;
  handle = NULL;
}

wxFrame::wxFrame(wxFrame *Parent, char *title, int x, int y,
                 int width, int height, int style, char *name):
  wxbFrame(Parent, title, x, y, width, height, style, name)
{
  Create(Parent, title, x, y, width, height, style, name);
}

Bool wxFrame::Create(wxFrame *Parent, char *title, int x, int y,
                 int width, int height, int style, char *name)
{
  wxbFrame::Create(Parent, title, x, y, width, height, style, name);
  
  frame_type = style & (wxSDI | wxMDI_PARENT | wxMDI_CHILD);
  wx_menu_bar = NULL;
  status_line_exists = FALSE;
  icon = NULL;
  modal_showing = FALSE;
  handle = NULL;
  
  if (Parent) Parent->AddChild(this);
  window_parent = Parent;

  for (int i = 0; i < wxMAX_STATUS; i++)
    status_window[i] = NULL;

  wx_iconized = FALSE;
  wxWnd *cparent = NULL;
  if (Parent)
    cparent = (wxWnd *)Parent->handle;

  switch (frame_type)
  {
    case wxMDI_PARENT:
      wxWinType = wxTYPE_XWND;
      handle = (char *)new wxMDIFrame(NULL, this, title, x, y, width, height, style);
      break;
    case wxMDI_CHILD:
      wxWinType = wxTYPE_MDICHILD;
      handle = (char *)new wxMDIChild((wxMDIFrame *)cparent, this, title, x, y, width, height, style);
      break;
    default:
    case wxSDI:
      wxWinType = wxTYPE_XWND;
      handle = (char *)new wxFrameWnd(cparent, "wxFrameClass", this, title,
                   x, y, width, height, style);
      break;
  }

  wxModelessWindows.Append(this);
  return TRUE;
}

// For ~wxFrame, see wx_item.cc

// Get size *available for subwindows* i.e. excluding menu bar etc.
// For XView, this is the same as GetSize
void wxFrame::GetClientSize(int *x, int *y)
{
  wxWnd *wnd = (wxWnd *)handle;
  RECT rect;
  GetClientRect(wnd->handle, &rect);
  if (status_window[0])
    rect.bottom -= status_window[0]->height;

  *x = rect.right;
  *y = rect.bottom;
}

// Set the client size (i.e. leave the calculation of borders etc.
// to wxWindows)
void wxFrame::SetClientSize(int width, int height)
{
/*
  wxWnd *wnd = (wxWnd *)handle;
  RECT rect;
  GetClientRect(wnd->handle, &rect);

  RECT rect2;
  GetWindowRect(wnd->handle, &rect2);

  // Find the difference between the entire window (title bar and all)
  // and the client area; add this to the new client size to move the
  // window
  int actual_width = rect2.right - rect2.left - rect.right + width;
  int actual_height = rect2.bottom - rect2.top - rect.bottom + height;

  if (status_window[0])
    actual_height += status_window[0]->height;

  MoveWindow(wnd->handle, rect2.left, rect2.top, actual_width, actual_height, TRUE);
  OnSize(actual_width, actual_height);
*/
  wxFrame *parent = (wxFrame *)GetParent();
  HWND hWnd = GetHWND();
  HWND hParentWnd = 0;
  if (parent)
    hParentWnd = parent->GetHWND();

  RECT rect;
  GetClientRect(hWnd, &rect);

  RECT rect2;
  GetWindowRect(hWnd, &rect2);

  // Find the difference between the entire window (title bar and all)
  // and the client area; add this to the new client size to move the
  // window
  int actual_width = rect2.right - rect2.left - rect.right + width;
  int actual_height = rect2.bottom - rect2.top - rect.bottom + height;

  POINT point;
  point.x = rect2.left;
  point.y = rect2.top;

  // If there's an MDI parent, must subtract the parent's top left corner
  // since MoveWindow moves relative to the parent
  if (parent && (wxWinType == wxTYPE_MDICHILD))
  {
    ::ScreenToClient(hParentWnd, &point);
  }

  MoveWindow(hWnd, point.x, point.y, actual_width, actual_height, TRUE);
  OnSize(actual_width, actual_height);
}

void wxFrame::GetSize(int *width, int *height)
{
  wxWnd *wnd = (wxWnd *)handle;
  RECT rect;
  GetWindowRect(wnd->handle, &rect);
  *width = rect.right - rect.left;
  *height = rect.bottom - rect.top;
}

void wxFrame::GetPosition(int *x, int *y)
{
  wxWnd *wnd = (wxWnd *)handle;
  wxWindow *parent = GetParent();

  RECT rect;
  GetWindowRect(wnd->handle, &rect);
  POINT point;
  point.x = rect.left;
  point.y = rect.top;

  // Since we now have the absolute screen coords,
  // if there's a parent we must subtract its top left corner
  if (parent)
  {
    wxWnd *cparent = (wxWnd *)(parent->handle);
    if (wxWinType == wxTYPE_MDICHILD)
    {
      wxMDIFrame *mdiParent = (wxMDIFrame *)cparent;
      ::ScreenToClient(mdiParent->client_hwnd, &point);
    }
  }
  *x = point.x;
  *y = point.y;
}

void wxFrame::SetSize(int x, int y, int width, int height)
{
  int currentX, currentY;
  GetPosition(&currentX, &currentY);
  if (x == -1)
    x = currentX;
  if (y == -1)
    y = currentY;

  int ww,hh ;
  GetSize(&ww,&hh) ;
  if (width == -1) width = ww ;
  if (height==-1) height = hh ;

  wxWnd *wnd = (wxWnd *)handle;
  if (wnd)
  {
    MoveWindow(wnd->handle, x, y, width, height, TRUE);
    OnSize(width, height);
  }
}

void wxFrame::Show(Bool show)
{
  wxWnd *wnd = (wxWnd *)handle;
  int cshow;
  if (show)
    cshow = SW_SHOW;
  else
    cshow = SW_HIDE;
  ShowWindow(wnd->handle, cshow);
  if (show)
    BringWindowToTop(wnd->handle);
}

void wxFrame::Iconize(Bool iconize)
{
  if (!iconize)
    Show(TRUE);

  wxWnd *wnd = (wxWnd *)handle;
  int cshow;
  if (iconize)
    cshow = SW_MINIMIZE;
  else
    cshow = SW_RESTORE;
  ShowWindow(wnd->handle, cshow);
  wx_iconized = iconize;
}

// Equivalent to maximize/restore in Windows
void wxFrame::Maximize(Bool maximize)
{
  Show(TRUE);
  wxWnd *wnd = (wxWnd *)handle;
  int cshow;
  if (maximize)
    cshow = SW_MAXIMIZE;
  else
    cshow = SW_RESTORE;
  ShowWindow(wnd->handle, cshow);
  wx_iconized = FALSE;
}

Bool wxFrame::Iconized(void)
{
//  wxWnd *wnd = (wxWnd *)handle;
  return wx_iconized;
}

void wxFrame::SetTitle(char *title)
{
  wxWnd *wnd = (wxWnd *)handle;
  SetWindowText(wnd->handle, title);
}

char *wxFrame::GetTitle(void)
{
  wxWnd *wnd = (wxWnd *)handle;
  GetWindowText(wnd->handle, wxBuffer, 1000);
  return wxBuffer;
}

void wxFrame::SetIcon(wxIcon *wx_icon)
{
  icon = wx_icon;
  switch (frame_type)
  {
    case wxMDI_PARENT:
    {
      wxMDIFrame *wnd = (wxMDIFrame *)handle;
      wnd->icon = wx_icon->ms_icon;
      break;
    }
    case wxMDI_CHILD:
    {
      wxMDIChild *wnd = (wxMDIChild *)handle;
      wnd->icon = wx_icon->ms_icon;
      break;
    }
    default:
    case wxSDI:
    {
      wxFrameWnd *wnd = (wxFrameWnd *)handle;
      wnd->icon = wx_icon->ms_icon;
      break;
    }
  }
}


void wxFrame::CreateStatusLine(int number, char *name)
{
  if (status_line_exists)
    return;

  status_line_exists = TRUE;

  nb_status = number;

  wxFrameWnd *cframe = (wxFrameWnd *)handle;

  TEXTMETRIC tm;
  HDC dc = GetDC(cframe->handle);
  SelectObject(dc, wxSTATUS_LINE_FONT);
  GetTextMetrics(dc, &tm);
  ReleaseDC(cframe->handle, dc);
  int char_height = tm.tmHeight + tm.tmExternalLeading;
  int status_window_height =
     (int)((char_height * 4.0/3.0) + 2*wxTHICK_LINE_BORDER);

  if (!wxStatusGreyPen)
  {
    wxStatusGreyPen = new wxPen("DIM GREY", wxTHICK_LINE_WIDTH, wxSOLID);
    wxStatusWhitePen = new wxPen("WHITE", wxTHICK_LINE_WIDTH, wxSOLID);
  }

  for (int i = 0; i < number; i++)
    status_window[i] = new wxStatusWnd(cframe, status_window_height);
  PositionStatusWindow();
}

void wxFrame::SetStatusText(char *text, int number)
{
  if (!status_line_exists)
    return;

  if ((number < 0) || (number >= nb_status))
    return;

  if (status_window[number]->status_text)
    delete[] status_window[number]->status_text;

  if (text)
    status_window[number]->status_text = copystring(text);
  else status_window[number]->status_text = NULL;

  HDC dc = GetDC(status_window[number]->handle);
  SelectObject(dc, wxSTATUS_LINE_FONT);

  RECT rect;
  GetClientRect(status_window[number]->handle, &rect );

  int width = rect.right;
  int height = rect.bottom;

  SetBkMode(dc, TRANSPARENT);

  ::SetTextColor(dc, ::GetSysColor( COLOR_WINDOWTEXT ) );

  TEXTMETRIC tm;
  GetTextMetrics(dc, &tm);
  int cy = tm.tmHeight + tm.tmExternalLeading;
  int y = (int)((rect.bottom - cy)/2);

  rect.left += wxTHICK_LINE_BORDER + 1;
  rect.top += wxTHICK_LINE_BORDER + 1;
  rect.right -= (wxTHICK_LINE_BORDER + 1);
  rect.bottom -= (wxTHICK_LINE_BORDER + 1);
  FillRect(dc, &rect, status_window[number]->light_grey_brush);

  IntersectClipRect(dc, wxTHICK_LINE_BORDER + 3, y-1,
                            width - wxTHICK_LINE_BORDER - 1, height);

  if (status_window[number]->status_text)
    TextOut(dc, wxTHICK_LINE_BORDER + 4, y,
                status_window[number]->status_text, strlen(status_window[number]->status_text));

  SelectClipRgn(dc, NULL);
  ReleaseDC(status_window[number]->handle, dc);
}

void wxFrame::PositionStatusWindow(void)
{
  // We will assume that in a multi status line, all fields have the
  //  same width.
  wxFrameWnd *cframe = (wxFrameWnd *)handle;
  RECT rect;
  GetClientRect(cframe->handle, &rect);
  int cwidth = rect.right;
  int cheight = rect.bottom;
  for (int i = 0; i < nb_status; i++)
  {
    int real_width = (int)(cwidth/nb_status);
    MoveWindow(status_window[i]->handle, i*real_width, cheight - status_window[0]->height,
                            real_width, status_window[0]->height, TRUE);
  }
}

void wxFrame::LoadAccelerators(char *table)
{
  wxFrameWnd *cframe = (wxFrameWnd *)handle;
  cframe->accelerator_table = ::LoadAccelerators(wxhInstance, table);
}

void wxFrame::Fit(void)
{
  // Work out max. size
  wxNode *node = children->First();
  int max_width = 0;
  int max_height = 0;
  while (node)
  {
    // Find a child that's a subwindow, but not a dialog box.
    wxWindow *win = (wxWindow *)node->Data();

    if ((wxSubType(win->__type, wxTYPE_PANEL) &&
         !wxSubType(win->__type, wxTYPE_DIALOG_BOX)) ||
        wxSubType(win->__type, wxTYPE_TEXT_WINDOW) ||
        wxSubType(win->__type, wxTYPE_CANVAS))
    {
      int width, height;
      int x, y;
      win->GetSize(&width, &height);
      win->GetPosition(&x, &y);

      if ((x + width) > max_width)
        max_width = x + width;
      if ((y + height) > max_height)
        max_height = y + height;
    }
    node = node->Next();
  }
  SetClientSize(max_width, max_height);
}

/*
 * Windows 3 specific windows
 *
 */

wxStatusWnd::wxStatusWnd(wxFrameWnd *parent, int the_height)
{
  status_text = NULL;
  height = the_height;
  light_grey_brush = GetStockObject(LTGRAY_BRUSH);

  Create(parent, "wxPanelClass", NULL, NULL, 0, 0, 100, 100, WS_CHILD);
  ShowWindow(handle, SW_SHOW);
}

wxStatusWnd::~wxStatusWnd(void)
{
  if (status_text)
    delete[] status_text;
}

BOOL wxStatusWnd::OnPaint()
{
#ifdef DEBUG
  wxDebugMsg("wxStatusWnd::OnPaint %d\n", handle);
#endif
  RECT rect;
  if (GetUpdateRect(handle, &rect, FALSE))
  {
    PAINTSTRUCT ps;
    // Hold a pointer to the dc so long as the OnPaint() message
    // is being processed
    cdc = BeginPaint(handle, &ps);
    SelectObject(cdc, wxSTATUS_LINE_FONT);

    ::GetClientRect(handle, &rect);

    int width = rect.right;
    int height = rect.bottom;

    ::SetBkMode(cdc, TRANSPARENT);
    ::FillRect(cdc, &rect, light_grey_brush);

    wxGREY_BRUSH->ChangeBrush() ;
    HBRUSH old_brush = ::SelectObject(cdc, wxGREY_BRUSH->cbrush);

    // Draw border
    // Have grey background, plus 3-d border -
    // One black rectangle.
    // Inside this, left and top sides - dark grey. Bottom and right -
    // white.

    // Right and bottom white lines
    wxStatusWhitePen->ChangePen() ;
    HPEN old_pen = SelectObject(cdc, wxStatusWhitePen->cpen);
    MoveToEx(cdc, width-wxTHICK_LINE_BORDER,
                  wxTHICK_LINE_BORDER, NULL);
    LineTo(cdc, width-wxTHICK_LINE_BORDER,
                height-wxTHICK_LINE_BORDER);
    LineTo(cdc, wxTHICK_LINE_BORDER,
              height-wxTHICK_LINE_BORDER);

    // Left and top grey lines
    wxStatusGreyPen->ChangePen() ;
    SelectObject(cdc, wxStatusGreyPen->cpen);
    LineTo(cdc, wxTHICK_LINE_BORDER, wxTHICK_LINE_BORDER);
    LineTo(cdc, width-wxTHICK_LINE_BORDER, wxTHICK_LINE_BORDER);

    SetTextColor(cdc, ::GetSysColor( COLOR_WINDOWTEXT ) );

    TEXTMETRIC tm;
    ::GetTextMetrics(cdc, &tm);
    int cy = tm.tmHeight + tm.tmExternalLeading;
    int y = (int)((rect.bottom - cy)/2);

    ::IntersectClipRect(cdc, wxTHICK_LINE_BORDER + 3, y-1,
                            rect.right - wxTHICK_LINE_BORDER - 1, rect.bottom);

    if (status_text)
      ::TextOut(cdc, wxTHICK_LINE_BORDER + 4, y,
                  status_text, strlen(status_text));

    ::SelectClipRgn(cdc, NULL);
    if (old_pen)
      SelectObject(cdc, old_pen);
    if (old_brush)
      SelectObject(cdc, old_brush);

    EndPaint(handle, &ps);
    cdc = NULL;
    return 0;
  }
  return 1;
}


/*
 * Frame window
 *
 */

wxFrameWnd::wxFrameWnd(wxWnd *parent, char *wclass, wxWindow *wx_win, char *title,
                   int x, int y, int width, int height, int style)
{
  DWORD msflags = WS_OVERLAPPED;
  DWORD extendedStyle = 0;
  if (style & wxMINIMIZE_BOX)
    msflags |= WS_MINIMIZEBOX;
  if (style & wxMAXIMIZE_BOX)
    msflags |= WS_MAXIMIZEBOX;
  if (style & wxTHICK_FRAME)
    msflags |= WS_THICKFRAME;
  if (style & wxSYSTEM_MENU)
    msflags |= WS_SYSMENU;
  if ((style & wxMINIMIZE) || (style & wxICONIZE))
    msflags |= WS_MINIMIZE;
  if (style & wxMAXIMIZE)
    msflags |= WS_MAXIMIZE;
  if (style & wxCAPTION)
    msflags |= WS_CAPTION;

    if (style & wxSTAY_ON_TOP)
    extendedStyle |= WS_EX_TOPMOST;

  icon = NULL;
  iconized = FALSE;
  Create(parent, "wxFrameClass", wx_win, title, x, y, width, height,
         msflags, NULL, extendedStyle);
#ifdef DEBUG
  wxDebugMsg("wxFrameWnd::wxFrameWnd %d\n", handle);
#endif
}

wxFrameWnd::~wxFrameWnd(void)
{
#ifdef DEBUG
  wxDebugMsg("wxFrameWnd::OnSize %d\n", handle);
#endif
}

BOOL wxFrameWnd::OnPaint(void)
{
#ifdef DEBUG
  wxDebugMsg("wxFrameWnd::OnPaint %d\n", handle);
#endif
  RECT rect;
  if (GetUpdateRect(handle, &rect, FALSE))
  {
    PAINTSTRUCT ps;
    // Hold a pointer to the dc so long as the OnPaint() message
    // is being processed
    cdc = BeginPaint(handle, &ps);

    if (iconized)
    {
      HICON the_icon = icon;
      if (the_icon == 0)
        the_icon = wxSTD_FRAME_ICON;

      // Erase background before painting or we get white background
      this->DefWindowProc(WM_ICONERASEBKGND,(WORD)ps.hdc,0L);
      
      if (the_icon)
      {
        RECT rect;
        GetClientRect(handle, &rect);
        int icon_width = 32;
        int icon_height = 32;
        int icon_x = (int)((rect.right - icon_width)/2);
        int icon_y = (int)((rect.bottom - icon_height)/2);
        DrawIcon(cdc, icon_x, icon_y, the_icon);
      }
    }

    if (!iconized && wx_window)
      wx_window->OnPaint();

    EndPaint(handle, &ps);
    cdc = NULL;
    return 0;
  }
  return 1;
}

void wxFrameWnd::OnSize(int x, int y, UINT id)
{
#ifdef DEBUG
  wxDebugMsg("wxFrameWnd::OnSize %d\n", handle);
#endif
  switch (id)
  {
    case SIZEFULLSCREEN:
    case SIZENORMAL:
      iconized = FALSE;
    break;
    case SIZEICONIC:
      iconized = TRUE;
    break;
  }

 if (!iconized)
 {
  wxFrame *frame = (wxFrame *)wx_window;
  if (frame && frame->status_window[0])
    frame->PositionStatusWindow();

  if (wx_window && wx_window->handle)
    wx_window->OnSize(x, y);
 }
}

BOOL wxFrameWnd::OnClose(void)
{
#ifdef DEBUG
  wxDebugMsg("wxFrameWnd::OnClose %d\n", handle);
#endif
  if (wx_window)
  {
    if (wx_window->OnClose())
    {
      delete wx_window;
      return TRUE;
    } else return FALSE;
  }
  return FALSE;
}

BOOL wxFrameWnd::OnCommand(WORD id, WORD cmd, HWND control)
{
#ifdef DEBUG
  wxDebugMsg("wxFrameWnd::OnCommand %d\n", handle);
#endif
  if (cmd == 0)
  {
    ((wxFrame *)wx_window)->Command(id);
    return TRUE;
  }
  else
    return FALSE;
}

void wxFrameWnd::OnMenuSelect(WORD nItem, WORD nFlags, HMENU hSysMenu)
{
  wxFrame *frame = (wxFrame *)wx_window;
  if (nFlags == -1 && hSysMenu == NULL)
    frame->OnMenuSelect(-1);
  else if (nFlags != MF_SEPARATOR)
    frame->OnMenuSelect(nItem);
}

/*
 * Windows MDI stuff
 */

wxMDIFrame::wxMDIFrame(wxWnd *parent, wxWindow *wx_win, char *title,
                   int x, int y, int width, int height, int style)
{
  icon = NULL;
  iconized = FALSE;
  parent_frame_active = TRUE;
  current_child = NULL;

  window_menu = ::LoadMenu(wxhInstance, "wxDefaultMenu");
#ifdef DEBUG
  wxDebugMsg("Loaded window_menu %d\n", window_menu);
#endif
  
  DWORD msflags = WS_OVERLAPPED;
  if (style & wxMINIMIZE_BOX)
    msflags |= WS_MINIMIZEBOX;
  if (style & wxMAXIMIZE_BOX)
    msflags |= WS_MAXIMIZEBOX;
  if (style & wxTHICK_FRAME)
    msflags |= WS_THICKFRAME;
  if (style & wxSYSTEM_MENU)
    msflags |= WS_SYSMENU;
  if ((style & wxMINIMIZE) || (style & wxICONIZE))
    msflags |= WS_MINIMIZE;
  if (style & wxMAXIMIZE)
    msflags |= WS_MAXIMIZE;
  if (style & wxCAPTION)
    msflags |= WS_CAPTION;

  Create(parent, "wxMDIFrameClass", wx_win, title, x, y, width, height,
         msflags);
#ifdef DEBUG
  wxDebugMsg("End of wxMDIFrame::wxMDIFrame %d\n", handle);
#endif
}

wxMDIFrame::~wxMDIFrame(void)
{
#ifdef DEBUG
  wxDebugMsg("wxMDIFrame::~wxMDIFrame %d\n", handle);
#endif
  DestroyMenu(window_menu); // Destroy dummy "Window" menu
}

BOOL wxMDIFrame::OnDestroy(void)
{
#ifdef DEBUG
  wxDebugMsg("wxMDIFrame::OnDestroy %d\n", handle);
#endif
  return FALSE;
}

void wxMDIFrame::OnCreate(LPCREATESTRUCT cs)
{
#ifdef DEBUG
  wxDebugMsg("wxMDIFrame::OnCreate %d\n", handle);
#endif
  CLIENTCREATESTRUCT ccs;
	
  ccs.hWindowMenu = window_menu;
  ccs.idFirstChild = wxFIRST_MDI_CHILD;

  client_hwnd = ::CreateWindowEx(0, "mdiclient", NULL,
                WS_VISIBLE | WS_CHILD | WS_CLIPCHILDREN, 0, 0, 0, 0, handle, NULL,
                wxhInstance, (LPSTR)(LPCLIENTCREATESTRUCT)&ccs);
}

BOOL wxMDIFrame::OnPaint(void)
{
#ifdef DEBUG
  wxDebugMsg("wxMDIFrame::OnPaint %d\n", handle);
#endif
  (void)DefWindowProc(last_msg, last_wparam, last_lparam);
  RECT rect;
  if (GetUpdateRect(handle, &rect, FALSE))
  {
    PAINTSTRUCT ps;
    // Hold a pointer to the dc so long as the OnPaint() message
    // is being processed
    cdc = BeginPaint(handle, &ps);

    if (iconized)
    {
      HICON the_icon = icon;
      if (the_icon == 0)
        the_icon = wxSTD_MDIPARENTFRAME_ICON;

      if (the_icon)
      {
        RECT rect;
        GetClientRect(handle, &rect);
        int icon_width = 32;
        int icon_height = 32;
        int icon_x = (int)((rect.right - icon_width)/2);
        int icon_y = (int)((rect.bottom - icon_height)/2);
        DrawIcon(cdc, icon_x, icon_y, the_icon);
      }
    }

    if (!iconized && wx_window)
      wx_window->OnPaint();

    EndPaint(handle, &ps);
    cdc = NULL;
    return 0;
  }
  return 1;
}

void wxMDIFrame::OnSize(int x, int y, UINT id)
{
#ifdef DEBUG
  wxDebugMsg("wxMDIFrame::OnSize %d\n", handle);
#endif
  switch (id)
  {
    case SIZEFULLSCREEN:
    case SIZENORMAL:
      iconized = FALSE;
    break;
    case SIZEICONIC:
      iconized = TRUE;
    break;
  }

 if (!iconized)
 {
  wxFrame *frame = (wxFrame *)wx_window;

  if (frame && frame->status_window[0])
  {
    RECT rect;
    GetClientRect(handle, &rect);
    int cwidth = rect.right;
    int cheight = rect.bottom;

    MoveWindow(client_hwnd, 0, 0,
               cwidth, cheight - frame->status_window[0]->height,
               TRUE);

    frame->PositionStatusWindow();
  }
  else (void)DefWindowProc(last_msg, last_wparam, last_lparam);

  if (wx_window && wx_window->handle)
    wx_window->OnSize(x, y);
  }
}

BOOL wxMDIFrame::OnClose(void)
{
#ifdef DEBUG
  wxDebugMsg("wxMDIFrame::OnClose %d\n", handle);
#endif
  if (wx_window)
  {
    if (wx_window->OnClose())
    {
      delete wx_window;
      return TRUE;
    } else return FALSE;
  }
  return FALSE;
}

BOOL wxMDIFrame::OnCommand(WORD id, WORD cmd, HWND control)
{
#ifdef DEBUG
  wxDebugMsg("wxMDIFrame::OnCommand %d, id = %d\n", handle, id);
#endif
  if (cmd == 0)
  {
    switch (id)
    {
      case IDM_WINDOWCASCADE:
        SendMessage(client_hwnd, WM_MDICASCADE, MDITILE_SKIPDISABLED, 0);
        return TRUE;
        break;
      case IDM_WINDOWTILE:
        SendMessage(client_hwnd, WM_MDITILE, MDITILE_HORIZONTAL, 0);
        return TRUE;
        break;
      case IDM_WINDOWICONS:
        SendMessage(client_hwnd, WM_MDIICONARRANGE, 0, 0);
        return TRUE;
        break;
      case IDM_WINDOWNEXT:
//        SendMessage(client_hwnd, WM_MDINEXT, current_child->handle, 0);
        SendMessage(client_hwnd, WM_MDINEXT, 0, 0);
        return TRUE;
        break;
      default:
        break;
     }
    if (id >= 0xF000)
    {
#ifdef DEBUG
      wxDebugMsg("wxMDIFrame::OnCommand %d: system command: calling default window proc\n", handle);
#endif
      return FALSE; // Get WndProc to call default proc
    }
    
    if (parent_frame_active && id < wxFIRST_MDI_CHILD)
    {
      ((wxFrame *)wx_window)->Command(id);
      return TRUE;
    }
    else if (current_child && id < wxFIRST_MDI_CHILD)
    {
/*
      ((wxFrame *)(current_child->wx_window))->Command(id);
      return TRUE;
*/
#ifdef DEBUG
      wxDebugMsg("wxMDIFrame::OnCommand %d: calling child OnCommand\n", handle);
#endif
      return current_child->OnCommand(id, cmd, control);
    }
 }
/*
#ifdef DEBUG
  wxDebugMsg("wxMDIFrame::OnCommand %d: calling default window proc\n", handle);
#endif
 return (BOOL)DefWindowProc(last_msg, last_wparam, last_lparam);
*/
  return FALSE;
}

void wxMDIFrame::OnMenuSelect(WORD nItem, WORD nFlags, HMENU hSysMenu)
{
  if (parent_frame_active)
  {
    wxFrame *frame = (wxFrame *)wx_window;
    if (nFlags == -1 && hSysMenu == NULL)
      frame->OnMenuSelect(-1);
    else if (nFlags != MF_SEPARATOR)
      frame->OnMenuSelect(nItem);
  }
  else if (current_child)
  {
    current_child->OnMenuSelect(nItem, nFlags, hSysMenu);
  }
}

long wxMDIFrame::DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
//#ifdef DEBUG
//  wxDebugMsg("wxMDIFrame::DefWindowProc %d, message = %d\n", handle, message);
//#endif
  return DefFrameProc(handle, client_hwnd, message, wParam, lParam);
}

BOOL wxMDIFrame::ProcessMessage(MSG* pMsg)
{
//#ifdef DEBUG
//  wxDebugMsg("wxMDIFrame::ProcessMessage %d\n", handle);
//#endif
  if ((current_child != NULL) && (current_child->handle != NULL) && current_child->ProcessMessage(pMsg))
     return TRUE;
	
  if (accelerator_table != NULL &&
          ::TranslateAccelerator(handle, accelerator_table, pMsg))
    return TRUE;
	
  if (pMsg->message == WM_KEYDOWN || pMsg->message == WM_SYSKEYDOWN)
  {
    if (::TranslateMDISysAccel(client_hwnd, pMsg))
      return TRUE;
  }

  return FALSE;
}

BOOL wxMDIFrame::OnEraseBkgnd(HDC pDC)
{
  return TRUE;
}

extern wxWnd *wxWndHook;
extern wxList *wxWinHandleList;
wxMDIChild::wxMDIChild(wxMDIFrame *parent, wxWindow *wx_win, char *title,
                   int x, int y, int width, int height, int style)
{
  icon = NULL;
  iconized = FALSE;
  wx_window = wx_win;
  active = FALSE;
  is_dialog = FALSE;

  HWND hParent = NULL;
  if (parent)
    hParent = parent->handle;

  wxWndHook = this;

  MDICREATESTRUCT mcs;
	
  mcs.szClass = "wxMDIChildFrameClass";
  mcs.szTitle = title;
  mcs.hOwner = wxhInstance;
  if (x > -1) mcs.x = x;
  else mcs.x = CW_USEDEFAULT;

  if (y > -1) mcs.y = y;
  else mcs.y = CW_USEDEFAULT;

  if (width > -1) mcs.cx = width;
  else mcs.cx = CW_USEDEFAULT;

  if (height > -1) mcs.cy = height;
  else mcs.cy = CW_USEDEFAULT;

  DWORD msflags = WS_OVERLAPPED;
  if (style & wxMINIMIZE_BOX)
    msflags |= WS_MINIMIZEBOX;
  if (style & wxMAXIMIZE_BOX)
    msflags |= WS_MAXIMIZEBOX;
  if (style & wxTHICK_FRAME)
    msflags |= WS_THICKFRAME;
  if (style & wxSYSTEM_MENU)
    msflags |= WS_SYSMENU;
  if ((style & wxMINIMIZE) || (style & wxICONIZE))
    msflags |= WS_MINIMIZE;
  if (style & wxMAXIMIZE)
    msflags |= WS_MAXIMIZE;
  if (style & wxCAPTION)
    msflags |= WS_CAPTION;

  mcs.style = msflags;

  mcs.lParam = 0;

  DWORD Return = SendMessage(parent->client_hwnd,
		WM_MDICREATE, 0, (LONG)(LPSTR)&mcs);

  handle = (HWND)LOWORD(Return);

  wxWndHook = NULL;
  wxWinHandleList->Append((long)handle, this);

  SetWindowLong(handle, 0, (long)this);
#ifdef DEBUG
  wxDebugMsg("End of wxMDIChild::wxMDIChild %d\n", handle);
#endif
}


BOOL wxMDIChild::OnPaint(void)
{
#ifdef DEBUG
  wxDebugMsg("wxMDIChild::OnPaint %d\n", handle);
#endif
  if (!handle) return 1;
  
//  (void)DefWindowProc(last_msg, last_wparam, last_lparam);

  RECT rect;
  if (GetUpdateRect(handle, &rect, FALSE))
  {
    PAINTSTRUCT ps;
    // Hold a pointer to the dc so long as the OnPaint() message
    // is being processed
    cdc = BeginPaint(handle, &ps);

    if (iconized)
    {
      HICON the_icon = icon;
      if (the_icon == 0)
        the_icon = wxSTD_FRAME_ICON;

      if (the_icon)
      {
        RECT rect;
        GetClientRect(handle, &rect);
        int icon_width = 32;
        int icon_height = 32;
        int icon_x = (int)((rect.right - icon_width)/2);
        int icon_y = (int)((rect.bottom - icon_height)/2);
        DrawIcon(cdc, icon_x, icon_y, the_icon);
      }
    }

    if (!iconized && wx_window)
      wx_window->OnPaint();

    EndPaint(handle, &ps);
    cdc = NULL;
    return 0;
  }
  return 1;
}

static HWND invalidHandle = 0;
void wxMDIChild::OnSize(int x, int y, UINT id)
{
#ifdef DEBUG
  wxDebugMsg("wxMDIChild::OnSize %d\n", handle);
#endif
  if (!handle) return;

  if (invalidHandle == handle)
  {
#ifdef DEBUG
  wxDebugMsg("wxMDIChild::OnSize %d: invalid, so returning.\n", handle);
#endif
    return;
  }
  
#ifdef DEBUG
  wxDebugMsg("wxMDIChild::OnSize %d: calling DefWindowProc\n", handle);
#endif
  (void)DefWindowProc(last_msg, last_wparam, last_lparam);
#ifdef DEBUG
  wxDebugMsg("wxMDIChild::OnSize %d: called DefWindowProc\n", handle);
#endif
  
  switch (id)
  {
    case SIZEFULLSCREEN:
    case SIZENORMAL:
      iconized = FALSE;
    break;
    case SIZEICONIC:
      iconized = TRUE;
    break;
  }

 if (!iconized)
 {
  wxFrame *frame = (wxFrame *)wx_window;
  if (frame && frame->status_window[0])
    frame->PositionStatusWindow();

  if (wx_window && wx_window->handle)
    wx_window->OnSize(x, y);
 }
}

BOOL wxMDIChild::OnClose(void)
{
#ifdef DEBUG
  wxDebugMsg("wxMDIChild::OnClose %d\n", handle);
#endif
  if (wx_window && handle)
  {
    if (wx_window->OnClose())
    {
      delete wx_window;
      return TRUE;
    } else return FALSE;
  }
  return FALSE;
}

BOOL wxMDIChild::OnCommand(WORD id, WORD cmd, HWND control)
{
#ifdef DEBUG
  wxDebugMsg("wxMDIChild::OnCommand %d\n", handle);
#endif
//  (void)DefWindowProc(last_msg, last_wparam, last_lparam);
  if ((cmd == 0) && handle)
  {
    ((wxFrame *)wx_window)->Command(id);
    return TRUE;
  }
  else
    return FALSE;
  return FALSE;
}

void wxMDIChild::OnMenuSelect(WORD nItem, WORD nFlags, HMENU hSysMenu)
{
  wxFrame *frame = (wxFrame *)wx_window;
  if (nFlags == -1 && hSysMenu == NULL)
    frame->OnMenuSelect(-1);
  else if (nFlags != MF_SEPARATOR)
    frame->OnMenuSelect(nItem);
}

long wxMDIChild::DefWindowProc(UINT message, UINT wParam, LONG lParam)
{
//#ifdef DEBUG
//  wxDebugMsg("wxMDIChild::DefWindowProc %d, message = %d\n", handle, message);
//#endif
  if (handle)
    return DefMDIChildProc(handle, message, wParam, lParam);
  else return 0;
}

BOOL wxMDIChild::ProcessMessage(MSG *msg)
{
//#ifdef DEBUG
//  wxDebugMsg("wxMDIChild::ProcessMessage %d\n", handle);
//#endif
  if (accelerator_table && handle)
  {
    wxFrame *parent = (wxFrame *)wx_window->GetParent();
    HWND parent_hwnd = ((wxWnd *)parent->handle)->handle;
    return ::TranslateAccelerator(parent_hwnd, accelerator_table, msg);
  }
  return FALSE;
}

BOOL wxMDIChild::OnMDIActivate(BOOL bActivate, HWND one,
                                                HWND two)
{
#ifdef DEBUG
  wxDebugMsg("wxMDIChild::OnActivate %d, activating %d, deactivating %d\n", handle, one, two);
  if (bActivate)
    wxDebugMsg("  ACTIVATING %d\n", handle);
  else
    wxDebugMsg("  DEACTIVATING %d\n", handle);
#endif

  wxFrame *parent = (wxFrame *)wx_window->GetParent();
  wxFrame *child = (wxFrame *)wx_window;
  HMENU parent_menu = parent->GetWinMenu();
#ifdef DEBUG
  wxDebugMsg("Parent menu is %d\n", parent_menu);
#endif
  HMENU child_menu = child->GetWinMenu();
#ifdef DEBUG
  wxDebugMsg("Child menu is %d\n", child_menu);
#endif

  wxMDIFrame *cparent = (wxMDIFrame *)parent->handle;
  if (bActivate)
  {
    active = TRUE;
    cparent->current_child = this;
    if (child_menu)
    {
      cparent->parent_frame_active = FALSE;
      HMENU subMenu = GetSubMenu(cparent->window_menu, 0);
#ifdef DEBUG
      wxDebugMsg("Window submenu is %d\n", subMenu);
#endif
//      HMENU subMenu = 0;
#ifdef WIN32
      ::SendMessage(cparent->client_hwnd, WM_MDISETMENU,
                    (WPARAM)child_menu,
                    (LPARAM)subMenu);
#else
      ::SendMessage(cparent->client_hwnd, WM_MDISETMENU, 0,
                  MAKELONG(child_menu, subMenu));
#endif

      ::DrawMenuBar(cparent->handle);
    }
  }
  else
  {
    if (cparent->current_child == this)
      cparent->current_child = NULL;

    active = FALSE;
    if (parent_menu)
    {
      cparent->parent_frame_active = TRUE;
      HMENU subMenu = GetSubMenu(cparent->window_menu, 0);
#ifdef DEBUG
      wxDebugMsg("Window submenu is %d\n", subMenu);
#endif
//      HMENU subMenu = 0;
#ifdef WIN32
      ::SendMessage(cparent->client_hwnd, WM_MDISETMENU,
                    (WPARAM)parent_menu,
                    (LPARAM)subMenu);
#else
      ::SendMessage(cparent->client_hwnd, WM_MDISETMENU, 0,
                  MAKELONG(parent_menu, subMenu));
#endif

      ::DrawMenuBar(cparent->handle);
    }
  }
  wx_window->OnActivate(bActivate);
#ifdef DEBUG
  wxDebugMsg("Finished (de)activating\n");
#endif
  return 0;
}

wxMDIChild::~wxMDIChild(void)
{
}

void wxMDIChild::DestroyWindow(void)
{
#ifdef DEBUG
  wxDebugMsg("Start of wxMDIChild::DestroyWindow %d\n", handle);
#endif
  DetachWindowMenu();
  invalidHandle = handle;

  wxFrame *parent = (wxFrame *)wx_window->GetParent();
  wxMDIFrame *cparent = (wxMDIFrame *)parent->handle;

  // Must make sure this handle is invalidated (set to NULL)
  // since all sorts of things could happen after the
  // child client is destroyed, but before the wxFrame is
  // destroyed.

  // Send a restore message.
//  SendMessage(cparent->client_hwnd, WM_MDIRESTORE, (WPARAM)handle, 0);

/*
  // EXPERIMENTAL
  wxFrame *child = (wxFrame *)wx_window;
  HMENU parent_menu = parent->GetWinMenu();
  HMENU child_menu = child->GetWinMenu();

  if (cparent->current_child == this)
    cparent->current_child = NULL;

  active = FALSE;
  if (parent_menu)
  {
    cparent->parent_frame_active = TRUE;
#ifdef WIN32
    ::SendMessage(cparent->client_hwnd, WM_MDISETMENU,
                  (WPARAM)parent_menu,
                  (LPARAM)GetSubMenu(cparent->window_menu, 0));
#else
    ::SendMessage(cparent->client_hwnd, WM_MDISETMENU, 0,
                MAKELONG(parent_menu, GetSubMenu(cparent->window_menu, 0)));
#endif
  }
*/
  HWND oldHandle = (HWND)handle;
//  handle = NULL;
#ifdef DEBUG
  wxDebugMsg("*** About to DestroyWindow MDI child %d\n", oldHandle);
#endif
#ifdef WIN32
  SendMessage(cparent->client_hwnd, WM_MDIDESTROY, (WPARAM)oldHandle, (LPARAM)0);
#else
  SendMessage(cparent->client_hwnd, WM_MDIDESTROY, (HWND)oldHandle, 0);
#endif
#ifdef DEBUG
  wxDebugMsg("*** Finished DestroyWindow MDI child %d\n", oldHandle);
#endif
  invalidHandle = 0;

  if (hMenu)
  {
    ::DestroyMenu(hMenu);
    hMenu = 0;
  }
}

