/*
 * File:	wx_enhdg.cc
 * Purpose:	wxEnhancedDialogBox
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

/* Uncomment for Borland/UNIX combination
#if defined(WINDOWS_STANDARD) || defined(WINDOWS_BUTTON_ONLY)
#ifndef WANT_CANCEL_BUTTON
#define WANT_CANCEL_BUTTON
#endif
#endif

#ifdef wx_msw
#include "wx.h"
#pragma hdrstop
#else

#ifdef wx_xview
  // Under XView, font setting doesn't works. 2 possibles reasons:
  // 1) I make a mistake
  // 2) XView doesn't allow font setting
  // Until clear, no font changes for XView!!
#ifdef ENHANCED_FONTS
#undef ENHANCED_FONTS
#endif
#endif

#include "common.h"
#include "wx_dialg.h"
#include "wx_utils.h"
#include "wx_frame.h"
#include "wx_panel.h"
#include "wx_item.h"
#include "wx_buttn.h"
#include "wx_messg.h"
#include "wx_choic.h"
#include "wx_check.h"
#include "wx_menu.h"
#include "wx_txt.h"
#include "wx_mtxt.h"
#include "wx_slidr.h"
#include "wx_lbox.h"
#include "wx_enhdg.h"
#endif
*/

#if defined(WINDOWS_STANDARD) || defined(WINDOWS_BUTTON_ONLY)
#ifndef WANT_CANCEL_BUTTON
#define WANT_CANCEL_BUTTON
#endif
#endif

#include "wx.h"                 // MSC 7/UNIX

#if USE_ENHANCED_DIALOG
#include "wx_enhdg.h"

#include <iostream.h>
#include <stdio.h>

#ifdef wx_xview
#include <xview/frame.h>
#endif

//
//	Enhanced Dialog Box
//
#if !defined(wx_xview) && !defined(WANT_CANCEL_BUTTON)
static        wxFont  *pin_font ;
#endif
static        wxFont  *label_font ;
static        wxFont  *button_font ;
static        wxFont  *cmd_font ;

#define	DO_UNSHOW	0
#define	DO_NOT_UNSHOW	1

#if !defined(wx_xview) && !defined(WANT_CANCEL_BUTTON)
void UnshowEnhDialog(wxCheckBox &pin,wxCommandEvent evt)
{
  if (pin.GetValue())
    return ;
  int clientData = (int)pin.GetClientData() ;
  if (clientData==DO_NOT_UNSHOW)
    return ;
  wxPanel *pinpanel = (wxPanel*)pin.window_parent ;
  wxEnhDialogBox *dialog = (wxEnhDialogBox*)pinpanel->window_parent ;
  dialog->Show(FALSE) ;
}
#endif

wxEnhDialogBox::wxEnhDialogBox(wxFrame *Parent, char *Title, Bool Modal, 
                         wxFunction fun,int space,
                         int x, int y, int width, int height,
			 char *name)
		: wxDialogBox(Parent,Title,Modal,x,y,width,height,wxXVIEW_CMD|DEFAULT_DIALOG_STYLE,name) 
{
  __type = wxTYPE_ENHANCED_DIALOG ;
  // Put your own defaults fonts here!
#if ENHANCED_FONTS
#ifndef wx_xview
  // Under XView, font setting doesn't works. 2 possibles reasons:
  // 1) I make a mistake
  // 2) XView doesn't allow font setting
  // Until clear, no font changes for XView!!
  if (label_font==NULL)
    label_font = new wxFont(12,wxSWISS,wxNORMAL,wxBOLD) ;
  if (button_font==NULL)
    button_font = new wxFont(12,wxSWISS,wxNORMAL,wxNORMAL) ;
  if (pin_font==NULL)
    pin_font = new wxFont(14,wxROMAN,wxITALIC,wxBOLD) ;
  if (cmd_font==NULL)
    cmd_font = new wxFont(17,wxROMAN,wxNORMAL,wxNORMAL) ;
#endif
#endif
  panel = this ;
  panel->SetVerticalSpacing(0) ;
  panel->SetHorizontalSpacing(0) ;
  panel->SetLabelFont(label_font) ;
  panel->SetButtonFont(button_font) ;
#ifndef wx_xview
  pinPanel = new wxPanel(panel) ;
  pinPanel->SetVerticalSpacing(0) ;
  pinPanel->SetButtonFont(pin_font) ;
#ifdef wx_motif
  // Motif provide enough spacing...
  pinPanel->SetHorizontalSpacing(0) ;
#endif
  pinCheck = new wxCheckBox(pinPanel,(wxFunction)UnshowEnhDialog,"Pinned",
                            -1,-1,100,20,0,"pin") ;
  pinCheck->SetClientData((char*)DO_UNSHOW) ;
  pinPanel->Fit() ;
  panel->NewLine() ;
#endif

  unshow = fun ;
  userPanel = new wxPanel(panel,-1,-1,-1,-1,0,"user") ;
  cmdPanel = 0 ;
  statusPanel = 0 ;
  statusText = 0 ;
  SetPin(FALSE) ;
  userSpacing = space ;
}

wxEnhDialogBox::~wxEnhDialogBox(void)
{
}

wxButton* wxEnhDialogBox::AddCmd(char *label,wxFunction fun,int tag)
{
  if (cmdPanel==0)
  {
    userPanel->Fit() ;
    panel->NewLine() ;
    cmdPanel = new wxPanel(panel) ;
    cmdPanel->SetVerticalSpacing(0) ;
    cmdPanel->SetButtonFont(cmd_font) ;
    if (userSpacing>-1)
      cmdPanel->SetHorizontalSpacing(userSpacing) ;
#ifdef WANT_CANCEL_BUTTON
    (void)new wxButton(cmdPanel,(wxFunction)UnshowEnhDialog,"Cancel") ;
#endif
  }

  wxButton *btn = new wxButton(cmdPanel,fun,label) ;
  if (btn)
    btn->SetClientData((char*)tag) ;
  return(btn) ;
}

wxButton* wxEnhDialogBox::AddCmd(wxBitmap *bitmap,wxFunction fun,int tag)
{
  if (cmdPanel==0)
  {
    userPanel->Fit() ;
    panel->NewLine() ;
    cmdPanel = new wxPanel(panel) ;
    cmdPanel->SetVerticalSpacing(0) ;
    cmdPanel->SetButtonFont(cmd_font) ;
    if (userSpacing>-1)
      cmdPanel->SetHorizontalSpacing(userSpacing) ;
#ifdef WANT_CANCEL_BUTTON
    (void)new wxButton(cmdPanel,(wxFunction)UnshowEnhDialog,"Cancel") ;
#endif
  }

  wxButton *btn = new wxButton(cmdPanel,fun,bitmap) ;
  if (btn)
    btn->SetClientData((char*)tag) ;
  return(btn) ;
}

wxButton* wxEnhDialogBox::GetCmd(int number)
{
  if (cmdPanel)
    return ((wxButton*)(cmdPanel->GetChild(number)));
  else
    return(NULL) ;
}

void wxEnhDialogBox::Show(Bool show,Bool flag)
{

  if (!show)
  {
#if !defined(wx_xview) && !defined(WANT_CANCEL_BUTTON)
    if (pinCheck->GetValue())
      return ;
#endif
#ifdef WANT_CANCEL_BUTTON
    if (pinned)
      return ;
#endif
#ifdef wx_xview
    wxFrame *frame = (wxFrame*)GetParent() ;
    Frame x_frame = (Frame)(frame->GetHandle());
    if (xv_get(x_frame,FRAME_CMD_PUSHPIN_IN))
      return ;
#endif
    if (unshow)
    {
    wxCommandEvent evt = 0;
      (void)(*(unshow))(*this,evt) ;
    }
  }
  if (show)
    SetPin(flag) ;
  wxDialogBox::Show(show) ;
}

void wxEnhDialogBox::SetPin(Bool flag)
{
#ifndef WANT_CANCEL_BUTTON
  pinCheck->SetClientData((char*)DO_NOT_UNSHOW) ;
#ifndef wx_xview
  if (flag)
  {
    if (pinCheck->GetValue())
    {
      pinCheck->SetClientData((char*)DO_UNSHOW) ;
      return ;
    }
  }
  else
  {
    if (!pinCheck->GetValue())
    {
      pinCheck->SetClientData((char*)DO_UNSHOW) ;
      return ;
    }
  }
  // Change state only if needed
  pinCheck->SetValue(flag) ;
#else
    wxFrame *frame = (wxFrame*)GetParent() ;
    Frame x_frame = (Frame)(frame->GetHandle());
    (void)xv_set(x_frame,FRAME_CMD_PUSHPIN_IN,flag) ;
#endif
  pinCheck->SetClientData((char*)DO_UNSHOW) ;
#else
  pinned = flag ;
#endif
}

void wxEnhDialogBox::SetStatus(char *label)
{
  if (label==0 || *label=='\0')
    label = "   " ;
  statusText->SetLabel(label) ;
}

void wxEnhDialogBox::Fit(void)
{
#ifdef WANT_CANCEL_BUTTON
  if (cmdPanel==0)
  {
    userPanel->Fit() ;
    panel->NewLine() ;
    cmdPanel = new wxPanel(panel) ;
    cmdPanel->SetVerticalSpacing(0) ;
    cmdPanel->SetButtonFont(cmd_font) ;
    if (userSpacing>-1)
      cmdPanel->SetHorizontalSpacing(userSpacing) ;
    (void)new wxButton(cmdPanel,(wxFunction)UnshowEnhDialog,"Cancel") ;
  }
#endif
  if (cmdPanel)
    cmdPanel->Fit() ;
  panel->NewLine() ;
  statusPanel = new wxPanel(panel) ;
  statusPanel->SetVerticalSpacing(0) ;
#ifdef wx_motif
  // Motif provide enough spacing...
  statusPanel->SetHorizontalSpacing(0) ;
#endif
  statusText = new wxMessage(statusPanel,"   ") ;
  statusPanel->Fit() ;
  panel->NewLine() ;
  wxDialogBox::Fit() ;
  if (cmdPanel)
    cmdPanel->Centre(wxHORIZONTAL) ;
  int fw,fh ;
  GetClientSize(&fw,&fh) ;
  statusPanel->SetSize(-1,-1,fw,-1) ;
  statusText->SetSize(-1,-1,fw,-1) ;
}

#endif
