/*
 * File:	wxstring.cc
 * Purpose:	Very simple string class
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

/* sccsid[] = "%W% %G%" */

#include "wx.h"
#include "string.h"
#include "wxstring.h"

#define   wxToUpper(C)      (((C) >= 'a' && (C) <= 'z')? (C) - 'a' + 'A': (C))
#define   wxToLower(C)      (((C) >= 'A' && (C) <= 'Z')? (C) - 'A' + 'a': (C))

extern char *copystring(char *);

wxString::wxString(char *s)
{
  if (s)
    stringData = copystring(s);
  else
    stringData = copystring("");
}

wxString::wxString(wxString& s)
{
  char *oldData = s.GetData();
  if (oldData)
    stringData = copystring(oldData);
  else stringData = NULL;
}

wxString::~wxString(void)
{
  if (stringData)
    delete[] stringData;
}

void wxString::operator =(wxString& s)
{
  if (stringData)
    delete[] stringData;
  char *oldData = s.GetData();
  if (oldData)
    stringData = copystring(oldData);
  else stringData = copystring("");
}

Bool wxString::operator ==(wxString& s)
{
  if (stringData && s.GetData())
  {
    return (strcmp(stringData, s.GetData()) == 0);
  }
  else return FALSE;
}

Bool wxString::operator !=(wxString& s)
{
  if (stringData && s.GetData())
  {
    return (strcmp(stringData, s.GetData()) != 0);
  }
  else return FALSE;
}

wxString wxString::operator +(wxString& s)
{
  char *s2 = s.GetData();
  char *s3 = NULL;
  if (!s2 && !stringData)
  {
    wxString string;
    return string;
  }
  else if (!s2 && stringData)
  {
    wxString string(stringData);
    return string;
  }
  else if (s2 && !stringData)
  {
    wxString string(s2);
    return string;
  }
  else if (s2 && stringData)
  {
    s3 = new char[strlen(s2) + strlen(stringData) + 1];
    strcpy(s3, stringData);
    strcat(s3, s2);
    wxString string;
    string.SetData(s3);
    return string;
  }
  wxString defeatBoringWarnings;
  return defeatBoringWarnings;
}

void wxString::SetData(char *s)
{
  if (stringData)
    delete[] stringData;
  if (s)
    stringData = s;
  else
    stringData = copystring("");
}

wxString wxString::SubString(int from, int to)
{
  wxString string;
  if (!stringData)
    return string;
  int len = strlen(stringData);
  if (from >= len)
    return string;
  if (to >= len)
    to = len - 1;
  char *buf = new char[to - from + 2];
  for (int i = from; i <= to; i++)
    buf[i] = stringData[i];
  buf[i] = 0;
  string.SetData(buf);
  return string;
}

wxString wxString::UpperCase(void)
{
  wxString string(stringData);
  if (stringData)
  {
    char *s = string.GetData();
    int len = strlen(s);
    for (int i = 0; i < len; i++)
      s[i] = wxToUpper(s[i]);
  }
  return string;
}

wxString wxString::LowerCase(void)
{
  wxString string(stringData);
  if (stringData)
  {
    char *s = string.GetData();
    int len = strlen(s);
    for (int i = 0; i < len; i++)
      s[i] = wxToLower(s[i]);
  }
  return string;
}
