/*
 * File:	wb_win.cc
 * Purpose:	wxWindow class implementation
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

/* Uncomment for Borland/UNIX combination
#ifdef wx_msw
#include "wx.h"
#pragma hdrstop
#else
#include "common.h"
#include "wx_win.h"
#include "wx_main.h"
#include "wx_utils.h"
#include "wx_gdi.h"
#endif
*/

#include "wx.h"
#include <iostream.h>

wxList wxTopLevelWindows;

// Constructor
wxbWindow::wxbWindow(void)
{
  __type = wxTYPE_WINDOW;
  wx_client_data = NULL;
  window_parent = NULL;
  font = NULL;
  handle = NULL;
  windowName = NULL;
  callback = 0;
  wx_cursor = wxSTANDARD_CURSOR;
  children = new wxList;
  paintingEnabled = TRUE;
  doubleClickAllowed = 0 ;
}

// Destructor
wxbWindow::~wxbWindow(void)
{
  if (windowName) delete[] windowName;
}

char *wxbWindow::GetHandle(void)
{
  return handle;
}

// General callback setting
void wxbWindow::Callback(wxFunction Function)
{
  if (Function)
    callback = Function;
}

// Client data handling (any window, item etc.)
void wxbWindow::SetClientData(char *data)
{
  wx_client_data = data;
}

char *wxbWindow::GetClientData(void)
{
  return wx_client_data;
}

wxWindow *wxbWindow::GetParent(void)
{
  return window_parent;
}

wxWindow *wxbWindow::GetGrandParent(void)
{
  if (window_parent)
    return window_parent->window_parent;
  else return NULL;
}

void wxbWindow::AddChild(wxObject *child)
{
  children->Append(child);
}

void wxbWindow::RemoveChild(wxObject *child)
{
  if (children)
    children->DeleteObject(child);
}

void wxbWindow::DestroyChildren(void)
{
  if (children)
  {
    wxNode *node = children->First();
    while (node)
    {
      wxWindow *child = (wxWindow *)node->Data();
//      child->DestroyChildren();
      delete child;
      node = children->First();
    }
  }
}


