/*
 * File:	wb_utils.cc
 * Purpose:	Miscellaneous utilities
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

/* Uncomment for Borland/UNIX combination
#ifdef wx_msw
#include "wx.h"
#pragma hdrstop
#else

#include "common.h"

#include "wx_utils.h"
#include "wx_win.h"
#include "wx_menu.h"
#endif
*/

#include "wx.h"                 // MSC 7/UNIX

#include <iostream.h>
#include <fstream.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

// Useful buffer
char wxBuffer[1000];

#define   wxToUpper(C)      (((C) >= 'a' && (C) <= 'z')? (C) - 'a' + 'A': (C))
#define   wxToLower(C)      (((C) >= 'A' && (C) <= 'Z')? (C) - 'A' + 'a': (C))

char *copystring(char *s)
{
  int l = strlen(s);
  char *news = new char[l+1];
  strcpy(news, s);
  return news;
}

#ifdef DEBUGLOG
wxLogClass::wxLogClass(char *file)
{
  log_file = copystring(file);
  the_stream = new ofstream(log_file);
  delete the_stream;
}

wxLogClass::~wxLogClass()
{
  delete log_file;
}

void wxLogClass::Open(void)
{
  the_stream = new ofstream(log_file, ios::app);
}

void wxLogClass::Close(void)
{
  delete the_stream;
}

wxLogClass& wxLogClass::operator << (char *s)
{
  this->Open();
  *the_stream << s;
  the_stream->flush();
  this->Close();
  return *this;
}

wxLogClass& wxLogClass::operator << (int i)
{
  this->Open();
  *the_stream << i;
  the_stream->flush();
  this->Close();
  return *this;
}

wxLogClass& wxLogClass::operator << (double i)
{
  this->Open();
  *the_stream << i;
  the_stream->flush();
  this->Close();
  return *this;
}

wxLogClass wxLog("log");
#endif

// Id generation
static long wxCurrentId = 100;
long NewId(void)
{
  return wxCurrentId++;
}

void RegisterId(long id)
{
  if (id >= wxCurrentId)
    wxCurrentId = id + 1;
}


void StringToFloat(char *s, float *number)
{
  if (s && strlen(s) > 0)
  {
    double n = strtod(s, NULL);
    *number = (float)n;
  }
}

void StringToDouble(char *s, double *number)
{
  if (s && strlen(s) > 0)
  {
    *number = strtod(s, NULL);
  }
}

char *FloatToString(float number)
{
  static char buf[20];
  sprintf(buf, "%.2f", number);
  return buf;
}

char *DoubleToString(double number)
{
  static char buf[20];
  sprintf(buf, "%.2lf", number);
  return buf;
}

void StringToInt(char *s, int *number)
{
  if (s && strlen(s) > 0)
  {
    long n = strtol(s, NULL, 10);
    *number = (int)n;
  }
}

void StringToLong(char *s, long *number)
{
  if (s && strlen(s) > 0)
  {
    *number = strtol(s, NULL, 10);
  }
}

char *IntToString(int number)
{
  static char buf[20];
  sprintf(buf, "%d", number);
  return buf;
}

char *LongToString(long number)
{
  static char buf[20];
  sprintf(buf, "%ld", number);
  return buf;
}

// Match a string (one) within a string (two)
Bool StringMatch(char *one, char *two, Bool subString, Bool exact)
{
  int lenOne = strlen(one);
  int lenTwo = strlen(two);

  char *oneUpper = new char[lenOne + 1];
  char *twoUpper = new char[lenTwo + 1];

  int j = 0;
  for (j = 0; j < lenOne; j++)
    oneUpper[j] = wxToUpper(one[j]);
  oneUpper[j] = 0;

  for (j = 0; j < lenTwo; j++)
    twoUpper[j] = wxToUpper(two[j]);
  twoUpper[j] = 0;
  
  int found = FALSE;
  if (subString)
  {
    int i = 0;
    while (!found && i < lenTwo)
    {
      strncpy(wxBuffer, twoUpper + i, lenOne);
      wxBuffer[lenOne] = 0;
      if (strcmp(oneUpper, wxBuffer) == 0)
        found = TRUE;
      i ++;
    }
  }
  else
  {
    if (exact)
      found = (strcmp(oneUpper, twoUpper) == 0);
    else
      found = (strncmp(oneUpper, twoUpper, min(lenOne, lenTwo)) == 0);
  }

  delete[] oneUpper;
  delete[] twoUpper;

  return found;
}


/****** FILE UTILITIES ******/

void wxPathList::Add(char *path)
{
  Append((wxObject *)path);
}

// Add paths e.g. from the PATH environment variable
void wxPathList::AddEnvList(char *envVariable)
{
  char *val = getenv(envVariable);
  if (val)
  {
    char *s = copystring(val);
#ifdef wx_msw
    char *token = strtok(s, " ;"); // Don't seperate with colon in DOS as this may be
                                   // part of a drive specification.
#else
    char *token = strtok(s, " :;");
#endif

    if (token)
    {
      Add(copystring(token));
      while (token)
      {
#ifdef wx_msw
        token = strtok(NULL, " ;");
#else
        token = strtok(NULL, " :;");
#endif
        if (token)
          Add(copystring(token));
      }
    }
    delete[] s;
  }
}

// Given a full filename (with path), ensure that that file can
// be accessed again USING FILENAME ONLY by adding the path
// to the list if not already there.
void wxPathList::EnsureFileAccessible(char *path)
{
  char *path_only = PathOnly(path);
  if (path_only)
  {
    if (!Member(path_only))
      Add(path_only);
    else delete[] path_only;
  }
}

Bool wxPathList::Member(char *path)
{
  char *pathcopy = copystring(path);
  int i;
  int len = strlen(pathcopy);
  for (i = 0; i < len; i++)
    pathcopy[i] = wxToUpper(pathcopy[i]);

  wxNode *node = First();
  Bool found = FALSE;
  while (node && !found)
  {
    char *path = (char *)node->Data();
    
    strcpy(wxBuffer, path);

    len = strlen(wxBuffer);
    for (i = 0; i < len; i++)
      wxBuffer[i] = wxToUpper(wxBuffer[i]);

    if (strcmp(pathcopy, wxBuffer) == 0)
    {
      found = TRUE;
      node = NULL;
    }
    else node = node->Next();
  }
  delete[] pathcopy;
  return found;
}

char *wxPathList::FindValidPath(char *file)
{
  if (FileExists(file))
    return file;

  char *filename = NULL;

  if (IsAbsolutePath(file))
    filename = FileNameFromPath(file);
  else
    filename = file;

  wxNode *node = First();
  char *found = NULL;
  while (node && !found)
  {
    char *path = (char *)node->Data();
    strcpy(wxBuffer, path);
#ifdef wx_x
    strcat(wxBuffer, "/");
#endif
#ifdef wx_msw
    strcat(wxBuffer, "\\");
#endif
    strcat(wxBuffer, filename);
#ifdef wx_msw
    Unix2DosFilename(wxBuffer);
#endif
    if (FileExists(wxBuffer))
    {
      found = wxBuffer;
    }
    else
      node = node->Next();
  }
  return found;
}

Bool FileExists(char *filename)
{
  if (!filename)
    return FALSE;
  FILE *fd = fopen(filename, "r");
  Bool bad = (fd == NULL);
  if (fd)
    fclose(fd);

  return !bad;
}

Bool IsAbsolutePath(char *filename)
{
  int len = strlen(filename);
  if ((len > 0 && (filename[0] == '/' || filename[0] == '\\')) ||
      (len > 1 && (filename[1] == ':')))
    return TRUE;
  else
    return FALSE;
}

// Return just the filename, not the path
char *FileNameFromPath(char *path)
{
  if (!path)
    return NULL;

  int i = 0;
  int l = strlen(path);
  static char buf[300];
  Bool done = FALSE;

  i = l - 1;

  // Search backward for a backward or forward slash
  while (!done && i > -1)
  {
    if (path[i] == '/' || path[i] == '\\')
    {
      done = TRUE;
    }
    else i --;
  }
  i ++;

  int j;
  for (j = i; j < l; j++)
  {
    buf[j - i] = path[j];
  }
  buf[j - i] = 0;
  return buf;
}

// Return just the directory, or NULL if no directort
char *PathOnly(char *path)
{
  if (!path)
    return NULL;

  static char buf[300];
  strcpy(buf, path);

  int i = 0;
  int l = strlen(path);
  Bool done = FALSE;

  i = l - 1;

  // Search backward for a backward or forward slash
  while (!done && i > -1)
  {
    if (path[i] == '/' || path[i] == '\\')
    {
      done = TRUE;
    }
    else i --;
  }

  if (i >= 0)
    buf[i] = 0;
  else
    buf[0] = 0;

  if (i <= 0)
    return NULL;
  else
    return buf;
}

// Utility for converting delimiters in DOS filenames to UNIX style
// and back again - or we get nasty problems with delimiters.
// Also, convert to lower case, since case is significant in UNIX.

void Dos2UnixFilename(char *s)
{
  int l = strlen(s);
  int i;
  for (i = 0; i < l; i++)
    if (s[i] == '\\')
      s[i] = '/';
    else
      s[i] = wxToLower(s[i]);
}

void Unix2DosFilename(char *s)
{
#ifdef wx_msw
  int l = strlen(s);
  int i;
  for (i = 0; i < l; i++)
    if (s[i] == '/')
      s[i] = '\\';
#endif
}

/*
 * Check whether the filename has wildcards
 * New GNU-free matching code
 *
 */


Bool wxPatternMatch(char *pattern, char *text, int i, int j);

/*************************************************************************
 *
 * wxIsWild checks whether the pattern contains wildcards, and
 * returns TRUE if it does, and FALSE if it does not (or if the 
 * pattern is NULL -- i.e. no string).
 *
 * The argument is:
 *   
 * 1) pattern - a character string
 */

Bool wxIsWild(char *pattern)
{
    int pattern_length = strlen(pattern);
    for (int i = 0; i < pattern_length; i++)
    {
	if (pattern[i] == '*' || pattern[i] == '?')
	    return TRUE;
    }
    return FALSE;
}
	
/*************************************************************************
 *
 *  wxMatchWild matches the given pattern string against 
 *  a text string, and returns TRUE if it matches, FALSE otherwise.
 *
 *  A match means that the entire text string is used up in the matching.
 *  The pattern can contain the following wildcards.
 * 
 *  * -- matches any sequence of characters
 *  ? -- matches one character
 *
 * If one or other or both of the string arguments to wxMatchWild function is  
 * NULL (i.e. there isn't a string), then the function returns FALSE.
 *
 */

Bool wxMatchWild(char *pattern, char *text, Bool dotSpecial)
{
   int i = 0;
   int j = 0;
   Bool match = FALSE;
   if (pattern[0] == '\0')
       return FALSE;
   if (text[0] == '\0')
       return FALSE;
   match = wxPatternMatch(pattern, text, i, j);
   return match;
}

/*************************************************************************
 *
 *  wxPatternMatch does the work for wxMatchWild. wxPatternMatch  matches 
 *  the given pattern string against a text string, and returns TRUE if 
 *  it matches, FALSE otherwise. It is assumed that the string arguments
 *  to wxPatternMatch exist.
 *
 *  A match means that the entire text string is used up in the matching.
 *  The pattern can contain the following wildcards.
 * 
 *  * -- matches any sequence of characters
 *  ? -- matches one character
 *
 *  wxPatternMatch works by going down the pattern trying to match the
 *  the same index character in the pattern and string arrays, and stops
 *  when the end of the pattern or text string is reached. However, if a
 *  '*' wildcard is met, the algorithm checks to see whether the remaining 
 *  pattern (after the wildcard) matches the rest of the text (i.e. the 
 *  wxPatternMatch function is called recursively).
 */

Bool wxPatternMatch(char *pattern, char *text, int i, int j)
{
    int pattern_length = strlen(pattern);
    int text_length = strlen(text);
    Bool match;
    while (j < pattern_length && i < text_length)
    {
	if (text[i] == pattern[j])
	{
	    match = TRUE;
	    i++;
	    j++;
	}
	else
	if (pattern[j] == '?')
	{
	    match = TRUE;
	    i++;
	    j++;
	}
	else
	if (pattern[j] == '*')
	{
	    j++;
	    if (j == pattern_length) // if pattern ends in '*'
	    {
		match = TRUE;
		i = text_length;
	    }
	    else
	    {
		match = FALSE;
// after wildcard check to see whether rest of pattern matches 
// up with rest of text
		while (i < text_length && match != TRUE)
		{
		    match = wxPatternMatch(pattern, text, i, j);
		    i++;
		}
// text index is decremented so that it points to where 
// the text string starts to match the rest of the pattern
		i--; 
	    }
	}
	else
	if (text[i] != pattern[j])
	{
	    j = pattern_length;
	    match = FALSE;
	}
    }
    if (j == pattern_length && i == text_length && match == TRUE)
    {
	return TRUE;
    }
    else
// special case where pattern and text are the same except that pattern
// also only has '*' wildcards on the end
    if (i == text_length  && pattern[j] == '*' && match == TRUE)
    {
	for ( ; j < pattern_length; j++)
	{ 
	    if (pattern[j] != '*')
		return FALSE;
	}
	return TRUE;
    }
    else
    {
	return FALSE;
    }
}

// Concatenate two files to form third
Bool wxConcatFiles(char *file1, char *file2, char *file3)
{
  FILE *fd1 = fopen(file1, "rb");
  FILE *fd2 = fopen(file2, "rb");
  FILE *fd3 = fopen(file3, "wb");

  if (!(fd1 && fd2 && fd3))
    return FALSE;

  int ch = -2;
  while (ch != EOF)
  {
    ch = getc(fd1);
    if (ch != EOF)
      putc(ch, fd3);
  }
  ch = -2;
  while (ch != EOF)
  {
    ch = getc(fd2);
    if (ch != EOF)
      putc(ch, fd3);
  }
  fclose(fd1);
  fclose(fd2);
  fclose(fd3);

  return TRUE;
}

// Copy files
Bool wxCopyFile(char *file1, char *file2)
{
  FILE *fd1 = fopen(file1, "rb");
  FILE *fd2 = fopen(file2, "wb");

  if (!(fd1 && fd2))
    return FALSE;

  int ch = -2;
  while (ch != EOF)
  {
    ch = getc(fd1);
    if (ch != EOF)
      putc(ch, fd2);
  }
  fclose(fd1);
  fclose(fd2);
  return TRUE;
}

Bool wxRenameFile(char *file1, char *file2)
{
  int flag = rename(file1, file2);
  if (flag == 0) return TRUE;
  return FALSE;
}

/*
 * Strip out any menu codes
 */
void wxStripMenuCodes(char *in, char *out)
{
  int len = strlen(in);
  int j = 0;
  for (int i = 0; i < len; i++)
  {
    if (in[i] == '&')
    {}
    else if (in[i] == '\\' && (i + 1) <= len && in[i+1] == 't')
    {
      i ++;
      out[j] = ' ';
      j ++;
    }
    else
    {
      out[j] = in[i];
      j ++;
    }
  }
  out[j] = 0;
}


/*
 * Window search functions
 *
 */

/*
 * If parent is non-NULL, look through children for a label or title
 * matching the specified string. If NULL, look through all top-level windows.
 *
 */

wxWindow *wxFindWindowByLabel1(wxWindow *parent, char *title);

wxWindow *wxFindWindowByLabel(wxWindow *parent, char *title)
{
  if (parent)
  {
    return wxFindWindowByLabel1(parent, title);
  }
  wxNode *node = wxTopLevelWindows.First();
  while (node)
  {
    wxWindow *win = (wxWindow *)node->Data();
    wxWindow *retwin = wxFindWindowByLabel1(win, title);
    if (retwin)
      return retwin;

    node = node->Next();
  }
  return NULL;
}

wxWindow *wxFindWindowByLabel1(wxWindow *parent, char *title)
{
  if (!parent)
    return NULL;
    
  char *lab = parent->GetLabel();
  if (lab)
  {
    char *s = copystring(lab);
    if (StringMatch(title, s))
    {
      delete[] s;
      return parent;
    }
    delete[] s;
  }

  if (parent)
  {
    wxNode *node = parent->children->First();
    while (node)
    {
      wxWindow *win = (wxWindow *)node->Data();
      wxWindow *retwin = wxFindWindowByLabel1(win, title);
      if (retwin)
        return retwin;
      node = node->Next();
    }
  }
  return NULL;
}

// Returns menu item id or -1 if none.
int wxFindMenuItemId(wxFrame *frame, char *menuString, char *itemString)
{
  wxMenuBar *menuBar = frame->GetMenuBar();
  if (!menuBar)
    return -1;
  return menuBar->FindMenuItem(menuString, itemString);
}

