/*
 * File:	wb_timer.cc
 * Purpose:	wxTimer implementation
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

/* Uncomment for Borland/UNIX combination
#ifdef wx_msw
#include "wx.h"
#pragma hdrstop
#else

#include "common.h"
#include "wx_timer.h"
#include "wx_list.h"
#include "wx_main.h"
#include "wx_frame.h"
#endif
*/

#include "wx.h"                 // MSC 7/UNIX
#include "wx_timer.h"

#include <time.h>
#include <sys/types.h>

#if defined(SVR4) || defined(SYSV) || defined(__sgi)
#include <sys/time.h>
#else
#include <sys/timeb.h>
#endif

#ifdef sun
// At least on Sun, ftime is undeclared.
// Need to be verified on other platforms.
extern "C" int ftime(struct timeb *tp);
#ifdef SVR4
// dito for gettimeofday on Solaris 2.x.
extern "C" int gettimeofday(struct timeval *tp);
#endif
#endif

wxbTimer::wxbTimer(void)
{
  __type = wxTYPE_TIMER;
  milli = 0 ;
  lastMilli = -1 ;
}

wxbTimer::~wxbTimer(void)
{
}

// Override me!
void wxbTimer::Notify(void)
{
}

int wxbTimer::Interval(void)
{
  return milli ;
}

/*
 * Timer functions
 *
 */

long wxStartTime = 0;
void wxStartTimer(void)
{
#if defined(SVR4) || defined(SYSV)
  struct timeval tp;
//  gettimeofday(&tp, (struct timezone *)NULL);
  gettimeofday(&tp);
  wxStartTime = 1000*tp.tv_sec + tp.tv_usec/1000;
#elif defined(__SC__)
  time_t t0;
  struct tm *tp;
  time(&t0);
  tp = localtime(&t0);
  wxStartTime = 1000*(60*(60*tp->tm_hour+tp->tm_min)+tp->tm_sec);
#else
  struct timeb tp;
  ftime(&tp);
  wxStartTime = 1000*tp.time + tp.millitm;
#endif
}

// Returns elapsed time in milliseconds
long wxGetElapsedTime(void)
{
#if defined(SVR4) || defined(SYSV)
  struct timeval tp;
//  gettimeofday(&tp, (struct timezone *)NULL);
  gettimeofday(&tp);
  long oldTime = wxStartTime;
  wxStartTime = 1000*tp.tv_sec + tp.tv_usec / 1000;
#elif defined(__SC__)
  time_t t0;
  struct tm *tp;
  time(&t0);
  tp = localtime(&t0);
  long oldTime = wxStartTime;
  wxStartTime = 1000*(60*(60*tp->tm_hour+tp->tm_min)+tp->tm_sec);
#else
  struct timeb tp;
  ftime(&tp);
  long oldTime = wxStartTime;
  wxStartTime = 1000*tp.time + tp.millitm;
#endif
  return wxStartTime - oldTime;
}
