/*
 * File:	wb_text.cc
 * Purpose:	wxTextWindow implementation
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

/* Uncomment for Borland/UNIX combination
#ifdef wx_msw
#include "wx.h"
#pragma hdrstop
#else

#include "common.h"
#include "wx_main.h"
#include "wx_text.h"
#include "wx_utils.h"
#include "wx_frame.h"
#endif
*/

#include "wx.h"                 // MSC 7/UNIX
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>

wxbTextWindow::wxbTextWindow(void)
{
  __type = wxTYPE_TEXT_WINDOW;
  file_name = NULL;
  window_parent = NULL;
  font = wxSWISS_FONT;
}

wxbTextWindow::wxbTextWindow(wxFrame *frame, int x, int y, int width, int height,
                           int style, char *name)
{
  __type = wxTYPE_TEXT_WINDOW;
  file_name = NULL;
  window_parent = frame;
  font = wxSWISS_FONT;
}

wxbTextWindow::~wxbTextWindow(void)
{
}

wxbTextWindow& wxbTextWindow::operator<<(char *s)
{
  WriteText(s);
  return *this;
}

wxbTextWindow& wxbTextWindow::operator<<(float f)
{
  static char buf[100];
  sprintf(buf, "%.2f", f);
  WriteText(buf);
  return *this;
}

wxbTextWindow& wxbTextWindow::operator<<(double d)
{
  static char buf[100];
  sprintf(buf, "%.2lf", d);
  WriteText(buf);
  return *this;
}

wxbTextWindow& wxbTextWindow::operator<<(int i)
{
  static char buf[100];
  sprintf(buf, "%i", i);
  WriteText(buf);
  return *this;
}

wxbTextWindow& wxbTextWindow::operator<<(long i)
{
  static char buf[100];
  sprintf(buf, "%ld", i);
  WriteText(buf);
  return *this;
}

wxbTextWindow& wxbTextWindow::operator<<(char c)
{
  char buf[2];

  buf[0] = c;
  buf[1] = 0;
  WriteText(buf);
  return *this;
}

