/*
 * File:	wb_panel.cc
 * Purpose:	wxPanel class implementation
 * Author:	Julian Smart
 * Created:	1993
 * Updated:	
 * Copyright:	(c) 1993, AIAI, University of Edinburgh
 */

static const char sccsid[] = "%W% %G%";

/* Uncomment for Borland/UNIX combination
#ifdef wx_msw
#include "wx.h"
#pragma hdrstop
#else

#include "common.h"
#include "wx_panel.h"
#include "wx_buttn.h"
#include "wx_frame.h"
#include "wx_stdev.h"
#include "wx_utils.h"
#endif
*/

#include "wx.h"                 // MSC 7/UNIX combination

#include <iostream.h>

// Constructors

wxbPanel::wxbPanel(void)
{
  __type = wxTYPE_PANEL;
  defaultItem = NULL;
  new_line = FALSE;
  label_position = wxHORIZONTAL;
  window_parent = NULL;
}

wxbPanel::wxbPanel(wxFrame *frame, int x, int y, int width, int height, int style,
                  char *name)
{
  __type = wxTYPE_PANEL;
  defaultItem = NULL;
  new_line = FALSE;
  label_position = wxHORIZONTAL;

  if (!frame)
    return;

  window_parent = frame;
}

wxbPanel::wxbPanel(wxPanel *frame, int x, int y, int width, int height, int style,
                   char *name)
{
  __type = wxTYPE_PANEL;
  defaultItem = NULL;
  new_line = FALSE;
  label_position = wxHORIZONTAL;

  if (!frame)
    return;

  window_parent = frame;
}

wxbPanel::~wxbPanel(void)
{
}

wxObject* wxbPanel::GetChild(int number)
{
  // Return a pointer to the Nth object in the Panel
  if (!children)
    return(NULL) ;
  wxNode *node = GetChildren()->First();
  while (node && number--)
    node = node->Next() ;
  wxObject *obj = (wxObject *)node->Data();
  return(obj) ;
}

void wxbPanel::SetLabelPosition(int pos)  // wxHORIZONTAL or wxVERTICAL
{
  label_position = pos;
}

void wxbPanel::OnDefaultAction(wxItem *initiatingItem)
{
  wxButton *but = GetDefaultItem();
  if (but)
  {
    wxCommandEvent event(wxEVENT_TYPE_BUTTON_COMMAND);
    but->Command(event);
  }
}

void wxbPanel::SetLabelFont(wxFont *font)
{
  labelFont = font ;
}

void wxbPanel::SetButtonFont(wxFont *font)
{
  buttonFont = font ;
}

void wxbPanel::SetBackgroundColour(wxColour *col)
{
  backColour = col ;
}

void wxbPanel::SetLabelColour(wxColour *col)
{
  labelColour = col ;
}

void wxbPanel::SetButtonColour(wxColour *col)
{
  buttonColour = col ;
}

